/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.netutil;

import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.HintLabel;
import com.xmlmind.guiutil.PreferencesSheet;
import com.xmlmind.guiutil.PreferencesSheetPane;
import com.xmlmind.netutil.Msg;
import com.xmlmind.netutil.PasswordUtil;
import com.xmlmind.netutil.ProxyUtil;
import com.xmlmind.util.Preferences;
import com.xmlmind.util.StringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class ProxiesOptions
extends PreferencesSheet {
    private JRadioButton systemSettings;
    private JRadioButton noSettings;
    private JRadioButton applicationSettings;
    private ButtonGroup settingsGroup;
    private JTextField[] hostFields;
    private JTextField[] portFields;
    private JTextField nonProxyField;
    private JCheckBox socksAuthToggle;
    private JTextField socksUserField;
    private JPasswordField socksPasswordField;
    private static final int HTTP_PROTOCOL = 0;
    private static final int HTTPS_PROTOCOL = 1;
    private static final int FTP_PROTOCOL = 2;
    private static final int SOCKS_PROTOCOL = 3;
    private static final int PROXY_PROTOCOL_COUNT = 4;
    private static final String[] PROXY_PROTOCOLS = new String[]{"HTTP", "HTTPS", "FTP", "SOCKS"};
    private static final int[] PROXY_DEFAULT_PORTS = new int[]{80, 443, 80, 1080};
    private static final String[] NO_PROXY_HOSTS_DEFAULT = new String[]{"localhost", "127.0.0.1"};

    public ProxiesOptions() {
        super("proxies", Msg.msg("proxies.title"));
    }

    @Override
    protected PreferencesSheetPane createPane() {
        Component component;
        Object object;
        PreferencesSheetPane preferencesSheetPane = new PreferencesSheetPane(new GridBagLayout());
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if ("toggleSettings".equals(string)) {
                    ProxiesOptions.this.toggleSettings();
                } else if ("toggleSocksAuth".equals(string)) {
                    ProxiesOptions.this.toggleSocksAuth();
                }
            }
        };
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        HintLabel hintLabel = new HintLabel(Msg.msg("needAppRestart"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        preferencesSheetPane.add((Component)hintLabel, DialogUtil.px(gridBagConstraints));
        this.noSettings = new JRadioButton(Msg.msg("proxies.noSettings"));
        this.noSettings.setActionCommand("toggleSettings");
        this.noSettings.addActionListener(actionListener);
        gridBagConstraints.insets.top = 10;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 17;
        preferencesSheetPane.add((Component)this.noSettings, DialogUtil.px(gridBagConstraints));
        this.systemSettings = new JRadioButton(Msg.msg("proxies.systemSettings"));
        this.systemSettings.setActionCommand("toggleSettings");
        this.systemSettings.addActionListener(actionListener);
        gridBagConstraints.insets.top = 5;
        ++gridBagConstraints.gridy;
        preferencesSheetPane.add((Component)this.systemSettings, DialogUtil.px(gridBagConstraints));
        this.applicationSettings = new JRadioButton(Msg.msg("proxies.applicationSettings"));
        this.applicationSettings.setActionCommand("toggleSettings");
        this.applicationSettings.addActionListener(actionListener);
        ++gridBagConstraints.gridy;
        preferencesSheetPane.add((Component)this.applicationSettings, DialogUtil.px(gridBagConstraints));
        this.settingsGroup = new ButtonGroup();
        this.settingsGroup.add(this.systemSettings);
        this.settingsGroup.add(this.noSettings);
        this.settingsGroup.add(this.applicationSettings);
        JPanel jPanel = new JPanel(new GridBagLayout());
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.left = 20;
        gridBagConstraints.insets.bottom = 5;
        preferencesSheetPane.add((Component)jPanel, DialogUtil.px(gridBagConstraints));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridy = -1;
        this.hostFields = new JTextField[4];
        this.portFields = new JTextField[4];
        for (int i = 0; i < 4; ++i) {
            object = PROXY_PROTOCOLS[i];
            component = new JLabel(Msg.msg("proxies.host", object));
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets.right = 0;
            jPanel.add(component, DialogUtil.px(gridBagConstraints));
            this.hostFields[i] = new JTextField(20);
            ++gridBagConstraints.gridx;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)this.hostFields[i], DialogUtil.px(gridBagConstraints));
            component = new JLabel(Msg.msg("proxies.port"));
            ++gridBagConstraints.gridx;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            jPanel.add(component, DialogUtil.px(gridBagConstraints));
            this.portFields[i] = new JTextField(5);
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets.right = 5;
            jPanel.add((Component)this.portFields[i], DialogUtil.px(gridBagConstraints));
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder((Border)null));
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 5;
        jPanel.add((Component)jPanel2, DialogUtil.px(gridBagConstraints));
        object = new JLabel(Msg.msg("proxies.nonProxyHosts"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.top = 10;
        jPanel.add((Component)object, DialogUtil.px(gridBagConstraints));
        this.nonProxyField = new JTextField(30);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.nonProxyField, DialogUtil.px(gridBagConstraints));
        component = new HintLabel(Msg.msg("proxies.nonProxyHostsHelp"));
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 1;
        gridBagConstraints.insets.bottom = 10;
        jPanel.add(component, DialogUtil.px(gridBagConstraints));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        this.socksAuthToggle = new JCheckBox(Msg.msg("proxies.authenticateSocksUser"));
        this.socksAuthToggle.setActionCommand("toggleSocksAuth");
        this.socksAuthToggle.addActionListener(actionListener);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.socksAuthToggle, DialogUtil.px(gridBagConstraints));
        object = new JLabel(Msg.msg("proxies.socksUser"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.right = 0;
        jPanel2.add((Component)object, DialogUtil.px(gridBagConstraints));
        this.socksUserField = new JTextField(15);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.right = 5;
        jPanel2.add((Component)this.socksUserField, DialogUtil.px(gridBagConstraints));
        object = new JLabel(Msg.msg("proxies.socksPassword"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 5;
        jPanel2.add((Component)object, DialogUtil.px(gridBagConstraints));
        this.socksPasswordField = new JPasswordField(15);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.right = 5;
        jPanel2.add((Component)this.socksPasswordField, DialogUtil.px(gridBagConstraints));
        return preferencesSheetPane;
    }

    private void toggleSettings() {
        int n;
        boolean bl = this.applicationSettings.isSelected();
        for (n = 0; n < this.hostFields.length; ++n) {
            this.hostFields[n].setEnabled(bl);
        }
        for (n = 0; n < this.portFields.length; ++n) {
            this.portFields[n].setEnabled(bl);
        }
        this.nonProxyField.setEnabled(bl);
        this.socksAuthToggle.setEnabled(!this.noSettings.isSelected());
        this.toggleSocksAuth();
    }

    private void toggleSocksAuth() {
        boolean bl = !this.noSettings.isSelected() && this.socksAuthToggle.isSelected();
        this.socksUserField.setEnabled(bl);
        this.socksPasswordField.setEnabled(bl);
    }

    @Override
    public void focusPane() {
        if (this.systemSettings.isEnabled()) {
            this.systemSettings.requestFocus();
        } else {
            this.noSettings.requestFocus();
        }
    }

    @Override
    public void fillPane(Preferences preferences) {
        String string;
        Object object;
        int n;
        String string2 = ProxyUtil.getProxySettings(preferences);
        this.systemSettings.setSelected("system".equals(string2));
        this.noSettings.setSelected("none".equals(string2));
        this.applicationSettings.setSelected("application".equals(string2));
        for (n = 0; n < 4; ++n) {
            object = PROXY_PROTOCOLS[n].toLowerCase() + "Proxy";
            string = preferences.getString((String)object + "Host", "");
            this.hostFields[n].setText(string);
            int n2 = preferences.getInt((String)object + "Port", 1, 65535, PROXY_DEFAULT_PORTS[n]);
            this.portFields[n].setText(Integer.toString(n2));
        }
        n = preferences.getBoolean("socksProxyAuthentication", false) ? 1 : 0;
        this.socksAuthToggle.setSelected(n != 0);
        object = System.getProperty("user.name");
        if (object == null) {
            object = "";
        }
        string = preferences.getString("socksUser", (String)object);
        this.socksUserField.setText(string);
        String string3 = preferences.getString("socksPassword", "");
        if (string3.length() > 0 && (string3 = PasswordUtil.unescapePassword(string3)) == null) {
            string3 = "";
        }
        this.socksPasswordField.setText(string3);
        String[] stringArray = preferences.getStrings("nonProxyHosts", NO_PROXY_HOSTS_DEFAULT);
        this.nonProxyField.setText(StringUtil.join(' ', stringArray));
        this.toggleSettings();
    }

    @Override
    public boolean validatePane(Preferences preferences) {
        int n;
        String[] stringArray;
        String string;
        Object object;
        int n2;
        String string2;
        boolean bl = false;
        if (this.systemSettings.isSelected()) {
            string2 = "system";
        } else if (this.noSettings.isSelected()) {
            string2 = "none";
        } else {
            string2 = "application";
            bl = true;
        }
        preferences.putString("proxySettings", string2);
        int n3 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            object = PROXY_PROTOCOLS[n2].toLowerCase() + "Proxy";
            string = this.hostFields[n2].getText().trim();
            if (string.length() == 0) {
                preferences.putString((String)object + "Host", "");
                preferences.putInt((String)object + "Port", PROXY_DEFAULT_PORTS[n2]);
                continue;
            }
            stringArray = ProxiesOptions.checkHost(string, false);
            if (stringArray == null) {
                if (bl) {
                    this.badField(this.hostFields[n2]);
                    return false;
                }
                stringArray = "";
            }
            preferences.putString((String)object + "Host", (String)stringArray);
            string = this.portFields[n2].getText().trim();
            n = ProxiesOptions.checkPort(string);
            if (n <= 0) {
                if (bl) {
                    this.badField(this.portFields[n2]);
                    return false;
                }
                n = PROXY_DEFAULT_PORTS[n2];
            }
            preferences.putInt((String)object + "Port", n);
            ++n3;
        }
        if (bl && n3 == 0) {
            this.badField(this.hostFields[0]);
            return false;
        }
        n2 = this.socksAuthToggle.isSelected() ? 1 : 0;
        preferences.putBoolean("socksProxyAuthentication", n2 != 0);
        if (n2 != 0) {
            object = this.socksUserField.getText().trim();
            if (object.length() == 0) {
                this.badField(this.socksUserField);
                return false;
            }
            preferences.putString("socksUser", (String)object);
            string = new String(this.socksPasswordField.getPassword());
            if (string.length() > 0) {
                string = PasswordUtil.escapePassword(string);
            }
            preferences.putString("socksPassword", string);
        } else {
            preferences.putString("socksUser", "");
            preferences.putString("socksPassword", "");
        }
        string = this.nonProxyField.getText().trim();
        if (string.length() == 0) {
            object = new String[]{};
        } else {
            object = StringUtil.split(string);
            stringArray = new String[((String[])object).length];
            n = 0;
            for (int i = 0; i < ((String[])object).length; ++i) {
                String string3 = ProxiesOptions.checkHost(object[i], true);
                if (string3 == null && bl) {
                    this.badField(this.nonProxyField);
                    return false;
                }
                if (string3 == null) continue;
                stringArray[n++] = string3;
            }
            object = new String[n];
            System.arraycopy(stringArray, 0, object, 0, n);
        }
        preferences.putStrings("nonProxyHosts", (String[])object);
        return true;
    }

    private static final String checkHost(String string, boolean bl) {
        Object object;
        if (bl) {
            if (string.startsWith("*.")) {
                string = string.substring(1);
            }
            object = string.startsWith(".") ? "www" + string : string;
        } else {
            object = string;
        }
        String string2 = null;
        try {
            new URI("http://" + (String)object + "/");
            string2 = string;
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return string2;
    }

    private static final int checkPort(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n <= 0 || n > 65535) {
            n = -1;
        }
        return n;
    }
}

