/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.netutil;

import com.xmlmind.netutil.FileContent;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

final class MultipartWriter {
    public final HttpURLConnection connection;
    public final String charEncoding;
    public final CharsetEncoder charEncoder;
    public final String boundary;
    public final OutputStream out;
    public static final String NEWLINE = "\r\n";
    public static final String BOUNDARY_PREFIX = "--";

    public MultipartWriter(HttpURLConnection httpURLConnection, String string) throws IOException {
        this.connection = httpURLConnection;
        this.charEncoding = string == null ? "ISO-8859-1" : string;
        this.charEncoder = Charset.forName(string).newEncoder();
        this.boundary = "--------------------" + Long.toString(System.currentTimeMillis(), 36);
        httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.out = httpURLConnection.getOutputStream();
    }

    public void writePart(String string, String string2) throws IOException {
        this.writeBoundary();
        string = MultipartWriter.toQuotableValue(string);
        this.writeBytes("Content-Disposition: form-data; name=\"" + MultipartWriter.escapeUnmappableChars(string, this.charEncoder) + "\"");
        this.writeBytes(NEWLINE);
        this.writeBytes(NEWLINE);
        this.writeBytes(MultipartWriter.escapeUnmappableChars(string2, this.charEncoder));
        this.writeBytes(NEWLINE);
        this.out.flush();
    }

    public static final String toQuotableValue(String string) {
        if (string.indexOf(34) >= 0) {
            string = StringUtil.replaceAll(string, "\"", "\\\"");
        }
        if (string.indexOf(13) >= 0 || string.indexOf(10) >= 0) {
            string = StringUtil.replaceAll(string, NEWLINE, " ");
            string = string.replace('\r', ' ');
            string = string.replace('\n', ' ');
        }
        return string;
    }

    public static final String escapeUnmappableChars(String string, CharsetEncoder charsetEncoder) {
        int n = string.length();
        if (n == 0 || "utf-8".equalsIgnoreCase(charsetEncoder.charset().name())) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (charsetEncoder.canEncode(c)) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append("&#");
            stringBuilder.append(Integer.toString(c));
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePart(String string, FileContent fileContent) throws IOException {
        this.writeBoundary();
        String string2 = fileContent.getName();
        if (string2 == null) {
            string2 = "";
        }
        string = MultipartWriter.toQuotableValue(string);
        string2 = MultipartWriter.toQuotableValue(string2);
        this.writeBytes("Content-Disposition: form-data; name=\"" + MultipartWriter.escapeUnmappableChars(string, this.charEncoder) + "\"; filename=\"" + MultipartWriter.escapeUnmappableChars(string2, this.charEncoder) + "\"");
        this.writeBytes(NEWLINE);
        String string3 = fileContent.getContentType();
        if (string3 == null) {
            string3 = "application/octet-stream";
        }
        this.writeBytes("Content-Type: " + string3);
        this.writeBytes(NEWLINE);
        this.writeBytes("Content-Length: " + fileContent.getSize());
        this.writeBytes(NEWLINE);
        this.writeBytes(NEWLINE);
        try (InputStream inputStream = fileContent.getInputStream();){
            MultipartWriter.copyBytes(inputStream, this.out);
        }
        this.writeBytes(NEWLINE);
        this.out.flush();
    }

    public static final void copyBytes(InputStream inputStream, OutputStream outputStream) throws IOException {
        FileUtil.copyFile(inputStream, outputStream);
    }

    public void writeBoundary() throws IOException {
        this.writeBytes(BOUNDARY_PREFIX);
        this.writeBytes(this.boundary);
        this.writeBytes(NEWLINE);
    }

    public void writeEndOfParts() throws IOException {
        this.writeBytes(BOUNDARY_PREFIX);
        this.writeBytes(this.boundary);
        this.writeBytes(BOUNDARY_PREFIX);
        this.writeBytes(NEWLINE);
    }

    public void writeBytes(String string) throws IOException {
        this.out.write(string.getBytes(this.charEncoding));
    }
}

