/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.jhelp;

import com.xmlmind.jhelp.IdMap;
import com.xmlmind.jhelp.IdMapPage;
import com.xmlmind.jhelp.Msg;
import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.Console;
import com.xmlmind.util.Log;
import com.xmlmind.util.ProgressMonitor;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.util.XMLText;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class IdMaps {
    public final URI helpBaseURI;
    private IdMap[] idMaps;
    private HashMap<String, IdMapPage> idToPage;
    private boolean needCompile;

    public IdMaps(URI uRI) {
        this.helpBaseURI = uRI;
        this.idMaps = IdMap.EMPTY_LIST;
        this.idToPage = new HashMap();
    }

    public synchronized IdMap add(URL uRL) {
        IdMap idMap = new IdMap(uRL);
        if (ArrayUtil.indexOf(this.idMaps, idMap) < 0) {
            this.idMaps = ArrayUtil.append(this.idMaps, idMap);
            this.needCompile = true;
        }
        return idMap;
    }

    public synchronized IdMap[] getAll() {
        return this.idMaps;
    }

    public synchronized boolean isCompileNeeded() {
        return this.needCompile;
    }

    public synchronized void compile(ProgressMonitor progressMonitor) {
        if (this.needCompile) {
            IdMap idMap;
            int n;
            this.needCompile = false;
            if (progressMonitor != null) {
                int n2 = 0;
                for (IdMap idMap2 : this.idMaps) {
                    if (idMap2.title != null) continue;
                    ++n2;
                }
                if (n2 == 0) {
                    return;
                }
                progressMonitor.start();
                if (!progressMonitor.stepCount(n2)) {
                    progressMonitor.stop();
                    return;
                }
            }
            ArrayList<IdMap> arrayList = new ArrayList<IdMap>();
            int n3 = this.idMaps.length;
            int n4 = -1;
            int n5 = 0;
            for (n = 0; n < n3; ++n) {
                idMap = this.idMaps[n];
                if (idMap.title != null) {
                    arrayList.add(idMap);
                    continue;
                }
                String string = URLUtil.toLabel(idMap.sourceURL);
                if (!(progressMonitor == null || progressMonitor.step(n5++) && progressMonitor.message(Msg.msg("loadingIdMap", string), Console.MessageType.INFO))) {
                    n4 = n;
                    break;
                }
                String string2 = null;
                try {
                    IdMap idMap3 = this.loadIdMap(idMap.sourceURL);
                    idMap3.setMainIdMap(idMap.isMainIdMap());
                    arrayList.add(idMap3);
                }
                catch (Exception exception) {
                    string2 = Msg.msg("cannotLoadIdMap", string, ThrowableUtil.reason(exception));
                }
                if (string2 == null) continue;
                if (progressMonitor != null) {
                    if (progressMonitor.message(string2, Console.MessageType.ERROR)) continue;
                    n4 = n + 1;
                    break;
                }
                IdMaps.getLog().error(string2);
            }
            if (n4 >= 0) {
                for (n = n4; n < n3; ++n) {
                    idMap = this.idMaps[n];
                    arrayList.add(idMap);
                    if (idMap.title != null) continue;
                    this.needCompile = true;
                }
            }
            this.idMaps = arrayList.toArray(IdMap.EMPTY_LIST);
            if (progressMonitor != null) {
                progressMonitor.stop();
            }
        }
    }

    static Log getLog() {
        return Log.getLog(Msg.msg("jhelpLogName"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdMap loadIdMap(URL uRL) throws Exception {
        IdMap idMap = null;
        try (InputStream inputStream = URLUtil.openStreamNoCache(uRL);){
            idMap = this.loadIdMap(inputStream, uRL);
        }
        return idMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdMap loadIdMap(InputStream inputStream, URL uRL) throws Exception {
        IdMap idMap = null;
        try (XMLStreamReader xMLStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(uRL.toExternalForm(), inputStream);){
            idMap = this.loadIdMap(xMLStreamReader, uRL);
        }
        return idMap;
    }

    private IdMap loadIdMap(XMLStreamReader xMLStreamReader, URL uRL) throws XMLStreamException {
        int n;
        while ((n = xMLStreamReader.next()) != 1) {
        }
        xMLStreamReader.require(1, null, "idMap");
        String string = xMLStreamReader.getAttributeValue(null, "title");
        if (string == null || (string = XMLText.collapseWhiteSpace(string)).length() == 0) {
            throw new XMLStreamException(Msg.msg("missingOrInvalidAttr", string == null ? "" : string, "title"), xMLStreamReader.getLocation());
        }
        IdMap idMap = null;
        URI uRI = null;
        URI uRI2 = null;
        String string2 = xMLStreamReader.getAttributeValue(null, "href");
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            try {
                idMap = new IdMap(uRL, string, string2);
                uRI = idMap.uri;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (uRI != null) {
                uRI2 = this.helpBaseURI == null ? uRI : this.helpBaseURI.resolve(uRI);
            }
        }
        if (uRI == null || !uRI2.isAbsolute()) {
            throw new XMLStreamException(Msg.msg("missingOrInvalidAttr", string2 == null ? "" : string2, "href"), xMLStreamReader.getLocation());
        }
        while ((n = xMLStreamReader.nextTag()) != 2) {
            xMLStreamReader.require(1, null, "page");
            URI uRI3 = null;
            String string3 = xMLStreamReader.getAttributeValue(null, "href");
            if (string3 != null && (string3 = string3.trim()).length() > 0) {
                try {
                    uRI3 = new URI(string3);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            if (uRI3 == null) {
                throw new XMLStreamException(Msg.msg("missingOrInvalidAttr", string3 == null ? "" : string3, "href"), xMLStreamReader.getLocation());
            }
            String[] stringArray = null;
            String string4 = xMLStreamReader.getAttributeValue(null, "ids");
            if (string4 != null) {
                for (String string5 : stringArray = XMLText.splitList(string4)) {
                    if (XMLText.isNCName(string5)) continue;
                    stringArray = null;
                    break;
                }
            }
            if (stringArray == null || stringArray.length == 0) {
                throw new XMLStreamException(Msg.msg("missingOrInvalidAttr", string4 == null ? "" : string4, "ids"), xMLStreamReader.getLocation());
            }
            IdMapPage object = new IdMapPage(idMap, string3);
            for (String string6 : stringArray) {
                IdMapPage idMapPage = this.idToPage.get(string6);
                if (idMapPage == null) {
                    this.idToPage.put(string6, object);
                    continue;
                }
                IdMaps.getLog().debug(URLUtil.toLabel(uRL) + ": ID collision for \"" + string6 + "\": found " + String.valueOf(idMapPage) + " while adding " + String.valueOf(object));
            }
            xMLStreamReader.nextTag();
            xMLStreamReader.require(2, null, "page");
        }
        xMLStreamReader.require(2, null, "idMap");
        return idMap;
    }

    public synchronized URI getHelpTopicURI(String string, boolean bl) {
        IdMapPage idMapPage;
        URI uRI = null;
        if (string != null && (string = string.trim()).length() > 0 && (idMapPage = this.idToPage.get(string)) != null) {
            uRI = idMapPage.getURI(string, this.helpBaseURI);
        }
        if (uRI == null && bl && this.idMaps.length > 0) {
            uRI = this.idMaps[0].getURI(this.helpBaseURI);
        }
        return uRI;
    }
}

