/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.IconResource;
import com.xmlmind.guiutil.Msg;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.Timer;
import javax.swing.UIManager;

public abstract class Wizard
extends JDialog
implements ActionListener {
    protected static final int STYLE_COMPACT = 1;
    protected static final int STYLE_HELP_BUTTON = 2;
    protected Component parentComponent;
    private JPanel headerPane;
    private JPanel formPane;
    private JButton backButton;
    private JButton nextButton;
    private JButton cancelButton;
    private int margin;
    private Screen[] screens;
    private String headerDefaultTitle;
    private Icon headerDefaultIcon;
    private Font headerFont;
    private Color headerForeground;
    private Color headerBackground;
    private State state;
    private Stack<Integer> backStack;
    private int currentScreen;
    private Status status = Status.UNKNOWN;
    private Thread performTaskThread;
    private Timer waitPerformTimer;
    private static final Class<?>[] NO_PARAMETER_TYPES = new Class[0];
    private static final Object[] NO_ARGUMENTS = new Object[0];
    private static final String HELP_BUTTON_TEXT = Msg.msg("W.help");
    private static final String BACK_BUTTON_TEXT = "< " + Msg.msg("W.back");
    private static final String NEXT_BUTTON_TEXT = Msg.msg("W.next") + " >";
    private static final String FINISH_BUTTON_TEXT = Msg.msg("W.finish");
    private static final String CANCEL_BUTTON_TEXT = Msg.msg("W.cancel");

    protected Wizard(Component component, String string) {
        this(component);
        this.setTitle(string);
        this.initialize(0);
    }

    protected Wizard(Component component, String string, int n) {
        this(component);
        this.setTitle(string);
        this.initialize(n);
    }

    protected Wizard(Component component) {
        super(DialogUtil.getDialogOwner(component), Dialog.DEFAULT_MODALITY_TYPE);
        this.parentComponent = component;
    }

    protected void initialize(int n) {
        JComponent jComponent;
        this.margin = (n & 1) != 0 ? 5 : 10;
        this.screens = new Screen[0];
        this.headerDefaultTitle = null;
        this.headerDefaultIcon = new IconResource(Wizard.class, "wizard.png");
        Font font = UIManager.getFont("Panel.font");
        this.headerFont = AWTUtil.pxDeriveFont(font, 1, 2);
        this.headerForeground = Color.black;
        this.headerBackground = Color.white;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Wizard.this.cancelButtonClicked();
            }
        });
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.headerPane = new JPanel(new CardLayout());
        this.headerPane.setBorder(DialogUtil.pxMatteBorder(this.margin, this.margin, this.margin, this.margin, this.headerBackground));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.headerPane, DialogUtil.px(gridBagConstraints));
        JSeparator jSeparator = new JSeparator();
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jSeparator, DialogUtil.px(gridBagConstraints));
        this.formPane = new JPanel(new CardLayout());
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top = this.margin;
        gridBagConstraints.insets.bottom = this.margin;
        gridBagConstraints.insets.left = this.margin;
        gridBagConstraints.insets.right = this.margin;
        jPanel.add((Component)this.formPane, DialogUtil.px(gridBagConstraints));
        jSeparator = new JSeparator();
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)jSeparator, DialogUtil.px(gridBagConstraints));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = this.margin;
        gridBagConstraints.insets.bottom = this.margin;
        gridBagConstraints.insets.left = this.margin;
        gridBagConstraints.insets.right = this.margin;
        jPanel.add((Component)jPanel2, DialogUtil.px(gridBagConstraints));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        if ((n & 2) != 0) {
            jComponent = new JButton(HELP_BUTTON_TEXT);
            if (!DialogUtil.hasHelpTopics()) {
                ((AbstractButton)jComponent).setEnabled(false);
            } else {
                ((AbstractButton)jComponent).addActionListener(this);
                ((AbstractButton)jComponent).setActionCommand("helpButtonClicked");
            }
            ++gridBagConstraints.gridx;
            jPanel2.add((Component)jComponent, DialogUtil.px(gridBagConstraints));
        }
        jComponent = new JPanel();
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)jComponent, DialogUtil.px(gridBagConstraints));
        this.backButton = new JButton(BACK_BUTTON_TEXT);
        this.backButton.addActionListener(this);
        this.backButton.setActionCommand("backButtonClicked");
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this.backButton, DialogUtil.px(gridBagConstraints));
        this.nextButton = new JButton(NEXT_BUTTON_TEXT);
        this.nextButton.addActionListener(this);
        this.nextButton.setActionCommand("nextButtonClicked");
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 5;
        jPanel2.add((Component)this.nextButton, DialogUtil.px(gridBagConstraints));
        this.cancelButton = new JButton(CANCEL_BUTTON_TEXT);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("cancelButtonClicked");
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 10;
        jPanel2.add((Component)this.cancelButton, DialogUtil.px(gridBagConstraints));
        this.addAllScreens();
        for (int i = 0; i < this.screens.length; ++i) {
            Screen screen = this.screens[i];
            String string = Integer.toString(i);
            this.headerPane.add((Component)screen.getHeader(), string);
            this.formPane.add(screen.form, string);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string != null && string.length() > 0) {
            try {
                Method method = this.getClass().getMethod(string, NO_PARAMETER_TYPES);
                method.invoke((Object)this, NO_ARGUMENTS);
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (exception instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)exception).getCause();
                }
                System.err.println("Wizard " + this.getClass().getName() + ": cannot invoke command '" + string + "':");
                System.err.println("Caught " + ThrowableUtil.detailedReason(throwable));
            }
        }
    }

    public void helpButtonClicked() {
        String string = this.screens[this.currentScreen].getHelpId();
        if (string != null && DialogUtil.showHelpTopic(string, false, this)) {
            return;
        }
        String string2 = this.getClass().getName();
        if (string2.indexOf(36) >= 0) {
            string2 = string2.replace('$', '.');
        }
        DialogUtil.showHelpTopic(string2, true, this);
    }

    public void backButtonClicked() {
        if (this.backStack.empty()) {
            return;
        }
        Integer n = this.backStack.pop();
        this.showScreen(n, this.currentScreen);
    }

    private void showScreen(int n, int n2) {
        this.currentScreen = n;
        if (n == 0) {
            Wizard.showButton(this.backButton, false);
            this.nextButton.setText(NEXT_BUTTON_TEXT);
            Wizard.showButton(this.nextButton, true);
            Wizard.showButton(this.cancelButton, true);
        } else if (n == this.screens.length - 3) {
            Wizard.showButton(this.backButton, true);
            this.nextButton.setText(this.performButtonText());
            Wizard.showButton(this.nextButton, true);
            Wizard.showButton(this.cancelButton, true);
        } else if (n == this.screens.length - 2) {
            Wizard.showButton(this.backButton, false);
            this.nextButton.setText(FINISH_BUTTON_TEXT);
            Wizard.showButton(this.nextButton, false);
            Wizard.showButton(this.cancelButton, true);
        } else if (n == this.screens.length - 1) {
            Wizard.showButton(this.backButton, false);
            this.nextButton.setText(FINISH_BUTTON_TEXT);
            Wizard.showButton(this.nextButton, true);
            Wizard.showButton(this.cancelButton, false);
        } else {
            Wizard.showButton(this.backButton, true);
            this.nextButton.setText(NEXT_BUTTON_TEXT);
            Wizard.showButton(this.nextButton, true);
            Wizard.showButton(this.cancelButton, true);
        }
        CardLayout cardLayout = (CardLayout)this.headerPane.getLayout();
        String string = Integer.toString(n);
        cardLayout.show(this.headerPane, string);
        cardLayout = (CardLayout)this.formPane.getLayout();
        cardLayout.show(this.formPane, string);
        this.showingScreen(n, n2);
        if (n == this.screens.length - 2) {
            this.cancelButton.requestFocus();
        } else if (n == this.screens.length - 1) {
            this.nextButton.requestFocus();
        } else if (!Wizard.requestFocus(this.screens[n].form)) {
            this.nextButton.requestFocus();
        }
    }

    private static final boolean requestFocus(Component component) {
        Component component2;
        FocusTraversalPolicy focusTraversalPolicy;
        Container container;
        if (component instanceof Container && (container = (Container)component).isFocusCycleRoot() && (focusTraversalPolicy = container.getFocusTraversalPolicy()) != null && (component2 = focusTraversalPolicy.getDefaultComponent(container)) != null) {
            component2.requestFocus();
            return true;
        }
        return false;
    }

    private static final void showButton(JButton jButton, boolean bl) {
        if (bl != jButton.isEnabled()) {
            if (bl) {
                jButton.setEnabled(true);
            } else {
                jButton.setEnabled(false);
            }
        }
    }

    public void nextButtonClicked() {
        int n;
        if (this.state == State.FINISHING) {
            this.closingWizard(this.status);
            this.setVisible(false);
            this.dispose();
            return;
        }
        if (this.currentScreen < 0) {
            n = 0;
        } else if (this.currentScreen == this.screens.length - 3) {
            n = this.currentScreen + 1;
            this.state = State.PERFORMING;
        } else {
            n = this.whichNextScreen(this.currentScreen);
        }
        if (n <= this.currentScreen) {
            return;
        }
        if (this.state == State.PERFORMING) {
            final int n2 = this.screens.length - 3;
            this.backStack.push(n2);
            this.showScreen(n2 + 1, n2);
            this.performTaskThread = new Thread("Wizard.performTaskThread"){

                @Override
                public void run() {
                    Wizard.this.status = Wizard.this.performTask();
                }
            };
            this.waitPerformTimer = new Timer(250, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!Wizard.this.performTaskThread.isAlive()) {
                        Wizard.this.waitPerformTimer.stop();
                        Wizard.this.performTaskThread = null;
                        Wizard.this.waitPerformTimer = null;
                        Wizard.this.state = State.FINISHING;
                        Wizard.this.backStack.push(n2 + 1);
                        Wizard.this.showScreen(n2 + 2, n2 + 1);
                    }
                }
            });
            this.waitPerformTimer.setRepeats(true);
            this.waitPerformTimer.setCoalesce(true);
            this.performTaskThread.start();
            Thread.yield();
            this.waitPerformTimer.start();
        } else {
            this.backStack.push(this.currentScreen);
            this.showScreen(n, this.currentScreen);
        }
    }

    public void cancelButtonClicked() {
        if (this.state == State.PERFORMING) {
            this.cancelButton.setEnabled(false);
            this.performTaskThread.interrupt();
            this.abortTask();
        } else {
            this.status = Status.CANCELED;
            this.closingWizard(this.status);
            this.setVisible(false);
            this.dispose();
        }
    }

    protected boolean addScreen(Screen screen) {
        return this.addScreen(this.screens.length, screen);
    }

    protected boolean addScreen(int n, Screen screen) {
        int n2;
        if (this.indexOfScreen(screen) >= 0) {
            return false;
        }
        Screen[] screenArray = new Screen[this.screens.length + 1];
        if (n > 0) {
            System.arraycopy(this.screens, 0, screenArray, 0, n);
        }
        if ((n2 = this.screens.length - n) > 0) {
            System.arraycopy(this.screens, n, screenArray, n + 1, n2);
        }
        screenArray[n] = screen;
        this.screens = screenArray;
        return true;
    }

    protected boolean removeScreen(Screen screen) {
        int n = this.indexOfScreen(screen);
        if (n < 0) {
            return false;
        }
        this.removeScreen(n);
        return true;
    }

    protected int indexOfScreen(Screen screen) {
        for (int i = 0; i < this.screens.length; ++i) {
            if (this.screens[i] != screen) continue;
            return i;
        }
        return -1;
    }

    protected Screen removeScreen(int n) {
        int n2;
        int n3;
        Screen screen = this.screens[n];
        Screen[] screenArray = new Screen[this.screens.length - 1];
        if (n > 0) {
            System.arraycopy(this.screens, 0, screenArray, 0, n);
        }
        if ((n3 = this.screens.length - (n2 = n + 1)) > 0) {
            System.arraycopy(this.screens, n2, screenArray, n, n3);
        }
        this.screens = screenArray;
        return screen;
    }

    protected Screen[] getAllScreens() {
        return this.screens;
    }

    protected int getScreenCount() {
        return this.screens.length;
    }

    protected Screen getScreen(int n) {
        return this.screens[n];
    }

    public void setHeaderDefaultIcon(Icon icon) {
        this.headerDefaultIcon = icon;
        this.resetHeaderPane();
    }

    public Icon getHeaderDefaultIcon() {
        return this.headerDefaultIcon;
    }

    public void setHeaderDefaultTitle(String string) {
        this.headerDefaultTitle = string;
        this.resetHeaderPane();
    }

    private void resetHeaderPane() {
        this.headerPane.removeAll();
        for (int i = 0; i < this.screens.length; ++i) {
            Screen screen = this.screens[i];
            screen.initHeader();
            this.headerPane.add(screen.getHeader());
        }
    }

    public String getHeaderDefaultTitle() {
        return this.headerDefaultTitle;
    }

    public void setHeaderFont(Font font) {
        this.headerFont = font;
        this.resetHeaderPane();
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public void setHeaderForeground(Color color) {
        this.headerForeground = color;
        this.resetHeaderPane();
    }

    public Color getHeaderForeground() {
        return this.headerForeground;
    }

    public void setHeaderBackground(Color color) {
        this.headerBackground = color;
        this.headerPane.setBorder(DialogUtil.pxMatteBorder(this.margin, this.margin, this.margin, this.margin, this.headerBackground));
        this.resetHeaderPane();
    }

    public Color getHeaderBackground() {
        return this.headerBackground;
    }

    protected static final JComponent multiLineText(String string) {
        return Wizard.multiLineText(string, null, null, null);
    }

    protected static final JComponent multiLineText(String string, Font font, Color color, Color color2) {
        if (string.startsWith("<html>") || string.indexOf(10) < 0) {
            return Wizard.createLabel(string, font, color, color2);
        }
        String[] stringArray = StringUtil.split(string, '\n');
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        for (int i = 0; i < stringArray.length; ++i) {
            gridBagConstraints.gridy = i;
            jPanel.add((Component)Wizard.createLabel(stringArray[i], font, color, color2), DialogUtil.px(gridBagConstraints));
        }
        return jPanel;
    }

    private static final JLabel createLabel(String string, Font font, Color color, Color color2) {
        JLabel jLabel = new JLabel(string);
        if (font != null) {
            jLabel.setFont(font);
        }
        if (color != null) {
            jLabel.setForeground(color);
        }
        if (color2 != null) {
            jLabel.setBackground(color2);
        }
        return jLabel;
    }

    protected abstract void addAllScreens();

    protected abstract int whichNextScreen(int var1);

    protected abstract void showingScreen(int var1, int var2);

    protected abstract String performButtonText();

    protected abstract Status performTask();

    protected abstract void abortTask();

    protected abstract void closingWizard(Status var1);

    public Status start() {
        if (this.screens.length < 4) {
            throw new IllegalStateException("less than 4 screens");
        }
        this.state = State.PREPARING;
        this.backStack = new Stack();
        this.currentScreen = -1;
        this.status = Status.UNKNOWN;
        this.nextButtonClicked();
        this.getRootPane().setDefaultButton(this.nextButton);
        this.pack();
        this.setLocationRelativeTo(DialogUtil.getDialogAnchor(this.parentComponent));
        this.nextButton.requestFocus();
        this.setVisible(true);
        return this.status;
    }

    protected final class Screen {
        public final Component form;
        public final String title;
        public final Icon icon;
        private JPanel header;
        private String helpId;

        public Screen(Component component, String string, Icon icon) {
            this.form = component;
            this.title = string;
            this.icon = icon;
            this.initHeader();
            if (component instanceof JPanel) {
                Container container = (Container)component;
                container.setFocusCycleRoot(true);
                container.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
            }
        }

        public void initHeader() {
            Object object;
            String string;
            this.header = new JPanel(DialogUtil.pxBorderLayout(5, 0));
            if (Wizard.this.headerFont != null) {
                this.header.setFont(Wizard.this.headerFont);
            }
            if (Wizard.this.headerForeground != null) {
                this.header.setForeground(Wizard.this.headerForeground);
            }
            if (Wizard.this.headerBackground != null) {
                this.header.setBackground(Wizard.this.headerBackground);
            }
            String string2 = string = this.title != null ? this.title : Wizard.this.headerDefaultTitle;
            if (string != null) {
                object = Wizard.multiLineText(string, Wizard.this.headerFont, Wizard.this.headerForeground, Wizard.this.headerBackground);
                this.header.add((Component)object, "Center");
            }
            Object object2 = object = this.icon != null ? this.icon : Wizard.this.headerDefaultIcon;
            if (object != null) {
                JLabel jLabel = new JLabel((Icon)object);
                this.header.add((Component)jLabel, "East");
            }
        }

        public JPanel getHeader() {
            return this.header;
        }

        public void setHelpId(String string) {
            this.helpId = string;
        }

        public String getHelpId() {
            return this.helpId;
        }
    }

    private static enum State {
        PREPARING,
        PERFORMING,
        FINISHING;

    }

    public static enum Status {
        DONE,
        CANCELED,
        ABORTED,
        FAILED,
        UNKNOWN;

    }
}

