/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.ThreadMonitorDialog;
import com.xmlmind.util.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public final class ThreadMonitorDialog2
extends ThreadMonitorDialog {
    private SimpleAttributeSet[] evenStyles;
    private SimpleAttributeSet[] oddStyles;
    private int messageCount;

    public ThreadMonitorDialog2(Component component, String string, String string2, int n, int n2, boolean bl) {
        super(component, string, string2, n, n2, bl);
    }

    @Override
    protected JTextComponent createMessages(int n, int n2) {
        JTextPane jTextPane = new JTextPane();
        Font font = jTextPane.getFont();
        font = new Font("Monospaced", 0, font.getSize());
        jTextPane.setFont(font);
        jTextPane.setBackground(Color.white);
        jTextPane.setForeground(Color.black);
        jTextPane.setEditable(false);
        int n3 = Log.Level.DEBUG.ordinal() + 1;
        this.evenStyles = new SimpleAttributeSet[n3];
        this.oddStyles = new SimpleAttributeSet[n3];
        for (int i = 0; i < n3; ++i) {
            this.evenStyles[i] = new SimpleAttributeSet();
            StyleConstants.setForeground(this.evenStyles[i], Color.black);
            this.oddStyles[i] = new SimpleAttributeSet();
            StyleConstants.setForeground(this.oddStyles[i], Color.black);
        }
        n3 = Log.Level.ERROR.ordinal();
        Color color = new Color(255, 192, 192);
        StyleConstants.setBackground(this.evenStyles[n3], color);
        color = new Color(255, 224, 224);
        StyleConstants.setBackground(this.oddStyles[n3], color);
        n3 = Log.Level.WARNING.ordinal();
        color = new Color(255, 240, 192);
        StyleConstants.setBackground(this.evenStyles[n3], color);
        color = new Color(255, 240, 224);
        StyleConstants.setBackground(this.oddStyles[n3], color);
        n3 = Log.Level.INFO.ordinal();
        color = new Color(255, 255, 240);
        StyleConstants.setBackground(this.evenStyles[n3], color);
        color = new Color(255, 255, 192);
        StyleConstants.setBackground(this.oddStyles[n3], color);
        n3 = Log.Level.VERBOSE.ordinal();
        color = new Color(224, 224, 255);
        StyleConstants.setBackground(this.evenStyles[n3], color);
        color = new Color(240, 240, 255);
        StyleConstants.setBackground(this.oddStyles[n3], color);
        n3 = Log.Level.DEBUG.ordinal();
        color = new Color(224, 224, 224);
        StyleConstants.setBackground(this.evenStyles[n3], color);
        color = new Color(240, 240, 240);
        StyleConstants.setBackground(this.oddStyles[n3], color);
        return jTextPane;
    }

    @Override
    protected JScrollPane createMessagesScroller(JTextComponent jTextComponent, int n, int n2) {
        Font font = jTextComponent.getFont();
        FontMetrics fontMetrics = jTextComponent.getFontMetrics(font);
        int n3 = (n2 + 5) * fontMetrics.charWidth('x');
        int n4 = (n + 1) * fontMetrics.getHeight();
        JScrollPane jScrollPane = DialogUtil.createScrollPane(jTextComponent);
        jScrollPane.setPreferredSize(new Dimension(n3, n4));
        return jScrollPane;
    }

    @Override
    protected void doSetMessage(String string, Log.Level level) {
        if (this.messages == null) {
            return;
        }
        Document document = ((JTextPane)this.messages).getEditorKit().createDefaultDocument();
        this.messages.setDocument(document);
        this.messageCount = 0;
        this.doAppendMessage(string, level);
    }

    @Override
    protected void doAppendMessage(String string, Log.Level level) {
        if (this.messages == null) {
            return;
        }
        int n = level.ordinal();
        SimpleAttributeSet simpleAttributeSet = this.messageCount % 2 == 0 ? this.evenStyles[n] : this.oddStyles[n];
        Document document = this.messages.getDocument();
        try {
            document.insertString(document.getLength(), string + "\n", simpleAttributeSet);
            ++this.messageCount;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.messages.setCaretPosition(document.getLength());
        if (this.messageLog != null) {
            Log.getLog(this.messageLog).log(level, string);
        }
    }
}

