/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.DialogBase;
import com.xmlmind.guiutil.SetTimePane;
import java.awt.Component;
import java.util.Calendar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SetTimeDialog
extends DialogBase
implements ChangeListener {
    protected SetTimePane editor;
    protected Calendar editable;
    protected boolean edited;
    protected boolean ok;

    public SetTimeDialog(Component component, String string) {
        super(component, string, true);
        this.initialize(component);
    }

    protected void initialize(Component component) {
        this.editor = this.createTimePane(Calendar.getInstance());
        this.editor.addChangeListener(this);
        super.initialize(component, 24);
    }

    protected SetTimePane createTimePane(Calendar calendar) {
        return new SetTimePane(calendar);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.edited = true;
    }

    @Override
    protected Component createForm() {
        return this.editor;
    }

    @Override
    public void ok() {
        if (this.edited) {
            Calendar calendar = this.editor.getCalendar();
            this.editable.set(11, calendar.get(11));
            this.editable.set(12, calendar.get(12));
            this.editable.set(13, calendar.get(13));
        }
        this.ok = true;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void cancel() {
        this.ok = false;
        this.edited = false;
        this.setVisible(false);
        this.dispose();
    }

    public boolean setTime(Calendar calendar) {
        this.editor.setCalendar((Calendar)calendar.clone());
        this.editable = calendar;
        this.ok = false;
        this.edited = false;
        this.getRootPane().setDefaultButton(this.dialogButtons[0]);
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        this.focusForm();
        this.setVisible(true);
        return this.ok;
    }

    protected void focusForm() {
        this.editor.focusForm();
    }
}

