/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.Msg;
import com.xmlmind.guiutil.PossiblyLengthyTaskMonitor;
import com.xmlmind.guiutil.ThreadMonitorDialog;
import com.xmlmind.guiutil.ThreadMonitorDialog2;
import com.xmlmind.util.ProgressMonitor;
import com.xmlmind.util.StoppableThread;
import com.xmlmind.util.ThrowableUtil;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicReference;

public class PossiblyLengthyTask {
    public final Component parentComponent;
    public final String title;
    public final Runnable task;
    public final int graceMillis;
    private int animateMillis;

    public PossiblyLengthyTask(Component component, String string, Runnable runnable, int n) {
        if (n <= 0) {
            n = 1;
        }
        this.parentComponent = component;
        this.title = string;
        this.task = runnable;
        this.graceMillis = n;
    }

    public void setAnimateMillis(int n) {
        this.animateMillis = n;
    }

    public int getAnimateMillis() {
        return this.animateMillis;
    }

    public String execute() {
        PossiblyLengthyTaskMonitor possiblyLengthyTaskMonitor;
        AtomicReference<ThreadMonitorDialog> atomicReference;
        if (this.task instanceof MonitoredRunnable) {
            atomicReference = new AtomicReference<ThreadMonitorDialog>();
            possiblyLengthyTaskMonitor = new PossiblyLengthyTaskMonitor(atomicReference, ((MonitoredRunnable)this.task).getMessageLog());
            possiblyLengthyTaskMonitor.setAnimateMillis(this.animateMillis);
        } else {
            atomicReference = null;
            possiblyLengthyTaskMonitor = null;
        }
        final String[] stringArray = new String[1];
        StoppableThread stoppableThread = new StoppableThread("PossiblyLengthyTask.taskThread"){

            @Override
            public void run() {
                try {
                    if (possiblyLengthyTaskMonitor != null) {
                        ((MonitoredRunnable)PossiblyLengthyTask.this.task).run(possiblyLengthyTaskMonitor);
                    } else {
                        PossiblyLengthyTask.this.task.run();
                    }
                }
                catch (Exception exception) {
                    stringArray[0] = ThrowableUtil.reason(exception);
                }
            }
        };
        stoppableThread.start();
        try {
            stoppableThread.join(this.graceMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!stoppableThread.isAlive()) {
            return stringArray[0];
        }
        String string = Msg.msg("PLT.pleaseWait");
        String string2 = DialogUtil.dialogTitle(this.title) + ".\n" + string;
        int n = 0;
        int n2 = 0;
        if (possiblyLengthyTaskMonitor != null) {
            n = 10;
            n2 = 80;
        }
        ThreadMonitorDialog threadMonitorDialog = this.createThreadMonitorDialog(this.parentComponent, string, string2, n, n2, true);
        if (possiblyLengthyTaskMonitor != null) {
            atomicReference.set(threadMonitorDialog);
        } else {
            threadMonitorDialog.setIndeterminateProgressBar(true);
        }
        boolean bl = threadMonitorDialog.attachThread(stoppableThread);
        if (!bl) {
            stringArray[0] = Msg.msg("PLT.canceledByUser");
        }
        return stringArray[0];
    }

    protected ThreadMonitorDialog createThreadMonitorDialog(Component component, String string, String string2, int n, int n2, boolean bl) {
        ThreadMonitorDialog2 threadMonitorDialog2 = new ThreadMonitorDialog2(component, string, string2, n, n2, bl);
        return threadMonitorDialog2;
    }

    public static interface MonitoredRunnable
    extends Runnable {
        public void run(ProgressMonitor var1) throws Exception;

        public String getMessageLog();
    }
}

