/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.AutoCompletion;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.HintLabel;
import com.xmlmind.guiutil.IconResource;
import com.xmlmind.guiutil.Msg;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class ItemSelectorDialog
extends JDialog
implements ActionListener,
MouseListener {
    protected Component parentComponent;
    protected Component dialogAnchor;
    protected JButton okButton;
    protected AutoCompletion.ProgressTextField field;
    protected JList<Object> list;
    protected JScrollPane listScroller;
    protected AutoCompletion autoCompletion;
    protected boolean singleClick;
    protected boolean pressSpaceToAppend;
    protected Object[] items;
    protected boolean allowAny;
    protected Object result;
    protected static final CompareItemsByString compareItemsByString = new CompareItemsByString();

    public ItemSelectorDialog(Component component, String string, int n, int n2) {
        this(component, string);
        this.initialize(component, n, n2);
    }

    protected ItemSelectorDialog(Component component, String string) {
        super(DialogUtil.getDialogOwner(component), string, Dialog.DEFAULT_MODALITY_TYPE);
    }

    public void setSingleClick(boolean bl) {
        this.singleClick = bl;
    }

    public boolean isSingleClick() {
        return this.singleClick;
    }

    public void setPressSpaceToAppend(boolean bl) {
        this.pressSpaceToAppend = bl;
        this.autoCompletion.setAppendKeyStrokes(bl ? AutoCompletion.KEY_STROKES2 : AutoCompletion.KEY_STROKES1);
    }

    public boolean getPressSpaceToAppend() {
        return this.pressSpaceToAppend;
    }

    protected void initialize(Component component, int n, int n2) {
        this.parentComponent = component;
        this.dialogAnchor = DialogUtil.getDialogAnchor(component);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ItemSelectorDialog.this.cancel();
            }
        });
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new GridBagLayout());
        jPanel.registerKeyboardAction(this, "cancel", KeyStroke.getKeyStroke(27, 0), 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        IconResource iconResource = new IconResource(ItemSelectorDialog.class, "cancel.png");
        JButton jButton = new JButton(iconResource);
        jButton.setDisabledIcon(iconResource);
        StringBuilder stringBuilder = new StringBuilder(DialogUtil.buttonLabel(Msg.msg("cancel")));
        stringBuilder.append(" [");
        stringBuilder.append(KeyEvent.getKeyText(27));
        stringBuilder.append(']');
        jButton.setToolTipText(stringBuilder.toString());
        DialogUtil.setIconic(jButton);
        jButton.setActionCommand("cancel");
        jButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        jPanel.add((Component)jButton, DialogUtil.px(gridBagConstraints));
        iconResource = new IconResource(ItemSelectorDialog.class, "ok.png");
        this.okButton = new JButton(iconResource);
        this.okButton.setDisabledIcon(iconResource);
        stringBuilder = new StringBuilder(DialogUtil.buttonLabel(Msg.msg("ok")));
        stringBuilder.append(" [");
        stringBuilder.append(KeyEvent.getKeyText(10));
        stringBuilder.append(']');
        this.okButton.setToolTipText(stringBuilder.toString());
        DialogUtil.setIconic(this.okButton);
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 2;
        jPanel.add((Component)this.okButton, DialogUtil.px(gridBagConstraints));
        this.field = n2 > 0 ? new AutoCompletion.ProgressTextField(n2) : new AutoCompletion.ProgressTextField();
        this.field.setActionCommand("ok");
        this.field.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.field, DialogUtil.px(gridBagConstraints));
        this.list = new JList();
        this.list.setSelectionMode(0);
        if (n > 0) {
            this.list.setVisibleRowCount(n);
        }
        this.list.setCellRenderer(AutoCompletion.RICH_CHOICE_RENDERER);
        this.list.addMouseListener(this);
        HintLabel hintLabel = this.createHint();
        this.listScroller = DialogUtil.createScrollPane(this.list);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.bottom = hintLabel != null ? 0 : 5;
        jPanel.add((Component)this.listScroller, DialogUtil.px(gridBagConstraints));
        AWTUtil.setFocusable(this.listScroller, false);
        this.autoCompletion = new AutoCompletion(this.field);
        this.autoCompletion.setList(this.list);
        this.setPressSpaceToAppend(false);
        if (hintLabel != null) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets.top = 2;
            gridBagConstraints.insets.bottom = 5;
            jPanel.add((Component)hintLabel, DialogUtil.px(gridBagConstraints));
        }
        this.pack();
        this.setResizable(true);
    }

    protected HintLabel createHint() {
        return null;
    }

    public Component getParentComponent() {
        return this.parentComponent;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok".equals(string)) {
            this.ok();
        } else if ("cancel".equals(string)) {
            this.cancel();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = null;
        int n = this.list.locationToIndex(mouseEvent.getPoint());
        if (n >= 0) {
            object = this.list.getModel().getElementAt(n);
        }
        if (object != null) {
            switch (mouseEvent.getClickCount()) {
                case 1: {
                    if (this.singleClick) {
                        this.done(object);
                        break;
                    }
                    this.autoCompletion.setEntry(object.toString());
                    break;
                }
                case 2: {
                    this.done(object);
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void ok() {
        int n;
        String string = this.field.getText().trim();
        if (string.length() == 0) {
            this.field.selectAll();
            this.field.requestFocus();
            return;
        }
        Object object = null;
        AutoCompletion.ChoiceList choiceList = new AutoCompletion.ChoiceList();
        this.autoCompletion.listChoices(string, choiceList);
        if (choiceList.first >= 0 && (n = choiceList.list.length) > 0) {
            for (int i = choiceList.first; i < n; ++i) {
                String string2 = AutoCompletion.toString(choiceList.list[i]);
                if (string2 == null || !string2.equals(string)) continue;
                object = choiceList.list[i];
                break;
            }
        }
        if (object == null && this.allowAny) {
            object = this.checkedValue(this.items, string);
        }
        this.done(object);
    }

    protected void done(Object object) {
        if (object == null) {
            this.field.selectAll();
            this.field.requestFocus();
            return;
        }
        this.result = object;
        this.setVisible(false);
        this.dispose();
    }

    protected Object checkedValue(Object[] objectArray, String string) {
        if (this.pressSpaceToAppend && string.indexOf(32) >= 0) {
            return null;
        }
        return string;
    }

    public void cancel() {
        this.result = null;
        this.setVisible(false);
        this.dispose();
    }

    public Object selectItem(Object[] objectArray, boolean bl, Object object) {
        this.allowAny = bl;
        if (objectArray.length > 1) {
            objectArray = (Object[])objectArray.clone();
            Arrays.sort(objectArray, compareItemsByString);
        }
        this.setItems(objectArray, bl, object);
        return this.selectItem();
    }

    protected void setItems(Object[] objectArray, boolean bl, Object object) {
        this.items = objectArray;
        AutoCompletion.ChoicesBase choicesBase = AutoCompletion.getPreferMinimalChoices() ? new AutoCompletion.MinimalChoices(objectArray) : new AutoCompletion.SimpleChoices(objectArray);
        this.autoCompletion.setChoices(choicesBase);
        this.autoCompletion.setAppendOnAccept(!bl);
        if (object == null) {
            object = "";
        }
        this.autoCompletion.setEntry(object.toString());
        this.field.selectAll();
        this.autoCompletion.suggest();
    }

    protected Object selectItem() {
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        this.field.requestFocus();
        this.result = null;
        this.setVisible(true);
        return this.result;
    }

    protected static final class CompareItemsByString
    implements Comparator<Object> {
        protected CompareItemsByString() {
        }

        @Override
        public int compare(Object object, Object object2) {
            return object.toString().compareTo(object2.toString());
        }
    }
}

