/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.DialogBase;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.IconResource;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ItemChooserDialog
extends DialogBase
implements MouseListener {
    protected JList<Object> list;
    protected JScrollPane listScroller;
    protected boolean singleClick;
    protected Object result;
    private static IconResource defaultIcon;

    public ItemChooserDialog(Component component, String string, int n, int n2) {
        super(component, string, true);
        this.initialize(component, n, n2);
    }

    public void setSingleClick(boolean bl) {
        this.singleClick = bl;
    }

    public boolean isSingleClick() {
        return this.singleClick;
    }

    protected void initialize(Component component, int n, int n2) {
        this.list = new JList();
        this.list.setSelectionMode(0);
        if (n2 > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            while (n2 > 0) {
                stringBuilder.append('x');
                --n2;
            }
            this.list.setPrototypeCellValue(stringBuilder.toString());
        }
        if (n > 0) {
            this.list.setVisibleRowCount(n);
        }
        this.list.addMouseListener(this);
        super.initialize(component, 30);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == (this.singleClick ? 1 : 2)) {
            this.ok();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    protected Component createForm() {
        JPanel jPanel = new JPanel(DialogUtil.pxBorderLayout(5, 5));
        JLabel jLabel = new JLabel(this.getIcon());
        jLabel.setVerticalAlignment(1);
        jPanel.add((Component)jLabel, "West");
        this.listScroller = DialogUtil.createScrollPane(this.list);
        jPanel.add((Component)this.listScroller, "Center");
        return jPanel;
    }

    protected Icon getIcon() {
        if (defaultIcon == null) {
            defaultIcon = new IconResource(ItemChooserDialog.class, "item.png");
        }
        return defaultIcon;
    }

    @Override
    public void ok() {
        if (this.list.getModel().getSize() == 0) {
            return;
        }
        Object object = this.list.getSelectedValue();
        if (object == null) {
            return;
        }
        this.result = object;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void cancel() {
        this.result = null;
        this.setVisible(false);
        this.dispose();
    }

    public Object chooseItem(Object[] objectArray) {
        return this.chooseItem(objectArray, 0);
    }

    public Object chooseItem(Object[] objectArray, int n) {
        this.list.setListData((Object[])objectArray);
        if (n >= 0 && n < objectArray.length) {
            this.list.setSelectedIndex(n);
        } else {
            n = 0;
        }
        this.list.ensureIndexIsVisible(n);
        this.getRootPane().setDefaultButton(this.dialogButtons[0]);
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        this.list.requestFocus();
        this.result = null;
        this.setVisible(true);
        return this.result;
    }
}

