/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public final class ImageTransferable
implements Transferable,
ClipboardOwner {
    public static final DataFlavor IMAGE_PNG_FLAVOR = new DataFlavor("image/png; class=java.io.InputStream", null);
    public static final DataFlavor IMAGE_JPEG_FLAVOR = new DataFlavor("image/jpeg; class=java.io.InputStream", null);
    public static final DataFlavor IMAGE_BMP_FLAVOR = new DataFlavor("image/bmp; class=java.io.InputStream", null);
    public static final DataFlavor[] DATA_FLAVORS = new DataFlavor[]{DataFlavor.imageFlavor, IMAGE_PNG_FLAVOR, IMAGE_JPEG_FLAVOR, IMAGE_BMP_FLAVOR};
    public final Image image;

    public ImageTransferable(Image image) {
        assert (image != null);
        this.image = image;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])DATA_FLAVORS.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (DataFlavor dataFlavor2 : DATA_FLAVORS) {
            if (!dataFlavor.equals(dataFlavor2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
        for (DataFlavor dataFlavor2 : DATA_FLAVORS) {
            if (!dataFlavor.equals(dataFlavor2)) continue;
            if (dataFlavor2.equals(DataFlavor.imageFlavor)) {
                return this.image;
            }
            return ImageTransferable.toInputStream(this.image, dataFlavor2);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    private static final InputStream toInputStream(Image image, DataFlavor dataFlavor) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        String string = dataFlavor.equals(IMAGE_PNG_FLAVOR) ? "png" : (dataFlavor.equals(IMAGE_JPEG_FLAVOR) ? "jpeg" : (dataFlavor.equals(IMAGE_BMP_FLAVOR) ? "bmp" : dataFlavor.getMimeType()));
        int n = "png".equals(string) ? 2 : 1;
        Image image2 = image;
        if (!(image instanceof BufferedImage) || ((BufferedImage)image).getType() != n) {
            image2 = AWTUtil.toBufferedImage(image, n);
        }
        if (!ImageIO.write((RenderedImage)((BufferedImage)image2), string, byteArrayOutputStream = new ByteArrayOutputStream())) {
            throw new IOException("\"" + string + "\", unsupported image format");
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

