/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.Msg;
import com.xmlmind.guiutil.MultiLineJLabel;
import com.xmlmind.util.SystemUtil;
import com.xmlmind.util.XMLText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public final class DialogUtil {
    private static final GridBagConstraints pxConstraints = new GridBagConstraints();
    public static final char NO_MNEMONIC = '\u0000';
    private static boolean addMnemonics = !SystemUtil.IS_MAC_OS;
    private static Method configureHelpButtonMethod;
    private static Method hasHelpTopicsMethod;
    private static Method showHelpTopicMethod;
    public static final Insets INSETS0;
    private static Insets ICONIC_INSETS;
    private static Border ROLLOVER_BUTTON_BORDER;
    private static Border ROLLOVER_BUTTON_NO_BORDER;
    private static MouseAdapter ROLLOVER_BUTTON_MOUSE_ADAPTER;
    private static ItemListener ROLLOVER_BUTTON_ITEM_LISTENER;
    private static final String WAIT_CURSOR_LEVEL_PROP = "com.xmlmind.guiutil.DialogUtil.waitCursorLevel";
    private static Boolean setUserScrollMode;
    private static int userScrollMode;

    private DialogUtil() {
    }

    public static Dimension pxDimension(int n, int n2) {
        return new Dimension(AWTUtil.px(n), AWTUtil.px(n2));
    }

    public static Insets pxInsets(int n, int n2, int n3, int n4) {
        return new Insets(AWTUtil.px(n), AWTUtil.px(n2), AWTUtil.px(n3), AWTUtil.px(n4));
    }

    public static Border pxLineBorder(Color color, int n) {
        return BorderFactory.createLineBorder(color, AWTUtil.px(n));
    }

    public static Border pxMatteBorder(int n, int n2, int n3, int n4, Color color) {
        return BorderFactory.createMatteBorder(AWTUtil.px(n), AWTUtil.px(n2), AWTUtil.px(n3), AWTUtil.px(n4), color);
    }

    public static Border pxEmptyBorder(int n, int n2, int n3, int n4) {
        return BorderFactory.createEmptyBorder(AWTUtil.px(n), AWTUtil.px(n2), AWTUtil.px(n3), AWTUtil.px(n4));
    }

    public static Component pxHorizontalStrut(int n) {
        return Box.createHorizontalStrut(AWTUtil.px(n));
    }

    public static Component pxVerticalStrut(int n) {
        return Box.createVerticalStrut(AWTUtil.px(n));
    }

    public static BorderLayout pxBorderLayout(int n, int n2) {
        return new BorderLayout(AWTUtil.px(n), AWTUtil.px(n2));
    }

    public static FlowLayout pxFlowLayout(int n, int n2, int n3) {
        return new FlowLayout(n, AWTUtil.px(n2), AWTUtil.px(n3));
    }

    public static GridLayout pxGridLayout(int n, int n2, int n3, int n4) {
        return new GridLayout(n, n2, AWTUtil.px(n3), AWTUtil.px(n4));
    }

    public static GridBagConstraints px(GridBagConstraints gridBagConstraints) {
        int n = AWTUtil.getDisplayScaling();
        if (n > 100) {
            DialogUtil.pxConstraints.gridx = gridBagConstraints.gridx;
            DialogUtil.pxConstraints.gridy = gridBagConstraints.gridy;
            DialogUtil.pxConstraints.gridwidth = gridBagConstraints.gridwidth;
            DialogUtil.pxConstraints.gridheight = gridBagConstraints.gridheight;
            DialogUtil.pxConstraints.weightx = gridBagConstraints.weightx;
            DialogUtil.pxConstraints.weighty = gridBagConstraints.weighty;
            DialogUtil.pxConstraints.anchor = gridBagConstraints.anchor;
            DialogUtil.pxConstraints.fill = gridBagConstraints.fill;
            DialogUtil.pxConstraints.insets.top = gridBagConstraints.insets.top * n / 100;
            DialogUtil.pxConstraints.insets.bottom = gridBagConstraints.insets.bottom * n / 100;
            DialogUtil.pxConstraints.insets.left = gridBagConstraints.insets.left * n / 100;
            DialogUtil.pxConstraints.insets.right = gridBagConstraints.insets.right * n / 100;
            DialogUtil.pxConstraints.ipadx = gridBagConstraints.ipadx * n / 100;
            DialogUtil.pxConstraints.ipady = gridBagConstraints.ipady * n / 100;
            gridBagConstraints = pxConstraints;
        }
        return gridBagConstraints;
    }

    public static Window getDialogOwner(Component component) {
        while (component != null) {
            if (component instanceof Window) {
                return (Window)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static Component getDialogAnchor(Component component) {
        while (component != null) {
            if (component instanceof Dialog && ((Dialog)component).isShowing() || component instanceof Frame) {
                return component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static void setAddingMnemonics(boolean bl) {
        addMnemonics = bl;
    }

    public static boolean isAddingMnemonics() {
        return addMnemonics;
    }

    public static String buttonLabel(String string) {
        int n = string.indexOf(95);
        if (n >= 0) {
            string = new StringBuilder(string).deleteCharAt(n).toString();
        }
        return string;
    }

    public static String dialogTitle(String string) {
        if ((string = DialogUtil.buttonLabel(string)).endsWith(".") || string.endsWith(":")) {
            string = string.endsWith("...") ? string.substring(0, string.length() - 3) : string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static char buttonMnemonic(String string) {
        if (!addMnemonics) {
            return '\u0000';
        }
        int n = string.indexOf(95);
        if (n >= 0) {
            return string.charAt(n + 1);
        }
        return '\u0000';
    }

    public static int buttonMnemonicIndex(String string) {
        if (!addMnemonics) {
            return -1;
        }
        int n = string.indexOf(95);
        if (n >= 0) {
            return n;
        }
        return -1;
    }

    public static void setMnemonic(AbstractButton abstractButton, String string) {
        char c = DialogUtil.buttonMnemonic(string);
        if (c != '\u0000') {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(DialogUtil.buttonMnemonicIndex(string));
        }
    }

    public static void setDisplayedMnemonic(JLabel jLabel, String string) {
        char c = DialogUtil.buttonMnemonic(string);
        if (c != '\u0000') {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(DialogUtil.buttonMnemonicIndex(string));
        }
    }

    public static void setDisplayedMnemonic(JTabbedPane jTabbedPane, int n, String string) {
        char c = DialogUtil.buttonMnemonic(string);
        if (c != '\u0000') {
            jTabbedPane.setMnemonicAt(n, Character.toUpperCase(c));
            jTabbedPane.setDisplayedMnemonicIndexAt(n, DialogUtil.buttonMnemonicIndex(string));
        }
    }

    public static String multiLineToHTML(String string) {
        StringBuilder stringBuilder = new StringBuilder("<html>");
        XMLText.escapeXML(string, stringBuilder);
        return stringBuilder.toString().replace("\n", "<br>");
    }

    public static void appendHTML(String string, StringBuilder stringBuilder) {
        String string2;
        String string3;
        int n;
        String[] stringArray = new String[]{"<b>", "\ue0010", "</b>", "\ue0011", "<i>", "\ue0020", "</i>", "\ue0021", "<tt>", "\ue0030", "</tt>", "\ue0031", "<small>", "\ue0040", "</small>", "\ue0041", "<u>", "\ue0050", "</u>", "\ue0051", "<br>", "\ue0060"};
        int n2 = stringArray.length;
        boolean bl = false;
        for (n = 0; n < n2; n += 2) {
            string3 = stringArray[n];
            string2 = stringArray[n + 1];
            if (string.indexOf(string3) < 0) continue;
            string = string.replace(string3, string2);
            bl = true;
        }
        if (!bl) {
            XMLText.escapeXML(string, stringBuilder);
        } else {
            string = XMLText.escapeXML(string);
            for (n = 0; n < n2; n += 2) {
                string3 = stringArray[n];
                string2 = stringArray[n + 1];
                if (string.indexOf(string2) < 0) continue;
                string = string.replace(string2, string3);
            }
            stringBuilder.append(string);
        }
    }

    public static void setOKText(AbstractButton abstractButton) {
        DialogUtil.setButtonText(abstractButton, "ok");
    }

    public static void setHelpText(AbstractButton abstractButton) {
        DialogUtil.setButtonText(abstractButton, "help");
    }

    public static void setCancelText(AbstractButton abstractButton) {
        DialogUtil.setButtonText(abstractButton, "cancel");
    }

    public static void setCloseText(AbstractButton abstractButton) {
        DialogUtil.setButtonText(abstractButton, "close");
    }

    private static void setButtonText(AbstractButton abstractButton, String string) {
        String string2 = Msg.msg(string);
        abstractButton.setText(DialogUtil.buttonLabel(string2));
        DialogUtil.setMnemonic(abstractButton, string2);
    }

    private static boolean initHelpMethods() {
        if (showHelpTopicMethod == null) {
            try {
                Class<?> clazz = Class.forName("com.xmlmind.jhelp.JHelp");
                configureHelpButtonMethod = clazz.getMethod("configureHelpButton", AbstractButton.class, String.class);
                hasHelpTopicsMethod = clazz.getMethod("hasHelpTopics", new Class[0]);
                showHelpTopicMethod = clazz.getMethod("showHelpTopic", String.class, Boolean.TYPE, Component.class);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return showHelpTopicMethod != null;
    }

    static boolean configureHelpButton(AbstractButton abstractButton, String string) {
        if (!DialogUtil.initHelpMethods()) {
            return false;
        }
        try {
            Boolean bl = (Boolean)configureHelpButtonMethod.invoke(null, abstractButton, string);
            return bl;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static boolean hasHelpTopics() {
        if (!DialogUtil.initHelpMethods()) {
            return false;
        }
        try {
            Boolean bl = (Boolean)hasHelpTopicsMethod.invoke(null, new Object[0]);
            return bl;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static boolean showHelpTopic(String string, boolean bl, Component component) {
        if (!DialogUtil.initHelpMethods()) {
            return false;
        }
        try {
            Boolean bl2 = (Boolean)showHelpTopicMethod.invoke(null, string, bl, component);
            return bl2;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Insets getIconicInsets() {
        if (ICONIC_INSETS == null) {
            ICONIC_INSETS = DialogUtil.pxInsets(1, 2, 1, 2);
        }
        return ICONIC_INSETS;
    }

    public static void setIconic(AbstractButton abstractButton) {
        abstractButton.setMargin(DialogUtil.getIconicInsets());
        if (SystemUtil.IS_MAC_OS && abstractButton instanceof JToggleButton) {
            DialogUtil.setSelectedIcons(abstractButton, abstractButton.getIcon());
        }
    }

    private static void setSelectedIcons(AbstractButton abstractButton, Icon icon) {
        if (icon != null && abstractButton.getSelectedIcon() == null) {
            abstractButton.setSelectedIcon(new SelectedIcon(icon));
            icon = abstractButton.getDisabledIcon();
            if (icon == null) {
                icon = UIManager.getLookAndFeel().getDisabledIcon(abstractButton, icon);
            }
            if (icon != null) {
                abstractButton.setDisabledSelectedIcon(new SelectedIcon(icon));
            }
        }
    }

    public static void configureToolBar(JToolBar jToolBar) {
        jToolBar.setFocusable(false);
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        if (!SystemUtil.IS_MAC_OS) {
            jToolBar.setMargin(INSETS0);
        }
        int n = jToolBar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jToolBar.getComponentAtIndex(i);
            if (component instanceof AbstractButton) {
                DialogUtil.configureToolBarButton((AbstractButton)component);
                continue;
            }
            AWTUtil.setFocusable(component, false);
        }
    }

    public static void configureToolBarButton(AbstractButton abstractButton) {
        abstractButton.setFocusable(false);
        if (abstractButton.getIcon() != null) {
            abstractButton.setText(null);
            abstractButton.setMnemonic(0);
        }
        DialogUtil.setIconic(abstractButton);
    }

    public static void setRollover(AbstractButton abstractButton) {
        if (ROLLOVER_BUTTON_BORDER == null) {
            ROLLOVER_BUTTON_BORDER = abstractButton.getBorder();
            Insets insets = ROLLOVER_BUTTON_BORDER.getBorderInsets(abstractButton);
            ROLLOVER_BUTTON_NO_BORDER = BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
            ROLLOVER_BUTTON_MOUSE_ADAPTER = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                    if (abstractButton.getBorder() != ROLLOVER_BUTTON_BORDER) {
                        abstractButton.setBorder(ROLLOVER_BUTTON_BORDER);
                    }
                    abstractButton.setContentAreaFilled(true);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                    if (abstractButton.getBorder() != ROLLOVER_BUTTON_NO_BORDER) {
                        abstractButton.setBorder(ROLLOVER_BUTTON_NO_BORDER);
                    }
                    abstractButton.setContentAreaFilled(abstractButton.isSelected());
                }
            };
            ROLLOVER_BUTTON_ITEM_LISTENER = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    AbstractButton abstractButton = (AbstractButton)itemEvent.getSource();
                    abstractButton.setContentAreaFilled(abstractButton.isSelected());
                }
            };
        }
        if (abstractButton.getBorder() != ROLLOVER_BUTTON_NO_BORDER) {
            abstractButton.setBorder(ROLLOVER_BUTTON_NO_BORDER);
        }
        abstractButton.setContentAreaFilled(abstractButton.isSelected());
        abstractButton.addMouseListener(ROLLOVER_BUTTON_MOUSE_ADAPTER);
        abstractButton.addItemListener(ROLLOVER_BUTTON_ITEM_LISTENER);
    }

    public static void adjustRowHeight(JTable jTable, int n) {
        FontMetrics fontMetrics = jTable.getFontMetrics(jTable.getFont());
        jTable.setRowHeight(Math.max(fontMetrics.getHeight(), n) + AWTUtil.px(4));
    }

    public static void adjustRowHeight(JTree jTree, int n) {
        FontMetrics fontMetrics = jTree.getFontMetrics(jTree.getFont());
        jTree.setRowHeight(Math.max(fontMetrics.getHeight(), n) + AWTUtil.px(4));
    }

    public static void showMenu(JPopupMenu jPopupMenu, AbstractButton abstractButton) {
        Dimension dimension = jPopupMenu.getPreferredSize();
        jPopupMenu.show(abstractButton, abstractButton.getWidth() - dimension.width, abstractButton.getHeight());
    }

    public static void badField(JTextComponent jTextComponent) {
        jTextComponent.getToolkit().beep();
        jTextComponent.selectAll();
        jTextComponent.requestFocus();
    }

    public static JTextField getTextField(JComboBox<?> jComboBox) {
        return (JTextField)jComboBox.getEditor().getEditorComponent();
    }

    public static void initGlassPane(RootPaneContainer rootPaneContainer) {
        Component component = rootPaneContainer.getGlassPane();
        component.setCursor(Cursor.getPredefinedCursor(3));
        component.addMouseListener(new MouseAdapter(){});
        component.addMouseMotionListener(new MouseMotionAdapter(){});
        component.addKeyListener(new KeyAdapter(){});
        JRootPane jRootPane = rootPaneContainer.getRootPane();
        jRootPane.putClientProperty(WAIT_CURSOR_LEVEL_PROP, new int[1]);
    }

    public static void waitCursor(RootPaneContainer rootPaneContainer, boolean bl) {
        JRootPane jRootPane = rootPaneContainer.getRootPane();
        int[] nArray = (int[])jRootPane.getClientProperty(WAIT_CURSOR_LEVEL_PROP);
        if (nArray == null) {
            System.err.println("com.xmlmind.guiutil.DialogUtil.waitCursor FAILURE");
            return;
        }
        Component component = rootPaneContainer.getGlassPane();
        if (bl) {
            nArray[0] = nArray[0] + 1;
            if (nArray[0] == 1) {
                component.setVisible(true);
            }
        } else if (nArray[0] > 0) {
            nArray[0] = nArray[0] - 1;
            if (nArray[0] == 0) {
                component.setVisible(false);
            }
        }
    }

    public static JScrollPane createScrollPane(Component component) {
        JScrollPane jScrollPane = new JScrollPane(component);
        DialogUtil.configureScrollPane(jScrollPane);
        return jScrollPane;
    }

    public static void configureScrollPane(JScrollPane jScrollPane) {
        if (setUserScrollMode == null) {
            setUserScrollMode = Boolean.FALSE;
            String string = System.getenv("XXE_VIEWPORT_SCROLL_MODE");
            if (string == null) {
                string = System.getProperty("XXE_VIEWPORT_SCROLL_MODE");
            }
            if (string == null && SystemUtil.IS_GENERIC_UNIX) {
                string = "backingstore";
            }
            if (string != null) {
                if ("simple".equals(string)) {
                    userScrollMode = 0;
                    setUserScrollMode = Boolean.TRUE;
                } else if ("backingstore".equals(string)) {
                    userScrollMode = 2;
                    setUserScrollMode = Boolean.TRUE;
                } else if ("blit".equals(string)) {
                    userScrollMode = 1;
                    setUserScrollMode = Boolean.TRUE;
                }
            }
        }
        if (setUserScrollMode == Boolean.TRUE) {
            jScrollPane.getViewport().setScrollMode(userScrollMode);
        }
    }

    public static final boolean wasShiftClick(int n) {
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 0x410) != 0;
        return bl && (bl2 || SystemUtil.IS_MAC_OS);
    }

    public static final boolean wasCtrlClick(int n) {
        boolean bl = (n & 2) != 0;
        boolean bl2 = (n & 0x410) != 0;
        return bl && (bl2 || SystemUtil.IS_MAC_OS);
    }

    public static final boolean wasRightClick(int n) {
        if (SystemUtil.IS_MAC_OS) {
            return false;
        }
        return (n & 0x1004) != 0;
    }

    static {
        INSETS0 = new Insets(0, 0, 0, 0);
    }

    private static final class SelectedIcon
    implements Icon {
        public final Icon icon;
        private static Color selectionColor;

        public SelectedIcon(Icon icon) {
            this.icon = icon;
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (selectionColor == null) {
                selectionColor = AWTUtil.editHSB(MultiLineJLabel.getLabelBackground(), -1, 0.0f, -0.2f, true);
            }
            graphics.setColor(selectionColor);
            graphics.fillRect(n, n2, this.icon.getIconWidth(), this.icon.getIconHeight());
            this.icon.paintIcon(component, graphics, n, n2);
        }
    }
}

