/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.MultiLineJLabel;
import com.xmlmind.util.ThrowableUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class DialogBase
extends JDialog
implements ActionListener {
    protected static final int STYLE_MODAL = 1;
    protected static final int STYLE_RESIZABLE = 2;
    protected static final int STYLE_FORM_MARGINS = 4;
    protected static final int STYLE_BUTTONS_VGAP = 8;
    protected static final int STYLE_OK_CANCEL_BUTTONS = 16;
    protected static final int STYLE_CLOSE_BUTTON = 32;
    protected static final int STYLE_HELP_BUTTON = 64;
    protected static final int STYLE_BUTTONS_AT_RIGHT = 128;
    protected Component parentComponent;
    protected Component dialogAnchor;
    protected JButton[] dialogButtons;
    protected JButton helpButton;
    private static final Class<?>[] NO_PARAMETER_TYPES = new Class[0];
    private static final Object[] NO_ARGUMENTS = new Object[0];
    private static final Class<?>[] INT_PARAMETER_TYPES = new Class[]{Integer.TYPE};

    protected DialogBase(Component component, String string, int n) {
        this((Component)DialogUtil.getDialogOwner(component), string, (n & 1) != 0);
        this.initialize(component, n);
    }

    protected DialogBase(Component component, String string, boolean bl) {
        super(DialogUtil.getDialogOwner(component), string, bl ? Dialog.DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS);
    }

    protected void initialize(Component component, final int n) {
        this.parentComponent = component;
        this.dialogAnchor = DialogUtil.getDialogAnchor(component);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if ((n & 0x20) != 0) {
                    DialogBase.this.close();
                } else {
                    DialogBase.this.cancel();
                }
            }
        });
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new GridBagLayout());
        jPanel.registerKeyboardAction(this, (n & 0x20) != 0 ? "close" : "cancel", KeyStroke.getKeyStroke(27, 0), 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if ((n & 4) != 0) {
            gridBagConstraints.insets.top = 5;
            gridBagConstraints.insets.bottom = 5;
            gridBagConstraints.insets.left = 5;
            gridBagConstraints.insets.right = 5;
        }
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add(this.createForm(), DialogUtil.px(gridBagConstraints));
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = (n & 8) != 0 ? 15 : 0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        Component component2 = this.createButtonsPane(n, gridBagConstraints);
        if (component2 != null) {
            jPanel.add(component2, DialogUtil.px(gridBagConstraints));
        }
        this.pack();
        this.setResizable((n & 2) != 0);
    }

    protected Component createButtonsPane(int n, GridBagConstraints gridBagConstraints) {
        int n2 = (n & 0x20) != 0 ? 1 : 2;
        this.dialogButtons = new JButton[n2];
        int n3 = n2;
        if ((n & 0x40) != 0) {
            ++n3;
        }
        int n4 = (n & 0x80) != 0 ? 5 : 10;
        JPanel jPanel = new JPanel(DialogUtil.pxGridLayout(1, n3, n4, 0));
        int n5 = 0;
        if ((n & 0x10) != 0) {
            this.dialogButtons[n5] = new JButton();
            DialogUtil.setOKText(this.dialogButtons[n5]);
            this.dialogButtons[n5].setActionCommand("ok");
            this.dialogButtons[n5].addActionListener(this);
            jPanel.add(this.dialogButtons[n5]);
            ++n5;
        }
        if ((n & 0x40) != 0) {
            this.helpButton = new JButton();
            DialogUtil.setHelpText(this.helpButton);
            jPanel.add(this.helpButton);
            this.setHelpId(null);
        }
        this.dialogButtons[n5] = new JButton();
        if ((n & 0x10) != 0) {
            DialogUtil.setCancelText(this.dialogButtons[n5]);
            this.dialogButtons[n5].setActionCommand("cancel");
        } else {
            DialogUtil.setCloseText(this.dialogButtons[n5]);
            this.dialogButtons[n5].setActionCommand("close");
        }
        this.dialogButtons[n5].addActionListener(this);
        jPanel.add(this.dialogButtons[n5]);
        if ((n & 0x80) != 0) {
            gridBagConstraints.anchor = 13;
        }
        return jPanel;
    }

    public void setHelpId(String string) {
        if (this.helpButton != null) {
            if (string == null && (string = this.getClass().getName()).indexOf(36) >= 0) {
                string = string.replace('$', '.');
            }
            DialogUtil.configureHelpButton(this.helpButton, string);
        }
    }

    protected abstract Component createForm();

    public Component getParentComponent() {
        return this.parentComponent;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string != null && string.length() > 0) {
            Class<?> clazz = this.getClass();
            Method method = null;
            try {
                method = clazz.getMethod(string, NO_PARAMETER_TYPES);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method != null) {
                try {
                    method.invoke((Object)this, NO_ARGUMENTS);
                }
                catch (Exception exception) {
                    this.reportActionError(clazz, string, ThrowableUtil.detailedReason(exception));
                }
                return;
            }
            try {
                method = clazz.getMethod(string, INT_PARAMETER_TYPES);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method != null) {
                try {
                    method.invoke((Object)this, actionEvent.getModifiers());
                }
                catch (Exception exception) {
                    this.reportActionError(clazz, string, ThrowableUtil.detailedReason(exception));
                }
                return;
            }
            if (!"comboBoxEdited".equals(string)) {
                this.reportActionError(clazz, string, "no corresponding public method");
            }
        }
    }

    private final void reportActionError(Class<?> clazz, String string, String string2) {
        System.err.println("Dialog box " + clazz.getName() + ": cannot invoke command \"" + string + "\":\n" + string2);
    }

    public void ok() {
        throw new RuntimeException("ok() must be implemented by subclass");
    }

    public void cancel() {
        throw new RuntimeException("cancel() must be implemented by subclass");
    }

    public void close() {
        throw new RuntimeException("close() must be implemented by subclass");
    }

    protected void initGlassPane() {
        DialogUtil.initGlassPane(this);
    }

    public void waitCursor(boolean bl) {
        DialogUtil.waitCursor(this, bl);
    }

    public static boolean showDialog(Dialog dialog, String string, int n, Component component, Component component2, Icon icon, String string2) {
        DialogImpl dialogImpl = new DialogImpl(dialog, string, n, component, icon, string2);
        return dialogImpl.showDialog(component2);
    }

    public static boolean showDialog(Component component, String string, int n, Component component2, Component component3, Icon icon, String string2) {
        DialogImpl dialogImpl = new DialogImpl(component, string, n, component2, icon, string2);
        return dialogImpl.showDialog(component3);
    }

    private static final class DialogImpl
    extends DialogBase {
        private Component form;
        private Icon icon;
        private String message;
        private boolean ok;

        public DialogImpl(Component component, String string, int n, Component component2, Icon icon, String string2) {
            super(component, string, true);
            this.init(component, n, component2, icon, string2);
        }

        private void init(Component component, int n, Component component2, Icon icon, String string) {
            this.form = component2;
            this.icon = icon;
            this.message = string;
            super.initialize(component, n);
        }

        @Override
        protected Component createForm() {
            Component component;
            if (this.icon == null && this.message == null) {
                return this.form;
            }
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            if (this.icon != null) {
                component = new JLabel(this.icon);
                gridBagConstraints.gridheight = this.message != null ? 2 : 1;
                gridBagConstraints.anchor = 11;
                gridBagConstraints.insets.right = 5;
                jPanel.add(component, DialogUtil.px(gridBagConstraints));
                ++gridBagConstraints.gridx;
                gridBagConstraints.gridheight = 1;
            }
            if (this.message != null) {
                component = new MultiLineJLabel(this.message);
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets.right = 0;
                gridBagConstraints.insets.bottom = 5;
                jPanel.add(component, DialogUtil.px(gridBagConstraints));
                ++gridBagConstraints.gridy;
            }
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets.right = 0;
            gridBagConstraints.insets.bottom = 0;
            jPanel.add(this.form, DialogUtil.px(gridBagConstraints));
            return jPanel;
        }

        @Override
        public void ok() {
            this.ok = true;
            this.setVisible(false);
            this.dispose();
        }

        @Override
        public void cancel() {
            this.setVisible(false);
            this.dispose();
        }

        @Override
        public void close() {
            this.setVisible(false);
            this.dispose();
        }

        public boolean showDialog(Component component) {
            this.getRootPane().setDefaultButton(this.dialogButtons[0]);
            this.pack();
            this.setLocationRelativeTo(this.dialogAnchor);
            if (component != null) {
                component.requestFocus();
            }
            this.ok = false;
            this.setVisible(true);
            return this.ok;
        }
    }
}

