/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.ChooseFile;
import com.xmlmind.guiutil.ChooseURL;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.IconResource;
import com.xmlmind.guiutil.Msg;
import com.xmlmind.guiutil.SplitButton;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.URLUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public final class BrowseButton
extends SplitButton {
    private IconResource browseIcon = new IconResource(BrowseButton.class, "browseButton.png");
    private SplitButton.ComboIcon comboIcon = new SplitButton.ComboIcon(this, this.browseIcon);
    private boolean saveMode;
    private boolean lockSaveMode;
    private boolean directoryMode;
    private boolean lockDirectoryMode;
    private boolean absoluteMode;
    private boolean lockAbsoluteMode;
    private boolean urlMode;
    private boolean lockURLMode;
    private ButtonGroup saveGroup;
    private ButtonGroup directoryGroup;
    private ButtonGroup absoluteGroup;
    private ButtonGroup urlGroup;
    private URL[] lastSelectedURL;

    public BrowseButton() {
        this.doSetIcon(this.comboIcon);
        DialogUtil.setIconic(this);
        this.setToolTipText(Msg.msg("BB.toolTip"));
        this.urlMode = true;
        this.lastSelectedURL = new URL[1];
    }

    public void setSaveMode(boolean bl, boolean bl2) {
        this.saveMode = bl;
        this.lockSaveMode = bl2;
        this.resetMenu();
    }

    private void resetMenu() {
        SplitButton.ComboIcon comboIcon;
        this.dropDownMenu = null;
        Icon icon = comboIcon = this.lockSaveMode && this.lockDirectoryMode && this.lockAbsoluteMode && this.lockURLMode ? this.browseIcon : this.comboIcon;
        if (comboIcon != this.getIcon()) {
            this.doSetIcon(comboIcon);
        }
    }

    public boolean getSaveMode() {
        return this.saveMode;
    }

    public void setDirectoryMode(boolean bl, boolean bl2) {
        this.directoryMode = bl;
        this.lockDirectoryMode = bl2;
        this.resetMenu();
    }

    public boolean getDirectoryMode() {
        return this.directoryMode;
    }

    public void setAbsoluteMode(boolean bl, boolean bl2) {
        this.absoluteMode = bl;
        this.lockAbsoluteMode = bl2;
        this.resetMenu();
    }

    public boolean getAbsoluteMode() {
        return this.absoluteMode;
    }

    public void setURLMode(boolean bl, boolean bl2) {
        this.urlMode = bl;
        this.lockURLMode = bl2;
        this.resetMenu();
    }

    public boolean getURLMode() {
        return this.urlMode;
    }

    @Override
    protected void showDropDownMenu() {
        if (this.dropDownMenu == null) {
            this.dropDownMenu = this.createOptionMenu();
        }
        super.showDropDownMenu();
    }

    private JPopupMenu createOptionMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("save")) {
                    BrowseButton.this.saveMode = true;
                } else if (string.equals("open")) {
                    BrowseButton.this.saveMode = false;
                } else if (string.equals("directory")) {
                    BrowseButton.this.directoryMode = true;
                } else if (string.equals("file")) {
                    BrowseButton.this.directoryMode = false;
                } else if (string.equals("absolute")) {
                    BrowseButton.this.absoluteMode = true;
                } else if (string.equals("relative")) {
                    BrowseButton.this.absoluteMode = false;
                } else if (string.equals("url")) {
                    BrowseButton.this.urlMode = true;
                } else if (string.equals("fileName")) {
                    BrowseButton.this.urlMode = false;
                }
            }
        };
        this.saveGroup = new ButtonGroup();
        this.directoryGroup = new ButtonGroup();
        this.absoluteGroup = new ButtonGroup();
        this.urlGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("BB.save"));
        jRadioButtonMenuItem.setSelected(this.saveMode);
        jRadioButtonMenuItem.setEnabled(!this.lockSaveMode);
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem.setActionCommand("save");
        jPopupMenu.add(jRadioButtonMenuItem);
        this.saveGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("BB.open"));
        jRadioButtonMenuItem.setSelected(!this.saveMode);
        jRadioButtonMenuItem.setEnabled(!this.lockSaveMode);
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem.setActionCommand("open");
        jPopupMenu.add(jRadioButtonMenuItem);
        this.saveGroup.add(jRadioButtonMenuItem);
        jPopupMenu.addSeparator();
        jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("BB.directory"));
        jRadioButtonMenuItem.setSelected(this.directoryMode);
        jRadioButtonMenuItem.setEnabled(!this.lockDirectoryMode);
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem.setActionCommand("directory");
        jPopupMenu.add(jRadioButtonMenuItem);
        this.directoryGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("BB.file"));
        jRadioButtonMenuItem.setSelected(!this.directoryMode);
        jRadioButtonMenuItem.setEnabled(!this.lockDirectoryMode);
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem.setActionCommand("file");
        jPopupMenu.add(jRadioButtonMenuItem);
        this.directoryGroup.add(jRadioButtonMenuItem);
        jPopupMenu.addSeparator();
        jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("BB.absolutePath"));
        jRadioButtonMenuItem.setSelected(this.absoluteMode);
        jRadioButtonMenuItem.setEnabled(!this.lockAbsoluteMode);
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem.setActionCommand("absolute");
        jPopupMenu.add(jRadioButtonMenuItem);
        this.absoluteGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("BB.relativePath"));
        jRadioButtonMenuItem.setSelected(!this.absoluteMode);
        jRadioButtonMenuItem.setEnabled(!this.lockAbsoluteMode);
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem.setActionCommand("relative");
        jPopupMenu.add(jRadioButtonMenuItem);
        this.absoluteGroup.add(jRadioButtonMenuItem);
        jPopupMenu.addSeparator();
        jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("BB.url"));
        jRadioButtonMenuItem.setSelected(this.urlMode);
        jRadioButtonMenuItem.setEnabled(!this.lockURLMode);
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem.setActionCommand("url");
        jPopupMenu.add(jRadioButtonMenuItem);
        this.urlGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("BB.filename"));
        jRadioButtonMenuItem.setSelected(!this.urlMode);
        jRadioButtonMenuItem.setEnabled(!this.lockURLMode);
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem.setActionCommand("fileName");
        jPopupMenu.add(jRadioButtonMenuItem);
        this.urlGroup.add(jRadioButtonMenuItem);
        return jPopupMenu;
    }

    public String getSelection(Component component, URL uRL) {
        return BrowseButton.selectFile(component, this.absoluteMode, this.directoryMode, this.saveMode, this.urlMode, uRL, this.lastSelectedURL);
    }

    public static final String selectFile(Component component, boolean bl, boolean bl2, boolean bl3, boolean bl4, URL uRL, URL[] uRLArray) {
        File file;
        URL uRL2 = null;
        if (uRLArray != null && uRLArray.length > 0) {
            uRL2 = uRLArray[0];
        }
        if (uRL2 == null) {
            uRL2 = uRL;
        }
        if (bl4) {
            URL uRL3 = bl2 ? (bl3 ? ChooseURL.chooseSaveDirectoryURL(component, uRL2, null) : ChooseURL.chooseOpenDirectoryURL(component, uRL2, null)) : (bl3 ? ChooseURL.chooseSaveFileURL(component, uRL2, null) : ChooseURL.chooseOpenFileURL(component, uRL2, null));
            if (uRL3 == null) {
                return null;
            }
            if (uRLArray != null && uRLArray.length > 0) {
                uRLArray[0] = uRL3;
            }
            String string = null;
            if (!bl && uRL != null && URLUtil.sameRoot(uRL3, uRL)) {
                string = URLUtil.getRawRelativePath(uRL3, uRL);
            }
            if (string == null) {
                string = uRL3.toExternalForm();
            }
            return string;
        }
        File file2 = null;
        if (uRL2 != null) {
            file2 = URLUtil.urlToFile(uRL2);
        }
        File file3 = bl2 ? (bl3 ? ChooseFile.chooseSaveDirectory(component, file2, null) : ChooseFile.chooseOpenDirectory(component, file2, null)) : (bl3 ? ChooseFile.chooseSaveFile(component, file2, null) : ChooseFile.chooseOpenFile(component, file2, null));
        if (file3 == null) {
            return null;
        }
        if (uRLArray != null && uRLArray.length > 0) {
            uRLArray[0] = FileUtil.fileToURL(file3);
        }
        String string = null;
        if (!bl && uRL != null && (file = URLUtil.urlToFile(uRL)) != null) {
            string = FileUtil.getRelativePath(file3, file);
        }
        if (string == null) {
            string = file3.getPath();
        }
        return string;
    }
}

