/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.ImagePreview;
import com.xmlmind.guiutil.ImageResource;
import java.awt.Image;
import java.net.URL;
import java.util.List;
import javax.swing.SwingWorker;

public final class AsyncImagePreview
extends ImagePreview {
    private PreviewLoader previewLoader;
    private static Image workingIcon;

    public AsyncImagePreview() {
        if (workingIcon == null) {
            workingIcon = ImageResource.get(AsyncImagePreview.class, "working.png");
        }
    }

    @Override
    protected void preview(URL uRL) {
        this.previewImageURL = uRL;
        this.previewImage = null;
        if (this.previewLoader != null) {
            this.previewLoader.cancel(false);
            this.previewLoader = null;
        }
        if (uRL != null) {
            this.previewImage = AsyncImagePreview.fetchPreview(uRL);
            if (this.previewImage == null) {
                this.previewLoader = new PreviewLoader(uRL);
                this.previewLoader.execute();
            }
        }
        this.repaint();
    }

    private final class PreviewLoader
    extends SwingWorker<Image, Image> {
        public final URL url;
        private final ImagePreview.PreviewFactory factory;
        private final int size;

        public PreviewLoader(URL uRL) {
            this.url = uRL;
            this.factory = ImagePreview.previewFactory;
            this.size = ImagePreview.getPreviewSize();
        }

        @Override
        public Image doInBackground() {
            Image image = null;
            Object object = this.factory.canCreatePreview(this.url);
            if (object != null) {
                this.publish(workingIcon);
                image = this.factory.createPreview(object, this.url, this.size, this.size);
            }
            return image;
        }

        @Override
        protected void process(List<Image> list) {
            if (list.size() > 0) {
                this.showPreview(this.url, list.get(0));
            }
        }

        private void showPreview(URL uRL, Image image) {
            if (AsyncImagePreview.this.previewImageURL != null && AsyncImagePreview.this.previewImageURL.equals(uRL)) {
                AsyncImagePreview.this.previewImage = image;
                AsyncImagePreview.this.repaint();
            }
        }

        @Override
        protected void done() {
            Image image = null;
            try {
                image = (Image)this.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (image != null && this.size == ImagePreview.getPreviewSize()) {
                ImagePreview.cachePreview(this.url, image);
            }
            this.showPreview(this.url, image);
        }
    }
}

