/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.IconResource;
import com.xmlmind.guiutil.Msg;
import com.xmlmind.guiutil.MultiLineJLabel;
import com.xmlmind.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.html.HTMLEditorKit;

public final class Alert {
    public static final String ERROR_LABEL = Msg.msg("error");
    public static final String WARNING_LABEL = Msg.msg("warning");
    public static final String INFO_LABEL = Msg.msg("info");
    public static final String CONFIRM_LABEL = Msg.msg("confirm");
    private static boolean isConsoleApp;

    public static void showError(Component component, String string) {
        Alert.showAlert(component, string, 0);
    }

    public static void showWarning(Component component, String string) {
        Alert.showAlert(component, string, 2);
    }

    public static void showInfo(Component component, String string) {
        Alert.showAlert(component, string, 1);
    }

    private static void showAlert(Component component, String string, int n) {
        string = Alert.checkMessage(string, 128, 50);
        Alert.showAlert(component, (Object)string, n);
    }

    public static String checkMessage(String string, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        String[] stringArray = StringUtil.split(string, '\n');
        for (int i = 0; i < stringArray.length; ++i) {
            int n4;
            String string2 = stringArray[i];
            if (i > 0) {
                stringBuilder.append('\n');
            }
            if ((n4 = string2.length()) <= n || string2.indexOf(32) < 0) {
                if (n4 > n) {
                    string2 = StringUtil.shortenText(string2, n);
                }
                stringBuilder.append(string2);
                ++n3;
            } else {
                n4 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    int n5 = string3.length();
                    if (n4 + n5 > n) {
                        if (n4 > 0) {
                            stringBuilder.append('\n');
                            n4 = 0;
                            if (++n3 >= n2) break;
                        }
                        if (n5 > n) {
                            string3 = StringUtil.shortenText(string3, n);
                            n5 = string3.length();
                        }
                    } else if (n4 > 0) {
                        stringBuilder.append(' ');
                        ++n4;
                    }
                    stringBuilder.append(string3);
                    n4 += n5;
                }
                if (n4 > 0) {
                    ++n3;
                }
            }
            if (n3 >= n2) break;
        }
        return stringBuilder.toString();
    }

    public static void setConsoleApp(boolean bl) {
        isConsoleApp = bl;
    }

    public static boolean isConsoleApp() {
        return isConsoleApp;
    }

    private static void showAlert(Component component, Object object, int n) {
        IconResource iconResource;
        String string;
        switch (n) {
            case 1: {
                string = INFO_LABEL;
                iconResource = new IconResource(Alert.class, "information.png");
                break;
            }
            case 2: {
                string = WARNING_LABEL;
                iconResource = new IconResource(Alert.class, "warning.png");
                break;
            }
            default: {
                string = ERROR_LABEL;
                iconResource = new IconResource(Alert.class, "error.png");
            }
        }
        component = DialogUtil.getDialogAnchor(component);
        if (component == null && isConsoleApp) {
            if (n == 1) {
                System.out.println(object.toString());
            } else {
                System.err.println(object.toString());
            }
        } else {
            JOptionPane.showMessageDialog(component, object, string, n, iconResource);
        }
    }

    public static boolean confirm(Component component, String string) {
        int n = Alert.confirm(component, string, 2);
        return n == 0;
    }

    public static boolean approve(Component component, String string) {
        int n = Alert.confirm(component, string, 0);
        return n == 0;
    }

    public static int confirm(Component component, String string, int n) {
        string = Alert.checkMessage(string, 128, 50);
        return Alert.showConfirm(component, string, n);
    }

    public static int showConfirm(Component component, Object object, int n) {
        IconResource iconResource = new IconResource(Alert.class, "question.png");
        return JOptionPane.showConfirmDialog(DialogUtil.getDialogAnchor(component), object, CONFIRM_LABEL, n, 3, iconResource);
    }

    public static void showError(Component component, String string, String[] stringArray) {
        Alert.showError(component, string, Alert.concatLines(stringArray), true, 25, 80);
    }

    public static void showWarning(Component component, String string, String[] stringArray) {
        Alert.showWarning(component, string, Alert.concatLines(stringArray), true, 25, 80);
    }

    public static void showInfo(Component component, String string, String[] stringArray) {
        Alert.showInfo(component, string, Alert.concatLines(stringArray), true, 25, 80);
    }

    public static final String concatLines(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string);
            stringBuilder.append("\n\n");
        }
        return stringBuilder.toString();
    }

    public static void showError(Component component, String string, String string2, boolean bl, int n, int n2) {
        Object[] objectArray = Alert.createTextContent(string, string2, bl, n, n2);
        Alert.showAlert(component, objectArray, 0);
    }

    public static void showWarning(Component component, String string, String string2, boolean bl, int n, int n2) {
        Object[] objectArray = Alert.createTextContent(string, string2, bl, n, n2);
        Alert.showAlert(component, objectArray, 2);
    }

    public static void showInfo(Component component, String string, String string2, boolean bl, int n, int n2) {
        Object[] objectArray = Alert.createTextContent(string, string2, bl, n, n2);
        Alert.showAlert(component, objectArray, 1);
    }

    public static Object[] createTextContent(String string, String string2, boolean bl, int n, int n2) {
        string = Alert.checkMessage(string, 128, 50);
        JTextArea jTextArea = new JTextArea(string2, n, n2);
        Font font = jTextArea.getFont();
        String string3 = bl ? font.getFamily() : "Monospaced";
        jTextArea.setFont(new Font(string3, 0, font.getSize()));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(bl);
        jTextArea.setWrapStyleWord(bl);
        jTextArea.setBackground(Color.white);
        jTextArea.setForeground(Color.black);
        return new Object[]{new MultiLineJLabel(string), DialogUtil.createScrollPane(jTextArea)};
    }

    public static void showErrorHTML(Component component, String string, String string2, Dimension dimension) {
        Object[] objectArray = Alert.createHTMLContent(string, string2, dimension);
        Alert.showAlert(component, objectArray, 0);
    }

    public static void showWarningHTML(Component component, String string, String string2, Dimension dimension) {
        Object[] objectArray = Alert.createHTMLContent(string, string2, dimension);
        Alert.showAlert(component, objectArray, 2);
    }

    public static void showInfoHTML(Component component, String string, String string2, Dimension dimension) {
        Object[] objectArray = Alert.createHTMLContent(string, string2, dimension);
        Alert.showAlert(component, objectArray, 1);
    }

    public static Object[] createHTMLContent(String string, String string2, Dimension dimension) {
        string = Alert.checkMessage(string, 128, 50);
        JEditorPane jEditorPane = new JEditorPane();
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKitForContentType("text/html");
        jEditorPane.setEditorKit(hTMLEditorKit);
        jEditorPane.setEditable(false);
        jEditorPane.setBackground(Color.white);
        jEditorPane.setForeground(Color.black);
        try {
            jEditorPane.read(new StringReader(string2), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JScrollPane jScrollPane = DialogUtil.createScrollPane(jEditorPane);
        jScrollPane.setPreferredSize(dimension);
        jEditorPane.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
        return new Object[]{new MultiLineJLabel(string), jScrollPane};
    }
}

