/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.util.SystemUtil;
import com.xmlmind.util.VersionNumber;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;

public final class AWTUtil {
    private static int displayScaling;
    private static int systemDisplayScaling;
    private static double screenResolution;
    public static final boolean isHeadless;
    private static final VersionNumber JAVA_20_0_0;
    private static boolean bugsDetected;
    private static boolean drawThinRectBug;
    private static boolean drawUnscaledImageBug;
    private static final Object FRACTIONALMETRICS_FLAG;
    private static final Object TEXT_ANTIALIAS_FLAG;
    private static final String UNSCALED_IMAGE_SIZE_PROP = "com.xmlmind.guiutil.AWTUtil.unscaledImageSize";
    public static final String[] GENERIC_FONT_FAMILIES;
    private static String[] fontFamilies;
    private static final float[] HSB;

    private AWTUtil() {
    }

    public static int setDisplayScaling(int n) {
        if (!isHeadless) {
            if ((n = AWTUtil.checkDisplayScaling(n)) > 100 && SystemUtil.javaVersionNumber().compareTo(JAVA_20_0_0) < 0) {
                System.setProperty("prism.allowhidpi", "false");
            }
            displayScaling = n;
        }
        return displayScaling;
    }

    public static int checkDisplayScaling(int n) {
        int n2 = AWTUtil.getSystemDisplayScaling();
        if (n2 < -100) {
            return n2;
        }
        if (n == -100) {
            n = 100;
        }
        if (n >= 100 && n <= 400) {
            return n;
        }
        if (n < -100 && n >= -400) {
            return -n;
        }
        return n2;
    }

    public static int getSystemDisplayScaling() {
        Toolkit toolkit;
        int n;
        block11: {
            int n2;
            if (isHeadless) {
                return systemDisplayScaling;
            }
            n = 100;
            toolkit = Toolkit.getDefaultToolkit();
            if (SystemUtil.javaVersionNumber().compareTo(SystemUtil.JAVA_9_0_0) >= 0 && !"false".equals(System.getProperty("sun.java2d.uiScale.enabled"))) {
                GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                AffineTransform affineTransform = graphicsDevice.getDefaultConfiguration().getDefaultTransform();
                double d = affineTransform.getScaleX();
                double d2 = affineTransform.getScaleY();
                n = (int)(d * -100.0);
                if (n == -100) {
                    n = 100;
                }
            } else if (SystemUtil.IS_MAC_OS) {
                GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                try {
                    Field field = graphicsDevice.getClass().getDeclaredField("scale");
                    if (field == null) break block11;
                    field.setAccessible(true);
                    Object object = field.get(graphicsDevice);
                    if (object != null && object instanceof Integer && (n = (Integer)object * -100) == -100) {
                        n = 100;
                    }
                }
                catch (Exception exception) {}
            } else if (SystemUtil.IS_WINDOWS && (n2 = toolkit.getScreenResolution()) > 96) {
                n = n2 * 100 / 96;
            }
        }
        if (n == 100 && toolkit.getScreenSize().height >= 2000) {
            n = 150;
        }
        return n;
    }

    public static int getDisplayScaling() {
        if (!isHeadless && displayScaling == 0) {
            AWTUtil.setDisplayScaling(-1);
        }
        return displayScaling;
    }

    public static double getScreenResolution() {
        if (!isHeadless && screenResolution == 0.0) {
            int n = AWTUtil.getDisplayScaling();
            screenResolution = n > 100 ? AWTUtil.px(96.0) : (double)Toolkit.getDefaultToolkit().getScreenResolution();
        }
        return screenResolution;
    }

    public static int px(int n) {
        int n2 = AWTUtil.getDisplayScaling();
        if (n2 > 100) {
            n = n * n2 / 100;
        }
        return n;
    }

    public static float px(float f) {
        int n = AWTUtil.getDisplayScaling();
        if (n > 100) {
            f = f * (float)n / 100.0f;
        }
        return f;
    }

    public static double px(double d) {
        int n = AWTUtil.getDisplayScaling();
        if (n > 100) {
            d = d * (double)n / 100.0;
        }
        return d;
    }

    public static int vpx(int n) {
        int n2 = AWTUtil.getDisplayScaling();
        if (n2 > 100) {
            n = n * 100 / n2;
        }
        return n;
    }

    public static double vpx(double d) {
        int n = AWTUtil.getDisplayScaling();
        if (n > 100) {
            d = d * 100.0 / (double)n;
        }
        return d;
    }

    public static Font pxDeriveFont(Font font, int n, int n2) {
        return font.deriveFont(n, (float)AWTUtil.derivedFontSize(font, n2));
    }

    private static double derivedFontSize(Font font, int n) {
        double d;
        double d2 = d = (double)font.getSize();
        if (n != 0) {
            d2 = AWTUtil.getDisplayScaling() > 100 ? Math.ceil(AWTUtil.px(AWTUtil.vpx(d) + (double)n)) : d + (double)n;
            if (d2 < 4.0) {
                d2 = 4.0;
            } else if (d2 > 144.0) {
                d2 = 144.0;
            }
        }
        return d2;
    }

    public static int pxFontSize(Font font, int n) {
        return (int)Math.rint(AWTUtil.derivedFontSize(font, n));
    }

    private static void detectBugs() {
        boolean bl;
        drawThinRectBug = bl = AWTUtil.getDisplayScaling() < -100;
        drawUnscaledImageBug = !SystemUtil.IS_MAC_OS && bl;
    }

    public static boolean hasDrawThinRectBug() {
        if (!bugsDetected) {
            bugsDetected = true;
            AWTUtil.detectBugs();
        }
        return drawThinRectBug;
    }

    public static boolean hasDrawUnscaledImageBug() {
        if (!bugsDetected) {
            bugsDetected = true;
            AWTUtil.detectBugs();
        }
        return drawUnscaledImageBug;
    }

    public static void setTextAntialiasing(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, TEXT_ANTIALIAS_FLAG);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, FRACTIONALMETRICS_FLAG);
    }

    public static void setLineAntialiasing(Graphics graphics, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static void union(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.width <= 0 || rectangle2.height <= 0) {
            return;
        }
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            rectangle.x = rectangle2.x;
            rectangle.y = rectangle2.y;
            rectangle.width = rectangle2.width;
            rectangle.height = rectangle2.height;
            return;
        }
        int n = Math.min(rectangle.x, rectangle2.x);
        int n2 = Math.max(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
        int n3 = Math.min(rectangle.y, rectangle2.y);
        int n4 = Math.max(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height);
        rectangle.x = n;
        rectangle.y = n3;
        rectangle.width = n2 - n;
        rectangle.height = n4 - n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getScaledImage(Image image, int n, int n2, boolean bl) {
        final int n3 = image.getWidth(null);
        final int n4 = image.getHeight(null);
        if (n <= 0 || n2 <= 0 || n3 <= 0 || n4 <= 0 || n == n3 && n2 == n4) {
            return image;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2){

            @Override
            public Object getProperty(String string) {
                if (AWTUtil.UNSCALED_IMAGE_SIZE_PROP.equals(string)) {
                    return new int[]{n3, n4};
                }
                return super.getProperty(string);
            }
        };
        double d = (double)n / (double)n3;
        double d2 = (double)n2 / (double)n4;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            Object object = bl ? (d >= 1.0 || d2 >= 1.0 ? RenderingHints.VALUE_INTERPOLATION_BICUBIC : RenderingHints.VALUE_INTERPOLATION_BILINEAR) : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            if (image instanceof RenderedImage) {
                graphics2D.drawRenderedImage((RenderedImage)((Object)image), affineTransform);
            } else {
                graphics2D.drawImage(image, affineTransform, null);
            }
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    public static int[] getUnscaledImageSize(Image image) {
        Object object;
        int[] nArray = null;
        if (image != null && image instanceof RenderedImage && (object = ((RenderedImage)((Object)image)).getProperty(UNSCALED_IMAGE_SIZE_PROP)) != null && object instanceof int[]) {
            nArray = (int[])object;
        }
        return nArray;
    }

    public static BufferedImage toBufferedImage(Image image) {
        return AWTUtil.toBufferedImage(image, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage toBufferedImage(Image image, int n) {
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            if (bufferedImage.getColorModel().getTransparency() == 1) {
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(0, 0, n2, n3);
            }
            graphics2D.drawImage(image, 0, 0, null);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    public static void setFocusable(Component component, boolean bl) {
        component.setFocusable(bl);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                AWTUtil.setFocusable(container.getComponent(i), bl);
            }
        }
    }

    public static String[] getFontFamilies() {
        if (fontFamilies == null) {
            fontFamilies = AWTUtil.getFontFamilies(null);
        }
        return fontFamilies;
    }

    public static String[] getFontFamilies(Locale locale) {
        Object[] objectArray = GENERIC_FONT_FAMILIES;
        try {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            objectArray = locale == null ? graphicsEnvironment.getAvailableFontFamilyNames() : graphicsEnvironment.getAvailableFontFamilyNames(locale);
            if (objectArray.length > 1) {
                Arrays.sort(objectArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objectArray;
    }

    public static String toHexString(Color color) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('#');
        int n = color.getRed();
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() < 2) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        n = color.getGreen();
        string = Integer.toHexString(n).toUpperCase();
        if (string.length() < 2) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        n = color.getBlue();
        string = Integer.toHexString(n).toUpperCase();
        if (string.length() < 2) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static Color fromHexString(String string) {
        if (string != null && (string = string.trim()).length() == 7) {
            try {
                int n = Integer.parseInt(string.substring(1, 3), 16);
                int n2 = Integer.parseInt(string.substring(3, 5), 16);
                int n3 = Integer.parseInt(string.substring(5, 7), 16);
                return new Color(n, n2, n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Color editHSB(Color color, int n, float f, float f2, boolean bl) {
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), HSB);
        if (n >= 0) {
            if (n > 360) {
                n = 360;
            }
            AWTUtil.HSB[0] = (float)n / 360.0f;
        }
        if (f != 0.0f) {
            HSB[1] = HSB[1] + f;
            if (HSB[1] < 0.0f) {
                AWTUtil.HSB[1] = 0.0f;
            } else if (HSB[1] > 1.0f) {
                AWTUtil.HSB[1] = 1.0f;
            }
        }
        if (f2 != 0.0f) {
            if (bl && (double)HSB[2] < 0.5) {
                f2 = -f2;
            }
            HSB[2] = HSB[2] + f2;
            if (HSB[2] < 0.0f) {
                AWTUtil.HSB[2] = 0.0f;
            } else if (HSB[2] > 1.0f) {
                AWTUtil.HSB[2] = 1.0f;
            }
        }
        return Color.getHSBColor(HSB[0], HSB[1], HSB[2]);
    }

    public static Color toHighlightColor(Color color) {
        return AWTUtil.editHSB(color, -1, 0.0f, 0.03f, true);
    }

    public static Color toShadowColor(Color color) {
        return AWTUtil.editHSB(color, -1, 0.0f, -0.03f, true);
    }

    public static Color toDarkShadowColor(Color color) {
        return AWTUtil.editHSB(color, -1, 0.0f, -0.06f, true);
    }

    public static Color toBorderColor(Color color) {
        return AWTUtil.editHSB(color, -1, 0.0f, -0.2f, true);
    }

    public static Color toSeparatorColor(Color color) {
        return AWTUtil.editHSB(color, -1, 0.0f, -0.2f, true);
    }

    public static Color convertToGray(Color color, float f, boolean bl) {
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), HSB);
        float f2 = HSB[2];
        if (f != 0.0f) {
            if (bl && (double)f2 < 0.5) {
                f = -f;
            }
            if ((f2 += f) < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
        }
        return Color.getHSBColor(0.0f, 0.0f, f2);
    }

    static {
        Object v;
        isHeadless = GraphicsEnvironment.isHeadless();
        if (isHeadless) {
            systemDisplayScaling = 100;
            displayScaling = 100;
            screenResolution = 96.0;
        }
        JAVA_20_0_0 = new VersionNumber(20, 0, 0);
        FRACTIONALMETRICS_FLAG = RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        Object object = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map != null && (v = map.get(RenderingHints.KEY_TEXT_ANTIALIASING)) != null && v != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
            object = v;
        }
        TEXT_ANTIALIAS_FLAG = object;
        GENERIC_FONT_FAMILIES = new String[]{"Monospaced", "SansSerif", "Serif"};
        HSB = new float[3];
    }
}

