/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.Console;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.ProgressMonitor;
import com.xmlmind.util.ProgressMonitorConsole;
import com.xmlmind.util.SimpleProgressMonitor;
import com.xmlmind.util.StringList;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.URIComponent;
import com.xmlmind.util.URLUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.w2x.processor.CanceledException;
import com.xmlmind.w2x.processor.Msg;
import com.xmlmind.w2x.processor.SplitStep;
import com.xmlmind.w2x.processor.XPathFunctions;
import com.xmlmind.whc.Compiler;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.DocumentTypeDeclaration;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.save.SaveDocument;
import com.xmlmind.xml.save.SaveOptions;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class WebHelpStep
extends SplitStep {
    protected static final Namespace WHC_NS = Namespace.get("http://www.xmlmind.com/whc/schema/whc");
    protected static final PrefixEntry[] PREFIX_ENTRIES = new PrefixEntry[]{new PrefixEntry("", WHC_NS), new PrefixEntry("htm", Namespace.XHTML)};
    protected static final Name TOC_NAME = Name.get(WHC_NS, "toc");
    protected static final Name ENTRY_NAME = Name.get(WHC_NS, "entry");
    protected static final Name TITLE_NAME = Name.get(WHC_NS, "title");
    protected static final Name INDEX_NAME = Name.get(WHC_NS, "index");
    protected static final Name MERGE_AND_SORT_NAME = Name.get("mergeAndSort");
    protected static final Name TERM_NAME = Name.get(WHC_NS, "term");
    protected static final Name ANCHOR_NAME = Name.get(WHC_NS, "anchor");
    protected static final Name SEE_NAME = Name.get(WHC_NS, "see");
    protected static final Name REF_NAME = Name.get("ref");
    protected static final String WINDOW_ONLOAD = "window.onload = w2x_expandTabs;";
    protected static final String DOCUMENT_READY = "$(document).ready(function() { w2x_expandTabs(); });";

    public WebHelpStep(String string) {
        super(string);
    }

    @Override
    public void process(Object[] objectArray, Map<String, String> map, int[] nArray, ProgressMonitor progressMonitor) throws Exception {
        Object object;
        String string;
        if (!(objectArray[0] instanceof Document)) {
            this.illegalState(Document.class);
        }
        Document document = (Document)objectArray[0];
        File file = this.getFileParameter(map, "out-file", null);
        if (file == null) {
            this.missingParameter("out-file");
        }
        if ((string = FileUtil.getExtension(file)) == null || string.toLowerCase().startsWith("xht")) {
            file = FileUtil.setExtension(file, "html");
        }
        File file2 = file.getParentFile();
        this.progress(Msg.msg("webHelpStep", file2), nArray, progressMonitor);
        this.debugParameters(map, progressMonitor);
        boolean bl = this.getBooleanParameter(map, "add-index", true);
        boolean bl2 = this.getBooleanParameter(map, "omit-toc-root", false);
        int n = this.getIntParameter(map, "split-before-level", 0, 8, 0);
        boolean bl3 = this.getBooleanParameter(map, "use-id-as-filename", false);
        boolean bl4 = this.getBooleanParameter(map, "allow-lonely-heading", false);
        boolean bl5 = this.getBooleanParameter(map, "indent", false);
        ArrayList<SplitStep.Part> arrayList = new ArrayList<SplitStep.Part>();
        HashSet<String> hashSet = null;
        if (bl3) {
            hashSet = new HashSet<String>();
            hashSet.add(FileUtil.setExtension(file.getName(), null));
        }
        this.splitDocument(document, n, hashSet, bl4, file, arrayList, progressMonitor);
        this.processParts(arrayList, document);
        Element[] elementArray = this.processIndexTerms(arrayList);
        this.saveParts(arrayList, bl5, "UTF-8", file, progressMonitor);
        File file3 = new File(file2, "__TOC.xml");
        this.saveTOC(arrayList, bl2, file3, progressMonitor);
        File file4 = null;
        if (elementArray != null) {
            object = null;
            if (arrayList.size() > 0) {
                object = arrayList.get((int)0).lang;
            }
            file4 = new File(file2, "__Index.xml");
            this.saveIndex(elementArray, (String)object, file4, progressMonitor);
        }
        this.compileWebHelp(arrayList, file3, file4, map, progressMonitor);
        file3.delete();
        if (file4 != null) {
            file4.delete();
        }
        if (bl && !((File)(object = new File(file2, "index.html"))).exists()) {
            File file5 = null;
            if (arrayList.size() > 0) {
                file5 = arrayList.get((int)0).file;
            }
            if (file5 != null) {
                WebHelpStep.creatingFile((File)object, progressMonitor);
                FileUtil.copyFile(file5, (File)object);
            }
        }
        objectArray[0] = file;
    }

    @Override
    protected Document createPartTemplate(Document document) throws Exception {
        URL uRL;
        String string;
        Document document2 = super.createPartTemplate(document);
        if (document2 == null) {
            return null;
        }
        Element element = document.getRootElement().getChildElement(0);
        Element element2 = Util.findDescendant(element, Constants.SCRIPT_ELEM);
        if (element2 != null && (string = element2.getAttribute(Constants.SRC_ATTR)) != null && (string = string.trim()).length() > 0 && string.endsWith("expand-tabs.js") && (uRL = document.getSourceURL()) != null) {
            Object object;
            File file = null;
            try {
                object = URLUtil.createURL(uRL, string);
                file = URLUtil.urlToFile((URL)object);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (file != null) {
                object = FileUtil.loadString(file, "UTF-8");
                int n = ((String)object).indexOf(WINDOW_ONLOAD);
                if (n >= 0) {
                    StringBuilder stringBuilder = new StringBuilder((String)object);
                    stringBuilder.delete(n, n + WINDOW_ONLOAD.length());
                    stringBuilder.insert(n, DOCUMENT_READY);
                    object = stringBuilder.toString();
                    FileUtil.saveString((String)object, file, "UTF-8");
                } else {
                    throw new RuntimeException("Internal error: did not find \"window.onload = w2x_expandTabs;\" in \"" + String.valueOf(file) + "\"");
                }
            }
        }
        return document2;
    }

    @Override
    protected File newOutFile(File file, int n) {
        if (n <= 0) {
            return file;
        }
        return WebHelpStep.newOutFile(file, "-" + n);
    }

    protected Element[] processIndexTerms(List<SplitStep.Part> list) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (SplitStep.Part elementArray2 : list) {
            Document document = elementArray2.document;
            if (document == null) continue;
            boolean bl = false;
            DocumentTypeDeclaration documentTypeDeclaration = document.getDocumentTypeDeclaration();
            if (documentTypeDeclaration != null && (documentTypeDeclaration.publicId == null && documentTypeDeclaration.systemId == null || "-//W3C//DTD XHTML 1.1//EN".equals(documentTypeDeclaration.publicId))) {
                bl = true;
            }
            this.processIndexTerms(document.getRootElement().getChildElement(1), elementArray2.href, bl, arrayList);
        }
        this.linkIndexTerms(arrayList);
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        Element[] elementArray = new Element[n];
        arrayList.toArray(elementArray);
        return elementArray;
    }

    protected void processIndexTerms(Element element, String string, boolean bl, List<Element> list) {
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getType() == Node.Type.ELEMENT) {
                Element element2 = (Element)node;
                if (element2.getName() == Constants.SPAN_ELEM && XPathFunctions.getClass(element2, "/role-index-term(-start)?/") != null) {
                    String string2 = element2.getAttribute(Constants.ID_ATTR);
                    if (string2 != null) {
                        Element element3 = this.toIndexEntry(element2, string2, string);
                        if (element3 != null) {
                            list.add(element3);
                        }
                        Element element4 = new Element(Constants.A_ELEM);
                        element4.putAttribute(Constants.ID_ATTR, string2);
                        if (!bl) {
                            element4.putAttribute(Constants.NAME_ATTR, string2);
                        }
                        element.replaceChild(element2, element4);
                    }
                } else {
                    this.processIndexTerms(element2, string, bl, list);
                }
            }
            node = node2;
        }
    }

    protected Element toIndexEntry(Element element, String string, String string2) {
        Element element2;
        Object object = null;
        Object object2 = null;
        Element element3 = null;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Object object3;
            if (node.getType() != Node.Type.ELEMENT || (element2 = (Element)node).getName() != Constants.SPAN_ELEM) continue;
            if (XPathFunctions.getClass(element2, "role-index-term-1") != null || XPathFunctions.getClass(element2, "role-index-term-2") != null || XPathFunctions.getClass(element2, "role-index-term-3") != null) {
                object3 = new Element(ENTRY_NAME);
                String string3 = element2.getText();
                if (string3 == null || (string3 = XMLText.collapseWhiteSpace(string3)).length() == 0) {
                    return null;
                }
                Element element4 = new Element(TERM_NAME);
                element4.appendChild(new Text(string3));
                ((Tree)object3).appendChild(element4);
                if (object2 == null) {
                    object = object2 = object3;
                    continue;
                }
                ((Tree)object2).appendChild((Node)object3);
                object2 = object3;
                continue;
            }
            if (XPathFunctions.getClass(element2, "role-index-term-see") == null) continue;
            element3 = new Element(SEE_NAME);
            object3 = element2.getText();
            if (object3 == null || ((String)(object3 = XMLText.collapseWhiteSpace((String)object3))).length() == 0) {
                return null;
            }
            element3.appendChild(new Text((String)object3));
            if (object2 == null) {
                return null;
            }
            ((Tree)object2).appendChild(element3);
        }
        if (element3 == null) {
            element2 = new Element(ANCHOR_NAME);
            element2.putAttribute(Constants.HREF_ATTR, string2 + "#" + URIComponent.quoteFragment(string));
            if (object2 == null) {
                return null;
            }
            ((Tree)object2).appendChild(element2);
        }
        return object;
    }

    protected void linkIndexTerms(List<Element> list) {
        HashMap<String, EntryElement> hashMap = new HashMap<String, EntryElement>();
        HashMap<String, EntryElement> hashMap2 = new HashMap<String, EntryElement>();
        HashMap<String, Element[]> hashMap3 = new HashMap<String, Element[]>();
        for (Element object : list) {
            this.linkIndexTerm(object, StringList.EMPTY_LIST, hashMap, hashMap2, hashMap3);
        }
        if (hashMap3.size() == 0) {
            return;
        }
        int n = 0;
        for (Map.Entry entry : hashMap3.entrySet()) {
            String string = (String)entry.getKey();
            Element[] elementArray = (Element[])entry.getValue();
            EntryElement entryElement = hashMap.get(string);
            if (entryElement == null) {
                entryElement = hashMap2.get(string);
            }
            if (entryElement == null) continue;
            Element element = entryElement.element;
            Object object = element.getAttribute(Name.XML_ID);
            if (object == null) {
                object = "__IE" + Integer.toString(++n) + "__";
                element.putAttribute(Name.XML_ID, (String)object);
            }
            for (Element element2 : elementArray) {
                if (element2.getParent() == element) continue;
                element2.putAttribute(REF_NAME, (String)object);
            }
        }
    }

    protected void linkIndexTerm(Element element, String[] stringArray, Map<String, EntryElement> map, Map<String, EntryElement> map2, Map<String, Element[]> map3) {
        String string = null;
        String[] stringArray2 = null;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getType() == Node.Type.ELEMENT) {
                String string2;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == TERM_NAME) {
                    string = element2.getText();
                    if (string == null || string.length() == 0) {
                        return;
                    }
                    string = string.toLowerCase();
                    stringArray2 = StringList.append(stringArray, string);
                    string2 = StringUtil.join(' ', stringArray2);
                    int n = stringArray2.length - 1;
                    EntryElement entryElement = map.get(string2);
                    if (entryElement == null || entryElement.nesting > n) {
                        map.put(string2, new EntryElement(element, n));
                    }
                    if ((entryElement = map2.get(string)) == null || entryElement.nesting > n) {
                        map2.put(string, new EntryElement(element, n));
                    }
                } else if (name == SEE_NAME) {
                    string2 = element2.getText();
                    if (string2 == null || string2.length() == 0) continue;
                    Element[] elementArray = map3.get(string2 = string2.toLowerCase());
                    elementArray = elementArray == null ? new Element[]{element2} : ArrayUtil.append(elementArray, element2);
                    map3.put(string2, elementArray);
                } else if (name == ENTRY_NAME) {
                    if (stringArray2 == null) {
                        return;
                    }
                    this.linkIndexTerm(element2, stringArray2, map, map2, map3);
                }
            }
            node = node.getNextSibling();
        }
    }

    @Override
    protected void saveDocument(Document document, boolean bl, String string, File file, ProgressMonitor progressMonitor) throws CanceledException, IOException {
        Node node;
        Element element = document.getRootElement().getChildElement(0);
        Node node2 = element.getFirstChild();
        while (node2 != null) {
            Element element2;
            node = node2.getNextSibling();
            if (node2.getType() == Node.Type.ELEMENT && (element2 = (Element)node2).getName() == Constants.META_ELEM && (element2.hasAttribute(Constants.HTTP_EQUIV_ATTR) || element2.hasAttribute(Constants.CHARSET_ATTR))) {
                element.removeChild(element2);
            }
            node2 = node;
        }
        node = new Element(Constants.META_ELEM);
        ((Element)node).putAttribute(Constants.HTTP_EQUIV_ATTR, "content-type");
        ((Element)node).putAttribute(Constants.CONTENT_ATTR, "text/html;charset=UTF-8");
        element.insertChild(element.getFirstChild(), node);
        super.saveDocument(document, bl, "UTF-8", file, progressMonitor);
    }

    protected void saveTOC(List<SplitStep.Part> list, boolean bl, File file, ProgressMonitor progressMonitor) throws CanceledException, IOException {
        WebHelpStep.creatingFile(file, progressMonitor);
        SaveOptions saveOptions = new SaveOptions();
        saveOptions.encoding = "UTF-8";
        saveOptions.preferredPrefixes = PREFIX_ENTRIES;
        saveOptions.useOriginalPrefixes = false;
        saveOptions.indent = 2;
        SaveDocument.save(this.toTOC(list, bl), file, saveOptions);
    }

    protected Document toTOC(List<SplitStep.Part> list, boolean bl) {
        Document document = new Document();
        Element element = new Element(TOC_NAME);
        document.appendChild(element);
        int n = list.size();
        if (n > 0) {
            Stack<SplitStep.Part> stack = new Stack<SplitStep.Part>();
            for (int i = 0; i < n; ++i) {
                Object object;
                SplitStep.Part part = list.get(i);
                Element element2 = null;
                if (i > 0 || !bl) {
                    element2 = new Element(ENTRY_NAME);
                    element2.putAttribute(Constants.HREF_ATTR, part.href);
                    object = new Element(TITLE_NAME);
                    element2.appendChild((Node)object);
                    ((Tree)object).appendChild(new Text(part.title));
                    part.clientData = element2;
                }
                if (i == 0) {
                    if (bl) {
                        part.clientData = element;
                    } else {
                        element.appendChild(element2);
                    }
                } else {
                    object = (SplitStep.Part)stack.peek();
                    while (((SplitStep.Part)object).level >= part.level) {
                        stack.pop();
                        object = (SplitStep.Part)stack.peek();
                    }
                    ((Element)((SplitStep.Part)object).clientData).appendChild(element2);
                }
                stack.push(part);
            }
        }
        return document;
    }

    protected void saveIndex(Element[] elementArray, String string, File file, ProgressMonitor progressMonitor) throws CanceledException, IOException {
        WebHelpStep.creatingFile(file, progressMonitor);
        Document document = new Document();
        Element element = new Element(INDEX_NAME);
        document.appendChild(element);
        element.putAttribute(MERGE_AND_SORT_NAME, "true");
        if (string != null) {
            element.putAttribute(Name.XML_LANG, string);
        }
        for (Element element2 : elementArray) {
            element.appendChild(element2);
        }
        SaveOptions saveOptions = new SaveOptions();
        saveOptions.encoding = "UTF-8";
        saveOptions.preferredPrefixes = PREFIX_ENTRIES;
        saveOptions.useOriginalPrefixes = false;
        saveOptions.indent = 2;
        SaveDocument.save(document, file, saveOptions);
    }

    protected void compileWebHelp(List<SplitStep.Part> list, File file, File file2, Map<String, String> map, ProgressMonitor progressMonitor) throws Exception {
        URL[] uRLArray;
        if (!progressMonitor.message(Msg.msg("compilingWebHelp", file.getParentFile()), Console.MessageType.VERBOSE)) {
            throw new CanceledException();
        }
        ProgressMonitorConsole progressMonitorConsole = new ProgressMonitorConsole(progressMonitor);
        Compiler compiler = new Compiler(progressMonitorConsole);
        compiler.setVerbose(WebHelpStep.isDebug(progressMonitor));
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.stepName + ".wh-";
        int n = string.length();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            uRLArray = entry.getKey();
            if (!uRLArray.startsWith(string)) continue;
            arrayList.add(uRLArray.substring(n));
            arrayList.add(entry.getValue());
        }
        if (arrayList.size() > 0 && !compiler.parseParameters(arrayList.toArray(StringUtil.EMPTY_LIST))) {
            throw new RuntimeException(Msg.msg("cannotConfigureWHC"));
        }
        int n2 = list.size();
        uRLArray = new URL[n2];
        n2 = 0;
        for (SplitStep.Part object2 : list) {
            if (object2.file == null) continue;
            uRLArray[n2++] = FileUtil.fileToURL(object2.file);
        }
        if (n2 != uRLArray.length) {
            uRLArray = ArrayUtil.trimToSize(uRLArray, n2);
        }
        URL uRL = FileUtil.fileToURL(file);
        URL uRL2 = file2 == null ? null : FileUtil.fileToURL(file2);
        compiler.compile(uRLArray, uRL, uRL2, null);
    }

    protected static final boolean isDebug(ProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor instanceof SimpleProgressMonitor) {
            SimpleProgressMonitor simpleProgressMonitor = (SimpleProgressMonitor)progressMonitor;
            return simpleProgressMonitor.messageLevel >= Console.MessageType.DEBUG.ordinal();
        }
        return false;
    }

    protected static final class EntryElement {
        public final Element element;
        public final int nesting;

        public EntryElement(Element element, int n) {
            this.element = element;
            this.nesting = n;
        }
    }
}

