/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.Console;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.LinearHashtable;
import com.xmlmind.util.URLUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.w2x.processor.CSSRule;
import com.xmlmind.w2x.processor.CSSRules;
import com.xmlmind.w2x.processor.Msg;
import com.xmlmind.w2x.processor.ParseStylesCmd;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.xed.Command;
import com.xmlmind.xml.xed.Script;
import com.xmlmind.xml.xpath.ExprContext;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public final class UnparseStylesCmd
extends Command {
    private static final String[] ARG_SPEC = new String[]{"css-uri", "String", "", "custom-styles-url-or-file", "String", ""};

    @Override
    public void executeCommand(Object[] objectArray, XNode xNode, ExprContext exprContext, Script script, Console console) throws Exception {
        objectArray = UnparseStylesCmd.parseArguments(objectArray, ARG_SPEC, "unparse-styles", xNode, exprContext, script);
        String string = (String)objectArray[0];
        String string2 = null;
        String string3 = (String)objectArray[1];
        if (string3 != null && (string3 = string3.trim()).length() > 0) {
            string2 = UnparseStylesCmd.loadCSS(string3);
        }
        Document document = (Document)xNode.document();
        this.execute(document, string, string2, true);
    }

    private static String loadCSS(String string) throws IllegalArgumentException, IOException {
        URL uRL = URLUtil.urlOrFile(string);
        if (uRL == null) {
            throw new IllegalArgumentException(Msg.msg("notAnURLOrFile", string));
        }
        return ParseStylesCmd.loadCSS(uRL);
    }

    public String execute(Document document, String string, String string2, boolean bl) {
        Object object = null;
        CSSRules cSSRules = ParseStylesCmd.removeRulesProperty(document);
        if (cSSRules != null && cSSRules.size() > 0) {
            object = cSSRules.toString();
        }
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            object = object == null ? string2 : (String)object + "\n" + string2;
        }
        Element element = document.getRootElement();
        if (object != null && !UnparseStylesCmd.saveToFile((String)object, string, bl, document)) {
            UnparseStylesCmd.saveToElement((String)object, element);
        }
        UnparseStylesCmd.process(element);
        return object;
    }

    private static boolean saveToFile(String string, String string2, boolean bl, Document document) {
        URL uRL;
        boolean bl2 = false;
        if (string2 != null && (string2 = string2.trim()).length() > 0 && (uRL = document.getSourceURL()) != null) {
            Serializable serializable;
            File file = null;
            try {
                serializable = URLUtil.createURL(uRL, string2);
                file = URLUtil.urlToFile((URL)serializable);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (file != null) {
                if (!bl && file.isFile()) {
                    bl2 = true;
                } else {
                    serializable = new StringBuilder();
                    ((StringBuilder)serializable).append("@charset \"UTF-8\";\n");
                    ((StringBuilder)serializable).append(string);
                    string = ((StringBuilder)serializable).toString();
                    try {
                        File file2 = file.getParentFile();
                        if (file2 != null && !file2.exists()) {
                            FileUtil.checkedMkdirs(file2);
                        }
                        FileUtil.saveString(string, file, "UTF-8");
                        bl2 = true;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return bl2;
    }

    private static boolean saveToElement(String string, Element element) {
        boolean bl = false;
        Element element2 = Util.findDescendant(element, Constants.HEAD_ELEM);
        if (element2 != null) {
            Element element3 = Util.findDescendant(element2, Constants.STYLE_ELEM);
            if (element3 == null) {
                element3 = new Element(Constants.STYLE_ELEM);
                element2.appendChild(element3);
            } else {
                element3.removeAllChildren();
            }
            element3.putAttribute(Constants.TYPE_ATTR, "text/css");
            element3.appendChild(new Text(string));
            bl = true;
        }
        return bl;
    }

    private static void process(Element element) {
        Object object;
        Serializable serializable;
        int n;
        List<String> list = ParseStylesCmd.removeClassProperty(element);
        if (list != null && (n = list.size()) > 0) {
            serializable = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    ((StringBuilder)serializable).append(' ');
                }
                ((StringBuilder)serializable).append(list.get(i));
            }
            object = element.getAttribute(Constants.CLASS_ATTR);
            if (object != null && ((String)(object = ((String)object).trim())).length() > 0) {
                for (String string : XMLText.splitList((String)object)) {
                    if (list.contains(string)) continue;
                    ((StringBuilder)serializable).append(' ');
                    ((StringBuilder)serializable).append(string);
                }
            }
            element.putAttribute(Constants.CLASS_ATTR, ((StringBuilder)serializable).toString());
        }
        if ((serializable = ParseStylesCmd.removeStyleProperty(element)) != null && ((LinearHashtable)serializable).size() > 0) {
            object = new StringBuilder();
            CSSRule.toString(serializable, ' ', (StringBuilder)object);
            String[] stringArray = element.getAttribute(Constants.STYLE_ATTR);
            if (stringArray != null && (stringArray = stringArray.trim()).length() > 0) {
                ((StringBuilder)object).append("; ");
                ((StringBuilder)object).append((String)stringArray);
            }
            element.putAttribute(Constants.STYLE_ATTR, ((StringBuilder)object).toString());
        }
        for (object = element.getFirstChild(); object != null; object = ((Node)object).getNextSibling()) {
            if (((Node)object).getType() != Node.Type.ELEMENT) continue;
            UnparseStylesCmd.process((Element)object);
        }
    }
}

