/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.ProgressMonitor;
import com.xmlmind.util.ProgressMonitorConsole;
import com.xmlmind.util.URLUtil;
import com.xmlmind.util.XMLUtil;
import com.xmlmind.w2x.processor.ConsoleErrorListener;
import com.xmlmind.w2x.processor.Msg;
import com.xmlmind.w2x.processor.NoEntityResolver;
import com.xmlmind.w2x.processor.ProcessStep;
import com.xmlmind.w2x.processor.XSLTCache;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.resolve.XMLCatalogs;
import com.xmlmind.xml.save.DocumentWriter;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class TransformStep
extends ProcessStep {
    public TransformStep(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Object[] objectArray, Map<String, String> map, int[] nArray, ProgressMonitor progressMonitor) throws Exception {
        URL uRL;
        InputSource inputSource;
        File file;
        File file2;
        Document document = null;
        File file3 = null;
        if (objectArray[0] instanceof Document) {
            document = (Document)objectArray[0];
        } else if (objectArray[0] instanceof File) {
            file3 = (File)objectArray[0];
        } else {
            throw new IllegalArgumentException("step \"" + this.stepName + "\": state[0] expected to contain a Document or a File");
        }
        URL uRL2 = this.getURLParameter(map, "xslt-url-or-file", null);
        if (uRL2 == null) {
            this.missingParameter("xslt-url-or-file");
        }
        if ((file2 = this.getFileParameter(map, "out-file", null)) == null) {
            this.missingParameter("out-file");
        }
        if ((file = file2.getParentFile()) != null && !file.isDirectory()) {
            FileUtil.checkedMkdirs(file);
        }
        this.progress(Msg.msg("transformStep", URLUtil.toLabel(uRL2), file2), nArray, progressMonitor);
        this.debugParameters(map, progressMonitor);
        ProgressMonitorConsole progressMonitorConsole = new ProgressMonitorConsole(progressMonitor);
        Transformer transformer = XSLTCache.newTransformer(uRL2, progressMonitorConsole);
        String[] stringArray = this.getAllParameters(map);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                transformer.setParameter(stringArray[i], stringArray[i + 1]);
            }
        }
        transformer.setURIResolver(XMLCatalogs.getURIResolver());
        transformer.setErrorListener(new ConsoleErrorListener(progressMonitorConsole));
        XMLReader xMLReader = XMLUtil.newSAXParser().getXMLReader();
        xMLReader.setEntityResolver(NoEntityResolver.INSTANCE);
        InputStream inputStream = null;
        if (document != null) {
            inputSource = new InputSource(new StringReader(TransformStep.docToString(document)));
            uRL = document.getSourceURL();
            if (uRL == null) {
                uRL = FileUtil.fileToURL(new File("(string)"));
            }
        } else {
            uRL = FileUtil.fileToURL(file3);
            inputStream = uRL.openStream();
            inputSource = new InputSource(inputStream);
        }
        try {
            String string = uRL.toExternalForm();
            inputSource.setSystemId(string);
            SAXSource sAXSource = new SAXSource(xMLReader, inputSource);
            sAXSource.setSystemId(string);
            StreamResult streamResult = new StreamResult(file2);
            transformer.transform(sAXSource, streamResult);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        objectArray[0] = file2;
    }

    protected static final String docToString(Document document) throws Exception {
        int n;
        StringWriter stringWriter = new StringWriter();
        DocumentWriter documentWriter = new DocumentWriter(stringWriter);
        PrefixEntry[] prefixEntryArray = document.getPrefixPreferences(true);
        if (prefixEntryArray != null && (n = prefixEntryArray.length) > 0) {
            Namespace namespace = document.prefixToNamespace("");
            PrefixEntry[] prefixEntryArray2 = new PrefixEntry[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                PrefixEntry prefixEntry = prefixEntryArray[i];
                if (prefixEntry.namespace == namespace && prefixEntry.prefix.length() != 0) continue;
                prefixEntryArray2[n2++] = prefixEntry;
            }
            if (n2 > 0) {
                if (n2 != n) {
                    prefixEntryArray2 = ArrayUtil.trimToSize(prefixEntryArray2, n2);
                }
                documentWriter.setPrefixPreferences(prefixEntryArray2);
            }
        }
        stringWriter.write("<?xml version=\"1.0\"?>\n");
        documentWriter.write(document);
        documentWriter.flush();
        return stringWriter.toString();
    }
}

