/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.Console;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.ProgressMonitor;
import com.xmlmind.util.StringUtil;
import com.xmlmind.w2x.processor.CanceledException;
import com.xmlmind.xml.resolve.XMLCatalogs;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;

public abstract class ProcessStep {
    public final String stepName;
    boolean defaultStep;

    protected ProcessStep(String string) {
        this.stepName = string;
    }

    public int hashCode() {
        return this.stepName.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ProcessStep)) {
            return false;
        }
        return this.stepName.equals(((ProcessStep)object).stepName);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.stepName);
        stringBuilder.append(" (");
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public abstract void process(Object[] var1, Map<String, String> var2, int[] var3, ProgressMonitor var4) throws Exception;

    protected final void progress(String string, int[] nArray, ProgressMonitor progressMonitor) throws CanceledException {
        int n = nArray[0];
        nArray[0] = n + 1;
        if (!progressMonitor.step(n) || !progressMonitor.message(string, Console.MessageType.VERBOSE)) {
            throw new CanceledException();
        }
    }

    protected final void debugParameters(Map<String, String> map, ProgressMonitor progressMonitor) throws CanceledException {
        String string = this.joinAllParameters(map, null, "=", " ");
        if (string != null && !progressMonitor.message(string, Console.MessageType.DEBUG)) {
            throw new CanceledException();
        }
    }

    protected final String joinAllParameters(Map<String, String> map, String string, String string2, String string3) {
        String string4 = this.stepName + ".";
        int n = string4.length();
        StringBuilder stringBuilder = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string5 = entry.getKey();
            if (!string5.startsWith(string4)) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            if (string != null) {
                stringBuilder.append(string);
            }
            stringBuilder.append(string5);
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(StringUtil.quoteArgument(entry.getValue()));
            if (string3 == null) continue;
            stringBuilder.append(string3);
        }
        if (stringBuilder == null) {
            return null;
        }
        return stringBuilder.toString();
    }

    protected final void illegalState(Class<?> clazz) throws IllegalArgumentException {
        throw new IllegalArgumentException("step \"" + this.stepName + "\": state[0] expected to contain an instance of " + clazz.getName());
    }

    protected final void missingParameter(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("step \"" + this.stepName + "\": required parameter \"" + this.parameterName(string) + "\" is missing");
    }

    protected final String parameterName(String string) {
        StringBuilder stringBuilder = new StringBuilder(this.stepName);
        stringBuilder.append('.');
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    protected final String[] getAllParameters(Map<String, String> map) {
        String string = this.stepName + ".";
        int n = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2.substring(n));
            arrayList.add(entry.getValue());
        }
        return arrayList.toArray(StringUtil.EMPTY_LIST);
    }

    protected final String getParameter(Map<String, String> map, String string, String string2) {
        String string3 = map.get(this.parameterName(string));
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    protected final boolean getBooleanParameter(Map<String, String> map, String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = map.get(this.parameterName(string));
        if (string2 != null) {
            if ("true".equals(string2) || "yes".equals(string2) || "on".equals(string2) || "1".equals(string2)) {
                bl2 = true;
            } else if ("false".equals(string2) || "no".equals(string2) || "off".equals(string2) || "0".equals(string2)) {
                bl2 = false;
            }
        }
        return bl2;
    }

    protected final int getIntParameter(Map<String, String> map, String string, int n, int n2, int n3) {
        int n4 = n3;
        String string2 = map.get(this.parameterName(string));
        if (string2 != null) {
            try {
                int n5 = Integer.parseInt(string2);
                if (n5 >= n && n5 <= n2) {
                    n4 = n5;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n4;
    }

    protected final File getFileParameter(Map<String, String> map, String string, File file) {
        File file2 = file;
        String string2 = map.get(this.parameterName(string));
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            file2 = new File(string2);
        }
        return file2;
    }

    protected final URL getURLParameter(Map<String, String> map, String string, URL uRL) {
        URL uRL2 = uRL;
        String string2 = map.get(this.parameterName(string));
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            uRL2 = ProcessStep.urlOrFile(string2, null);
        }
        return uRL2;
    }

    public static final URL urlOrFile(String string, URL uRL) {
        URL uRL2 = null;
        if (string != null && (string = string.trim()).length() > 0) {
            try {
                uRL2 = XMLCatalogs.resolveURI(string, uRL);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL2 == null) {
                File file;
                if (string.indexOf(47) >= 0 && File.separatorChar != '/') {
                    string = string.replace('/', File.separatorChar);
                }
                if ((file = new File(string)).exists()) {
                    uRL2 = FileUtil.fileToURL(file);
                }
            }
        }
        return uRL2;
    }
}

