/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.Console;
import com.xmlmind.util.LinearHashtable;
import com.xmlmind.util.LoadText;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.w2x.processor.CSSRule;
import com.xmlmind.w2x.processor.CSSRules;
import com.xmlmind.w2x.processor.Msg;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.xed.Command;
import com.xmlmind.xml.xed.Script;
import com.xmlmind.xml.xpath.ExprContext;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public final class ParseStylesCmd
extends Command {
    private static final Namespace STYLE_NAMESPACE = Namespace.get("urn:x-mlmind:namespace:style");
    private static final Name RULES_PROP = Name.get(STYLE_NAMESPACE, "rules");
    private static final Name STYLE_PROP = Name.get(STYLE_NAMESPACE, "style");
    private static final Name CLASS_PROP = Name.get(STYLE_NAMESPACE, "class");
    private static final Pattern CHARSET_REGEX = Pattern.compile("@charset[^;]*;", 32);
    private static final Pattern COMMENT_REGEX = Pattern.compile("/\\*.*\\*/", 32);
    private static final Pattern MULTI_SELECTOR_REGEX = Pattern.compile("\\s*,\\s*", 32);

    @Override
    public void executeCommand(Object[] objectArray, XNode xNode, ExprContext exprContext, Script script, Console console) throws Exception {
        ParseStylesCmd.parseArguments(objectArray, StringUtil.EMPTY_LIST, "parse-styles", xNode, exprContext, script);
        Document document = (Document)xNode.document();
        this.execute(document, console);
    }

    public void execute(Document document, Console console) throws Exception {
        CSSRules cSSRules = ParseStylesCmd.newRulesProperty(document);
        Element element = document.getRootElement();
        String string = ParseStylesCmd.getCSS(element);
        if (string != null) {
            this.parseRules(string, cSSRules);
        }
        ParseStylesCmd.process(element, console);
    }

    private static String getCSS(Element element) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        Element element2 = element.getChildElement(0);
        if (element2 != null) {
            Node node = element2.getFirstChild();
            while (node != null) {
                Node node2 = node.getNextSibling();
                if (node.getType() == Node.Type.ELEMENT) {
                    Element element3 = (Element)node;
                    Name name = element3.getName();
                    String string = null;
                    if (name == Constants.STYLE_ELEM) {
                        string = element3.getText();
                        element2.removeChild(element3);
                    } else if (name == Constants.LINK_ELEM && "stylesheet".equals(element3.getAttribute(Constants.REL_ATTR)) && "text/css".equals(element3.getAttribute(Constants.TYPE_ATTR))) {
                        URL uRL = null;
                        String string2 = element3.getAttribute(Constants.HREF_ATTR);
                        if (string2 != null) {
                            try {
                                uRL = URLUtil.createURL(element3.getBaseURL(), string2);
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                        element2.removeChild(element3);
                        if (uRL == null) {
                            if (string2 == null) {
                                string2 = "";
                            }
                            throw new RuntimeException(Msg.msg("missingOrInvalidAttr", string2, "href"));
                        }
                        string = ParseStylesCmd.loadCSS(uRL);
                    }
                    if (string != null) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append('\n');
                        }
                        stringBuilder.append(string);
                    }
                }
                node = node2;
            }
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    static String loadCSS(URL uRL) throws IOException {
        String string = null;
        try {
            string = LoadText.loadText(uRL, "UTF-8", null, LoadText.CSS_CHARSET_DETECTOR);
        }
        catch (IOException iOException) {
            throw new IOException(Msg.msg("cannotLoad", URLUtil.toLabel(uRL), ThrowableUtil.reason(iOException)));
        }
        string = CHARSET_REGEX.matcher(string).replaceAll("");
        string = COMMENT_REGEX.matcher(string).replaceAll("");
        if (string.indexOf("\r\n") >= 0) {
            string = StringUtil.replaceAll(string, "\r\n", "\n");
        }
        return string.trim();
    }

    private void parseRules(String string, CSSRules cSSRules) throws RuntimeException {
        int n;
        int n2 = string.length();
        int n3 = 0;
        int[] nArray = new int[1];
        boolean bl = false;
        while (n3 < n2 && (n = string.indexOf(123, n3)) >= n3) {
            String[] stringArray;
            String string2 = string.substring(n3, n).trim();
            if (string2.length() == 0) {
                bl = true;
                break;
            }
            nArray[0] = n + 1;
            String[] stringArray2 = Util.splitStyleProps(string, nArray);
            int n4 = nArray[0] - 1;
            if (n4 < 0 || n4 >= n2 || string.charAt(n4) != '}') {
                bl = true;
                break;
            }
            boolean bl2 = false;
            for (String string3 : stringArray = MULTI_SELECTOR_REGEX.split(string2, 0)) {
                if (string3.length() <= 0) continue;
                CSSRule cSSRule = new CSSRule(string3);
                if (!CSSRule.addProperties(stringArray2, cSSRule.properties)) {
                    bl = true;
                    break;
                }
                cSSRules.put(cSSRule);
                bl2 = true;
            }
            if (bl || !bl2) {
                bl = true;
                break;
            }
            n3 = nArray[0];
        }
        if (bl) {
            int n5 = n3 > 30 ? n3 - 30 : 0;
            int n6 = Math.min(n5 + 60, n2);
            String string4 = string.substring(n5, n6);
            string4 = XMLText.collapseWhiteSpace(string4);
            throw new RuntimeException(Msg.msg("cssParseError", string4));
        }
    }

    private static void process(Element element, Console console) {
        LinearHashtable<String, String> linearHashtable;
        Object object;
        Object object2;
        String string = element.removeAttribute(Constants.CLASS_ATTR);
        if (string != null && ((String[])(object2 = XMLText.splitList(string))).length > 0) {
            object = ParseStylesCmd.newClassProperty(element);
            Collections.addAll(object, object2);
        }
        if ((object2 = element.removeAttribute(Constants.STYLE_ATTR)) != null && ((String[])(object = Util.splitStyleProps((String)object2))).length > 0 && !CSSRule.addProperties((String[])object, linearHashtable = ParseStylesCmd.newStyleProperty(element))) {
            ParseStylesCmd.removeStyleProperty(element);
            console.showMessage(Msg.msg("cssParseError", object2), Console.MessageType.ERROR);
        }
        for (object = element.getFirstChild(); object != null; object = ((Node)object).getNextSibling()) {
            if (((Node)object).getType() != Node.Type.ELEMENT) continue;
            ParseStylesCmd.process((Element)object, console);
        }
    }

    public static CSSRules newRulesProperty(XNode xNode) {
        Document document = (Document)xNode.document();
        if (document == null) {
            return null;
        }
        CSSRules cSSRules = new CSSRules();
        document.putProperty(RULES_PROP, cSSRules);
        return cSSRules;
    }

    public static CSSRules getRulesProperty(XNode xNode) {
        Document document = (Document)xNode.document();
        if (document == null) {
            return null;
        }
        return (CSSRules)document.getProperty(RULES_PROP);
    }

    public static CSSRules removeRulesProperty(XNode xNode) {
        Document document = (Document)xNode.document();
        if (document == null) {
            return null;
        }
        return (CSSRules)document.removeProperty(RULES_PROP);
    }

    public static LinearHashtable<String, String> newStyleProperty(Element element) {
        LinearHashtable<String, String> linearHashtable = new LinearHashtable<String, String>();
        element.putProperty(STYLE_PROP, linearHashtable);
        return linearHashtable;
    }

    public static LinearHashtable<String, String> getStyleProperty(Element element) {
        return (LinearHashtable)element.getProperty(STYLE_PROP);
    }

    public static LinearHashtable<String, String> removeStyleProperty(Element element) {
        return (LinearHashtable)element.removeProperty(STYLE_PROP);
    }

    public static List<String> newClassProperty(Element element) {
        ArrayList<String> arrayList = new ArrayList<String>();
        element.putProperty(CLASS_PROP, arrayList);
        return arrayList;
    }

    public static List<String> getClassProperty(Element element) {
        return (List)element.getProperty(CLASS_PROP);
    }

    public static List<String> removeClassProperty(Element element) {
        return (List)element.removeProperty(CLASS_PROP);
    }
}

