/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.Console;
import com.xmlmind.w2x.processor.Msg;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;

final class ConsoleErrorListener
implements ErrorListener {
    public final Console console;

    public ConsoleErrorListener(Console console) {
        this.console = console;
    }

    @Override
    public void warning(TransformerException transformerException) throws TransformerException {
        if (this.console != null) {
            this.console.showMessage(Msg.msg("transformWarning", transformerException.getMessageAndLocation()), Console.MessageType.WARNING);
        }
    }

    @Override
    public void error(TransformerException transformerException) throws TransformerException {
        if (this.console != null) {
            this.console.showMessage(Msg.msg("transformError", transformerException.getMessageAndLocation()), Console.MessageType.ERROR);
        }
    }

    @Override
    public void fatalError(TransformerException transformerException) throws TransformerException {
        if (this.console != null) {
            this.console.showMessage(Msg.msg("transformFatalError", transformerException.getMessageAndLocation()), Console.MessageType.ERROR);
        }
        throw transformerException;
    }
}

