/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.processor;

import com.xmlmind.util.Console;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.processor.HTMLElements;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.xed.Command;
import com.xmlmind.xml.xed.Script;
import com.xmlmind.xml.xpath.ExprContext;
import java.util.IdentityHashMap;

public class BeforeSaveCmd
extends Command {
    private static final String[] ARG_SPEC = new String[]{"allow-flow", "Boolean", "true"};
    private static final String[] MERGEABLE_INLINE_LOCAL_NAMES = new String[]{"abbr", "acronym", "b", "bdi", "bdo", "big", "cite", "code", "dfn", "em", "font", "i", "kbd", "mark", "q", "s", "samp", "small", "span", "strike", "strong", "sub", "sup", "tt", "u", "var"};
    private static final IdentityHashMap<Name, Name> MERGEABLE_INLINE_NAMES = new IdentityHashMap();

    @Override
    public void executeCommand(Object[] objectArray, XNode xNode, ExprContext exprContext, Script script, Console console) throws IllegalArgumentException {
        objectArray = BeforeSaveCmd.parseArguments(objectArray, ARG_SPEC, "before-save", xNode, exprContext, script);
        boolean bl = (Boolean)objectArray[0];
        Document document = (Document)xNode.document();
        Element element = document.getRootElement().getChildElement(1);
        if (!bl && element != null) {
            BeforeSaveCmd.noFlowContent(element);
        }
        if (element != null) {
            BeforeSaveCmd.mergeBlocks(element);
        }
    }

    private static void noFlowContent(Element element) {
        if (HTMLElements.isFlow(element.getName())) {
            BeforeSaveCmd.wrapInlines(element);
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            if (node.getType() != Node.Type.ELEMENT || (element2 = (Element)node).getName() == Constants.P_ELEM) continue;
            BeforeSaveCmd.noFlowContent(element2);
        }
    }

    private static void wrapInlines(Element element) {
        Element element2 = null;
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            switch (node.getType()) {
                case TEXT: {
                    if (element2 == null) {
                        element2 = BeforeSaveCmd.insertWrapper(element, node);
                    }
                    element.removeChild(node);
                    element2.appendChild(node);
                    break;
                }
                case ELEMENT: {
                    Name name = ((Element)node).getName();
                    if (HTMLElements.isInline(name) || name == Name.MATH) {
                        if (element2 == null) {
                            element2 = BeforeSaveCmd.insertWrapper(element, node);
                        }
                        element.removeChild(node);
                        element2.appendChild(node);
                        break;
                    }
                    element2 = null;
                }
            }
            node = node2;
        }
    }

    private static Element insertWrapper(Element element, Node node) {
        Element element2 = new Element(Constants.P_ELEM);
        element2.putAttribute(Constants.CLASS_ATTR, "role-inline-wrapper");
        element.insertChild(node, element2);
        return element2;
    }

    private static void mergeBlocks(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            if (name == Constants.P_ELEM || name == Constants.LI_ELEM || name == Constants.H1_ELEM || name == Constants.H2_ELEM || name == Constants.H3_ELEM || name == Constants.H4_ELEM || name == Constants.H5_ELEM || name == Constants.H6_ELEM) {
                BeforeSaveCmd.mergeInlines(element2);
                continue;
            }
            BeforeSaveCmd.mergeBlocks(element2);
        }
    }

    private static boolean isMergeableInline(Name name, Element element) {
        if (name == Constants.SPAN_ELEM) {
            String string = element.getAttribute(Constants.CLASS_ATTR);
            return string == null || !"role-tab".equals(string);
        }
        return MERGEABLE_INLINE_NAMES.containsKey(name);
    }

    private static void mergeInlines(Element element) {
        Element element2 = null;
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getType() == Node.Type.ELEMENT) {
                Element element3 = (Element)node;
                Name name = element3.getName();
                if (BeforeSaveCmd.isMergeableInline(name, element3)) {
                    if (element2 != null && element2.getName() == name && BeforeSaveCmd.merge(element3, element2)) {
                        element.removeChild(element3);
                    } else {
                        element2 = element3;
                    }
                } else {
                    element2 = null;
                }
            } else {
                element2 = null;
            }
            node = node2;
        }
        for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            BeforeSaveCmd.mergeInlines((Element)node);
        }
    }

    private static boolean merge(Element element, Element element2) {
        XNode xNode;
        Object object;
        assert (element.getName() == element2.getName());
        int n = element2.getAttributeCount();
        if (element.getAttributeCount() != n) {
            return false;
        }
        if (n > 0) {
            boolean bl = true;
            object = element.getAttributes(false);
            while (object.hasNext()) {
                xNode = (Attribute)object.next();
                if (((Attribute)xNode).value.equals(element2.getAttribute(((Attribute)xNode).name))) continue;
                bl = false;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        Object object2 = element.getFirstChild();
        while (object2 != null) {
            object = ((Node)object2).getNextSibling();
            element.removeChild((Node)object2);
            if (((Node)object2).getType() == Node.Type.TEXT) {
                xNode = element2.getLastChild();
                if (xNode != null && ((Node)xNode).getType() == Node.Type.TEXT) {
                    ((Text)xNode).appendText(((Text)object2).getText());
                } else {
                    element2.appendChild((Node)object2);
                }
            } else {
                element2.appendChild((Node)object2);
            }
            object2 = object;
        }
        return true;
    }

    static {
        for (String string : MERGEABLE_INLINE_LOCAL_NAMES) {
            Name name = Name.get(Namespace.XHTML, string);
            MERGEABLE_INLINE_NAMES.put(name, name);
        }
    }
}

