/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.Console;
import com.xmlmind.util.LocaleUtil;
import com.xmlmind.util.StringList;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.docx.packaging.Part;
import com.xmlmind.w2x.docx.toxhtml.BasicPattern;
import com.xmlmind.w2x.docx.toxhtml.Binding;
import com.xmlmind.w2x.docx.toxhtml.Border;
import com.xmlmind.w2x.docx.toxhtml.CSSProperties;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.ImgTranslator;
import com.xmlmind.w2x.docx.toxhtml.Numbering;
import com.xmlmind.w2x.docx.toxhtml.NumberingEntry;
import com.xmlmind.w2x.docx.toxhtml.RemoveAnnotations;
import com.xmlmind.w2x.docx.toxhtml.Settings;
import com.xmlmind.w2x.docx.toxhtml.Style;
import com.xmlmind.w2x.docx.toxhtml.TabStop;
import com.xmlmind.w2x.docx.toxhtml.Theme;
import com.xmlmind.w2x.docx.toxhtml.Unlocalizer;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.PrefixPreferences;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class Styles {
    private final boolean alwaysUseLangVal;
    private final ImgTranslator imgTranslator;
    private final Console console;
    private Theme theme;
    private Settings settings;
    private Unlocalizer unlocalizer;
    private HashMap<String, String> styleIdToName;
    private ArrayList<Style> defaultStyles;
    private HashMap<String, Element> imgBullets;
    private HashMap<String, Style> styles;
    private String implicitParagraphStyleId;
    private String implicitParagraphStyleName;
    private String implicitCharacterStyleId;
    private String implicitCharacterStyleName;
    private String implicitTableStyleId;
    private String implicitTableStyleName;
    private HashMap<String, String> equivalentNumberingNames;
    private HashMap<String, Integer> referencedStyleNames;
    private static final String[] TABLE_STYLE_PREFIXES = new String[]{"tr", "tc", "tp"};
    private static final String[] TABLE_STYLE_SUFFIXES = new String[]{null, "wholeTable", "band1Vert", "band2Vert", "band1Horz", "band2Horz", "firstCol", "lastCol", "firstRow", "lastRow", "neCell", "nwCell", "seCell", "swCell"};
    private static final String[] QNAMES = new String[]{"w:abstractNum", "w:abstractNumId", "w:after", "w:afterLines", "w:ascii", "w:asciiTheme", "w:bar", "w:basedOn", "w:bdr", "w:before", "w:beforeLines", "w:between", "w:bottom", "w:color", "w:default", "w:docDefaults", "w:customStyle", "w:end", "w:endChars", "w:eastAsia", "w:evenHBand", "w:evenVBand", "w:fill", "w:firstColumn", "w:firstLine", "w:firstLineChars", "w:firstRow", "w:firstRowFirstColumn", "w:firstRowLastColumn", "w:hAnsi", "w:hAnsiTheme", "w:hRule", "w:hanging", "w:hangingChars", "w:ilvl", "w:insideH", "w:insideV", "w:lang", "w:lastColumn", "w:lastRow", "w:lastRowFirstColumn", "w:lastRowLastColumn", "w:leader", "w:left", "w:leftChars", "w:line", "w:lineRule", "w:link", "w:lvl", "w:lvlOverride", "w:name", "w:noHBand", "w:noVBand", "w:null", "w:num", "w:numId", "w:numPicBullet", "w:numPicBulletId", "w:numPr", "w:numStyleLink", "w:oddHBand", "w:oddVBand", "w:pPr", "w:pPrDefault", "w:pStyle", "w:pos", "w:rPr", "w:rPrDefault", "w:rStyle", "w:right", "w:rightChars", "w:shd", "w:space", "w:start", "w:startChars", "w:startOverride", "w:style", "w:styleId", "w:sz", "w:tab", "w:tblBorders", "w:tblCellMar", "w:tblPr", "w:tblStyle", "w:tblStylePr", "w:tcBorders", "w:tcMar", "w:tcPr", "w:themeColor", "w:themeShade", "w:themeTint", "w:themeFill", "w:themeFillShade", "w:themeFillTint", "w:tl2br", "w:top", "w:tr2bl", "w:trPr", "w:type", "w:val", "w:vanish", "w:w"};
    private Name name_w_abstractNum;
    private Name name_w_abstractNumId;
    private Name name_w_after;
    private Name name_w_afterLines;
    private Name name_w_ascii;
    private Name name_w_asciiTheme;
    private Name name_w_bar;
    private Name name_w_basedOn;
    private Name name_w_bdr;
    private Name name_w_before;
    private Name name_w_beforeLines;
    private Name name_w_between;
    private Name name_w_bottom;
    private Name name_w_color;
    private Name name_w_default;
    private Name name_w_docDefaults;
    private Name name_w_customStyle;
    private Name name_w_end;
    private Name name_w_endChars;
    private Name name_w_eastAsia;
    private Name name_w_evenHBand;
    private Name name_w_evenVBand;
    private Name name_w_fill;
    private Name name_w_firstColumn;
    private Name name_w_firstLine;
    private Name name_w_firstLineChars;
    private Name name_w_firstRow;
    private Name name_w_firstRowFirstColumn;
    private Name name_w_firstRowLastColumn;
    private Name name_w_hAnsi;
    private Name name_w_hAnsiTheme;
    private Name name_w_hRule;
    private Name name_w_hanging;
    private Name name_w_hangingChars;
    private Name name_w_ilvl;
    private Name name_w_insideH;
    private Name name_w_insideV;
    private Name name_w_lang;
    private Name name_w_lastColumn;
    private Name name_w_lastRow;
    private Name name_w_lastRowFirstColumn;
    private Name name_w_lastRowLastColumn;
    private Name name_w_leader;
    private Name name_w_left;
    private Name name_w_leftChars;
    private Name name_w_line;
    private Name name_w_lineRule;
    private Name name_w_link;
    private Name name_w_lvl;
    private Name name_w_lvlOverride;
    private Name name_w_name;
    private Name name_w_noHBand;
    private Name name_w_noVBand;
    private Name name_w_null;
    private Name name_w_num;
    private Name name_w_numId;
    private Name name_w_numPicBullet;
    private Name name_w_numPicBulletId;
    private Name name_w_numPr;
    private Name name_w_numStyleLink;
    private Name name_w_oddHBand;
    private Name name_w_oddVBand;
    private Name name_w_pPr;
    private Name name_w_pPrDefault;
    private Name name_w_pStyle;
    private Name name_w_pos;
    private Name name_w_rPr;
    private Name name_w_rPrDefault;
    private Name name_w_rStyle;
    private Name name_w_right;
    private Name name_w_rightChars;
    private Name name_w_shd;
    private Name name_w_space;
    private Name name_w_start;
    private Name name_w_startChars;
    private Name name_w_startOverride;
    private Name name_w_style;
    private Name name_w_styleId;
    private Name name_w_sz;
    private Name name_w_tab;
    private Name name_w_tblBorders;
    private Name name_w_tblCellMar;
    private Name name_w_tblPr;
    private Name name_w_tblStyle;
    private Name name_w_tblStylePr;
    private Name name_w_tcBorders;
    private Name name_w_tcMar;
    private Name name_w_tcPr;
    private Name name_w_themeColor;
    private Name name_w_themeShade;
    private Name name_w_themeTint;
    private Name name_w_themeFill;
    private Name name_w_themeFillShade;
    private Name name_w_themeFillTint;
    private Name name_w_tl2br;
    private Name name_w_top;
    private Name name_w_tr2bl;
    private Name name_w_trPr;
    private Name name_w_type;
    private Name name_w_val;
    private Name name_w_vanish;
    private Name name_w_w;
    private static final String[] PARSE_SPEC = new String[]{"w:b", "parse_w_b", "w:bdr", "parse_w_bdr", "w:cantSplit", "parse_w_cantSplit", "w:caps", "parse_w_caps", "w:cnfStyle", "parse_w_cnfStyle", "w:color", "parse_w_color", "w:contextualSpacing", "parse_w_contextualSpacing", "w:dstrike", "parse_w_dstrike", "w:effect", "parseSimpleProperty", "w:emboss", "parseToggleProperty", "w:highlight", "parse_w_highlight", "w:i", "parse_w_i", "w:imprint", "parseToggleProperty", "w:ind", "parse_w_ind", "w:isLgl", "parse_w_isLgl", "w:keepLines", "parse_w_keepLines", "w:keepNext", "parse_w_keepNext", "w:lang", "parse_w_lang", "w:lvl/w:pStyle", "parse_w_lvl_pStyle", "w:lvlJc", "parse_w_lvlJc", "w:lvlPicBulletId", "parse_w_lvlPicBulletId", "w:lvlRestart", "parse_w_lvlRestart", "w:lvlText", "parse_w_lvlText", "w:noWrap", "parse_w_noWrap", "w:numFmt", "parse_w_numFmt", "w:numPr", "parse_w_numPr", "w:outline", "parseToggleProperty", "w:outlineLvl", "parse_w_outlineLvl", "w:pBdr", "parseBorders", "w:pPr/w:jc", "parse_w_pPr_w_jc", "w:pPr/w:spacing", "parse_w_pPr_w_spacing", "w:pageBreakBefore", "parse_w_pageBreakBefore", "w:position", "parse_w_position", "w:rFonts", "parse_w_rFonts", "w:shadow", "parseToggleProperty", "w:shd", "parse_w_shd", "w:smallCaps", "parse_w_smallCaps", "w:start", "parse_w_start", "w:strike", "parse_w_strike", "w:suff", "parse_w_suff", "w:suppressAutoHyphens", "parse_w_suppressAutoHyphens", "w:sz", "parse_w_sz", "w:tabs", "parse_w_tabs", "w:tblBorders", "parseBordersNoPadding", "w:tblCellMar", "parse_w_tblCellMar", "w:tblHeader", "parse_w_tblHeader", "w:tblInd", "parse_w_tblInd", "w:tblLayout", "parse_w_tblLayout", "w:tblLook", "parse_w_tblLook", "w:tblPr/w:jc", "parse_w_tblPr_w_jc", "w:tblPr/w:tblCellSpacing", "parse_w_tblPr_w_tblCellSpacing", "w:tblStyleColBandSize", "parse_w_tblStyleColBandSize", "w:tblStyleRowBandSize", "parse_w_tblStyleRowBandSize", "w:tblW", "parse_w_tblW", "w:tcBorders", "parseBordersNoPadding", "w:tcMar", "parse_w_tcMar", "w:tcW", "parse_w_tcW", "w:textAlignment", "parse_w_textAlignment", "w:textDirection", "parseSimpleProperty", "w:trHeight", "parse_w_trHeight", "w:u", "parse_w_u", "w:vAlign", "parse_w_vAlign", "w:vanish", "parse_w_vanish", "w:vertAlign", "parse_w_vertAlign", "w:widowControl", "parse_w_widowControl", "w:wordWrap", "parse_w_wordWrap"};
    private IdentityHashMap<Name, Binding[]> bindingMap;
    private static final String[] TEMP_PROP_NAME_LIST = new String[]{"-ms-abstractNumId", "-ms-border-insideH", "-ms-border-insideH-color", "-ms-border-insideH-space", "-ms-border-insideH-sz", "-ms-border-insideV", "-ms-border-insideV-color", "-ms-border-insideV-space", "-ms-border-insideV-sz", "-ms-cnfStyle-band1Horz", "-ms-cnfStyle-band1Vert", "-ms-cnfStyle-band2Horz", "-ms-cnfStyle-band2Vert", "-ms-cnfStyle-firstCol", "-ms-cnfStyle-firstRow", "-ms-cnfStyle-lastCol", "-ms-cnfStyle-lastRow", "-ms-cnfStyle-neCell", "-ms-cnfStyle-nwCell", "-ms-cnfStyle-seCell", "-ms-cnfStyle-swCell", "-ms-lang", "-ms-lvlOverride", "-ms-lvl-pStyle", "-ms-numPr", "-ms-startOverride", "-ms-tblCellMar-bottom", "-ms-tblCellMar-left", "-ms-tblCellMar-right", "-ms-tblCellMar-top", "-ms-tblHeader", "-ms-tblLook-firstColumn", "-ms-tblLook-firstRow", "-ms-tblLook-lastColumn", "-ms-tblLook-lastRow", "-ms-tblLook-noHBand", "-ms-tblLook-noVBand", "-ms-tblStyleColBandSize", "-ms-tblStyleRowBandSize", "-w2x-restart-counter", "-w2x-restart-value"};
    private static final HashSet<String> TEMP_PROP_NAMES = new HashSet();

    public Styles(Part part, Part part2, Part part3, Part part4, boolean bl, int n, String string, ImgTranslator imgTranslator, Console console) throws IOException {
        Object object;
        boolean bl2 = false;
        if (string != null) {
            object = new String[]{"ja", "zh", "ko"};
            for (String string2 : object) {
                if (!string.regionMatches(true, 0, string2, 0, 2)) continue;
                bl2 = true;
                break;
            }
        }
        this.alwaysUseLangVal = !bl2;
        this.imgTranslator = imgTranslator;
        this.console = console;
        this.initialize(n);
        this.theme = new Theme(part3, n);
        this.settings = new Settings(part4, n);
        this.unlocalizer = new Unlocalizer();
        this.defaultStyles = new ArrayList();
        object = new Style("body");
        ((Style)object).put("background-color", "white");
        this.defaultStyles.add((Style)object);
        object = new Style("p");
        String[] stringArray = new String[]{"line-height", "1", "margin-top", "0pt", "margin-bottom", "0pt", "-ms-defaultTabStop", Util.formatDouble(this.settings.getDefaultTabStop()) + "pt"};
        ((Style)object).put(stringArray);
        this.defaultStyles.add((Style)object);
        object = new Style("p:empty");
        ((Style)object).put("height", "1em");
        this.defaultStyles.add((Style)object);
        object = new Style("a");
        ((Style)object).put("text-decoration", "none");
        this.defaultStyles.add((Style)object);
        object = new Style("table");
        stringArray = new String[]{"border-collapse", "separate", "border-spacing", "0pt", "empty-cells", "hide"};
        ((Style)object).put(stringArray);
        this.defaultStyles.add((Style)object);
        object = new Style("td");
        stringArray = new String[]{"vertical-align", "top", "padding-top", "0pt", "padding-bottom", "0pt", "padding-left", "5.75pt", "padding-right", "5.75pt"};
        ((Style)object).put(stringArray);
        this.defaultStyles.add((Style)object);
        this.styles = new HashMap();
        RemoveAnnotations removeAnnotations = new RemoveAnnotations(n, console);
        if (part != null) {
            Document document = part.getDocument();
            Util.setPartProperty(document, part);
            this.initUnlocalizer(document, this.unlocalizer);
            this.addStyles(document, bl);
        }
        this.imgBullets = new HashMap();
        if (part2 != null) {
            Document document = part2.getDocument();
            Util.setPartProperty(document, part2);
            removeAnnotations.process(document);
            this.addNumberings(document);
        }
        this.finishStyles();
        this.referencedStyleNames = new HashMap();
    }

    private void initialize(int n) {
        this.bindingMap = new IdentityHashMap();
        PrefixPreferences prefixPreferences = Util.createPrefixPreferences(n);
        try {
            Object object;
            Object object2;
            String string;
            String[] stringArray = QNAMES;
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                string = stringArray[i];
                object2 = Name.parse(string, true, prefixPreferences);
                if (object2 == null) {
                    throw new RuntimeException("'" + string + "', not a Name");
                }
                object = "name_" + string.replace(':', '_');
                Field field = Styles.class.getDeclaredField((String)object);
                field.set(this, object2);
            }
            int n3 = PARSE_SPEC.length;
            for (n2 = 0; n2 < n3; n2 += 2) {
                String string2 = PARSE_SPEC[n2];
                string = PARSE_SPEC[n2 + 1];
                object2 = BasicPattern.parse(string2, prefixPreferences);
                object = Styles.class.getDeclaredMethod(string, Element.class, Map.class);
                Binding.bind((BasicPattern)object2, (Method)object, this.bindingMap);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initUnlocalizer(Document document, Unlocalizer unlocalizer) {
        boolean bl;
        String string;
        String string2;
        String string3;
        Element element;
        Node node;
        Element element2 = document.getRootElement();
        for (node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT || (element = (Element)node).getName() != this.name_w_style || "character".equals(string3 = element.getAttribute(this.name_w_type))) continue;
            string2 = element.getAttribute(this.name_w_styleId);
            string = this.getVal(element, this.name_w_name, null);
            bl = this.isCustomStyle(element);
            if (string2 == null || string == null || bl) continue;
            unlocalizer.addLocalStyleId(string2, string, false);
        }
        for (node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string4;
            if (node.getType() != Node.Type.ELEMENT || (element = (Element)node).getName() != this.name_w_style || !"character".equals(string3 = element.getAttribute(this.name_w_type))) continue;
            string2 = element.getAttribute(this.name_w_styleId);
            string = this.getVal(element, this.name_w_name, null);
            bl = this.isCustomStyle(element);
            if (string2 == null || string == null || bl) continue;
            boolean bl2 = false;
            String string5 = this.getVal(element, this.name_w_link, null);
            if (string5 != null && (string4 = unlocalizer.getLocalStyleName(string5)) != null) {
                string = string4;
                bl2 = true;
            }
            unlocalizer.addLocalStyleId(string2, string, bl2);
        }
    }

    private boolean isCustomStyle(Element element) {
        boolean bl = false;
        String string = element.getAttribute(this.name_w_customStyle);
        if (string != null) {
            bl = Styles.parseBoolean(string);
        }
        return bl;
    }

    private void addStyles(Document document, boolean bl) {
        Object object;
        Element element = document.getRootElement();
        this.mapStyleIdToName(element);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            object = (Element)node;
            Name name = ((Element)object).getName();
            if (name == this.name_w_style) {
                this.addStyle((Element)object, bl);
                continue;
            }
            if (name != this.name_w_docDefaults) continue;
            Element element2 = Util.findDescendant((Element)object, this.name_w_rPrDefault, false);
            if (element2 != null) {
                this.addStyle(element2, false);
            }
            if ((element2 = Util.findDescendant((Element)object, this.name_w_pPrDefault, false)) == null) continue;
            this.addStyle(element2, false);
        }
        object = new Style[this.styles.size()];
        this.styles.values().toArray((T[])object);
        for (Object object2 : object) {
            this.addInsideBorderStyles((Style)object2);
        }
    }

    private void mapStyleIdToName(Element element) {
        String[] stringArray;
        String string;
        Serializable serializable;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String object;
            Iterator iterator;
            if (node.getType() != Node.Type.ELEMENT || (iterator = ((Element)(serializable = (Element)node)).getName()) != this.name_w_style || (object = Util.getNonEmptyAttribute((Element)serializable, this.name_w_styleId)) == null) continue;
            arrayList.add(object);
        }
        serializable = new HashMap();
        for (String string2 : arrayList) {
            string = this.unlocalizer.toCanonicalId(string2);
            stringArray = (String[])((HashMap)serializable).get(string);
            stringArray = stringArray == null ? new String[]{string2} : StringList.append(stringArray, string2);
            ((HashMap)serializable).put(string, stringArray);
        }
        this.styleIdToName = new HashMap();
        for (Map.Entry entry : ((HashMap)serializable).entrySet()) {
            string = (String)entry.getKey();
            stringArray = (String[])entry.getValue();
            int n = 0;
            for (int i = stringArray.length - 1; i >= 0; --i) {
                String string3 = stringArray[i];
                Object object = n > 0 ? string + "--" + Integer.toString(1 + n) : string;
                this.styleIdToName.put(string3, (String)object);
                ++n;
            }
        }
    }

    private String styleIdToName(String string) {
        String string2 = null;
        if (string != null && (string2 = this.styleIdToName.get(string)) == null) {
            string2 = string;
        }
        return string2;
    }

    private void addStyle(Element element, boolean bl) {
        String string;
        Name name = element.getName();
        if (name == this.name_w_pPrDefault) {
            Element element2 = Util.findDescendant(element, this.name_w_pPr, false);
            if (element2 != null) {
                Style style = this.defaultStyles.get(1);
                if (element2 != null) {
                    this.traverse(element2, style.props);
                }
            }
            return;
        }
        if (name == this.name_w_rPrDefault) {
            Element element3 = Util.findDescendant(element, this.name_w_rPr, false);
            if (element3 != null) {
                Style style = this.defaultStyles.get(0);
                this.traverse(element3, style.props);
            }
            return;
        }
        String string2 = element.getAttribute(this.name_w_type);
        String string3 = string = element.getAttribute(this.name_w_styleId);
        string = this.styleIdToName(string);
        boolean bl2 = false;
        String string4 = null;
        if (bl && (bl2 = this.isCustomStyle(element))) {
            string4 = this.getVal(element, this.name_w_name, null);
        }
        String string5 = this.getVal(element, this.name_w_basedOn, null);
        string5 = this.styleIdToName(string5);
        String string6 = this.getVal(element, this.name_w_link, null);
        string6 = this.styleIdToName(string6);
        boolean bl3 = false;
        String string7 = element.getAttribute(this.name_w_default);
        if (string7 != null) {
            bl3 = Styles.parseBoolean(string7);
        }
        if ("paragraph".equals(string2)) {
            Element element4 = Util.findDescendant(element, this.name_w_pPr, false);
            Element element5 = Util.findDescendant(element, this.name_w_rPr, false);
            if (element5 != null) {
                this.discardBox(element5);
            }
            this.putStyle("p", string, null, bl2, string4, string5, string6, element4, element5);
            if (bl3) {
                this.implicitParagraphStyleId = string3;
                this.implicitParagraphStyleName = Styles.joinStyleName("p", string, null);
            }
        } else if ("character".equals(string2)) {
            Element element6 = Util.findDescendant(element, this.name_w_rPr, false);
            this.putStyle("c", string, null, bl2, string4, string5, null, element6, null);
            if (bl3) {
                this.implicitCharacterStyleId = string3;
                this.implicitCharacterStyleName = Styles.joinStyleName("c", string, null);
            }
        } else if ("table".equals(string2)) {
            this.simplifyTableStyle(element);
            this.addTableStyles(string, bl2, string4, string5, element);
            if (bl3) {
                this.implicitTableStyleId = string3;
                this.implicitTableStyleName = Styles.joinStyleName("t", string, null);
            }
        } else if ("numbering".equals(string2)) {
            this.addNumberingStyle(string, element);
        }
    }

    private void discardBox(Element element) {
        Element element2 = Util.findDescendant(element, this.name_w_shd, false);
        if (element2 != null) {
            element.removeChild(element2);
        }
        if ((element2 = Util.findDescendant(element, this.name_w_bdr, false)) != null) {
            element.removeChild(element2);
        }
    }

    private void putStyle(String string, String string2, String string3, boolean bl, String string4, String string5, String string6, Element element, Element element2) {
        String string7 = Styles.joinStyleName(string, string2, string3);
        Style style = new Style(string7);
        if (element != null) {
            this.traverse(element, style.props);
        }
        if (element2 != null) {
            this.traverse(element2, style.props);
        }
        if (bl) {
            style.props.put("-ms-customStyle", "true");
        }
        if (string4 != null) {
            style.props.put("-ms-name", Util.toCSSString(string4));
        }
        if (string5 != null) {
            style.props.put("-w2x-base-style-name", Styles.joinStyleName(string, string5, string3));
        }
        if (string6 != null) {
            assert ("p".equals(string));
            style.props.put("-w2x-linked-style-name", Styles.joinStyleName("c", string6, null));
        }
        this.styles.put(string7, style);
    }

    private void simplifyTableStyle(Element element) {
        Element element2 = Util.findDescendant(element, this.name_w_tblPr, this.name_w_tblCellMar);
        if (element2 != null) {
            Element element3;
            element2.getParent().removeChild(element2);
            Element element4 = Util.findDescendant(element, this.name_w_tcPr, false);
            if (element4 == null) {
                element4 = new Element(this.name_w_tcPr);
                element.appendChild(element4);
            }
            if ((element3 = Util.findDescendant(element4, this.name_w_tcMar, false)) == null) {
                element2.setName(this.name_w_tcMar);
                element4.appendChild(element2);
            } else {
                Node node = element2.getFirstChild();
                while (node != null) {
                    Element element5;
                    Node node2 = node.getNextSibling();
                    if (node.getType() == Node.Type.ELEMENT && Util.findDescendant(element3, (element5 = (Element)node).getName(), false) == null) {
                        element2.removeChild(element5);
                        element3.appendChild(element5);
                    }
                    node = node2;
                }
            }
        }
        this.simplifyInsideBorder(element, this.name_w_insideH);
        this.simplifyInsideBorder(element, this.name_w_insideV);
    }

    private void simplifyInsideBorder(Element element, Name name) {
        Element element2 = Util.findDescendant(element, this.name_w_tblPr, this.name_w_tblBorders, name);
        if (element2 != null) {
            Element element3;
            element2.getParent().removeChild(element2);
            Element element4 = Util.findDescendant(element, this.name_w_tcPr, false);
            if (element4 == null) {
                element4 = new Element(this.name_w_tcPr);
                element.appendChild(element4);
            }
            if ((element3 = Util.findDescendant(element4, this.name_w_tcBorders, null)) == null) {
                element3 = new Element(this.name_w_tcBorders);
                element4.appendChild(element3);
            }
            if (Util.findDescendant(element3, name, null) == null) {
                element3.appendChild(element2);
            }
        }
    }

    private void addTableStyles(String string, boolean bl, String string2, String string3, Element element) {
        Element element2 = Util.findDescendant(element, this.name_w_tblPr, false);
        this.putStyle("t", string, null, bl, string2, string3, null, element2, null);
        this.doAddTableStyles(string, null, bl, string3, element);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string4;
            Element element3;
            if (node.getType() != Node.Type.ELEMENT || (element3 = (Element)node).getName() != this.name_w_tblStylePr || (string4 = element3.getAttribute(this.name_w_type)) == null) continue;
            this.doAddTableStyles(string, string4, bl, string3, element3);
        }
    }

    private void doAddTableStyles(String string, String string2, boolean bl, String string3, Element element) {
        Element element2;
        Element element3 = Util.findDescendant(element, this.name_w_trPr, false);
        if (element3 != null) {
            this.putStyle("tr", string, string2, bl, null, string3, null, element3, null);
        }
        if ((element2 = Util.findDescendant(element, this.name_w_tcPr, false)) != null) {
            this.putStyle("tc", string, string2, bl, null, string3, null, element2, null);
        }
        Element element4 = Util.findDescendant(element, this.name_w_pPr, false);
        Element element5 = Util.findDescendant(element, this.name_w_rPr, false);
        if (element4 != null || element5 != null) {
            if (element5 != null) {
                this.discardBox(element5);
            }
            this.putStyle("tp", string, string2, bl, null, string3, null, element4, element5);
        }
    }

    private void addNumberingStyle(String string, Element element) {
        String string2;
        Element element2 = Util.findDescendant(element, this.name_w_pPr, this.name_w_numPr, this.name_w_numId);
        if (element2 != null && (string2 = Util.checkIntAttribute(element2, this.name_w_val, 0, Integer.MAX_VALUE)) != null) {
            Style style = new Style(Styles.joinStyleName("ns", string, null));
            style.props.put("-ms-numId", string2);
            this.styles.put(style.name, style);
        }
    }

    private void addInsideBorderStyles(Style style) {
        if (!style.name.startsWith("tc-")) {
            return;
        }
        String[] stringArray = new String[]{"insideV", "left", "--bl", "insideV", "right", "--br", "insideH", "top", "--bt", "insideH", "bottom", "--bb"};
        for (int i = 0; i < 12; i += 3) {
            String string = stringArray[i];
            String string2 = "-ms-border-" + string;
            String string3 = "border-" + stringArray[i + 1];
            String string4 = style.props.get(string2);
            if (string4 == null) continue;
            String string5 = style.name + stringArray[i + 2];
            Style style2 = new Style(string5);
            this.styles.put(string5, style2);
            style2.props.put(string3 + "-style", string4);
            String string6 = style.props.get(string2 + "-sz");
            if (string6 != null) {
                style2.props.put(string3 + "-width", Util.checkBorderWidth(string6));
            }
            if ((string6 = style.props.get(string2 + "-color")) == null) continue;
            style2.props.put(string3 + "-color", "auto".equals(string6) ? "#000000" : string6);
        }
    }

    private void addNumberings(Document document) throws IOException {
        HashMap<String, NumberingEntry> hashMap = new HashMap<String, NumberingEntry>();
        HashMap<String, NumberingEntry> hashMap2 = new HashMap<String, NumberingEntry>();
        for (Node node = document.getRootElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            NumberingEntry numberingEntry;
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element = (Element)node;
            Name object = element.getName();
            if (object == this.name_w_numPicBullet) {
                this.addImgBullet(element);
                continue;
            }
            if (object == this.name_w_abstractNum) {
                numberingEntry = this.abstractNumToEntry(element);
                if (numberingEntry == null) continue;
                hashMap.put(numberingEntry.abstractNumId, numberingEntry);
                continue;
            }
            if (object != this.name_w_num || (numberingEntry = this.numToEntry(element)) == null) continue;
            hashMap2.put(numberingEntry.numId, numberingEntry);
        }
        this.resolveNumStyleLinks(hashMap, hashMap2);
        for (NumberingEntry numberingEntry : hashMap.values()) {
            this.addAbstractNum(numberingEntry.abstractNumId, numberingEntry.element);
        }
        for (NumberingEntry numberingEntry : hashMap2.values()) {
            this.addNum(numberingEntry.numId, numberingEntry.abstractNumId, numberingEntry.element);
        }
        this.resolveStartOverride();
    }

    private void addImgBullet(Element element) throws IOException {
        Element element2;
        Element element3;
        String string = Util.checkIntAttribute(element, this.name_w_numPicBulletId);
        if (string != null && (element3 = element.getChildElement(0)) != null && (element2 = this.imgTranslator.translateToImg(element3)) != null) {
            this.imgBullets.put(string, element2);
        }
    }

    private NumberingEntry abstractNumToEntry(Element element) {
        String string = Util.checkIntAttribute(element, this.name_w_abstractNumId, 0, Integer.MAX_VALUE);
        if (string == null) {
            return null;
        }
        return new NumberingEntry(null, string, element);
    }

    private NumberingEntry numToEntry(Element element) {
        String string = Util.checkIntAttribute(element, this.name_w_numId, 0, Integer.MAX_VALUE);
        if (string == null) {
            return null;
        }
        String string2 = null;
        Element element2 = Util.findDescendant(element, this.name_w_abstractNumId, false);
        if (element2 != null) {
            string2 = Util.checkIntAttribute(element2, this.name_w_val, 0, Integer.MAX_VALUE);
        }
        if (string2 == null) {
            return null;
        }
        return new NumberingEntry(string, string2, element);
    }

    private void resolveNumStyleLinks(Map<String, NumberingEntry> map, Map<String, NumberingEntry> map2) {
        for (NumberingEntry numberingEntry : map.values()) {
            NumberingEntry numberingEntry2;
            NumberingEntry numberingEntry3;
            String string;
            Style style;
            String string2;
            Element element = Util.findDescendant(numberingEntry.element, this.name_w_numStyleLink, false);
            if (element == null || (string2 = this.getVal(element, null)) == null || (style = this.getStyle("ns", string2, null)) == null || (string = style.get("-ms-numId")) == null || (numberingEntry3 = map2.get(string)) == null || (numberingEntry2 = map.get(numberingEntry3.abstractNumId)) == null) continue;
            numberingEntry.element = numberingEntry2.element;
        }
    }

    private void addAbstractNum(String string, Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string2;
            Element element2;
            if (node.getType() != Node.Type.ELEMENT || (element2 = (Element)node).getName() != this.name_w_lvl || (string2 = Util.checkIntAttribute(element2, this.name_w_ilvl, 0, 9)) == null) continue;
            this.addNumbering(Styles.joinStyleName("an", string, string2), null, element2);
        }
    }

    private Numbering addNumbering(String string, Numbering numbering, Element element) {
        Numbering numbering2 = this.createNumbering(string, numbering, element);
        if (numbering2 != null) {
            this.styles.put(string, numbering2);
        }
        return numbering2;
    }

    private Numbering createNumbering(String string, Numbering numbering, Element element) {
        Numbering numbering2 = new Numbering(string);
        if (numbering != null) {
            numbering2.props.putAll(numbering.props);
            numbering2.propsBefore.putAll(numbering.propsBefore);
            numbering2.paragraphProps.putAll(numbering.paragraphProps);
        }
        if (element != null) {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getType() != Node.Type.ELEMENT) continue;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == this.name_w_pPr) {
                    this.traverse(element2, numbering2.paragraphProps);
                    continue;
                }
                if (name == this.name_w_rPr) {
                    this.traverse(element2, numbering2.propsBefore);
                    continue;
                }
                this.parse(element2, numbering2.props);
            }
        }
        if (numbering2.get("-ms-lvlText") == null && numbering2.get("-ms-lvlPicBullet") == null) {
            numbering2 = null;
        }
        return numbering2;
    }

    private void addNum(String string, String string2, Element element) {
        Element element2;
        for (int i = 0; i <= 9; ++i) {
            element2 = this.findLvlOverride(element, i);
            if (element2 != null) {
                if (element2.getChildElementCount() != 0) continue;
                Element element3 = new Element(this.name_w_startOverride);
                element2.appendChild(element3);
                element3.putAttribute(this.name_w_val, "0");
                continue;
            }
            element2 = new Element(this.name_w_lvlOverride);
            element.appendChild(element2);
            element2.putAttribute(this.name_w_ilvl, Integer.toString(i));
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT || (element2 = (Element)node).getName() != this.name_w_lvlOverride) continue;
            this.doAddNum(string, string2, element2);
        }
    }

    private Element findLvlOverride(Element element, int n) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            int n2;
            Element element2;
            if (node.getType() != Node.Type.ELEMENT || (element2 = (Element)node).getName() != this.name_w_lvlOverride || (n2 = element2.getIntAttribute(this.name_w_ilvl, 0, 9, -1)) != n) continue;
            return element2;
        }
        return null;
    }

    private void doAddNum(String string, String string2, Element element) {
        String string3 = Util.checkIntAttribute(element, this.name_w_ilvl, 0, 9);
        if (string3 == null) {
            return;
        }
        String string4 = Styles.joinStyleName("n", string, string3);
        Element element2 = Util.findDescendant(element, this.name_w_startOverride, false);
        if (element2 != null) {
            int n = element2.getIntAttribute(this.name_w_val, Integer.MAX_VALUE);
            if (n != Integer.MAX_VALUE) {
                Style style = new Style("r" + string4);
                style.props.put("-ms-abstractNumId", string2);
                style.props.put("-w2x-restart-value", Integer.toString(n - 1));
                this.styles.put(style.name, style);
            }
            return;
        }
        Numbering numbering = (Numbering)this.getStyle("an", string2, string3);
        if (numbering == null) {
            return;
        }
        Element element3 = Util.findDescendant(element, this.name_w_lvl, false);
        Numbering numbering2 = this.addNumbering(string4, numbering, element3);
        if (numbering2 != null) {
            numbering2.props.put("-ms-abstractNumId", string2);
            if (element3 != null) {
                numbering2.props.put("-ms-lvlOverride", string3);
            }
        }
    }

    private void resolveStartOverride() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 1000 + this.styles.size();
        for (Style style : this.styles.values()) {
            Object object;
            String string;
            if (!style.name.startsWith("rn-") || (string = style.get("-ms-abstractNumId")) == null) continue;
            String string2 = null;
            int n2 = style.name.lastIndexOf(45);
            if (n2 >= 0) {
                string2 = style.name.substring(n2);
            }
            if (string2 == null) continue;
            boolean bl = false;
            for (Style style2 : this.styles.values()) {
                if (!style2.name.startsWith("n-") || !style2.name.endsWith(string2) || !string.equals(object = style2.get("-ms-abstractNumId")) || style2.get("-ms-lvlOverride") != null) continue;
                style.put("-w2x-restart-counter", style2.name);
                bl = true;
                break;
            }
            if (bl) continue;
            Numbering numbering = (Numbering)this.getStyle("an-" + string + string2);
            if (numbering == null) {
                return;
            }
            String string3 = "n-" + Integer.toString(n + arrayList.size()) + string2;
            object = this.createNumbering(string3, numbering, null);
            if (object == null) continue;
            ((Numbering)object).props.put("-ms-abstractNumId", string);
            arrayList.add(object);
            style.put("-w2x-restart-counter", string3);
        }
        for (Numbering numbering : arrayList) {
            this.styles.put(numbering.name, numbering);
        }
    }

    private void finishStyles() {
        this.inheritNumId();
        this.resolveNumLevel();
        this.finishNumberings();
        this.inheritStyleProps();
        for (Style style : this.styles.values()) {
            this.fixLineHeight(style);
        }
    }

    private void inheritNumId() {
        for (Style style : this.styles.values()) {
            int n;
            Style style2;
            Object object = style.props.get("-ms-numPr");
            if (object == null || !((String)object).startsWith("n-_-")) continue;
            String string = null;
            String string2 = style.props.get("-w2x-base-style-name");
            while (string2 != null && (style2 = this.styles.get(string2)) != null) {
                string = style2.props.get("-ms-numPr");
                if (string != null && string.startsWith("n-_-")) {
                    string = null;
                }
                if (string != null) break;
                string2 = style2.props.get("-w2x-base-style-name");
            }
            if (string == null || (n = string.indexOf("-", 2)) < 0) continue;
            object = string.substring(0, n + 1) + ((String)object).substring(4);
            style.props.put("-ms-numPr", (String)object);
        }
    }

    private void resolveNumLevel() {
        for (Style style : this.styles.values()) {
            int[] nArray;
            int n;
            Object object = style.props.get("-ms-numPr");
            if (object == null || (n = ((String)object).indexOf("-?")) < 0) continue;
            style.props.remove("-ms-numPr");
            boolean bl = false;
            String string = ((String)object).substring(n + 2);
            String string2 = this.abstractNumForStyle(string);
            if (string2 != null && Numbering.splitName(string2, nArray = new int[2]) && nArray[1] >= 0) {
                object = ((String)object).substring(0, n + 1) + Integer.toString(nArray[1]);
                style.props.put("-ms-numPr", (String)object);
                bl = true;
            }
            if (bl) continue;
            object = ((String)object).substring(0, n + 1) + "0";
            style.props.put("-ms-numPr", (String)object);
        }
    }

    private String abstractNumForStyle(String string) {
        string = string.substring(2);
        for (Style style : this.styles.values()) {
            String string2;
            if (!style.name.startsWith("an-") || (string2 = style.get("-ms-lvl-pStyle")) == null || !string.equals(string2)) continue;
            return style.name;
        }
        return null;
    }

    private void finishNumberings() {
        Object object;
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        Iterator<Style> iterator = this.styles.values().iterator();
        while (iterator.hasNext()) {
            Style style = iterator.next();
            Object[] objectArray = style.name;
            if (objectArray.startsWith("an-") || objectArray.startsWith("ns-")) {
                iterator.remove();
                continue;
            }
            if (!objectArray.startsWith("n-")) continue;
            Numbering numbering = (Numbering)style;
            numbering.finishTranslation(this.styles);
            if (numbering.props.containsKey("-ms-lvlOverride")) continue;
            object = new StringBuilder("an-");
            ((StringBuilder)object).append((String)numbering.props.get("-ms-abstractNumId"));
            ((StringBuilder)object).append('-');
            ((StringBuilder)object).append(Integer.toString(numbering.getLevel()));
            String string = ((StringBuilder)object).toString();
            String[] stringArray = (String[])hashMap.get(string);
            stringArray = stringArray == null ? new String[]{numbering.name} : ArrayUtil.append(stringArray, numbering.name);
            hashMap.put(string, stringArray);
        }
        this.equivalentNumberingNames = new HashMap();
        for (Object[] objectArray : hashMap.values()) {
            int n = objectArray.length;
            if (n <= 1) continue;
            Arrays.sort(objectArray);
            object = objectArray[0];
            for (int i = 1; i < n; ++i) {
                this.equivalentNumberingNames.put((String)objectArray[i], (String)object);
            }
        }
    }

    private void inheritStyleProps() {
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        for (Style object : this.styles.values()) {
            hashMap.put(object.name, (Map)object.props.clone());
        }
        ArrayList arrayList = new ArrayList();
        for (Style style : this.styles.values()) {
            this.getPropsHierarchy(hashMap, style, arrayList);
            if (arrayList.size() > 0) {
                style.props.clear();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Map map = (Map)iterator.next();
                    if (map == null) continue;
                    TabStop[] tabStopArray = TabStop.removeFromProperties(style.props);
                    TabStop[] tabStopArray2 = TabStop.removeFromProperties(map);
                    style.props.putAll(map);
                    TabStop.addToProperties(tabStopArray2, map);
                    TabStop.addToProperties(TabStop.merge(tabStopArray, tabStopArray2), style.props);
                }
            }
            style.props.remove("-w2x-linked-style-name");
            style.props.remove("-w2x-base-style-name");
        }
    }

    private void getPropsHierarchy(Map<String, Map<String, String>> map, Style style, List<Map<String, String>> list) {
        list.clear();
        Map<String, String> map2 = map.get(style.name);
        boolean bl = style.name.startsWith("p-");
        if (map2.containsKey("-w2x-base-style-name") || bl && map2.containsKey("-ms-numPr")) {
            while (map2 != null) {
                String string;
                list.add(0, map2);
                Numbering numbering = null;
                if (bl && (string = map2.get("-ms-numPr")) != null) {
                    numbering = string.startsWith("n-0-") ? Numbering.NO_NUMBERING : (Numbering)this.styles.get(string);
                }
                if (numbering != null) {
                    list.add(0, numbering.paragraphProps);
                } else {
                    list.add(0, null);
                }
                string = map2.get("-w2x-base-style-name");
                map2 = null;
                if (string == null) continue;
                map2 = map.get(string);
            }
            boolean bl2 = false;
            int n = list.size();
            for (int i = n - 2; i >= 0; i -= 2) {
                if (bl2) {
                    list.set(i, null);
                    continue;
                }
                if (list.get(i) == null) continue;
                bl2 = true;
            }
        }
    }

    private void fixLineHeight(Style style) {
        String string = style.props.get("line-height");
        if (string != null && string.endsWith("pt")) {
            String string2 = style.props.get("font-size");
            style.props.put("line-height", this.fixedLineHeight(string, string2));
        }
    }

    public String fixedLineHeight(String object, String string) {
        Style style;
        if (string == null && (style = this.defaultStyles.get(1)) != null) {
            string = style.get("font-size");
        }
        if (string == null && (style = this.defaultStyles.get(0)) != null) {
            string = style.get("font-size");
        }
        if (string == null) {
            string = "12pt";
        }
        if (((String)object).endsWith("pt") && string.endsWith("pt")) {
            try {
                double d = Double.parseDouble(((String)object).substring(0, ((String)object).length() - 2));
                double d2 = Double.parseDouble(string.substring(0, string.length() - 2));
                object = Util.formatDouble(d2 + d / 2.0) + "pt";
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return object;
    }

    public Style getStyle(String string, String string2, String string3) {
        String string4 = Styles.joinStyleName(string, string2, string3);
        if (string4 == null) {
            return null;
        }
        return this.getStyle(string4);
    }

    public static String joinStyleName(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('-');
        Styles.checkStyleId(string2, stringBuilder);
        if (string3 != null) {
            stringBuilder.append('-');
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    private static void checkStyleId(String string, StringBuilder stringBuilder) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (XMLText.isNCNameChar(c) && c != '.') {
                stringBuilder.append(c);
                n = c;
                continue;
            }
            if (n == 95) continue;
            stringBuilder.append('_');
            n = 95;
        }
    }

    public double getDefaultTabStop() {
        return this.settings.getDefaultTabStop();
    }

    public String getImplicitTableStyleId() {
        return this.implicitTableStyleId;
    }

    public String getImplicitTableStyleName() {
        return this.implicitTableStyleName;
    }

    public String getImplicitParagraphStyleId() {
        return this.implicitParagraphStyleId;
    }

    public String getImplicitParagraphStyleName() {
        return this.implicitParagraphStyleName;
    }

    public String getImplicitCharacterStyleId() {
        return this.implicitCharacterStyleId;
    }

    public String getImplicitCharacterStyleName() {
        return this.implicitCharacterStyleName;
    }

    public Map<String, Style> getStyles() {
        return this.styles;
    }

    public Style getStyle(String string) {
        return this.styles.get(string);
    }

    public String getStyleProperty(Element element, String string) {
        String string2 = element.getAttribute(Constants.CLASS_ATTR);
        if (string2 == null) {
            return null;
        }
        return this.getStyleProperty(string2, string);
    }

    public String getStyleProperty(String string, String string2) {
        Style style;
        String string3 = null;
        String[] stringArray = XMLText.splitList(string);
        for (int i = stringArray.length - 1; i >= 0 && ((style = this.styles.get(stringArray[i])) == null || (string3 = style.get(string2)) == null); --i) {
        }
        return string3;
    }

    public Style getDefaultStyle(String string) {
        for (Style style : this.defaultStyles) {
            if (!style.name.equals(string)) continue;
            return style;
        }
        return null;
    }

    public void setBodyBackground(Element element) {
        Style style;
        String string = this.theme.getColor(element, this.name_w_themeColor, this.name_w_themeShade, this.name_w_themeTint, this.name_w_color);
        if (string != null && string != "#000000" && (style = this.defaultStyles.get(0)) != null) {
            style.put("background-color", string);
        }
    }

    public String lookupStyle(Element element, String string) {
        String string2;
        block1: {
            string2 = this.doLookupStyle(element, string);
            if (string2 != null || !CSSProperties.isInherited(string)) break block1;
            while ((element = element.getParentElement()) != null && (string2 = this.doLookupStyle(element, string)) == null) {
            }
        }
        return string2;
    }

    private String doLookupStyle(Element element, String string) {
        String string2 = Util.getStyleProperty(element, string);
        if (string2 != null) {
            return string2;
        }
        string2 = this.getStyleProperty(element, string);
        if (string2 != null) {
            return string2;
        }
        Style style = this.getDefaultStyle(element.getLocalName());
        if (style != null && (string2 = style.get(string)) != null) {
            return string2;
        }
        return null;
    }

    public Map<String, String> getTableStyleNames(String string) {
        if (string == null || !string.startsWith("t-")) {
            return null;
        }
        String string2 = string.substring(2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string3 : TABLE_STYLE_PREFIXES) {
            boolean bl = "tc".equals(string3);
            for (String string4 : TABLE_STYLE_SUFFIXES) {
                String string5;
                Object object = string3;
                if (string4 != null) {
                    object = (String)object + "-" + string4;
                }
                if (this.getStyle(string5 = Styles.joinStyleName(string3, string2, string4)) != null) {
                    hashMap.put((String)object, string5);
                }
                if (!bl) continue;
                String string6 = (String)object + "--bt";
                String string7 = string5 + "--bt";
                if (this.getStyle(string7) != null) {
                    hashMap.put(string6, string7);
                }
                string6 = (String)object + "--bb";
                string7 = string5 + "--bb";
                if (this.getStyle(string7) != null) {
                    hashMap.put(string6, string7);
                }
                string6 = (String)object + "--bl";
                string7 = string5 + "--bl";
                if (this.getStyle(string7) != null) {
                    hashMap.put(string6, string7);
                }
                string6 = (String)object + "--br";
                string7 = string5 + "--br";
                if (this.getStyle(string7) == null) continue;
                hashMap.put(string6, string7);
            }
        }
        return hashMap;
    }

    public void parseStyleProps(Element element, Map<String, String> map, String[] stringArray) {
        map.clear();
        this.traverse(element, map);
        String string = null;
        String string2 = null;
        Name name = element.getName();
        if (name == this.name_w_rPr) {
            string = "c";
            string2 = this.getVal(element, this.name_w_rStyle, null);
        } else if (name == this.name_w_pPr) {
            string = "p";
            string2 = this.getVal(element, this.name_w_pStyle, null);
        } else if (name == this.name_w_tblPr) {
            string = "t";
            string2 = this.getVal(element, this.name_w_tblStyle, null);
        }
        string2 = this.styleIdToName(string2);
        String string3 = Styles.joinStyleName(string, string2, null);
        if (string3 != null) {
            this.referenceStyle(string3);
            if ("t".equals(string)) {
                for (String object2 : TABLE_STYLE_PREFIXES) {
                    boolean object3 = "tc".equals(object2);
                    for (String string4 : TABLE_STYLE_SUFFIXES) {
                        String string5 = Styles.joinStyleName(object2, string2, string4);
                        if (this.styles.containsKey(string5)) {
                            this.referenceStyle(string5);
                        }
                        if (!object3) continue;
                        String string6 = string5 + "--bt";
                        if (this.styles.containsKey(string6)) {
                            this.referenceStyle(string6);
                        }
                        if (this.styles.containsKey(string6 = string5 + "--bb")) {
                            this.referenceStyle(string6);
                        }
                        if (this.styles.containsKey(string6 = string5 + "--bl")) {
                            this.referenceStyle(string6);
                        }
                        if (!this.styles.containsKey(string6 = string5 + "--br")) continue;
                        this.referenceStyle(string6);
                    }
                }
            }
        }
        stringArray[0] = string3;
        stringArray[1] = null;
        stringArray[2] = null;
        if (name == this.name_w_pPr) {
            Object object = map.remove("-ms-numPr");
            if (object != null) {
                Style style = this.getStyle("r" + (String)object);
                if (style != null) {
                    object = style.get("-w2x-restart-counter");
                    if (object != null) {
                        int n;
                        if (((String)object).startsWith("!")) {
                            n = 1;
                            object = ((String)object).substring(1);
                        } else {
                            n = 0;
                            style.put("-w2x-restart-counter", "!" + (String)object);
                        }
                        object = this.equivalentNumPr((String)object);
                        Numbering numbering = (Numbering)this.getStyle((String)object);
                        if (numbering != null) {
                            this.numPrToClasses(null, (String)object, stringArray);
                            if (n == 0) {
                                Object object2 = numbering.get("counter-reset");
                                if (object2 == null) {
                                    object2 = "";
                                }
                                object2 = (String)object2 + " " + (String)object + " " + style.get("-w2x-restart-value");
                                map.put("counter-reset", ((String)object2).trim());
                            }
                        }
                    }
                } else {
                    object = this.equivalentNumPr((String)object);
                    this.numPrToClasses(null, (String)object, stringArray);
                }
            } else {
                this.numPrToClasses(string3, null, stringArray);
            }
        }
    }

    private void numPrToClasses(String string, String string2, String[] stringArray) {
        Style style;
        if (string2 != null) {
            assert (string2.equals(this.equivalentNumPr(string2)));
            if (this.getStyle(string2) != null) {
                stringArray[1] = "p" + string2;
                stringArray[2] = string2;
                this.referenceStyle(string2);
            }
        } else if (string != null && (style = this.getStyle(string)) != null) {
            string2 = style.get("-ms-numPr");
            if ((string2 = this.equivalentNumPr(string2)) != null && this.getStyle(string2) != null) {
                stringArray[1] = string2;
                this.referenceStyle(string2);
            }
        }
    }

    private String equivalentNumPr(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.equivalentNumberingNames.get(string);
        return string2 == null ? string : string2;
    }

    private void referenceStyle(String string) {
        if (!this.referencedStyleNames.containsKey(string)) {
            this.referencedStyleNames.put(string, this.referencedStyleNames.size());
        }
    }

    private String getLangVal(Element element, Name name, String string) {
        String string2 = string;
        Element element2 = Util.findDescendant(element, name, false);
        if (element2 != null) {
            string2 = this.getLangVal(element2, string);
        }
        return string2;
    }

    private String getLangVal(Element element, String string) {
        String string2;
        String string3 = null;
        String string4 = element.getAttribute(this.name_w_val);
        string3 = this.alwaysUseLangVal ? string4 : ((string2 = element.getAttribute(this.name_w_eastAsia)) != null ? string2 : string4);
        return string3 == null || string3.regionMatches(true, 0, "x-", 0, 2) ? string : string3;
    }

    private String getVal(Element element, Name name, String string) {
        String string2 = string;
        Element element2 = Util.findDescendant(element, name, false);
        if (element2 != null) {
            string2 = this.getVal(element2, string);
        }
        return string2;
    }

    private String getVal(Element element, String string) {
        String string2 = element.getAttribute(this.name_w_val);
        return string2 == null ? string : string2;
    }

    private void traverse(Element element, Map<String, String> map) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            this.parse((Element)node, map);
        }
    }

    private void parse(Element element, Map<String, String> map) {
        Method method = Binding.getMethod(this.bindingMap, element);
        if (method != null) {
            try {
                method.invoke((Object)this, element, map);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    private void parse_w_b(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        map.put("font-weight", Styles.parseBoolean(string) ? "bold" : "normal");
    }

    private static boolean parseBoolean(String string) {
        return "true".equals(string) || "1".equals(string) || "on".equals(string);
    }

    private void parse_w_bdr(Element element, Map<String, String> map) {
        Border border = this.parseBorder(element);
        if (border == null) {
            return;
        }
        border.toCSS(15, map);
    }

    private Border parseBorder(Element element) {
        return this.parseBorder(element, true);
    }

    private Border parseBorder(Element element, boolean bl) {
        String string;
        String string2 = element.getAttribute(this.name_w_val);
        if (string2 == null) {
            return null;
        }
        String string3 = null;
        if ("single".equals(string2)) {
            string = "solid";
        } else if ("nil".equals(string2)) {
            string = "none";
        } else if ("none".equals(string2) || "dotted".equals(string2) || "dashed".equals(string2) || "double".equals(string2) || "inset".equals(string2) || "outset".equals(string2)) {
            string = string2;
        } else if ("dotDash".equals(string2) || "dotDotDash".equals(string2) || "dashSmallGap".equals(string2) || "dashDotStroked".equals(string2)) {
            string = "dashed";
            string3 = string2;
        } else if ("thinThickSmallGap".equals(string2) || "thickThinSmallGap".equals(string2) || "thinThickMediumGap".equals(string2) || "thickThinMediumGap".equals(string2) || "thinThickLargeGap".equals(string2) || "thickThinLargeGap".equals(string2)) {
            string = "double";
            string3 = string2;
        } else if ("threeDEmboss".equals(string2)) {
            string = "ridge";
            string3 = string2;
        } else if ("threeDEngrave".equals(string2)) {
            string = "groove";
            string3 = string2;
        } else {
            string = "solid";
            string3 = string2;
        }
        String string4 = element.getAttribute(this.name_w_sz);
        if (string4 != null) {
            string4 = Util.parsePt(string4, 8);
        }
        String string5 = this.theme.getColor(element, this.name_w_themeColor, this.name_w_themeShade, this.name_w_themeTint, this.name_w_color);
        String string6 = null;
        if (bl && (string6 = element.getAttribute(this.name_w_space)) != null) {
            string6 = Util.parsePt(string6, 1);
        }
        return new Border(string, string3, string4, string5, string6);
    }

    private void parse_w_caps(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        map.put("text-transform", Styles.parseBoolean(string) ? "uppercase" : "none");
    }

    private void parse_w_color(Element element, Map<String, String> map) {
        String string = this.theme.getColor(element, this.name_w_themeColor, this.name_w_themeShade, this.name_w_themeTint, this.name_w_val);
        if (string != null) {
            map.put("color", string);
        }
    }

    private void parse_w_dstrike(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        map.put("text-decoration", Styles.parseBoolean(string) ? "line-through" : "none");
        map.put("-ms-dstrike", "true");
    }

    private void parse_w_highlight(Element element, Map<String, String> map) {
        String string = this.theme.getColor(element, null, null, null, this.name_w_val);
        if (string != null) {
            map.put("background-color", string);
        }
    }

    private void parse_w_i(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        map.put("font-style", Styles.parseBoolean(string) ? "italic" : "normal");
    }

    private void parse_w_lang(Element element, Map<String, String> map) {
        String string = this.getLangVal(element, null);
        if (string != null) {
            map.put("-ms-lang", string);
        }
    }

    private void parse_w_position(Element element, Map<String, String> map) {
        String string = this.getVal(element, null);
        if (string == null) {
            return;
        }
        String string2 = Util.parsePt(string, 2);
        if (string2 == null) {
            return;
        }
        map.put("vertical-align", string2);
    }

    private void parse_w_rFonts(Element element, Map<String, String> map) {
        String string = this.theme.getFontFamily(element, this.name_w_hAnsiTheme, this.name_w_hAnsi);
        if (string == null) {
            string = this.theme.getFontFamily(element, this.name_w_asciiTheme, this.name_w_ascii);
        }
        if (string != null) {
            map.put("font-family", StringUtil.quoteArgument(string));
        }
    }

    private void parse_w_shd(Element element, Map<String, String> map) {
        String string;
        String string2 = this.getVal(element, null);
        if (string2 == null) {
            return;
        }
        String string3 = this.theme.getColor(element, this.name_w_themeColor, this.name_w_themeShade, this.name_w_themeTint, this.name_w_color);
        if (string3 == null) {
            string3 = "#000000";
        }
        if ((string = this.theme.getColor(element, this.name_w_themeFill, this.name_w_themeFillShade, this.name_w_themeFillTint, this.name_w_fill)) == null) {
            string = "#000000";
        }
        boolean bl = false;
        int n = -1;
        if ("solid".equals(string2)) {
            map.put("background-color", string3);
            bl = true;
        } else if ("clear".equals(string2) || "nil".equals(string2)) {
            map.put("background-color", string == "#000000" ? "transparent" : string);
            bl = true;
        } else if (string2.startsWith("pct") && (string3 == "#000000" || "#000000".equals(string3)) && (string == "#000000" || "#FFFFFF".equals(string)) && (n = Styles.parsePct(string2)) > 0) {
            int n2 = (100 - n) * 255 / 100;
            Object object = Integer.toHexString(n2).toUpperCase();
            if (((String)object).length() < 2) {
                object = "0" + (String)object;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('#');
            stringBuilder.append((String)object);
            stringBuilder.append((String)object);
            stringBuilder.append((String)object);
            map.put("background-color", stringBuilder.toString());
            bl = true;
        }
        if (!bl) {
            map.put("-ms-shd", string2);
            map.put("-ms-shd-color", string3 == "#000000" ? "auto" : string3);
            map.put("-ms-shd-fill", string == "#000000" ? "auto" : string);
            map.put("background-color", string == "#000000" ? "transparent" : string);
        }
    }

    private static int parsePct(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string.substring(3));
            if (n <= 0 || n >= 100) {
                n = -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private void parse_w_smallCaps(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        map.put("font-variant", Styles.parseBoolean(string) ? "small-caps" : "normal");
    }

    private void parse_w_strike(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        map.put("text-decoration", Styles.parseBoolean(string) ? "line-through" : "none");
    }

    private void parse_w_sz(Element element, Map<String, String> map) {
        String string = this.getVal(element, null);
        if (string == null) {
            return;
        }
        String string2 = Util.parsePt(string, 2);
        if (string2 == null) {
            return;
        }
        map.put("font-size", string2);
    }

    private void parse_w_u(Element element, Map<String, String> map) {
        String string = this.getVal(element, null);
        if (string != null) {
            String string2;
            String string3;
            String string4 = null;
            if ("single".equals(string)) {
                string3 = "underline";
            } else if ("none".equals(string)) {
                string3 = "none";
            } else {
                string3 = "underline";
                string4 = string;
            }
            map.put("text-decoration", string3);
            if (string4 != null) {
                map.put("-ms-u", string4);
            }
            if ((string2 = this.theme.getColor(element, this.name_w_themeColor, this.name_w_themeShade, this.name_w_themeTint, this.name_w_color)) != null && string2 != "#000000") {
                map.put("-ms-u-color", string2);
            }
        }
    }

    private void parse_w_vanish(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        if (Styles.parseBoolean(string)) {
            map.put("display", "none");
        }
    }

    private void parse_w_vertAlign(Element element, Map<String, String> map) {
        String string = this.getVal(element, null);
        if (string == null) {
            return;
        }
        if ("superscript".equals(string)) {
            string = "super";
        } else if ("subscript".equals(string)) {
            string = "sub";
        }
        map.put("vertical-align", string);
    }

    private void parseSimpleProperty(Element element, Map<String, String> map) {
        String string = this.getVal(element, null);
        if (string != null) {
            map.put("-ms-" + element.getLocalName(), string);
        }
    }

    private void parseToggleProperty(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        map.put("-ms-" + element.getLocalName(), Styles.parseBoolean(string) ? "true" : "false");
    }

    private void parseBorders(Element element, Map<String, String> map) {
        this.parseBorders(element, true, map);
    }

    private void parseBorders(Element element, boolean bl, Map<String, String> map) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            Border border = this.parseBorder(element2, bl);
            if (border == null) continue;
            int n = 0;
            if (name == this.name_w_left || name == this.name_w_start) {
                n = 8;
            } else if (name == this.name_w_right || name == this.name_w_end) {
                n = 2;
            } else if (name == this.name_w_top) {
                n = 1;
            } else if (name == this.name_w_bottom) {
                n = 4;
            } else if (name == this.name_w_between) {
                n = 16;
            } else if (name == this.name_w_bar) {
                n = 32;
            } else if (name == this.name_w_insideH) {
                n = 64;
            } else if (name == this.name_w_insideV) {
                n = 128;
            } else if (name == this.name_w_tl2br) {
                n = 256;
            } else if (name == this.name_w_tr2bl) {
                n = 512;
            }
            if (n == 0) continue;
            border.toCSS(n, map);
        }
    }

    private void parse_w_contextualSpacing(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        boolean bl = Styles.parseBoolean(string);
        map.put("-ms-contextualSpacing", bl ? "true" : "false");
    }

    private void parse_w_cnfStyle(Element element, Map<String, String> map) {
        int n;
        String[] stringArray = new String[]{"firstRow", "lastRow", "firstCol", "lastCol", "band1Vert", "band2Vert", "band1Horz", "band2Horz", "neCell", "nwCell", "seCell", "swCell"};
        String string = this.getVal(element, null);
        if (string != null && string.length() == 12) {
            for (int i = 0; i < 12; ++i) {
                n = string.charAt(i);
                map.put("-ms-cnfStyle-" + stringArray[i], n == 49 ? "true" : "false");
            }
        }
        Name[] nameArray = new Name[]{this.name_w_firstRow, this.name_w_lastRow, this.name_w_firstColumn, this.name_w_lastColumn, this.name_w_oddVBand, this.name_w_evenVBand, this.name_w_oddHBand, this.name_w_evenHBand, this.name_w_firstRowLastColumn, this.name_w_firstRowFirstColumn, this.name_w_lastRowLastColumn, this.name_w_lastRowFirstColumn};
        for (n = 0; n < 12; ++n) {
            string = element.getAttribute(nameArray[n]);
            if (string == null) continue;
            map.put("-ms-cnfStyle-" + stringArray[n], Styles.parseBoolean(string) ? "true" : "false");
        }
    }

    private void parse_w_ind(Element element, Map<String, String> map) {
        String string = Util.getAnyAttribute(element, this.name_w_rightChars, this.name_w_endChars);
        if (string != null && !"0".equals(string)) {
            if ((string = Util.parseEm(string, 100)) != null) {
                map.put("margin-right", string);
            }
        } else {
            string = Util.getAnyAttribute(element, this.name_w_right, this.name_w_end);
            if (string != null && (string = Util.parsePt(string, 20)) != null) {
                map.put("margin-right", string);
            }
        }
        if ((string = Util.getAnyAttribute(element, this.name_w_leftChars, this.name_w_startChars)) != null && !"0".equals(string)) {
            if ((string = Util.parseEm(string, 100)) != null) {
                map.put("margin-left", string);
            }
        } else {
            string = Util.getAnyAttribute(element, this.name_w_left, this.name_w_start);
            if (string != null && (string = Util.parsePt(string, 20)) != null) {
                map.put("margin-left", string);
            }
        }
        boolean bl = false;
        string = element.getAttribute(this.name_w_hangingChars);
        if (string != null && !"0".equals(string)) {
            if ((string = Util.parseEm(string, 100, true)) != null) {
                map.put("text-indent", string);
                bl = true;
            }
        } else {
            string = element.getAttribute(this.name_w_hanging);
            if (string != null && (string = Util.parsePt(string, 20, true)) != null) {
                map.put("text-indent", string);
                bl = true;
            }
        }
        if (!bl) {
            string = element.getAttribute(this.name_w_firstLineChars);
            if (string != null && !"0".equals(string)) {
                if ((string = Util.parseEm(string, 100)) != null) {
                    map.put("text-indent", string);
                }
            } else {
                string = element.getAttribute(this.name_w_firstLine);
                if (string != null && (string = Util.parsePt(string, 20)) != null) {
                    map.put("text-indent", string);
                }
            }
        }
    }

    private void parse_w_pPr_w_jc(Element element, Map<String, String> map) {
        String string;
        String string2 = this.getVal(element, null);
        if (string2 == null) {
            return;
        }
        String string3 = null;
        if ("start".equals(string2) || "left".equals(string2)) {
            string = "left";
        } else if ("end".equals(string2) || "right".equals(string2)) {
            string = "right";
        } else if ("center".equals(string2)) {
            string = "center";
        } else if ("both".equals(string2)) {
            string = "justify";
        } else {
            string = "left";
            string3 = string2;
        }
        map.put("text-align", string);
        if (string3 != null) {
            map.put("-ms-jc", string3);
        }
    }

    private void parse_w_keepLines(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        map.put("page-break-inside", Styles.parseBoolean(string) ? "avoid" : "auto");
    }

    private void parse_w_keepNext(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        map.put("page-break-after", Styles.parseBoolean(string) ? "avoid" : "auto");
    }

    private void parse_w_pageBreakBefore(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        map.put("page-break-before", Styles.parseBoolean(string) ? "always" : "auto");
    }

    private void parse_w_widowControl(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        if (!Styles.parseBoolean(string)) {
            map.put("orphans", "1");
            map.put("widows", "1");
        }
    }

    private void parse_w_numPr(Element element, Map<String, String> map) {
        String string = null;
        Element element2 = Util.findDescendant(element, this.name_w_numId, false);
        if (element2 != null) {
            string = Util.checkIntAttribute(element2, this.name_w_val);
        }
        Object object = null;
        element2 = Util.findDescendant(element, this.name_w_ilvl, false);
        if (element2 != null) {
            object = Util.checkIntAttribute(element2, this.name_w_val, 0, 9);
        }
        if (string == null || object == null) {
            String string2 = null;
            Element element3 = Util.findAncestor(element, this.name_w_style);
            if (element3 != null) {
                string2 = this.styleName(element3);
            }
            if (string2 == null) {
                if (string == null) {
                    return;
                }
                if (object == null) {
                    object = "0";
                }
            } else {
                if (string == null && object == null) {
                    return;
                }
                if (string == null) {
                    string = "_";
                }
                if (object == null) {
                    object = "?" + string2;
                }
            }
        }
        map.put("-ms-numPr", Styles.joinStyleName("n", string, (String)object));
    }

    private String styleName(Element element) {
        String string = null;
        String string2 = element.getAttribute(this.name_w_styleId);
        String string3 = element.getAttribute(this.name_w_type);
        if (string2 != null && "paragraph".equals(string3)) {
            string2 = this.styleIdToName(string2);
            string = Styles.joinStyleName("p", string2, null);
        }
        return string;
    }

    private void parse_w_outlineLvl(Element element, Map<String, String> map) {
        String string = this.getVal(element, null);
        if (string == null) {
            return;
        }
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n >= 0 && n <= 9) {
            map.put("-ms-outlineLvl", Integer.toString(n));
        }
    }

    private void parse_w_pPr_w_spacing(Element element, Map<String, String> map) {
        String string = element.getAttribute(this.name_w_afterLines);
        if (string != null && !"0".equals(string)) {
            if ((string = Util.parseEm(string, 100)) != null) {
                map.put("margin-bottom", string);
            }
        } else {
            string = element.getAttribute(this.name_w_after);
            if (string != null && (string = Util.parsePt(string, 20)) != null) {
                map.put("margin-bottom", string);
            }
        }
        if ((string = element.getAttribute(this.name_w_beforeLines)) != null && !"0".equals(string)) {
            if ((string = Util.parseEm(string, 100)) != null) {
                map.put("margin-top", string);
            }
        } else {
            string = element.getAttribute(this.name_w_before);
            if (string != null && (string = Util.parsePt(string, 20)) != null) {
                map.put("margin-top", string);
            }
        }
        if ((string = element.getAttribute(this.name_w_lineRule)) == null) {
            string = "auto";
        }
        boolean bl = "auto".equals(string);
        string = element.getAttribute(this.name_w_line);
        if (string != null) {
            String string2 = null;
            if (bl) {
                double d = Double.NaN;
                if (Util.hasUnit(string)) {
                    d = Util.doParsePt(string, 1, false);
                    if (!Double.isNaN(d)) {
                        d *= 20.0;
                    }
                } else {
                    try {
                        d = Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!Double.isNaN(d)) {
                    string2 = Util.formatDouble(1.0 + (d /= 240.0) / 2.0);
                }
            } else {
                string2 = Util.parsePt(string, 20);
            }
            if (string2 != null) {
                map.put("line-height", string2);
            }
        }
    }

    private void parse_w_suppressAutoHyphens(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        map.put("hyphens", Styles.parseBoolean(string) ? "none" : "auto");
    }

    private void parse_w_tabs(Element element, Map<String, String> map) {
        int n = 0;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT || ((Element)node).getName() != this.name_w_tab) continue;
            Element element2 = (Element)node;
            String string = element2.getAttribute(this.name_w_val);
            if (string == null) {
                string = "left";
            } else if ("start".equals(string)) {
                string = "left";
            } else if ("end".equals(string)) {
                string = "right";
            }
            String string2 = element2.getAttribute(this.name_w_pos);
            if (string2 != null) {
                string2 = Util.parsePt(string2, 20);
            }
            if (string2 == null) continue;
            String string3 = element2.getAttribute(this.name_w_leader);
            String string4 = "-ms-tab" + Integer.toString(n++);
            map.put(string4, string);
            map.put(string4 + "-pos", string2);
            if (string3 == null) continue;
            map.put(string4 + "-leader", string3);
        }
    }

    private void parse_w_textAlignment(Element element, Map<String, String> map) {
        String string = this.getVal(element, null);
        if (string == null) {
            return;
        }
        map.put("-ms-textAlignment", string);
    }

    private void parse_w_wordWrap(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        map.put("word-wrap", Styles.parseBoolean(string) ? "normal" : "break-word");
    }

    private void parseBordersNoPadding(Element element, Map<String, String> map) {
        this.parseBorders(element, false, map);
    }

    private void parse_w_tcW(Element element, Map<String, String> map) {
        String string = this.parseLength(element);
        if (!(string == null || "0".equals(string) || "0pt".equals(string) || "0%".equals(string))) {
            map.put("width", string);
        }
    }

    private String parseLength(Element element) {
        return this.parseLength(element, false);
    }

    private String parseLength(Element element, boolean bl) {
        String string = element.getAttribute(this.name_w_type);
        if (string == null) {
            string = "dxa";
        }
        if ("nil".equals(string)) {
            return "0";
        }
        String string2 = element.getAttribute(this.name_w_w);
        if (string2 == null) {
            return null;
        }
        if ("dxa".equals(string)) {
            return Util.parsePt(string2, 20);
        }
        if ("pct".equals(string)) {
            double d;
            boolean bl2 = false;
            if (string2.endsWith("%")) {
                bl2 = true;
                string2 = string2.substring(0, string2.length() - 1);
            }
            try {
                d = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (!bl2 && bl) {
                d /= 50.0;
            }
            return Util.formatDouble(d) + "%";
        }
        return null;
    }

    private void parse_w_noWrap(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        map.put("white-space", Styles.parseBoolean(string) ? "nowrap" : "normal");
    }

    private void parse_w_tcMar(Element element, Map<String, String> map) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            String string = this.parseLength(element2);
            if (string == null) continue;
            String string2 = null;
            if (name == this.name_w_left || name == this.name_w_start) {
                string2 = "padding-left";
            } else if (name == this.name_w_right || name == this.name_w_end) {
                string2 = "padding-right";
            } else if (name == this.name_w_top) {
                string2 = "padding-top";
            } else if (name == this.name_w_bottom) {
                string2 = "padding-bottom";
            }
            if (string2 == null) continue;
            map.put(string2, string);
        }
    }

    private void parse_w_vAlign(Element element, Map<String, String> map) {
        String string = this.getVal(element, null);
        String string2 = null;
        if ("top".equals(string) || "bottom".equals(string)) {
            string2 = string;
        } else if ("center".equals(string)) {
            string2 = "middle";
        }
        if (string2 != null) {
            map.put("vertical-align", string2);
        }
    }

    private void parse_w_cantSplit(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        map.put("page-break-inside", Styles.parseBoolean(string) ? "avoid" : "auto");
    }

    private void parse_w_tblHeader(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        if (Styles.parseBoolean(string)) {
            map.put("-ms-tblHeader", "true");
        }
    }

    private void parse_w_trHeight(Element element, Map<String, String> map) {
        String string = element.getAttribute(this.name_w_hRule);
        String string2 = this.getVal(element, null);
        if (string == null) {
            string = "0".equals(string2) ? "auto" : "atLeast";
        }
        if ("auto".equals(string) || "0".equals(string2)) {
            return;
        }
        if (string2 != null) {
            string2 = Util.parsePt(string2, 20);
        }
        if (string2 != null) {
            map.put("height", string2);
        }
    }

    private void parse_w_tblPr_w_jc(Element element, Map<String, String> map) {
        String string = this.getVal(element, null);
        if (string == null) {
            return;
        }
        if ("end".equals(string) || "right".equals(string)) {
            map.put("margin-left", "auto");
        } else if ("center".equals(string)) {
            map.put("margin-left", "auto");
            map.put("margin-right", "auto");
        }
    }

    private void parse_w_tblW(Element element, Map<String, String> map) {
        String string = this.parseLength(element, true);
        if (!(string == null || "0".equals(string) || "0pt".equals(string) || "0%".equals(string))) {
            map.put("width", string);
        }
    }

    private void parse_w_tblPr_w_tblCellSpacing(Element element, Map<String, String> map) {
        String string = this.parseLength(element);
        if (string != null) {
            map.put("border-spacing", string);
        }
    }

    private void parse_w_tblInd(Element element, Map<String, String> map) {
        String string = this.parseLength(element);
        if (string != null && !"auto".equals(map.get("margin-left"))) {
            map.put("margin-left", string);
        }
    }

    private void parse_w_tblLook(Element element, Map<String, String> map) {
        Name[] nameArray;
        String string = this.getVal(element, "0000");
        if (string != null) {
            try {
                int n = Integer.parseInt(string, 16);
                if ((n & 0x20) != 0) {
                    map.put("-ms-tblLook-firstRow", "true");
                }
                if ((n & 0x40) != 0) {
                    map.put("-ms-tblLook-lastRow", "true");
                }
                if ((n & 0x80) != 0) {
                    map.put("-ms-tblLook-firstColumn", "true");
                }
                if ((n & 0x100) != 0) {
                    map.put("-ms-tblLook-lastColumn", "true");
                }
                if ((n & 0x200) != 0) {
                    map.put("-ms-tblLook-noHBand", "true");
                }
                if ((n & 0x400) != 0) {
                    map.put("-ms-tblLook-noVBand", "true");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (Name name : nameArray = new Name[]{this.name_w_firstColumn, this.name_w_firstRow, this.name_w_lastColumn, this.name_w_lastRow, this.name_w_noHBand, this.name_w_noVBand}) {
            String string2 = element.getAttribute(name);
            if (string2 == null) continue;
            map.put("-ms-tblLook-" + name.localPart, Styles.parseBoolean(string2) ? "true" : "false");
        }
    }

    private void parse_w_tblLayout(Element element, Map<String, String> map) {
        String string = element.getAttribute(this.name_w_type);
        if (string == null) {
            return;
        }
        map.put("table-layout", "fixed".equals(string) ? "fixed" : "auto");
    }

    private void parse_w_tblCellMar(Element element, Map<String, String> map) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            String string = this.parseLength(element2);
            if (string == null) continue;
            String string2 = null;
            if (name == this.name_w_left || name == this.name_w_start) {
                string2 = "-ms-tblCellMar-left";
            } else if (name == this.name_w_right || name == this.name_w_end) {
                string2 = "-ms-tblCellMar-right";
            } else if (name == this.name_w_top) {
                string2 = "-ms-tblCellMar-top";
            } else if (name == this.name_w_bottom) {
                string2 = "-ms-tblCellMar-bottom";
            }
            if (string2 == null) continue;
            map.put(string2, string);
        }
    }

    private void parse_w_tblStyleColBandSize(Element element, Map<String, String> map) {
        int n = element.getIntAttribute(this.name_w_val, 1, Integer.MAX_VALUE, -1);
        if (n > 0) {
            map.put("-ms-tblStyleColBandSize", Integer.toString(n));
        }
    }

    private void parse_w_tblStyleRowBandSize(Element element, Map<String, String> map) {
        int n = element.getIntAttribute(this.name_w_val, 1, Integer.MAX_VALUE, -1);
        if (n > 0) {
            map.put("-ms-tblStyleRowBandSize", Integer.toString(n));
        }
    }

    private void parse_w_isLgl(Element element, Map<String, String> map) {
        String string = this.getVal(element, "true");
        if (string != null) {
            map.put("-ms-isLgl", Styles.parseBoolean(string) ? "true" : "false");
        }
    }

    private void parse_w_lvlJc(Element element, Map<String, String> map) {
        String string = this.getVal(element, null);
        if (string == null) {
            string = "left";
        } else if ("start".equals(string)) {
            string = "left";
        } else if ("end".equals(string)) {
            string = "right";
        }
        map.put("-ms-lvlJc", string);
    }

    private void parse_w_lvl_pStyle(Element element, Map<String, String> map) {
        String string = this.getVal(element, null);
        if (string != null) {
            map.put("-ms-lvl-pStyle", this.styleIdToName(string));
        }
    }

    private void parse_w_lvlText(Element element, Map<String, String> map) {
        String string = element.getAttribute(this.name_w_null);
        String string2 = string != null && Styles.parseBoolean(string) ? "0" : Util.toCSSString(this.getVal(element, ""));
        map.put("-ms-lvlText", string2);
    }

    private void parse_w_lvlPicBulletId(Element element, Map<String, String> map) {
        Element element2;
        String string = Util.checkIntAttribute(element, this.name_w_val);
        if (string != null && (element2 = this.imgBullets.get(string)) != null) {
            map.put("-ms-lvlPicBullet", Util.toCSSURL(element2.getAttribute(Constants.SRC_ATTR)));
        }
    }

    private void parse_w_lvlRestart(Element element, Map<String, String> map) {
        String string = Util.checkIntAttribute(element, this.name_w_val);
        if (string != null) {
            map.put("-ms-lvlRestart", string);
        }
    }

    private void parse_w_numFmt(Element element, Map<String, String> map) {
        String string = this.getVal(element, null);
        if (string != null) {
            map.put("-ms-numFmt", string);
        }
    }

    private void parse_w_start(Element element, Map<String, String> map) {
        String string = Util.checkIntAttribute(element, this.name_w_val);
        if (string != null) {
            map.put("-ms-start", string);
        }
    }

    private void parse_w_suff(Element element, Map<String, String> map) {
        String string = this.getVal(element, null);
        if (string != null) {
            map.put("-ms-suff", string);
        }
    }

    public void declareStyles(Element element) {
        Element element2 = new Element(Constants.STYLE_ELEM);
        element.appendChild(element2);
        element2.putAttribute(Constants.TYPE_ATTR, "text/css");
        int n = this.referencedStyleNames.size();
        Object[] objectArray = new Style[n];
        if (n > 0) {
            n = 0;
            for (String object : this.referencedStyleNames.keySet()) {
                Style style = this.styles.get(object);
                if (style == null) continue;
                objectArray[n++] = style;
            }
            if (n != objectArray.length) {
                objectArray = ArrayUtil.trimToSize(objectArray, n);
            }
            if (n > 1) {
                Arrays.sort(objectArray);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Style style : this.defaultStyles) {
            String string = style.name;
            Object object = style.props;
            if ("body".equals(string)) {
                this.addCounterResets((Style[])objectArray, (Map<String, String>)object);
            }
            if (((HashMap)object).size() <= 0) continue;
            stringBuilder.append("\n");
            stringBuilder.append(string);
            stringBuilder.append(" {\n");
            Styles.toCSS((Map<String, String>)object, '\n', stringBuilder);
            stringBuilder.append("\n}\n");
        }
        for (Object object : objectArray) {
            HashMap<String, String> hashMap;
            Numbering numbering;
            String string = ((Style)object).name;
            Numbering numbering2 = numbering = string.startsWith("n-") ? (Numbering)object : null;
            if (numbering != null) {
                hashMap = numbering.paragraphProps;
                stringBuilder.append("\n.p");
                stringBuilder.append(string);
                stringBuilder.append(" {\n");
                Styles.toCSS(hashMap, '\n', stringBuilder);
                stringBuilder.append("\n}\n");
            }
            stringBuilder.append("\n.");
            stringBuilder.append(string);
            stringBuilder.append(" {\n");
            Styles.toCSS(((Style)object).props, '\n', stringBuilder);
            stringBuilder.append("\n}\n");
            if (numbering == null || (hashMap = numbering.propsBefore).size() <= 0) continue;
            stringBuilder.append("\n.");
            stringBuilder.append(string);
            stringBuilder.append(":before {\n");
            Styles.toCSS(hashMap, '\n', stringBuilder);
            stringBuilder.append("\n}\n");
            if (!hashMap.containsKey("float")) continue;
            stringBuilder.append("\n.");
            stringBuilder.append(string);
            stringBuilder.append(":after {\n");
            stringBuilder.append("    clear: both;\n");
            stringBuilder.append("    content: \"\";\n");
            stringBuilder.append("    display: block;\n");
            stringBuilder.append("}\n");
        }
        element2.appendChild(new Text(stringBuilder.toString()));
    }

    private void addCounterResets(Style[] styleArray, Map<String, String> map) {
        int n;
        Numbering numbering;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Style object : styleArray) {
            int n2;
            if (!object.name.startsWith("n-") || !(numbering = (Numbering)object).hasCounter()) continue;
            n = numbering.getStart() - 1;
            boolean bl = false;
            String string = numbering.name;
            int n3 = this.referenceRank(string);
            if (n3 >= 0 && (n2 = string.lastIndexOf(45)) >= 0) {
                String string2 = string.substring(0, n2 + 1);
                for (int i = numbering.getLevel() + 1; i <= 9; ++i) {
                    String string3 = string2 + Integer.toString(i);
                    int n4 = this.referenceRank(string3);
                    if (n4 < 0 || n4 >= n3) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                ++n;
            }
            hashMap.put(numbering.name, n);
        }
        for (Style style : styleArray) {
            if (!style.name.startsWith("n-")) continue;
            numbering = (Numbering)style;
            for (n = numbering.getLevel() - 1; n >= 0; --n) {
                Numbering numbering2 = numbering.getNumbering(this.styles, n);
                if (numbering2 == null || !numbering2.hasCounter() || hashMap.containsKey(numbering2.name)) continue;
                int n5 = numbering2.getStart();
                hashMap.put(numbering2.name, n5);
            }
        }
        int n6 = hashMap.size();
        if (n6 > 0) {
            Object[] objectArray = new String[n6];
            n6 = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                objectArray[n6++] = (String)entry.getKey() + " " + ((Integer)entry.getValue()).toString();
            }
            if (n6 > 1) {
                Arrays.sort(objectArray);
            }
            map.put("counter-reset", StringUtil.join(' ', (String[])objectArray));
        }
    }

    private int referenceRank(String string) {
        Integer n = this.referencedStyleNames.get(string);
        return n == null ? -1 : n;
    }

    public static String toCSS(Map<String, String> map, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        Styles.toCSS(map, c, stringBuilder);
        return stringBuilder.toString();
    }

    public static void toCSS(Map<String, String> map, char c, StringBuilder stringBuilder) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        Object[] objectArray = new String[n];
        n = 0;
        StringBuilder stringBuilder2 = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (TEMP_PROP_NAMES.contains(string) || "-ms-outlineLvl".equals(string) && "9".equals(string2)) continue;
            if (stringBuilder2 == null) {
                stringBuilder2 = new StringBuilder();
            } else {
                stringBuilder2.setLength(0);
            }
            stringBuilder2.append(string);
            stringBuilder2.append(": ");
            stringBuilder2.append(string2);
            objectArray[n++] = stringBuilder2.toString();
        }
        if (n == 0) {
            return;
        }
        if (n != objectArray.length) {
            objectArray = ArrayUtil.trimToSize(objectArray, n);
        }
        if (n > 1) {
            Arrays.sort(objectArray);
        }
        boolean bl = c == '\n';
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(c);
            }
            if (bl) {
                stringBuilder.append("    ");
            }
            stringBuilder.append((String)objectArray[i]);
            stringBuilder.append(';');
        }
    }

    public void setDefaultLang(Element element) {
        String string = null;
        Style style = this.defaultStyles.get(0);
        if (style != null) {
            string = style.get("-ms-lang");
        }
        if (string != null) {
            element.putAttribute(Name.LANG, LocaleUtil.normalizeLang(string));
        }
    }

    public String getLang(Element element) {
        String string = null;
        if (element.getName() == this.name_w_rPr) {
            string = this.getLangVal(element, this.name_w_lang, null);
        }
        if (string == null) {
            Style style = null;
            if (element.getName() == this.name_w_pPr) {
                String string2 = this.getVal(element, this.name_w_pStyle, null);
                if (string2 != null) {
                    string2 = this.styleIdToName(string2);
                    style = this.getStyle("p", string2, null);
                }
            } else {
                String string3 = this.getVal(element, this.name_w_rStyle, null);
                if (string3 != null) {
                    string3 = this.styleIdToName(string3);
                    style = this.getStyle("c", string3, null);
                }
            }
            if (style != null) {
                string = style.get("-ms-lang");
            }
        }
        return string == null ? null : LocaleUtil.normalizeLang(string);
    }

    static {
        for (String string : TEMP_PROP_NAME_LIST) {
            TEMP_PROP_NAMES.add(string);
        }
    }
}

