/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.Styles;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.name.Name;

final class SimplifyTables {
    SimplifyTables() {
    }

    public static void process(Document document, Styles styles) {
        Element element = document.getRootElement();
        Element element2 = Util.findDescendant(element, Constants.BODY_ELEM, false);
        if (element2 == null) {
            return;
        }
        SimplifyTables.processCells(element2, false, styles);
    }

    private static void processCells(Element element, boolean bl, Styles styles) {
        Node node;
        Name name = element.getName();
        if (name == Constants.TD_ELEM) {
            SimplifyTables.processCell(element, bl, styles);
        } else if (name == Constants.TABLE_ELEM) {
            if (Util.findDescendant(element, Constants.TD_ELEM, true) == null) {
                element.getParent().removeChild(element);
                return;
            }
            node = Util.findDescendant(element, Constants.COLGROUP_ELEM, false);
            bl = node != null && Util.getStyleProp((Element)node, "width") != null;
        }
        node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getType() == Node.Type.ELEMENT) {
                SimplifyTables.processCells((Element)node, bl, styles);
            }
            node = node2;
        }
    }

    private static void processCell(Element element, boolean bl, Styles styles) {
        Node node;
        if (bl) {
            Util.removeStyleProp(element, "width");
        }
        String string = null;
        for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT || ((Element)node).getName() != Constants.P_ELEM) continue;
            Element element2 = (Element)node;
            String string2 = Util.getStyleProp(element2, "text-align");
            if (string2 == null) {
                string = null;
                break;
            }
            if (string == null) {
                string = string2;
            } else if (!string2.equals(string)) {
                string = null;
                break;
            }
            String string3 = styles.getStyleProperty(element2, "text-align");
            if (string3 == null || string3.equals(string)) continue;
            string = null;
            break;
        }
        if (string != null) {
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getType() != Node.Type.ELEMENT || ((Element)node).getName() != Constants.P_ELEM) continue;
                Util.removeStyleProp((Element)node, "text-align");
            }
            Util.addStyleProp(element, "text-align", string);
        }
    }
}

