/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.util.StringUtil;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.SimplifyFields;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.w2x.docx.toxhtml.XHTMLVersion;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;

final class SimplifyReferences {
    SimplifyReferences() {
    }

    public static void process(Document document, XHTMLVersion xHTMLVersion) {
        Element element = document.getRootElement();
        Element element2 = Util.findDescendant(element, Constants.BODY_ELEM, false);
        if (element2 == null) {
            return;
        }
        SimplifyReferences.refToLink(element2, xHTMLVersion);
        SimplifyReferences.processNestedLinks(element2);
    }

    private static void refToLink(Element element, XHTMLVersion xHTMLVersion) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            ProcessingInstruction processingInstruction;
            Node node2;
            String string;
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            if (element2.getName() == Constants.SPAN_ELEM && (string = element2.getAttribute(Constants.CLASS_ATTR)) != null && string.startsWith("role-field") && (node2 = SimplifyFields.getFirstChild(element2)) != null && node2.getType() == Node.Type.PROCESSING_INSTRUCTION && "field".equals((processingInstruction = (ProcessingInstruction)node2).getTarget())) {
                String string2 = processingInstruction.getText();
                if (string2.startsWith("HYPERLINK")) {
                    SimplifyReferences.hyperlinkToLink(element2, processingInstruction, string2, xHTMLVersion);
                } else if (string2.startsWith("NOTEREF") || string2.startsWith("PAGEREF") || string2.startsWith("REF")) {
                    SimplifyReferences.xrefToLink(element2, processingInstruction, string2);
                }
            }
            SimplifyReferences.refToLink(element2, xHTMLVersion);
        }
    }

    private static void hyperlinkToLink(Element element, ProcessingInstruction processingInstruction, String string, XHTMLVersion xHTMLVersion) {
        Object object;
        String[] stringArray = StringUtil.splitArguments(string);
        int n = stringArray.length;
        if (n < 2) {
            return;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n2 = 1;
        if (!stringArray[n2].startsWith("\\")) {
            string2 = stringArray[n2];
            ++n2;
        }
        while (n2 < n) {
            object = stringArray[n2];
            if ("\\l".equals(object)) {
                if (n2 + 1 >= n) {
                    return;
                }
                string3 = stringArray[++n2];
            } else if (!"\\m".equals(object)) {
                if ("\\n".equals(object)) {
                    string5 = "_blank";
                } else if ("\\o".equals(object)) {
                    if (n2 + 1 >= n) {
                        return;
                    }
                    string4 = stringArray[++n2];
                } else if ("\\t".equals(object)) {
                    if (n2 + 1 >= n) {
                        return;
                    }
                    string5 = stringArray[++n2];
                }
            }
            ++n2;
        }
        if (string2 == null && string3 == null) {
            return;
        }
        element.setName(Constants.A_ELEM);
        Util.removeClass(element, "role-field");
        element.removeChild(processingInstruction);
        object = string2 == null ? "#" + string3 : string2;
        element.putAttribute(Constants.HREF_ATTR, (String)object);
        if (string4 != null) {
            element.putAttribute(Constants.TITLE_ATTR, string4);
        }
        if (xHTMLVersion != XHTMLVersion.V1_0_Strict && xHTMLVersion != XHTMLVersion.V1_1 && string5 != null) {
            element.putAttribute(Constants.TARGET_ATTR, string5);
        }
    }

    private static void xrefToLink(Element element, ProcessingInstruction processingInstruction, String string) {
        String string2;
        String[] stringArray = StringUtil.splitArguments(string);
        if (stringArray.length < 2) {
            return;
        }
        String string3 = string2 = stringArray[1].startsWith("\\") ? null : stringArray[1];
        if (string2 == null) {
            return;
        }
        element.setName(Constants.A_ELEM);
        Util.removeClass(element, "role-field");
        Util.addClass(element, "role-" + stringArray[0].toLowerCase() + "-field", true);
        element.putAttribute(Constants.HREF_ATTR, "#" + string2);
    }

    private static void processNestedLinks(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getType() == Node.Type.ELEMENT) {
                Element element2 = (Element)node;
                if (element2.getName() == Constants.A_ELEM && element2.hasAttribute(Constants.HREF_ATTR)) {
                    Element element3 = SimplifyReferences.findFirstLink(element2);
                    if (element3 != null) {
                        Node node3 = element3;
                        while (node3 != null) {
                            Node node4 = node3.getNextSibling();
                            element2.removeChild(node3);
                            element.insertChild(node2, node3);
                            node3 = node4;
                        }
                        node2 = element3;
                    }
                } else {
                    SimplifyReferences.processNestedLinks(element2);
                }
            }
            node = node2;
        }
    }

    private static Element findFirstLink(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            if (node.getType() != Node.Type.ELEMENT || (element2 = (Element)node).getName() != Constants.A_ELEM || !element2.hasAttribute(Constants.HREF_ATTR)) continue;
            return element2;
        }
        return null;
    }
}

