/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.toxhtml;

import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.docx.toxhtml.Constants;
import com.xmlmind.w2x.docx.toxhtml.Style;
import com.xmlmind.w2x.docx.toxhtml.Styles;
import com.xmlmind.w2x.docx.toxhtml.TabStop;
import com.xmlmind.w2x.docx.toxhtml.Util;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import java.util.HashMap;
import java.util.Map;

final class PrepareTabs {
    PrepareTabs() {
    }

    public static void process(Document document, Styles styles) {
        Element element = document.getRootElement();
        Element element2 = Util.findDescendant(element, Constants.BODY_ELEM, false);
        if (element2 == null) {
            return;
        }
        PrepareTabs.processParagraphs(element2, styles);
    }

    private static void processParagraphs(Element element, Styles styles) {
        if (element.getName() == Constants.P_ELEM) {
            String string = element.getAttribute(Constants.CLASS_ATTR);
            if ((string == null || !string.startsWith("role-")) && PrepareTabs.containsTab(element)) {
                PrepareTabs.processParagraph(element, styles);
            }
        } else {
            Node node = element.getFirstChild();
            while (node != null) {
                Node node2 = node.getNextSibling();
                if (node.getType() == Node.Type.ELEMENT) {
                    PrepareTabs.processParagraphs((Element)node, styles);
                }
                node = node2;
            }
        }
    }

    private static boolean containsTab(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            if (element2.getName() == Constants.SPAN_ELEM && (string = element2.getAttribute(Constants.CLASS_ATTR)) != null && string.startsWith("role-tab")) {
                return true;
            }
            if (!PrepareTabs.containsTab(element2)) continue;
            return true;
        }
        return false;
    }

    private static void processParagraph(Element element, Styles styles) {
        Object object;
        Object object2;
        String string;
        TabStop[] tabStopArray = TabStop.EMPTY_LIST;
        String string2 = styles.lookupStyle(element, "text-indent");
        if (string2 != null && string2.endsWith("pt")) {
            double d = 0.0;
            try {
                d = Double.parseDouble(string2.substring(0, string2.length() - 2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (d < 0.0) {
                tabStopArray = TabStop.merge(tabStopArray, new TabStop[]{new TabStop("start", -d, null)});
            }
        }
        if ((string = element.getAttribute(Constants.CLASS_ATTR)) != null) {
            object2 = XMLText.splitList(string);
            for (String string3 : object2) {
                Style style = styles.getStyle(string3);
                if (style == null) continue;
                tabStopArray = TabStop.merge(tabStopArray, TabStop.getFromProperties(style.props));
            }
        }
        if ((object2 = element.getAttribute(Constants.STYLE_ATTR)) != null) {
            String[] stringArray;
            object = new HashMap();
            for (String string4 : stringArray = Util.splitStyleProps((String)object2)) {
                int n = string4.indexOf(58);
                if (n < 0) continue;
                String string5 = string4.substring(0, n).trim();
                String string6 = string4.substring(n + 1).trim();
                if (string5.length() <= 0 || string6.length() <= 0) continue;
                ((HashMap)object).put(string5, string6);
            }
            tabStopArray = TabStop.merge(tabStopArray, TabStop.getFromProperties((Map<String, String>)object));
        }
        object = new StringBuilder("role-tabs-");
        double d = styles.getDefaultTabStop();
        ((StringBuilder)object).append(Util.formatDouble(d));
        ((StringBuilder)object).append("-0");
        for (TabStop tabStop : tabStopArray) {
            ((StringBuilder)object).append('-');
            ((StringBuilder)object).append(Util.formatDouble(tabStop.pos));
        }
        Util.addClass(element, ((StringBuilder)object).toString(), true);
    }
}

