/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.packaging;

import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.w2x.docx.packaging.Msg;
import com.xmlmind.w2x.docx.packaging.ParseException;
import com.xmlmind.w2x.docx.packaging.PartNameUtil;
import com.xmlmind.w2x.docx.packaging.Util;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import java.net.URI;
import java.util.Map;

public final class Related
implements Comparable<Related> {
    public final String id;
    public final String type;
    public final boolean external;
    public final String target;
    public static final Related[] EMPTY_LIST = new Related[0];
    private static final Namespace RELATIONSHIPS_NS = Namespace.get("http://schemas.openxmlformats.org/package/2006/relationships");
    private static final Name RELATIONSHIPS_ELEM = Name.get(RELATIONSHIPS_NS, "Relationships");
    private static final Name RELATIONSHIP_ELEM = Name.get(RELATIONSHIPS_NS, "Relationship");
    private static final Name ID_ATTR = Name.get(Namespace.NONE, "Id");
    private static final Name TYPE_ATTR = Name.get(Namespace.NONE, "Type");
    private static final Name TARGET_MODE_ATTR = Name.get(Namespace.NONE, "TargetMode");
    private static final Name TARGET_ATTR = Name.get(Namespace.NONE, "Target");

    public Related(String string, String string2, boolean bl, String string3) {
        this.id = string;
        this.type = string2;
        this.external = bl;
        this.target = string3;
    }

    public static void loadFrom(Document document, String string, URI uRI, Map<String, Related> map) throws ParseException {
        Element element = document.getRootElement();
        if (element.getName() != RELATIONSHIPS_ELEM) {
            throw new ParseException(element, Msg.msg("unknownElement", element.getName().format(false, element)));
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string2;
            Element element2;
            if (node.getType() != Node.Type.ELEMENT || (element2 = (Element)node).getName() != RELATIONSHIP_ELEM) continue;
            String string3 = Util.getRequiredAttribute(element2, ID_ATTR);
            String string4 = Util.getRequiredAttribute(element2, TYPE_ATTR);
            String string5 = element2.getAttribute(TARGET_MODE_ATTR);
            boolean bl = "external".equalsIgnoreCase(string5);
            String string6 = Util.getRequiredAttribute(element2, TARGET_ATTR);
            try {
                if (bl) {
                    if (string6.startsWith("file:///\\\\")) {
                        string6 = string6.replaceFirst("^file:///\\\\\\\\([^\\\\]+)\\\\", "file://$1/");
                    }
                    string6 = PartNameUtil.fix(string6);
                    string2 = new URI(string6).normalize().toASCIIString();
                } else {
                    string2 = PartNameUtil.resolve(string6, string);
                }
            }
            catch (Exception exception) {
                throw new ParseException(element2, Msg.msg("invalidAttribute2", string6, "Target", ThrowableUtil.reason(exception)));
            }
            map.put(string3, new Related(string3, string4, bl, string2));
        }
    }

    @Override
    public int compareTo(Related related) {
        return this.id.compareTo(related.id);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("  <Relationship Id=");
        XMLText.quoteXML(this.id, stringBuilder);
        stringBuilder.append(" Type=");
        XMLText.quoteXML(this.type, stringBuilder);
        if (this.external) {
            stringBuilder.append(" TargetMode=\"External\"");
        }
        stringBuilder.append(" Target=");
        XMLText.quoteXML(this.target, stringBuilder);
        stringBuilder.append("/>");
    }

    public static String toString(Related[] relatedArray) {
        StringBuilder stringBuilder = new StringBuilder("<Relationships>\n");
        for (Related related : relatedArray) {
            related.toString(stringBuilder);
            stringBuilder.append('\n');
        }
        stringBuilder.append("</Relationships>");
        return stringBuilder.toString();
    }
}

