/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.packaging;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class PartInputStream
extends InputStream {
    public final ZipFile zip;
    public final ZipEntry[] zipEntries;
    private int currentIndex;
    private InputStream currentStream;

    public PartInputStream(ZipFile zipFile, ZipEntry[] zipEntryArray) throws IOException {
        this.zip = zipFile;
        this.zipEntries = zipEntryArray;
        this.currentIndex = 0;
        this.currentStream = zipFile.getInputStream(zipEntryArray[this.currentIndex]);
    }

    @Override
    public int read() throws IOException {
        int n = this.currentStream.read();
        if (n < 0 && this.currentIndex + 1 < this.zipEntries.length) {
            this.currentStream.close();
            ++this.currentIndex;
            this.currentStream = this.zip.getInputStream(this.zipEntries[this.currentIndex]);
            n = this.currentStream.read();
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.currentStream.read(byArray, n, n2);
        if (n3 < 0 && this.currentIndex + 1 < this.zipEntries.length) {
            this.currentStream.close();
            ++this.currentIndex;
            this.currentStream = this.zip.getInputStream(this.zipEntries[this.currentIndex]);
            n3 = this.currentStream.read(byArray, n, n2);
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        return this.currentStream.skip(l);
    }

    @Override
    public int available() throws IOException {
        return this.currentStream.available();
    }

    @Override
    public void close() throws IOException {
        this.currentStream.close();
    }
}

