/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x.docx.math;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.w2x.docx.math.MathConverter;
import com.xmlmind.w2x.docx.math.MathConverterFactory;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.load.DocumentLoader;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.resolve.XMLCatalogs;
import com.xmlmind.xml.save.DocumentWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;

public final class MathConverterFactoryImpl
implements MathConverterFactory {
    private HashMap<String, Templates> cache = new HashMap();
    private TransformerFactory transformerFactory;
    private URL stylesheetURL;
    private String stylesheet;
    private static final String WORDPROCESSINGML_NS = "http://schemas.openxmlformats.org/wordprocessingml/2006/main";
    private static final String MATH_NS = "http://schemas.openxmlformats.org/officeDocument/2006/math";

    @Override
    public MathConverter createMathConverter(Element element) throws Exception {
        final Transformer transformer = this.newTransformer(element);
        if (transformer == null) {
            return null;
        }
        return new MathConverter(){

            @Override
            public Element convertMath(Element element) throws Exception {
                URL uRL = element.getSourceURL();
                String string = uRL == null ? null : uRL.toExternalForm();
                StreamSource streamSource = new StreamSource(new StringReader(MathConverterFactoryImpl.elementToString(element)), string);
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                transformer.transform(streamSource, streamResult);
                return MathConverterFactoryImpl.elementFromString(stringWriter.toString());
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.getClass().getName());
                stringBuilder.append('[');
                stringBuilder.append(URLUtil.toLabel(MathConverterFactoryImpl.this.stylesheetURL));
                stringBuilder.append(']');
                return stringBuilder.toString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformer newTransformer(Element element) throws Exception {
        String string = element.getNamespace().uri;
        String string2 = WORDPROCESSINGML_NS;
        Element element2 = element.getParentElement();
        if (element2 != null) {
            string2 = element2.getNamespace().uri;
        }
        String string3 = string + "\n" + string2;
        HashMap<String, Templates> hashMap = this.cache;
        synchronized (hashMap) {
            Templates templates = this.cache.get(string3);
            if (templates == null) {
                String string4 = this.loadStylesheet();
                if (string4 == null) {
                    return null;
                }
                string4 = StringUtil.replaceAll(string4, WORDPROCESSINGML_NS, string2);
                string4 = StringUtil.replaceAll(string4, MATH_NS, string);
                TransformerFactory transformerFactory = this.getTransformerFactory();
                templates = transformerFactory.newTemplates(new StreamSource(new StringReader(string4), this.stylesheetURL.toExternalForm()));
                this.cache.put(string3, templates);
            }
            return templates.newTransformer();
        }
    }

    private String loadStylesheet() throws IOException {
        if (this.stylesheet == null) {
            this.stylesheetURL = null;
            String string = System.getProperty("W2X_MATH_CONVERTER_XSLT");
            if (string != null && (string = string.trim()).length() > 0) {
                System.err.print("W2X_MATH_CONVERTER_XSLT=" + string);
                if ("-".equals(string)) {
                    System.err.println();
                    return null;
                }
                this.stylesheetURL = URLUtil.urlOrFile(string);
                System.err.println(" (" + String.valueOf(this.stylesheetURL) + ")");
            }
            if (this.stylesheetURL == null) {
                this.stylesheetURL = MathConverterFactoryImpl.class.getResource("omml2mml.xsl");
                if (this.stylesheetURL == null) {
                    throw new FileNotFoundException("resource \"omml2mml.xsl\" not found");
                }
            }
            this.stylesheet = URLUtil.loadString(this.stylesheetURL, "UTF-8");
        }
        return this.stylesheet;
    }

    private TransformerFactory getTransformerFactory() throws Exception {
        if (this.transformerFactory == null) {
            try {
                this.transformerFactory = TransformerFactory.newInstance("com.icl.saxon.TransformerFactoryImpl", null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.transformerFactory == null) {
                this.transformerFactory = TransformerFactory.newInstance();
            }
            URIResolver uRIResolver = XMLCatalogs.getURIResolver();
            this.transformerFactory.setURIResolver(uRIResolver);
            ErrorListener errorListener = new ErrorListener(){

                @Override
                public void warning(TransformerException transformerException) throws TransformerException {
                    System.err.println("WARNING: " + transformerException.getMessageAndLocation());
                }

                @Override
                public void error(TransformerException transformerException) throws TransformerException {
                    System.err.println("ERROR: " + transformerException.getMessageAndLocation());
                }

                @Override
                public void fatalError(TransformerException transformerException) throws TransformerException {
                    System.err.println("FATAL ERROR: " + transformerException.getMessageAndLocation());
                    throw transformerException;
                }
            };
            this.transformerFactory.setErrorListener(errorListener);
        }
        return this.transformerFactory;
    }

    private static String elementToString(Element element) throws IOException {
        StringWriter stringWriter = new StringWriter();
        DocumentWriter documentWriter = new DocumentWriter(stringWriter);
        PrefixEntry[] prefixEntryArray = new PrefixEntry[]{new PrefixEntry("m", element.getNamespace())};
        Element element2 = element.getParentElement();
        if (element2 != null) {
            prefixEntryArray = ArrayUtil.append(prefixEntryArray, new PrefixEntry("w", element2.getNamespace()));
        }
        documentWriter.setPrefixPreferences(prefixEntryArray);
        documentWriter.write(element);
        return stringWriter.toString();
    }

    private static Element elementFromString(String string) throws Exception {
        DocumentLoader documentLoader = new DocumentLoader();
        InputSource inputSource = new InputSource(new StringReader(string));
        Document document = documentLoader.load(inputSource);
        Element element = document.getRootElement();
        if (element == null || element.getName() != Name.MATH) {
            throw new RuntimeException("converted element not a mml:math");
        }
        document.removeChild(element);
        return element;
    }
}

