/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.whc;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.whc.DOMUtil;
import com.xmlmind.whc.EntityResolverImpl;
import com.xmlmind.whc.Msg;
import com.xmlmind.whc.SAXToDOM;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

final class LoadDocument {
    private LoadDocument() {
    }

    public static Document load(File file) throws IOException {
        return LoadDocument.load(FileUtil.fileToURL((File)file));
    }

    public static Document load(URL uRL) throws IOException {
        XMLReader xMLReader;
        Document document;
        try {
            document = DOMUtil.newDocument();
            xMLReader = LoadDocument.createSAXParser();
        }
        catch (Exception exception) {
            throw new IOException(ThrowableUtil.reason((Throwable)exception));
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(URLUtil.openStreamNoCache((URL)uRL));
        InputSource inputSource = new InputSource(bufferedInputStream);
        inputSource.setSystemId(uRL.toExternalForm());
        SAXToDOM sAXToDOM = new SAXToDOM(document);
        xMLReader.setContentHandler(sAXToDOM);
        xMLReader.setErrorHandler(sAXToDOM);
        xMLReader.setEntityResolver(EntityResolverImpl.INSTANCE);
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", sAXToDOM);
        }
        catch (Exception exception) {
            throw new IOException(ThrowableUtil.reason((Throwable)exception));
        }
        try {
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            throw new IOException(LoadDocument.format(sAXParseException));
        }
        catch (SAXException sAXException) {
            throw new IOException(ThrowableUtil.reason((Throwable)sAXException));
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        document.setDocumentURI(uRL.toExternalForm());
        return document;
    }

    private static XMLReader createSAXParser() {
        XMLReader xMLReader = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setXIncludeAware(false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", true);
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
            sAXParserFactory.setFeature("http://xml.org/sax/features/lexical-handler/parameter-entities", false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/resolve-dtd-uris", true);
            try {
                sAXParserFactory.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (Exception exception) {
            throw new RuntimeException(Msg.msg("cannotCreateSAXParser", ThrowableUtil.reason((Throwable)exception)));
        }
        return xMLReader;
    }

    private static String format(SAXParseException sAXParseException) {
        StringBuilder stringBuilder = new StringBuilder();
        if (sAXParseException.getSystemId() != null) {
            stringBuilder.append(sAXParseException.getSystemId());
        }
        stringBuilder.append(':');
        if (sAXParseException.getLineNumber() > 0) {
            stringBuilder.append(sAXParseException.getLineNumber());
        }
        stringBuilder.append(':');
        if (sAXParseException.getColumnNumber() > 0) {
            stringBuilder.append(sAXParseException.getColumnNumber());
        }
        stringBuilder.append(":parse error: ");
        stringBuilder.append(sAXParseException.getMessage());
        return stringBuilder.toString();
    }
}

