/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpointer;

import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.validate.AnyDocumentType;
import com.xmlmind.xml.validate.DocumentType;
import com.xmlmind.xml.validate.DocumentTypeUtil;
import com.xmlmind.xml.xpointer.SimpleXPointer;

public final class ElementXPointer
implements SimpleXPointer {
    public final String id;
    public final int[] descendant;

    public ElementXPointer(String string) {
        this(string, null);
    }

    public ElementXPointer(String string, int[] nArray) {
        this.id = string;
        this.descendant = nArray == null ? new int[]{} : nArray;
    }

    public boolean isRootElement() {
        return this.id == null && this.descendant.length == 1 && this.descendant[0] == 1;
    }

    public boolean isElementID() {
        return this.id != null && this.descendant.length == 0;
    }

    public String toString() {
        if (this.descendant.length == 0) {
            return this.id;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("element(");
        if (this.id != null) {
            stringBuilder.append(this.id);
        }
        for (int i = 0; i < this.descendant.length; ++i) {
            stringBuilder.append('/');
            stringBuilder.append(Integer.toString(this.descendant[i]));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public Element findElement(Document document) {
        DocumentType documentType = DocumentTypeUtil.getDocumentType(document);
        return this.findElement(document, new ContextImpl(documentType));
    }

    public Element findElement(Document document, Context context) {
        int n;
        Element element;
        if (this.id == null) {
            if (this.descendant.length == 0 || this.descendant[0] != 1) {
                return null;
            }
            element = document.getRootElement();
            n = 1;
        } else {
            element = context.findElementById(document, this.id);
            if (element == null) {
                return null;
            }
            n = 0;
        }
        int n2 = this.descendant.length;
        for (int i = n; i < n2; ++i) {
            int n3 = this.descendant[i];
            if ((element = element.getChildElement(n3 - 1)) != null) continue;
            return null;
        }
        return element;
    }

    @Override
    public Node[] findNodes(Document document, Object object) {
        Node[] nodeArray;
        Object object2;
        Context context;
        if (object != null && object instanceof Context) {
            context = (Context)object;
        } else {
            object2 = DocumentTypeUtil.getDocumentType(document);
            context = new ContextImpl((DocumentType)object2);
        }
        object2 = this.findElement(document, context);
        if (object2 == null) {
            nodeArray = null;
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = object2;
        }
        return nodeArray;
    }

    public static final class ContextImpl
    implements Context {
        public final DocumentType documentType;

        public ContextImpl(DocumentType documentType) {
            if (documentType == null) {
                documentType = AnyDocumentType.INSTANCE;
            }
            this.documentType = documentType;
        }

        @Override
        public Element findElementById(Document document, String string) {
            Element[] elementArray = DocumentTypeUtil.findElementById(this.documentType, document.getRootElement(), string, true);
            if (elementArray == null) {
                return null;
            }
            return elementArray[0];
        }
    }

    public static interface Context {
        public Element findElementById(Document var1, String var2);
    }
}

