/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.NodeIterator;

class UnionNodeIterator
implements NodeIterator {
    private NodeIterator iter1;
    private NodeIterator iter2;
    private XNode node1;
    private XNode node2;

    public UnionNodeIterator(NodeIterator nodeIterator, NodeIterator nodeIterator2) throws EvalException {
        this.iter1 = nodeIterator;
        this.iter2 = nodeIterator2;
        this.node1 = nodeIterator.next();
        this.node2 = nodeIterator2.next();
    }

    @Override
    public XNode next() throws EvalException {
        if (this.node1 == null) {
            XNode xNode = this.node2;
            this.node2 = this.iter2.next();
            return xNode;
        }
        if (this.node2 == null) {
            XNode xNode = this.node1;
            this.node1 = this.iter1.next();
            return xNode;
        }
        int n = this.node1.compareTo(this.node2);
        if (n == 0) {
            XNode xNode = this.node1;
            this.node1 = this.iter1.next();
            this.node2 = this.iter2.next();
            return xNode;
        }
        if (n < 0) {
            XNode xNode = this.node1;
            this.node1 = this.iter1.next();
            return xNode;
        }
        XNode xNode = this.node2;
        this.node2 = this.iter2.next();
        return xNode;
    }
}

