/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.xpath.ConvertibleExpr;
import com.xmlmind.xml.xpath.ConvertibleNodeSetExpr;
import com.xmlmind.xml.xpath.ConvertibleStringExpr;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.Function;
import com.xmlmind.xml.xpath.LiteralExpr;
import com.xmlmind.xml.xpath.ParseException;
import com.xmlmind.xml.xpath.SelfAxisExpr;

class PropertyFunction
implements Function {
    PropertyFunction() {
    }

    @Override
    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] convertibleExprArray, PrefixToNamespace prefixToNamespace) throws ParseException {
        if (convertibleExprArray.length < 1 || convertibleExprArray.length > 2) {
            throw new ParseException("should be: property(name, node-set?)");
        }
        if (convertibleExprArray.length == 1) {
            return this.makeCallExpr(convertibleExprArray[0], new SelfAxisExpr());
        }
        if (convertibleExprArray[1] instanceof LiteralExpr) {
            return this.makeCallExpr(convertibleExprArray[1], convertibleExprArray[0]);
        }
        return this.makeCallExpr(convertibleExprArray[0], convertibleExprArray[1]);
    }

    ConvertibleExpr makeCallExpr(ConvertibleExpr convertibleExpr, ConvertibleExpr convertibleExpr2) throws ParseException {
        final ConvertibleStringExpr convertibleStringExpr = convertibleExpr.makeStringExpr();
        final ConvertibleNodeSetExpr convertibleNodeSetExpr = convertibleExpr2.makeNodeSetExpr();
        return new ConvertibleStringExpr(){

            @Override
            public String eval(XNode xNode, ExprContext exprContext) throws EvalException {
                Node node = null;
                XNode xNode2 = convertibleNodeSetExpr.eval(xNode, exprContext).next();
                if (xNode2 != null) {
                    if (xNode2 instanceof Attribute) {
                        node = ((Attribute)xNode2).element;
                    } else if (xNode2 instanceof Node) {
                        node = (Node)xNode2;
                    }
                }
                if (node != null) {
                    Object object;
                    String string = convertibleStringExpr.eval(xNode, exprContext);
                    Name name = Name.parse(string, true, xNode.namespacePrefixMap());
                    if (name == null) {
                        name = Name.fromString(string);
                    }
                    if (name != null && (object = node.getProperty(name)) != null) {
                        return object.toString();
                    }
                }
                return "";
            }
        };
    }
}

