/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.xpath.EvalException;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

final class PatternCache {
    private static HashMap<Entry, Entry> cache = new HashMap();
    private static Entry probe = new Entry(null, 0, null);

    private PatternCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pattern get(String string, int n) throws EvalException {
        HashMap<Entry, Entry> hashMap = cache;
        synchronized (hashMap) {
            PatternCache.probe.regexp = string;
            PatternCache.probe.options = n;
            Entry entry = cache.get(probe);
            if (entry == null) {
                Pattern pattern;
                try {
                    pattern = Pattern.compile(string, n);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new EvalException("invalid pattern '" + string + "': " + patternSyntaxException.getMessage());
                }
                entry = new Entry(string, n, pattern);
                cache.put(entry, entry);
            }
            return entry.pattern;
        }
    }

    private static final class Entry {
        public String regexp;
        public int options;
        public Pattern pattern;

        public Entry(String string, int n, Pattern pattern) {
            this.regexp = string;
            this.options = n;
            this.pattern = pattern;
        }

        public int hashCode() {
            return this.regexp.hashCode() ^ this.options;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.regexp.equals(entry.regexp) && this.options == entry.options;
        }
    }
}

