/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.xpath.ConvertibleExpr;
import com.xmlmind.xml.xpath.ConvertibleNodeSetExpr;
import com.xmlmind.xml.xpath.ConvertibleStringExpr;
import com.xmlmind.xml.xpath.DocumentOrderComparator;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.Function1;
import com.xmlmind.xml.xpath.NodeIterator;
import com.xmlmind.xml.xpath.NodeListSorter;
import com.xmlmind.xml.xpath.NodeSetExpr;
import com.xmlmind.xml.xpath.ParseException;
import com.xmlmind.xml.xpath.UniqueNodeIterator;
import com.xmlmind.xml.xpath.ValueIdIterator;
import com.xmlmind.xml.xpath.Variant;
import com.xmlmind.xml.xpath.VariantExpr;

class IdFunction
extends Function1 {
    IdFunction() {
    }

    @Override
    ConvertibleExpr makeCallExpr(ConvertibleExpr convertibleExpr) throws ParseException {
        if (convertibleExpr instanceof NodeSetExpr) {
            final NodeSetExpr nodeSetExpr = (NodeSetExpr)((Object)convertibleExpr);
            return new ConvertibleNodeSetExpr(){

                @Override
                public NodeIterator eval(XNode xNode, ExprContext exprContext) throws EvalException {
                    return IdFunction.id(xNode, nodeSetExpr.eval(xNode, exprContext), exprContext);
                }
            };
        }
        if (convertibleExpr instanceof VariantExpr) {
            final VariantExpr variantExpr = (VariantExpr)((Object)convertibleExpr);
            return new ConvertibleNodeSetExpr(){

                @Override
                public NodeIterator eval(XNode xNode, ExprContext exprContext) throws EvalException {
                    Variant variant = variantExpr.eval(xNode, exprContext);
                    if (variant.isNodeSet()) {
                        return IdFunction.id(xNode, variant.convertToNodeSet(), exprContext);
                    }
                    return IdFunction.id(xNode, variant.convertToString(), exprContext);
                }
            };
        }
        final ConvertibleStringExpr convertibleStringExpr = convertibleExpr.makeStringExpr();
        return new ConvertibleNodeSetExpr(){

            @Override
            public NodeIterator eval(XNode xNode, ExprContext exprContext) throws EvalException {
                return IdFunction.id(xNode, convertibleStringExpr.eval(xNode, exprContext), exprContext);
            }
        };
    }

    private static final NodeIterator id(XNode xNode, NodeIterator nodeIterator, ExprContext exprContext) throws EvalException {
        return new UniqueNodeIterator(NodeListSorter.sort(new ValueIdIterator(xNode, nodeIterator, exprContext), new DocumentOrderComparator()));
    }

    private static final NodeIterator id(XNode xNode, String string, ExprContext exprContext) throws EvalException {
        return new UniqueNodeIterator(NodeListSorter.sort(new ValueIdIterator.Iterator(xNode, string, exprContext), new DocumentOrderComparator()));
    }
}

