/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.xpath.BooleanVariant;
import com.xmlmind.xml.xpath.ConvertibleExpr;
import com.xmlmind.xml.xpath.ConvertibleStringExpr;
import com.xmlmind.xml.xpath.ConvertibleVariantExpr;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.Function;
import com.xmlmind.xml.xpath.ParseException;
import com.xmlmind.xml.xpath.Variant;

class DefinedFunction
implements Function {
    DefinedFunction() {
    }

    @Override
    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] convertibleExprArray, final PrefixToNamespace prefixToNamespace) throws ParseException {
        if (convertibleExprArray.length < 1 || convertibleExprArray.length > 2) {
            throw new ParseException("wrong number of arguments: should be: variable_name default_value?");
        }
        final ConvertibleStringExpr convertibleStringExpr = convertibleExprArray[0].makeStringExpr();
        final ConvertibleVariantExpr convertibleVariantExpr = convertibleExprArray.length == 2 ? convertibleExprArray[1].makeVariantExpr() : null;
        return new ConvertibleVariantExpr(){

            @Override
            public Variant eval(XNode xNode, ExprContext exprContext) throws EvalException {
                String string = convertibleStringExpr.eval(xNode, exprContext);
                Variant variant = null;
                if (convertibleVariantExpr != null) {
                    variant = convertibleVariantExpr.eval(xNode, exprContext);
                }
                Variant variant2 = null;
                Name name = Name.parse(string, true, prefixToNamespace);
                if (name == null) {
                    name = Name.fromString(string);
                }
                if (name != null) {
                    variant2 = exprContext.getVariableValue(name, xNode);
                }
                if (variant2 == null) {
                    if (variant != null) {
                        return variant;
                    }
                    return new BooleanVariant(false);
                }
                if (variant != null) {
                    return variant2;
                }
                return new BooleanVariant(true);
            }
        };
    }
}

