/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xed;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.LoadText;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.load.DocumentLoader;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.resolve.XMLCatalogs;
import com.xmlmind.xml.xed.Action;
import com.xmlmind.xml.xed.CommandAction;
import com.xmlmind.xml.xed.ForEachAction;
import com.xmlmind.xml.xed.IfAction;
import com.xmlmind.xml.xed.MacroCmd;
import com.xmlmind.xml.xed.Msg;
import com.xmlmind.xml.xed.Scanner;
import com.xmlmind.xml.xed.Script;
import com.xmlmind.xml.xed.ScriptLoadException;
import com.xmlmind.xml.xed.XMLTemplate;
import com.xmlmind.xml.xed.XPathExpr;
import com.xmlmind.xml.xpath.ParseException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Stack;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public final class ScriptLoader {
    private Script script;
    private Stack<Source> sources = new Stack();
    private Scanner scanner;
    private URL url;
    private int importPrecedence;
    private int token;
    private int[] token1;
    private ArrayList<String> paramNameList = new ArrayList();
    private ArrayList<Object> argumentList = new ArrayList();
    private DocumentLoader docLoader;
    public static final LoadText.KeywordBasedDetector XED_ENCODING_DETECTOR = new LoadText.KeywordBasedDetector("encoding");

    public ScriptLoader() {
        this.token1 = new int[1];
    }

    public Script load(File file) throws IOException, ScriptLoadException {
        return this.load(FileUtil.fileToURL(file));
    }

    public Script load(URL uRL) throws IOException, ScriptLoadException {
        return this.load(ScriptLoader.loadSource(uRL, null), uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadSource(URL uRL, String string) throws IOException {
        String string2 = null;
        try (InputStream inputStream = URLUtil.openStreamNoCache(uRL);){
            string2 = ScriptLoader.loadSource(inputStream, string);
        }
        return string2;
    }

    public Script load(InputStream inputStream, String string, URL uRL) throws IOException, ScriptLoadException {
        return this.load(ScriptLoader.loadSource(inputStream, string), uRL);
    }

    private static String loadSource(InputStream inputStream, String string) throws IOException {
        if (string != null) {
            return FileUtil.loadString(inputStream, string);
        }
        return LoadText.loadText(inputStream, null, null, XED_ENCODING_DETECTOR);
    }

    public Script load(String string, URL uRL) throws ScriptLoadException {
        return this.load(string, 0, string.length(), uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Script load(String string, int n, int n2, URL uRL) throws ScriptLoadException {
        this.script = new Script();
        if (uRL != null) {
            this.script.setURL(uRL);
        }
        try {
            this.pushSource(string, n, n2, uRL);
            this.nextToken();
            this.script();
        }
        finally {
            while (this.scanner != null) {
                this.popSource();
            }
        }
        this.script.resolveCommands();
        return this.script;
    }

    private void nextToken() {
        this.token = this.scanner.getNextToken();
    }

    private void pushSource(String string, URL uRL) {
        this.pushSource(string, 0, string.length(), uRL);
    }

    private void pushSource(String string, int n, int n2, URL uRL) {
        Source source;
        if (!this.sources.empty()) {
            source = this.sources.peek();
            source.token = this.token;
        }
        source = new Source(new Scanner(string, n, n2), uRL);
        this.sources.push(source);
        this.scanner = source.scanner;
        this.url = source.url;
        this.token = 0;
    }

    private void popSource() {
        if (!this.sources.empty()) {
            this.sources.pop();
            if (this.sources.empty()) {
                this.scanner = null;
                this.url = null;
                this.token = 0;
            } else {
                Source source = this.sources.peek();
                this.scanner = source.scanner;
                this.url = source.url;
                this.token = source.token;
            }
        }
    }

    private void script() throws ScriptLoadException {
        if (this.token == -4) {
            this.skipStatement();
        }
        this.skipSpace();
        while (true) {
            switch (this.token) {
                case -1: {
                    return;
                }
                case -6: {
                    this.namespace();
                    break;
                }
                case -5: {
                    this.include();
                    break;
                }
                case -7: {
                    this.script.addMacro(this.macroCmd());
                    break;
                }
                case -8: {
                    this.script.addAction(this.forEachAction());
                    break;
                }
                case -9: {
                    this.script.addAction(this.ifAction());
                    break;
                }
                case -13: {
                    this.script.addAction(this.commandAction());
                    break;
                }
                case 59: {
                    this.nextToken();
                    break;
                }
                default: {
                    this.unexpectedToken(this.token);
                }
            }
            this.skipSpace();
        }
    }

    private void include() throws ScriptLoadException {
        this.nextToken();
        this.skipSpace();
        this.matchToken(-12);
        String string = ScriptLoader.unquoteString(this.scanner.getLexeme());
        this.nextToken();
        this.skipSpace();
        this.matchToken(59);
        this.nextToken();
        this.skipSpace();
        URL uRL = null;
        try {
            uRL = XMLCatalogs.resolveURI(string, this.url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL == null) {
            this.loadError(Msg.msg("notAnURL", string));
        }
        String string2 = null;
        try {
            string2 = ScriptLoader.loadSource(uRL, null);
        }
        catch (IOException iOException) {
            this.loadError(Msg.msg("cannotLoad", uRL, ThrowableUtil.reason(iOException)));
        }
        this.pushSource(string2, uRL);
        this.nextToken();
        this.script();
        this.popSource();
    }

    private void namespace() throws ScriptLoadException {
        this.nextToken();
        this.skipSpace();
        String string = null;
        if (this.token == -13) {
            string = this.scanner.getLexeme();
            this.nextToken();
            this.skipSpace();
            this.matchToken(61);
            this.nextToken();
            this.skipSpace();
        }
        this.matchToken(-12);
        String string2 = ScriptLoader.unquoteString(this.scanner.getLexeme());
        this.nextToken();
        this.skipSpace();
        this.matchToken(59);
        this.nextToken();
        this.skipSpace();
        this.script.declareNamespace(string, string2);
    }

    private MacroCmd macroCmd() throws ScriptLoadException {
        this.nextToken();
        this.skipSpace();
        this.matchToken(-13);
        String string = this.scanner.getLexeme();
        this.nextToken();
        this.skipSpace();
        this.matchToken(40);
        this.nextToken();
        this.skipSpace();
        this.paramNameList.clear();
        boolean bl = true;
        block5: while (true) {
            switch (this.token) {
                case -13: {
                    if (!bl) {
                        this.unexpectedToken(this.token);
                    }
                    this.paramNameList.add(this.scanner.getLexeme());
                    bl = false;
                    this.nextToken();
                    break;
                }
                case 44: {
                    if (bl) {
                        this.unexpectedToken(this.token);
                    }
                    bl = true;
                    this.nextToken();
                    break;
                }
                case 41: {
                    this.nextToken();
                    this.skipSpace();
                    break block5;
                }
                default: {
                    this.unexpectedToken(this.token);
                }
            }
            this.skipSpace();
        }
        Action[] actionArray = this.actionBlock();
        return new MacroCmd(string, this.paramNameList.toArray(StringUtil.EMPTY_LIST), actionArray);
    }

    private ForEachAction forEachAction() throws ScriptLoadException {
        int n = this.scanner.getLineNumber();
        int n2 = this.scanner.getColumnNumber();
        XPathExpr xPathExpr = this.scanXPathExpr();
        this.token = this.token1[0];
        Action[] actionArray = this.actionBlock();
        ForEachAction forEachAction = new ForEachAction(xPathExpr, actionArray);
        forEachAction.initLocation(this.url, n, n2);
        return forEachAction;
    }

    private Action[] actionBlock() throws ScriptLoadException {
        this.matchToken(123);
        this.nextToken();
        this.skipSpace();
        ArrayList<Action> arrayList = new ArrayList<Action>();
        block7: while (true) {
            switch (this.token) {
                case 59: {
                    this.nextToken();
                    break;
                }
                case 125: {
                    this.nextToken();
                    this.skipSpace();
                    break block7;
                }
                case -8: {
                    arrayList.add(this.forEachAction());
                    break;
                }
                case -9: {
                    arrayList.add(this.ifAction());
                    break;
                }
                case -13: {
                    arrayList.add(this.commandAction());
                    break;
                }
                default: {
                    this.unexpectedToken(this.token);
                }
            }
            this.skipSpace();
        }
        Action[] actionArray = new Action[arrayList.size()];
        arrayList.toArray(actionArray);
        return actionArray;
    }

    private IfAction ifAction() throws ScriptLoadException {
        int n = this.scanner.getLineNumber();
        int n2 = this.scanner.getColumnNumber();
        ArrayList<IfAction.TestCase> arrayList = new ArrayList<IfAction.TestCase>();
        XPathExpr xPathExpr = this.scanXPathExpr();
        this.token = this.token1[0];
        Action[] actionArray = this.actionBlock();
        arrayList.add(new IfAction.TestCase(xPathExpr, actionArray));
        while (this.token == -10) {
            xPathExpr = this.scanXPathExpr();
            this.token = this.token1[0];
            actionArray = this.actionBlock();
            arrayList.add(new IfAction.TestCase(xPathExpr, actionArray));
        }
        if (this.token == -11) {
            this.nextToken();
            this.skipSpace();
            actionArray = this.actionBlock();
            arrayList.add(new IfAction.TestCase(null, actionArray));
        }
        IfAction.TestCase[] testCaseArray = new IfAction.TestCase[arrayList.size()];
        arrayList.toArray(testCaseArray);
        IfAction ifAction = new IfAction(testCaseArray);
        ifAction.initLocation(this.url, n, n2);
        return ifAction;
    }

    private CommandAction commandAction() throws ScriptLoadException {
        Object[] objectArray;
        int n = this.scanner.getLineNumber();
        int n2 = this.scanner.getColumnNumber();
        String string = this.scanner.getLexeme();
        this.nextToken();
        this.skipSpace();
        this.matchToken(40);
        boolean bl = true;
        this.argumentList.clear();
        block5: while (true) {
            switch (this.token) {
                case 40: {
                    if (bl) {
                        bl = false;
                    } else {
                        this.unexpectedToken(this.token);
                    }
                }
                case 44: {
                    objectArray = this.argument();
                    if (objectArray == null) continue block5;
                    this.argumentList.add(objectArray);
                    continue block5;
                }
                case 41: {
                    this.nextToken();
                    this.skipSpace();
                    break block5;
                }
                default: {
                    this.unexpectedToken(this.token);
                    continue block5;
                }
            }
            break;
        }
        objectArray = new Object[this.argumentList.size()];
        this.argumentList.toArray(objectArray);
        CommandAction commandAction = new CommandAction(string, objectArray);
        commandAction.initLocation(this.url, n, n2);
        return commandAction;
    }

    private Object argument() throws ScriptLoadException {
        Object object = this.scanXPathExpr();
        if (object != null) {
            this.token = this.token1[0];
        } else {
            this.nextToken();
            this.skipSpace();
            if (this.token != 41) {
                this.matchToken(-14);
                object = this.parseXMLTemplate(this.scanner.getLexeme());
                this.nextToken();
                this.skipSpace();
            }
        }
        return object;
    }

    private XPathExpr scanXPathExpr() throws ScriptLoadException {
        XPathExpr xPathExpr = null;
        try {
            xPathExpr = this.scanner.scanXPathExpr(this.script, this.token1);
        }
        catch (ParseException parseException) {
            this.loadError(Msg.msg("badXPathExpr", ThrowableUtil.reason(parseException)));
        }
        return xPathExpr;
    }

    private XMLTemplate parseXMLTemplate(String string) throws ScriptLoadException {
        XMLTemplate xMLTemplate = null;
        String string2 = null;
        try {
            Element element = this.parseElement(string);
            xMLTemplate = new XMLTemplate(element, string, this.script);
        }
        catch (SAXParseException sAXParseException) {
            string2 = sAXParseException.getMessage();
        }
        catch (Exception exception) {
            string2 = ThrowableUtil.reason(exception);
        }
        if (string2 != null) {
            this.loadError(Msg.msg("cannotParseXMLTemplate", string, string2));
        }
        return xMLTemplate;
    }

    private Element parseElement(String string) throws Exception {
        Comparable<PrefixEntry> comparable2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<root");
        for (Comparable<PrefixEntry> comparable2 : this.script.getNamespacePrefixes()) {
            stringBuilder.append(" xmlns");
            if (comparable2.prefix.length() > 0) {
                stringBuilder.append(':');
                stringBuilder.append(comparable2.prefix);
            }
            stringBuilder.append('=');
            XMLText.quoteXML(comparable2.namespace.uri, stringBuilder);
        }
        stringBuilder.append('>');
        stringBuilder.append(string);
        stringBuilder.append("</root>");
        InputSource inputSource = new InputSource(new StringReader(stringBuilder.toString()));
        inputSource.setSystemId(this.url.toExternalForm());
        if (this.docLoader == null) {
            this.docLoader = new DocumentLoader();
        }
        Document document = this.docLoader.load(inputSource);
        Element element = document.getRootElement();
        comparable2 = element.getFirstChildElement();
        element.removeChild((Node)comparable2);
        return comparable2;
    }

    private void matchToken(int n) throws ScriptLoadException {
        if (this.token != n) {
            this.loadError(Msg.msg("unexpectedToken2", Scanner.tokenName(n), Scanner.tokenName(this.token)));
        }
    }

    private void unexpectedToken(int n) throws ScriptLoadException {
        this.loadError(Msg.msg("unexpectedToken", Scanner.tokenName(n)));
    }

    private void loadError(String string) throws ScriptLoadException {
        throw new ScriptLoadException(this.url, this.scanner.getLineNumber(), this.scanner.getColumnNumber(), string);
    }

    private void skipStatement() {
        boolean bl = false;
        while (true) {
            switch (this.token) {
                case -1: {
                    return;
                }
                case 59: {
                    this.nextToken();
                    this.skipSpace();
                    return;
                }
            }
            this.nextToken();
        }
    }

    private void skipSpace() {
        block3: while (true) {
            switch (this.token) {
                case -3: 
                case -2: {
                    this.nextToken();
                    continue block3;
                }
            }
            break;
        }
    }

    private static String unquoteString(String string) {
        return XMLText.unescapeXML(string.substring(1, string.length() - 1));
    }

    private static final class Source {
        public Scanner scanner;
        public URL url;
        public int token;

        public Source(Scanner scanner, URL uRL) {
            this.scanner = scanner;
            this.url = uRL;
            this.token = 0;
        }
    }
}

