/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xed;

import com.xmlmind.util.Console;
import com.xmlmind.util.StringList;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.NamespacePrefixMap;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.xed.Action;
import com.xmlmind.xml.xed.ActionException;
import com.xmlmind.xml.xed.MacroCmd;
import com.xmlmind.xml.xed.ScriptExprContext;
import com.xmlmind.xml.xed.ScriptLoadException;
import com.xmlmind.xml.xpath.ExprContext;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;

public final class Script
implements NamespacePrefixMap {
    private URL url;
    private final HashMap<String, Namespace> prefixToNS = new HashMap();
    private IdentityHashMap<Namespace, String[]> nsToPrefixes;
    private final HashMap<String, MacroCmd> macroMap = new HashMap();
    private final ArrayList<Action> actionList = new ArrayList();
    private Action[] actions;

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    public URL getURL() {
        return this.url;
    }

    public void declareNamespace(String string, String string2) {
        this.declareNamespace(string, Namespace.get(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareNamespace(String string, Namespace namespace) {
        HashMap<String, Namespace> hashMap = this.prefixToNS;
        synchronized (hashMap) {
            if (string == null) {
                string = "";
            }
            if (!string.regionMatches(true, 0, "xml", 0, 3)) {
                this.prefixToNS.put(string, namespace);
                this.nsToPrefixes = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrefixEntry[] getNamespacePrefixes() {
        HashMap<String, Namespace> hashMap = this.prefixToNS;
        synchronized (hashMap) {
            PrefixEntry[] prefixEntryArray = new PrefixEntry[this.prefixToNS.size()];
            int n = 0;
            for (String string : this.prefixToNS.keySet()) {
                Namespace namespace = this.prefixToNS.get(string);
                prefixEntryArray[n++] = new PrefixEntry(string, namespace);
            }
            return prefixEntryArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMacro(MacroCmd macroCmd) {
        HashMap<String, MacroCmd> hashMap = this.macroMap;
        synchronized (hashMap) {
            this.macroMap.put(macroCmd.name, macroCmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MacroCmd getMacro(String string) {
        HashMap<String, MacroCmd> hashMap = this.macroMap;
        synchronized (hashMap) {
            return this.macroMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MacroCmd[] getMacros() {
        HashMap<String, MacroCmd> hashMap = this.macroMap;
        synchronized (hashMap) {
            MacroCmd[] macroCmdArray = new MacroCmd[this.macroMap.size()];
            this.macroMap.values().toArray(macroCmdArray);
            return macroCmdArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAction(Action action) {
        ArrayList<Action> arrayList = this.actionList;
        synchronized (arrayList) {
            this.actionList.add(action);
            this.actions = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action[] getActions() {
        ArrayList<Action> arrayList = this.actionList;
        synchronized (arrayList) {
            if (this.actions == null) {
                this.actions = new Action[this.actionList.size()];
                this.actionList.toArray(this.actions);
            }
            return this.actions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveCommands() throws ScriptLoadException {
        Cloneable cloneable = this.macroMap;
        synchronized (cloneable) {
            for (MacroCmd macroCmd : this.macroMap.values()) {
                macroCmd.resolveCommands(this);
            }
        }
        cloneable = this.actionList;
        synchronized (cloneable) {
            for (Action action : this.getActions()) {
                action.resolveCommands(this);
            }
        }
    }

    public void run(Document document, Console console) throws ActionException {
        ScriptExprContext scriptExprContext = new ScriptExprContext(document);
        this.run(document, scriptExprContext, console);
    }

    public void run(ScriptExprContext scriptExprContext, Console console) throws ActionException {
        this.run(scriptExprContext.editedDocument, scriptExprContext, console);
    }

    public void run(XNode xNode, ExprContext exprContext, Console console) throws ActionException {
        for (Action action : this.getActions()) {
            try {
                action.performAction(xNode, exprContext, this, console);
            }
            catch (ActionException actionException) {
                throw actionException;
            }
            catch (Exception exception) {
                throw new ActionException(action.name, action.scriptURL, action.lineNumber, action.columnNumber, Action.errorReason(exception));
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        Object[] objectArray = this.getNamespacePrefixes();
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        for (Object object : objectArray) {
            stringBuilder.append("namespace ");
            if (((PrefixEntry)object).prefix.length() > 0) {
                stringBuilder.append(((PrefixEntry)object).prefix);
                stringBuilder.append(" = ");
            }
            stringBuilder.append('\"');
            stringBuilder.append(((PrefixEntry)object).namespace.uri);
            stringBuilder.append("\";\n");
        }
        Object[] objectArray2 = this.getMacros();
        if (objectArray2.length > 1) {
            Arrays.sort(objectArray2);
        }
        for (Object object : objectArray2) {
            stringBuilder.append('\n');
            ((MacroCmd)object).toString(stringBuilder);
            stringBuilder.append('\n');
        }
        for (Action action : this.getActions()) {
            stringBuilder.append('\n');
            action.toString(0, stringBuilder);
            stringBuilder.append('\n');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Namespace prefixToNamespace(String string) {
        HashMap<String, Namespace> hashMap = this.prefixToNS;
        synchronized (hashMap) {
            Namespace namespace = this.prefixToNS.get(string);
            if (namespace == null && "xml".equals(string)) {
                namespace = Namespace.XML;
            }
            return namespace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] namespaceToPrefixes(Namespace namespace) {
        HashMap<String, Namespace> hashMap = this.prefixToNS;
        synchronized (hashMap) {
            String[] stringArray;
            if (this.nsToPrefixes == null) {
                this.nsToPrefixes = Script.createInverseMap(this.prefixToNS);
            }
            if ((stringArray = this.nsToPrefixes.get(namespace)) == null && namespace == Namespace.XML) {
                stringArray = XML_PREFIXES;
            }
            return stringArray;
        }
    }

    private static final IdentityHashMap<Namespace, String[]> createInverseMap(HashMap<String, Namespace> hashMap) {
        IdentityHashMap<Namespace, String[]> identityHashMap = new IdentityHashMap<Namespace, String[]>();
        for (String string : hashMap.keySet()) {
            Namespace namespace = hashMap.get(string);
            String[] stringArray = identityHashMap.get(namespace);
            stringArray = stringArray == null ? new String[]{string} : StringList.append(stringArray, string);
            identityHashMap.put(namespace, stringArray);
        }
        return identityHashMap;
    }
}

