/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.validate;

import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.validate.Diagnostic;

public final class ValidationError
implements Diagnostic {
    public final Element element;
    public final String constraint;
    public final String message;
    String detailId;
    Object[] detailValues;

    public ValidationError(Element element, String string, String string2) {
        this.element = element;
        this.constraint = string;
        this.message = string2;
    }

    @Override
    public Element getDiagnosedElement() {
        return this.element;
    }

    @Override
    public String getDiagnosticMessage() {
        if (this.constraint != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.message);
            stringBuilder.append(" [");
            stringBuilder.append(this.constraint);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
        return this.message;
    }

    @Override
    public Diagnostic.Severity getDiagnosticSeverity() {
        if (this.constraint == null) {
            return Diagnostic.Severity.INVALID_STRUCTURE;
        }
        if (this.constraint.startsWith("cvc-id") || this.constraint.startsWith("cvc-identity-constraint")) {
            return Diagnostic.Severity.INVALID_REFERENCE;
        }
        if (this.constraint.equals("cvc-type.3.1.3") || this.constraint.equals("cvc-elt.5.2.2.2") || this.constraint.equals("cvc-complex-type.2.2") || this.constraint.startsWith("cvc-attribute")) {
            return Diagnostic.Severity.INVALID_DATA;
        }
        return Diagnostic.Severity.INVALID_STRUCTURE;
    }

    @Override
    public String getDiagnosticDetailId() {
        return this.detailId;
    }

    @Override
    public Object[] getDiagnosticDetailValues() {
        return this.detailValues;
    }
}

