/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.validate;

import java.io.Serializable;

public abstract class Particle
implements Serializable,
Cloneable {
    public static final int UNBOUNDED = -1;
    protected int minOccurs;
    protected int maxOccurs;

    protected Particle(int n, int n2) {
        this.setOccurs(n, n2);
    }

    public final void setOccurs(int n, int n2) {
        this.minOccurs = n;
        this.maxOccurs = n2;
    }

    public abstract Type getType();

    public final int getMinOccurs() {
        return this.minOccurs;
    }

    public final int getMaxOccurs() {
        return this.maxOccurs;
    }

    public final boolean isEmptiable() {
        return this.minOccurs == 0 || this.rangeMin() == 0;
    }

    public abstract int rangeMin();

    public abstract int rangeMax();

    public Particle simplify() {
        if (this.minOccurs == 0 && this.maxOccurs == 0) {
            return null;
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        if (this.maxOccurs == 1) {
            if (this.minOccurs == 0) {
                stringBuilder.append('?');
            }
        } else if (this.maxOccurs == -1) {
            if (this.minOccurs == 0) {
                stringBuilder.append('*');
            } else if (this.minOccurs == 1) {
                stringBuilder.append('+');
            } else {
                stringBuilder.append('{');
                stringBuilder.append(this.minOccurs);
                stringBuilder.append(",}");
            }
        } else {
            stringBuilder.append('{');
            stringBuilder.append(this.minOccurs);
            if (this.maxOccurs != this.minOccurs) {
                stringBuilder.append(',');
                stringBuilder.append(this.maxOccurs);
            }
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    protected abstract void toString(StringBuilder var1);

    public abstract Particle copy();

    public static enum Type {
        SEQUENCE,
        CHOICE,
        ALL,
        ELEMENT,
        WILDCARD;


        public String toString() {
            switch (this) {
                case SEQUENCE: {
                    return "sequence";
                }
                case CHOICE: {
                    return "choice";
                }
                case ALL: {
                    return "all";
                }
                case ELEMENT: {
                    return "element";
                }
                case WILDCARD: {
                    return "any";
                }
            }
            return "???";
        }
    }
}

