/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.validate;

import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.sxpath.XPath;
import com.xmlmind.xml.wxs.datatype.DataType;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.StringValue;
import com.xmlmind.xml.wxs.datatype.Value;
import com.xmlmind.xml.wxs.validate.AttributeDeclaration;
import com.xmlmind.xml.wxs.validate.ElementDeclaration;
import com.xmlmind.xml.wxs.validate.ElementHandler;
import com.xmlmind.xml.wxs.validate.IdentityConstraint;
import com.xmlmind.xml.wxs.validate.KeySequence;
import com.xmlmind.xml.wxs.validate.Msg;
import com.xmlmind.xml.wxs.validate.Schema;
import com.xmlmind.xml.wxs.validate.Type;
import com.xmlmind.xml.wxs.validate.ValidationErrors;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;

final class IdentityConstraintChecker
extends ElementHandler {
    private Element validationRoot;
    private ValidationErrors errors;
    private HashMap<KeySequence, KeySequence> uniques;
    private IdentityHashMap<Name, HashMap<KeySequence, KeySequence>> definedKeysByName;
    private ArrayList<KeyrefRecord> keyrefRecords;
    private boolean checked;

    public IdentityConstraintChecker(Schema schema) {
        super(schema);
    }

    public boolean check(Element element, Element element2, ValidationErrors validationErrors) {
        this.validationRoot = element2;
        this.errors = validationErrors;
        this.uniques = new HashMap();
        this.definedKeysByName = new IdentityHashMap();
        this.keyrefRecords = new ArrayList();
        this.checked = true;
        this.traverse(element, element2);
        int n = this.keyrefRecords.size();
        for (int i = 0; i < n; ++i) {
            KeyrefRecord keyrefRecord = this.keyrefRecords.get(i);
            KeySequence[] keySequenceArray = keyrefRecord.keySequences;
            HashMap<KeySequence, KeySequence> hashMap = this.definedKeysByName.get(keyrefRecord.referencedKey);
            for (int j = 0; j < keySequenceArray.length; ++j) {
                KeySequence keySequence = keySequenceArray[j];
                if (hashMap != null && hashMap.containsKey(keySequence)) continue;
                validationErrors.append(keySequence.selected, "cvc-identity-constraint.4.3", Msg.msg("badKeyref", keySequence.toString()));
                this.checked = false;
            }
        }
        this.validationRoot = null;
        this.errors = null;
        this.uniques = null;
        this.definedKeysByName = null;
        this.keyrefRecords = null;
        return this.checked;
    }

    @Override
    protected Object handleElement(Element element, ElementDeclaration elementDeclaration, Type type) {
        IdentityConstraint[] identityConstraintArray;
        if (elementDeclaration == null || (identityConstraintArray = elementDeclaration.getIdentityConstraints()) == null || identityConstraintArray.length == 0) {
            return null;
        }
        block5: for (int i = 0; i < identityConstraintArray.length; ++i) {
            IdentityConstraint identityConstraint = identityConstraintArray[i];
            KeySequence[] keySequenceArray = this.apply(identityConstraint, element);
            switch (identityConstraint.type) {
                case UNIQUE: {
                    this.checkUnique(identityConstraint.name, keySequenceArray);
                    continue block5;
                }
                case KEY: {
                    this.checkKey(identityConstraint.name, keySequenceArray);
                    continue block5;
                }
                case KEYREF: {
                    this.recordKeyref(identityConstraint.referencedKey, keySequenceArray);
                    continue block5;
                }
                default: {
                    throw new RuntimeException("unknown IdentityConstraint type " + String.valueOf((Object)identityConstraint.type));
                }
            }
        }
        return null;
    }

    private KeySequence[] apply(IdentityConstraint identityConstraint, Element element) {
        XNode[] xNodeArray = identityConstraint.selector.select(element);
        KeySequence[] keySequenceArray = new KeySequence[xNodeArray.length];
        XPath[] xPathArray = identityConstraint.fields;
        boolean[] blArray = new boolean[1];
        for (int i = 0; i < xNodeArray.length; ++i) {
            Element element2 = (Element)xNodeArray[i];
            Value[] valueArray = new Value[xPathArray.length];
            for (int j = 0; j < xPathArray.length; ++j) {
                XNode[] xNodeArray2 = xPathArray[j].select(element2, true);
                valueArray[j] = null;
                if (xNodeArray2.length == 0) continue;
                boolean bl = false;
                boolean bl2 = false;
                for (int k = 0; k < xNodeArray2.length; ++k) {
                    Object object;
                    Serializable serializable;
                    XNode xNode;
                    DataType dataType = null;
                    Value value = null;
                    if (xNodeArray2[k] instanceof Attribute) {
                        xNode = (Attribute)xNodeArray2[k];
                        serializable = this.schema.findAttributeDeclaration(((Attribute)xNode).element, this.validationRoot, ((Attribute)xNode).name);
                        if (serializable == null) {
                            dataType = null;
                            value = null;
                            bl = true;
                            if (((Attribute)xNode).value == null) {
                                bl = false;
                            } else if (IdentityConstraintChecker.isWildcardDescendant(this.schema, this.validationRoot, ((Attribute)xNode).element, blArray)) {
                                value = new StringValue(((Attribute)xNode).value);
                                bl = false;
                            }
                        } else {
                            dataType = ((AttributeDeclaration)serializable).dataType;
                            if (((Attribute)xNode).value == null) {
                                object = ((AttributeDeclaration)serializable).defaultValue;
                            } else {
                                try {
                                    object = dataType.valueOf(((Attribute)xNode).value, ((Attribute)xNode).element);
                                }
                                catch (InvalidDataException invalidDataException) {
                                    object = null;
                                    bl = true;
                                }
                            }
                            value = object;
                        }
                    } else {
                        xNode = (Element)xNodeArray2[k];
                        serializable = this.schema.findElementDeclaration((Element)xNode, this.validationRoot);
                        if (serializable == null) {
                            dataType = null;
                            value = null;
                            bl = true;
                            if (IdentityConstraintChecker.isWildcardDescendant(this.schema, this.validationRoot, (Element)xNode, blArray) && (object = ((Element)xNode).getText()) != null) {
                                value = new StringValue((String)object);
                                bl = false;
                            }
                        } else {
                            dataType = serializable.type.getDataType();
                            String string = ((Element)xNode).getText();
                            if (string == null) {
                                object = null;
                                bl = true;
                            } else if (dataType == null) {
                                object = null;
                                bl = true;
                            } else if (string.trim().length() == 0) {
                                object = (Value)serializable.defaultValue;
                            } else {
                                try {
                                    object = dataType.valueOf(string, (PrefixToNamespace)((Object)xNode));
                                }
                                catch (InvalidDataException invalidDataException) {
                                    object = null;
                                    bl = true;
                                }
                            }
                            value = object;
                        }
                    }
                    if (value == null) continue;
                    if (valueArray[j] == null) {
                        valueArray[j] = value;
                        continue;
                    }
                    bl2 = true;
                    break;
                }
                if (bl) {
                    this.errors.append(element2, "cvc-identity-constraint.3", Msg.msg("badField1", xPathArray[j].toString(element2), identityConstraint.name.format(false, element2)));
                    this.checked = false;
                    continue;
                }
                if (!bl2) continue;
                this.errors.append(element2, "cvc-identity-constraint.3", Msg.msg("badField2", xPathArray[j].toString(element2), identityConstraint.name.format(false, element2)));
                this.checked = false;
            }
            keySequenceArray[i] = new KeySequence(element2, valueArray);
        }
        return keySequenceArray;
    }

    private static boolean isWildcardDescendant(Schema schema, Element element, Element element2, boolean[] blArray) {
        return schema.findElementType(element2, element, blArray) == null && blArray[0];
    }

    private void checkUnique(Name name, KeySequence[] keySequenceArray) {
        this.uniques.clear();
        for (int i = 0; i < keySequenceArray.length; ++i) {
            HashMap<KeySequence, KeySequence> hashMap;
            KeySequence keySequence = keySequenceArray[i];
            if (!keySequence.isComplete()) continue;
            if (this.uniques.put(keySequence, keySequence) != null) {
                this.errors.append(keySequence.selected, "cvc-identity-constraint.4.1", Msg.msg("notUnique", keySequence.toString()));
                this.checked = false;
            }
            if ((hashMap = this.definedKeysByName.get(name)) == null) {
                hashMap = new HashMap();
                this.definedKeysByName.put(name, hashMap);
            }
            hashMap.put(keySequence, keySequence);
        }
    }

    private void checkKey(Name name, KeySequence[] keySequenceArray) {
        this.uniques.clear();
        for (int i = 0; i < keySequenceArray.length; ++i) {
            HashMap<KeySequence, KeySequence> hashMap;
            KeySequence keySequence = keySequenceArray[i];
            if (!keySequence.isComplete()) {
                this.errors.append(keySequence.selected, "cvc-identity-constraint.4.2.1", Msg.msg("badKey", name.format(false, keySequence.selected)));
                this.checked = false;
                continue;
            }
            if (this.uniques.put(keySequence, keySequence) != null) {
                this.errors.append(keySequence.selected, "cvc-identity-constraint.4.2.2", Msg.msg("notAKey", keySequence.toString()));
                this.checked = false;
            }
            if ((hashMap = this.definedKeysByName.get(name)) == null) {
                hashMap = new HashMap();
                this.definedKeysByName.put(name, hashMap);
            }
            hashMap.put(keySequence, keySequence);
        }
    }

    private void recordKeyref(Name name, KeySequence[] keySequenceArray) {
        KeySequence[] keySequenceArray2 = new KeySequence[keySequenceArray.length];
        int n = 0;
        for (int i = 0; i < keySequenceArray.length; ++i) {
            KeySequence keySequence = keySequenceArray[i];
            if (!keySequence.isComplete()) continue;
            keySequenceArray2[n++] = keySequence;
        }
        if (n == 0) {
            return;
        }
        if (n != keySequenceArray2.length) {
            KeySequence[] keySequenceArray3 = new KeySequence[n];
            System.arraycopy(keySequenceArray2, 0, keySequenceArray3, 0, n);
            keySequenceArray2 = keySequenceArray3;
        }
        this.keyrefRecords.add(new KeyrefRecord(name, keySequenceArray2));
    }

    private static final class KeyrefRecord {
        public final Name referencedKey;
        public final KeySequence[] keySequences;

        public KeyrefRecord(Name name, KeySequence[] keySequenceArray) {
            this.referencedKey = name;
            this.keySequences = keySequenceArray;
        }
    }
}

