/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.validate;

import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.validate.IdEntry;
import com.xmlmind.xml.validate.IdRefItem;
import com.xmlmind.xml.wxs.datatype.DataType;
import com.xmlmind.xml.wxs.datatype.IDREFSType;
import com.xmlmind.xml.wxs.datatype.IDREFType;
import com.xmlmind.xml.wxs.datatype.IDType;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.ListValue;
import com.xmlmind.xml.wxs.validate.AttributeDeclaration;
import com.xmlmind.xml.wxs.validate.ComplexType;
import com.xmlmind.xml.wxs.validate.ElementDeclaration;
import com.xmlmind.xml.wxs.validate.ElementHandler;
import com.xmlmind.xml.wxs.validate.Schema;
import com.xmlmind.xml.wxs.validate.SimpleType;
import com.xmlmind.xml.wxs.validate.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class IdCollector
extends ElementHandler {
    private Map<String, IdEntry> ids;
    private List<IdRefItem> idRefs;

    public IdCollector(Schema schema) {
        super(schema);
    }

    public void collect(Element element, Element element2, Map<String, IdEntry> map, List<IdRefItem> list) {
        this.ids = map;
        this.idRefs = list;
        this.traverse(element, element2);
    }

    @Override
    protected Object handleElement(Element element, ElementDeclaration elementDeclaration, Type type) {
        if (elementDeclaration == null || type instanceof SimpleType || element.getAttributeCount() == 0) {
            return null;
        }
        ComplexType complexType = (ComplexType)type;
        Iterator<Attribute> iterator = element.getAttributes();
        while (iterator.hasNext()) {
            int n;
            Object object;
            String[] stringArray;
            Attribute attribute = iterator.next();
            Name name = attribute.name;
            AttributeDeclaration attributeDeclaration = null;
            if (complexType.containsAttributeField(name) && (attributeDeclaration = complexType.getAttributeDeclaration(name)) == null) {
                attributeDeclaration = this.schema.getAttributeDeclaration(name);
            }
            if (attributeDeclaration == null) continue;
            DataType dataType = attributeDeclaration.dataType;
            if (this.ids != null && this.isIDType(dataType)) {
                try {
                    stringArray = dataType.valueOf(attribute.value, element).toString();
                }
                catch (InvalidDataException invalidDataException) {
                    stringArray = null;
                }
                if (stringArray != null) {
                    object = this.ids.get(stringArray);
                    if (object == null) {
                        object = new IdEntry((String)stringArray, element);
                        this.ids.put((String)stringArray, (IdEntry)object);
                    } else {
                        ((IdEntry)object).addElement(element);
                    }
                }
            }
            if (this.idRefs == null) continue;
            if (dataType instanceof IDREFType) {
                try {
                    stringArray = dataType.valueOf(attribute.value, element).toString();
                }
                catch (InvalidDataException invalidDataException) {
                    stringArray = null;
                }
                if (stringArray == null) continue;
                object = null;
                n = this.idRefs.size() - 1;
                if (n >= 0) {
                    object = this.idRefs.get(n);
                    if (((IdRefItem)object).element != element) {
                        object = null;
                    }
                }
                if (object == null) {
                    this.idRefs.add(new IdRefItem(element, (String)stringArray));
                    continue;
                }
                ((IdRefItem)object).addIdRef((String)stringArray);
                continue;
            }
            if (!(dataType instanceof IDREFSType)) continue;
            try {
                stringArray = ((ListValue)dataType.valueOf(attribute.value, element)).toStringArray();
            }
            catch (InvalidDataException invalidDataException) {
                stringArray = null;
            }
            if (stringArray == null) continue;
            object = null;
            n = this.idRefs.size() - 1;
            if (n >= 0) {
                object = this.idRefs.get(n);
                if (((IdRefItem)object).element != element) {
                    object = null;
                }
            }
            if (object == null) {
                this.idRefs.add(new IdRefItem(element, stringArray));
                continue;
            }
            ((IdRefItem)object).addIdRefs(stringArray);
        }
        return null;
    }

    protected boolean isIDType(DataType dataType) {
        return dataType instanceof IDType;
    }
}

