/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.validate;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.validate.DocumentationGeneratorBase;
import com.xmlmind.xml.validate.ElementType;
import com.xmlmind.xml.validate.SchemaKind;
import com.xmlmind.xml.validate.SubDocumentType;
import com.xmlmind.xml.wxs.datatype.DataType;
import com.xmlmind.xml.wxs.datatype.Pattern;
import com.xmlmind.xml.wxs.datatype.Value;
import com.xmlmind.xml.wxs.validate.AllParticle;
import com.xmlmind.xml.wxs.validate.AttributeDeclaration;
import com.xmlmind.xml.wxs.validate.AttributeUse;
import com.xmlmind.xml.wxs.validate.ChoiceParticle;
import com.xmlmind.xml.wxs.validate.ComplexType;
import com.xmlmind.xml.wxs.validate.ElementDeclaration;
import com.xmlmind.xml.wxs.validate.ElementParticle;
import com.xmlmind.xml.wxs.validate.ElementTypeImpl;
import com.xmlmind.xml.wxs.validate.Msg;
import com.xmlmind.xml.wxs.validate.NameWildcard;
import com.xmlmind.xml.wxs.validate.Particle;
import com.xmlmind.xml.wxs.validate.Schema;
import com.xmlmind.xml.wxs.validate.SequenceParticle;
import com.xmlmind.xml.wxs.validate.SimpleType;
import com.xmlmind.xml.wxs.validate.Type;
import com.xmlmind.xml.wxs.validate.Wildcard;
import com.xmlmind.xml.wxs.validate.WildcardParticle;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class DocumentationGenerator
extends DocumentationGeneratorBase {
    private Schema schema;
    private HashMap<Entry, Entry> entries;
    private HashMap<String, ElementDeclaration> pageNameToElementDecl;
    private HashMap<Entry, Entry[]> childToParentEntries;
    private Entry probe = new Entry();
    private HashMap<NameWildcard, Integer> wildcards = new HashMap();
    private static final AttributeUse[] NO_ATTRIBUTE_USES = new AttributeUse[0];
    private static final PrefixEntry[] EXTRA_PREFIX_ENTRIES = new PrefixEntry[]{new PrefixEntry("xsi", Namespace.XSI)};

    @Override
    public void initSubDocumentType(SubDocumentType subDocumentType) {
        Object object;
        this.schema = (Schema)subDocumentType;
        this.entries = new HashMap();
        this.pageNameToElementDecl = new HashMap();
        this.childToParentEntries = new HashMap();
        Iterator<ElementDeclaration> iterator = this.schema.getElementDeclarations();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (this.containsEntry((ElementDeclaration)object)) continue;
            this.add((ElementDeclaration)object);
        }
        object = this.sortEntries();
        Name name = null;
        int n = 1;
        for (int i = 0; i < ((Entry[])object).length; ++i) {
            Entry objectArray = object[i];
            Name name2 = objectArray.getName();
            if (name2 != name) {
                n = 1;
                objectArray.occurrenceOfName = 1;
            } else {
                objectArray.occurrenceOfName = ++n;
            }
            name = name2;
        }
        for (Object[] objectArray : this.childToParentEntries.values()) {
            if (objectArray.length <= 1) continue;
            Arrays.sort(objectArray);
        }
    }

    private boolean containsEntry(ElementDeclaration elementDeclaration) {
        this.probe.decl = elementDeclaration;
        return this.entries.containsKey(this.probe);
    }

    private Entry getEntry(ElementDeclaration elementDeclaration) {
        this.probe.decl = elementDeclaration;
        return this.entries.get(this.probe);
    }

    private void add(ElementDeclaration elementDeclaration) {
        Entry entry = new Entry(elementDeclaration);
        this.entries.put(entry, entry);
        this.pageNameToElementDecl.put(entry.toPageName(), elementDeclaration);
        Type type = elementDeclaration.type;
        if (!(type instanceof ComplexType)) {
            return;
        }
        ComplexType complexType = (ComplexType)type;
        Name[] nameArray = complexType.getElementFields();
        for (int i = 0; i < nameArray.length; ++i) {
            Name name = nameArray[i];
            ElementDeclaration elementDeclaration2 = complexType.getElementDeclaration(name);
            if (elementDeclaration2 == null) {
                elementDeclaration2 = this.schema.getElementDeclaration(name);
            }
            if (elementDeclaration2 == null) continue;
            this.addParent(elementDeclaration2, entry);
            if (this.containsEntry(elementDeclaration2)) continue;
            this.add(elementDeclaration2);
        }
    }

    private void addParent(ElementDeclaration elementDeclaration, Entry entry) {
        Entry[] entryArray = this.getParentEntries(elementDeclaration);
        if (entryArray == null) {
            this.childToParentEntries.put(new Entry(elementDeclaration), new Entry[]{entry});
        } else {
            boolean bl = false;
            for (int i = 0; i < entryArray.length; ++i) {
                if (!entryArray[i].equals(entry)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                Entry[] entryArray2 = new Entry[entryArray.length + 1];
                System.arraycopy(entryArray, 0, entryArray2, 0, entryArray.length);
                entryArray2[entryArray.length] = entry;
                this.childToParentEntries.put(new Entry(elementDeclaration), entryArray2);
            }
        }
    }

    private Entry[] getParentEntries(ElementDeclaration elementDeclaration) {
        this.probe.decl = elementDeclaration;
        return this.childToParentEntries.get(this.probe);
    }

    @Override
    public void generateAll(File file) throws IOException {
        DocumentationGeneratorBase.PageInfo pageInfo = new DocumentationGeneratorBase.PageInfo();
        for (Entry entry : this.entries.values()) {
            this.generateElementPage(entry, pageInfo);
            FileUtil.saveString(pageInfo.html, new File(file, pageInfo.name), this.charset);
        }
        this.generateIndexPage(pageInfo);
        FileUtil.saveString(pageInfo.html, new File(file, pageInfo.name), this.charset);
        this.generateNamespacesPage(pageInfo);
        FileUtil.saveString(pageInfo.html, new File(file, pageInfo.name), this.charset);
    }

    @Override
    public void generateIndexPage(DocumentationGeneratorBase.PageInfo pageInfo) {
        Entry[] entryArray = this.sortEntries();
        StringBuilder stringBuilder = new StringBuilder();
        this.appendPageStart(stringBuilder);
        stringBuilder.append("<title>");
        String string = indexPageTitle;
        XMLText.escapeXML(string, stringBuilder);
        stringBuilder.append("</title>\n");
        this.appendPageMiddle(false, true, stringBuilder);
        stringBuilder.append("<h1>");
        XMLText.escapeXML(string, stringBuilder);
        stringBuilder.append("</h1>\n");
        if (entryArray.length > 0) {
            Namespace namespace = null;
            char c = '\u0000';
            for (int i = 0; i < entryArray.length; ++i) {
                Entry entry = entryArray[i];
                Name name = entry.getName();
                Namespace namespace2 = name.namespace;
                char c2 = name.localPart.charAt(0);
                if (namespace2 != namespace) {
                    stringBuilder.append("<h2>");
                    if (namespace2 == Namespace.NONE) {
                        XMLText.escapeXML(Msg.msg("DG.noNamespaceHead"), stringBuilder);
                    } else {
                        XMLText.escapeXML(Msg.msg("DG.namespaceHead", namespace2), stringBuilder);
                    }
                    stringBuilder.append("</h2>\n");
                }
                if (!Character.isLetter(c2)) {
                    c2 = '_';
                }
                if (c2 != c) {
                    stringBuilder.append("<h3>");
                    if (Character.isLetter(c2)) {
                        XMLText.escapeXML(Character.toString(c2), stringBuilder);
                    } else {
                        stringBuilder.append("&#160;");
                    }
                    stringBuilder.append("</h3>\n");
                }
                this.appendLink(entry, stringBuilder);
                stringBuilder.append("<br>\n");
                namespace = namespace2;
                c = c2;
            }
        }
        this.appendPageEnd(false, true, stringBuilder);
        pageInfo.html = stringBuilder.toString();
        pageInfo.name = "index.html";
        pageInfo.title = string;
    }

    private Entry[] sortEntries() {
        Entry[] entryArray = new Entry[this.entries.size()];
        this.entries.values().toArray(entryArray);
        Arrays.sort(entryArray, new Comparator<Entry>(){

            @Override
            public int compare(Entry entry, Entry entry2) {
                int n = entry.getName().compareTo(entry2.getName());
                if (n == 0) {
                    Entry[] entryArray = DocumentationGenerator.this.childToParentEntries.get(entry);
                    Entry[] entryArray2 = DocumentationGenerator.this.childToParentEntries.get(entry2);
                    int n2 = entryArray == null ? 0 : entryArray.length;
                    int n3 = entryArray2 == null ? 0 : entryArray2.length;
                    return -(n2 - n3);
                }
                return n;
            }
        });
        return entryArray;
    }

    @Override
    public void generateNamespacesPage(DocumentationGeneratorBase.PageInfo pageInfo) {
        if (this.schema.getSchemaKind() == SchemaKind.DTD) {
            this.generateNamespacesPage(null, pageInfo);
        } else {
            this.generateNamespacesPage(EXTRA_PREFIX_ENTRIES, pageInfo);
        }
    }

    public ElementDeclaration getElementDeclaration(String string) {
        return this.pageNameToElementDecl.get(string);
    }

    public boolean generateElementPage(ElementDeclaration elementDeclaration, DocumentationGeneratorBase.PageInfo pageInfo) {
        this.probe.decl = elementDeclaration;
        Entry entry = this.entries.get(this.probe);
        if (entry == null) {
            return false;
        }
        this.generateElementPage(entry, pageInfo);
        return true;
    }

    private void generateElementPage(Entry entry, DocumentationGeneratorBase.PageInfo pageInfo) {
        Object[] objectArray;
        int n;
        Entry[] entryArray;
        StringBuilder stringBuilder = new StringBuilder();
        this.appendPageStart(stringBuilder);
        stringBuilder.append("<title>");
        String string = this.entryName(entry);
        String string2 = Msg.msg("DG.elementPageTitle", string);
        XMLText.escapeXML(string2, stringBuilder);
        stringBuilder.append("</title>\n");
        this.appendPageMiddle(true, true, stringBuilder);
        stringBuilder.append("<h1>");
        XMLText.escapeXML(string2, stringBuilder);
        stringBuilder.append("</h1>\n");
        ElementDeclaration elementDeclaration = entry.getElementDeclaration();
        Value value = (Value)elementDeclaration.defaultValue;
        boolean bl = elementDeclaration.isFixedValue;
        Type type = entry.getType();
        ComplexType complexType = null;
        SimpleType simpleType = null;
        if (type instanceof ComplexType) {
            complexType = (ComplexType)type;
        } else {
            simpleType = (SimpleType)type;
        }
        DataType dataType = type.getDataType();
        stringBuilder.append("<h2>");
        XMLText.escapeXML(Msg.msg("DG.contentModelHead"), stringBuilder);
        stringBuilder.append("</h2>\n");
        if (simpleType != null) {
            this.appendDataContent(dataType, value, bl, stringBuilder);
        } else {
            ComplexType.ContentType contentType = complexType.getContentType();
            switch (contentType) {
                case DATA: {
                    this.appendDataContent(dataType, value, bl, stringBuilder);
                    break;
                }
                case EMPTY: {
                    stringBuilder.append("<p>");
                    XMLText.escapeXML(Msg.msg("DG.emptyContent"), stringBuilder);
                    stringBuilder.append("</p>\n");
                    break;
                }
                case MIXED: {
                    stringBuilder.append("<p>");
                    XMLText.escapeXML(Msg.msg("DG.mixedContentBlurb", string), stringBuilder);
                    stringBuilder.append(".</p>\n");
                }
                default: {
                    this.appendComplexContent(complexType, stringBuilder);
                }
            }
        }
        boolean bl2 = elementDeclaration.isNillable;
        AttributeUse[] attributeUseArray = NO_ATTRIBUTE_USES;
        Wildcard wildcard = null;
        if (complexType != null) {
            attributeUseArray = complexType.getAttributeUses();
            wildcard = complexType.getAttributeWildcard();
        }
        if (bl2 || attributeUseArray.length > 0 || wildcard != null) {
            this.appendAttributesSection(bl2, complexType, attributeUseArray, wildcard, stringBuilder);
        }
        if ((entryArray = this.getParentEntries(entry.getElementDeclaration())) != null) {
            stringBuilder.append("<h2>");
            XMLText.escapeXML(Msg.msg("DG.parentsHead"), stringBuilder);
            stringBuilder.append("</h2>\n");
            stringBuilder.append("<p>");
            XMLText.escapeXML(Msg.msg("DG.parentsBlurb", this.entryName(entry)), stringBuilder);
            stringBuilder.append(": ");
            boolean bl3 = true;
            for (n = 0; n < entryArray.length; ++n) {
                if (bl3) {
                    bl3 = false;
                } else {
                    stringBuilder.append(",\n");
                }
                this.appendLink(entryArray[n], stringBuilder);
            }
            stringBuilder.append(".</p>\n");
        }
        if (complexType != null && (objectArray = complexType.getElementFields()).length > 0) {
            if (objectArray.length > 1) {
                objectArray = (Name[])objectArray.clone();
                Arrays.sort(objectArray);
            }
            stringBuilder.append("<h2>");
            XMLText.escapeXML(Msg.msg("DG.childrenHead"), stringBuilder);
            stringBuilder.append("</h2>\n");
            stringBuilder.append("<p>");
            XMLText.escapeXML(Msg.msg("DG.childrenBlurb", this.entryName(entry)), stringBuilder);
            stringBuilder.append(": ");
            n = 1;
            for (int i = 0; i < objectArray.length; ++i) {
                Entry entry2;
                Object object = objectArray[i];
                ElementDeclaration elementDeclaration2 = complexType.getElementDeclaration((Name)object);
                if (elementDeclaration2 == null) {
                    elementDeclaration2 = this.schema.getElementDeclaration((Name)object);
                }
                if (elementDeclaration2 == null || (entry2 = this.getEntry(elementDeclaration2)) == null) continue;
                if (n != 0) {
                    n = 0;
                } else {
                    stringBuilder.append(",\n");
                }
                this.appendLink(entry2, stringBuilder);
            }
            stringBuilder.append(".</p>\n");
        }
        this.appendPageEnd(true, true, stringBuilder);
        pageInfo.html = stringBuilder.toString();
        pageInfo.name = entry.toPageName();
        pageInfo.title = string2;
    }

    private void appendLink(Entry entry, StringBuilder stringBuilder) {
        stringBuilder.append("<a href='");
        XMLText.escapeXML(entry.toPageName(), stringBuilder);
        stringBuilder.append("'>");
        XMLText.escapeXML(this.entryName(entry), stringBuilder);
        stringBuilder.append("</a>");
    }

    private String entryName(Entry entry) {
        int n = entry.getOccurrenceOfName();
        String string = entry.getName().format(false, this);
        if (n == 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append('#');
        stringBuilder.append(Integer.toString(n));
        return stringBuilder.toString();
    }

    private void appendComplexContent(ComplexType complexType, StringBuilder stringBuilder) {
        Particle particle = complexType.getParticle();
        if (DocumentationGenerator.isEmptyParticle(particle)) {
            return;
        }
        this.wildcards.clear();
        int n = 0;
        stringBuilder.append("<pre>");
        this.appendParticle(particle, n, this.wildcards, complexType, stringBuilder);
        stringBuilder.append("</pre>\n");
        if (this.wildcards.size() > 0) {
            Map.Entry[] entryArray = new Map.Entry[this.wildcards.size()];
            this.wildcards.entrySet().toArray(entryArray);
            Arrays.sort(entryArray, new Comparator<Map.Entry<NameWildcard, Integer>>(){

                @Override
                public int compare(Map.Entry<NameWildcard, Integer> entry, Map.Entry<NameWildcard, Integer> entry2) {
                    Integer n = entry.getValue();
                    Integer n2 = entry2.getValue();
                    return n - n2;
                }
            });
            stringBuilder.append("<p></p>\n");
            stringBuilder.append("<table border='0' cellspacing='0'>\n");
            for (int i = 0; i < entryArray.length; ++i) {
                Map.Entry entry = entryArray[i];
                Integer n2 = (Integer)entry.getValue();
                stringBuilder.append("<tr valign='top'>\n");
                stringBuilder.append("<td nowrap><a name='__wc__");
                stringBuilder.append(n2.toString());
                stringBuilder.append("'>[");
                stringBuilder.append(n2.toString());
                stringBuilder.append("]</a></td>\n");
                stringBuilder.append("<td>");
                ((NameWildcard)entry.getKey()).getHTMLDescription(false, stringBuilder);
                stringBuilder.append("</td>\n");
                stringBuilder.append("</tr>\n");
            }
            stringBuilder.append("</table>\n");
        }
    }

    private static final boolean isEmptyParticle(Particle particle) {
        return particle instanceof SequenceParticle && ((SequenceParticle)particle).getParticles().length == 0;
    }

    private void appendParticle(Particle particle, int n, HashMap<NameWildcard, Integer> hashMap, ComplexType complexType, StringBuilder stringBuilder) {
        switch (particle.getType()) {
            case SEQUENCE: {
                SequenceParticle sequenceParticle = (SequenceParticle)particle;
                this.appendParticle(',', sequenceParticle.getParticles(), sequenceParticle.getMinOccurs(), sequenceParticle.getMaxOccurs(), n, hashMap, complexType, stringBuilder);
                break;
            }
            case CHOICE: {
                ChoiceParticle choiceParticle = (ChoiceParticle)particle;
                this.appendParticle('|', choiceParticle.getParticles(), choiceParticle.getMinOccurs(), choiceParticle.getMaxOccurs(), n, hashMap, complexType, stringBuilder);
                break;
            }
            case ALL: {
                AllParticle allParticle = (AllParticle)particle;
                this.appendParticle('&', allParticle.getParticles(), allParticle.getMinOccurs(), allParticle.getMaxOccurs(), n, hashMap, complexType, stringBuilder);
                break;
            }
            case ELEMENT: {
                this.appendElementParticle((ElementParticle)particle, complexType, stringBuilder);
                break;
            }
            case WILDCARD: {
                this.appendWildcardParticle((WildcardParticle)particle, hashMap, stringBuilder);
            }
        }
    }

    private void appendParticle(char c, Particle[] particleArray, int n, int n2, int n3, HashMap<NameWildcard, Integer> hashMap, ComplexType complexType, StringBuilder stringBuilder) {
        int n4;
        boolean bl = true;
        block3: for (n4 = 0; n4 < particleArray.length; ++n4) {
            switch (particleArray[n4].getType()) {
                case SEQUENCE: 
                case CHOICE: 
                case ALL: {
                    bl = false;
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        stringBuilder.append('(');
        for (n4 = 0; n4 < particleArray.length; ++n4) {
            if (n4 > 0) {
                stringBuilder.append(' ');
                stringBuilder.append(c);
                stringBuilder.append(' ');
                if (bl && n4 % 5 == 0 || !bl) {
                    stringBuilder.append('\n');
                    DocumentationGenerator.appendIndent(n3 + 1, stringBuilder);
                }
            }
            this.appendParticle(particleArray[n4], n3 + 1, hashMap, complexType, stringBuilder);
        }
        stringBuilder.append(')');
        DocumentationGenerator.appendOccurs(n, n2, stringBuilder);
    }

    private static final void appendIndent(int n, StringBuilder stringBuilder) {
        while (n > 0) {
            stringBuilder.append(' ');
            --n;
        }
    }

    private void appendElementParticle(ElementParticle elementParticle, ComplexType complexType, StringBuilder stringBuilder) {
        Name name = elementParticle.elementName;
        ElementDeclaration elementDeclaration = complexType.getElementDeclaration(name);
        if (elementDeclaration == null) {
            elementDeclaration = this.schema.getElementDeclaration(name);
        }
        if (elementDeclaration == null) {
            return;
        }
        Entry entry = this.getEntry(elementDeclaration);
        this.appendLink(entry, stringBuilder);
        DocumentationGenerator.appendOccurs(elementParticle.getMinOccurs(), elementParticle.getMaxOccurs(), stringBuilder);
    }

    private void appendWildcardParticle(WildcardParticle wildcardParticle, HashMap<NameWildcard, Integer> hashMap, StringBuilder stringBuilder) {
        NameWildcard nameWildcard = wildcardParticle.wildcard.nameWildcard;
        Integer n = hashMap.get(nameWildcard);
        if (n == null) {
            n = 1 + hashMap.size();
            hashMap.put(nameWildcard, n);
        }
        stringBuilder.append("<a href='#__wc__");
        stringBuilder.append(n.toString());
        stringBuilder.append("'>[");
        stringBuilder.append(n.toString());
        stringBuilder.append("]</a>");
        DocumentationGenerator.appendOccurs(wildcardParticle.getMinOccurs(), wildcardParticle.getMaxOccurs(), stringBuilder);
    }

    private static final void appendOccurs(int n, int n2, StringBuilder stringBuilder) {
        if (n == 0 && n2 == 1) {
            stringBuilder.append('?');
        } else if (n == 0 && n2 == -1) {
            stringBuilder.append('*');
        } else if (n == 1 && n2 == -1) {
            stringBuilder.append('+');
        } else if (n != 1 && n2 != 1) {
            stringBuilder.append('{');
            stringBuilder.append(Integer.toString(n));
            stringBuilder.append(',');
            if (n2 != -1) {
                stringBuilder.append(Integer.toString(n2));
            }
            stringBuilder.append('}');
        }
    }

    private void appendDataContent(DataType dataType, Value value, boolean bl, StringBuilder stringBuilder) {
        stringBuilder.append("<table border='1'>");
        stringBuilder.append("<tr align='center'>\n");
        stringBuilder.append("<th>");
        XMLText.escapeXML(Msg.msg("DG.elementDataType"), stringBuilder);
        stringBuilder.append("</th>\n");
        stringBuilder.append("<th>");
        XMLText.escapeXML(Msg.msg("DG.elementDefaultValue"), stringBuilder);
        stringBuilder.append("</th>\n");
        stringBuilder.append("</tr>\n");
        stringBuilder.append("<tr valign='top'>\n");
        stringBuilder.append("<td>");
        this.appendDataType(dataType, stringBuilder);
        stringBuilder.append("</td>\n");
        stringBuilder.append("<td>");
        this.appendDefaultValue(value, bl, dataType, false, stringBuilder);
        stringBuilder.append("</td>\n");
        stringBuilder.append("</tr>\n");
        stringBuilder.append("</table>\n");
    }

    private void appendAttributesSection(boolean bl, ComplexType complexType, AttributeUse[] attributeUseArray, Wildcard wildcard, StringBuilder stringBuilder) {
        stringBuilder.append("<h2>");
        XMLText.escapeXML(Msg.msg("DG.attributesHead"), stringBuilder);
        stringBuilder.append("</h2>\n");
        if (bl || attributeUseArray.length > 0) {
            if (attributeUseArray.length > 1) {
                attributeUseArray = (AttributeUse[])attributeUseArray.clone();
                Arrays.sort(attributeUseArray);
            }
            stringBuilder.append("<table border='1'>\n");
            stringBuilder.append("<tr align='center'>\n");
            stringBuilder.append("<th>");
            XMLText.escapeXML(Msg.msg("DG.attributeName"), stringBuilder);
            stringBuilder.append("</th>\n");
            stringBuilder.append("<th>");
            XMLText.escapeXML(Msg.msg("DG.attributeDataType"), stringBuilder);
            stringBuilder.append("</th>\n");
            stringBuilder.append("<th>");
            XMLText.escapeXML(Msg.msg("DG.attributeDefaultValue"), stringBuilder);
            stringBuilder.append("</th>\n");
            stringBuilder.append("</tr>\n");
            for (int i = 0; i < attributeUseArray.length; ++i) {
                AttributeUse attributeUse = attributeUseArray[i];
                Name name = attributeUse.name;
                AttributeDeclaration attributeDeclaration = complexType.getAttributeDeclaration(name);
                if (attributeDeclaration == null) {
                    attributeDeclaration = this.schema.getAttributeDeclaration(name);
                }
                if (attributeDeclaration == null) continue;
                DataType dataType = attributeDeclaration.dataType;
                Value value = attributeDeclaration.defaultValue;
                boolean bl2 = attributeDeclaration.isFixedValue;
                stringBuilder.append("<tr valign='top'>\n");
                stringBuilder.append("<td>");
                if (attributeUse.isRequired) {
                    stringBuilder.append("<b>");
                } else if (bl2) {
                    stringBuilder.append("<b><i>");
                }
                XMLText.escapeXML(name.format(true, this), stringBuilder);
                if (attributeUse.isRequired) {
                    stringBuilder.append("</b>");
                } else if (bl2) {
                    stringBuilder.append("</i></b>");
                }
                stringBuilder.append("</td>\n");
                stringBuilder.append("<td>");
                this.appendDataType(dataType, stringBuilder);
                stringBuilder.append("</td>\n");
                stringBuilder.append("<td>");
                this.appendDefaultValue(value, bl2, dataType, attributeUse.isRequired, stringBuilder);
                stringBuilder.append("</td>\n");
                stringBuilder.append("</tr>\n");
            }
            if (bl) {
                stringBuilder.append("<tr valign='top'>\n");
                stringBuilder.append("<td>xsi:nil</td>\n");
                stringBuilder.append("<td>boolean</td>\n");
                stringBuilder.append("<td>\"false\"</td>\n");
                stringBuilder.append("</tr>\n");
            }
            stringBuilder.append("</table>\n");
        }
        if (wildcard != null) {
            stringBuilder.append("<p></p>\n");
            stringBuilder.append("<p><b>");
            XMLText.escapeXML(Msg.msg("DG.attributeWildcardBlurb"), stringBuilder);
            stringBuilder.append(":</b><br>\n");
            wildcard.nameWildcard.getHTMLDescription(true, stringBuilder);
            stringBuilder.append("</p>\n");
        }
    }

    private void appendDataType(DataType dataType, StringBuilder stringBuilder) {
        int n;
        Serializable[] serializableArray;
        DataType dataType2 = dataType.getRootType();
        XMLText.escapeXML(dataType.getDataTypeLabel(this), stringBuilder);
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 1)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DG.length"), stringBuilder);
            stringBuilder.append(": ");
            stringBuilder.append(Integer.toString(dataType.getLength()));
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 2)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DG.minLength"), stringBuilder);
            stringBuilder.append(": ");
            stringBuilder.append(Integer.toString(dataType.getMinLength()));
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 4)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DG.maxLength"), stringBuilder);
            stringBuilder.append(": ");
            stringBuilder.append(Integer.toString(dataType.getMaxLength()));
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 8)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DG.pattern"), stringBuilder);
            stringBuilder.append(": ");
            serializableArray = dataType.getPattern();
            for (n = 0; n < serializableArray.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\"');
                DocumentationGenerator.appendLongLine(((Pattern)serializableArray[n]).toString(), stringBuilder);
                stringBuilder.append('\"');
            }
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 16)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DG.enumeration"), stringBuilder);
            stringBuilder.append(": ");
            serializableArray = dataType.getEnumeration();
            for (n = 0; n < serializableArray.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\"');
                DocumentationGenerator.appendLongLine(((Value)serializableArray[n]).toString(this), stringBuilder);
                stringBuilder.append('\"');
            }
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 32)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DG.whiteSpace"), stringBuilder);
            stringBuilder.append(": ");
            XMLText.escapeXML(dataType.getWhiteSpace().toString(), stringBuilder);
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 64)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DG.maxInclusive"), stringBuilder);
            stringBuilder.append(": ");
            XMLText.escapeXML(dataType.getMaxInclusive().toString(this), stringBuilder);
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 128)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DG.maxExclusive"), stringBuilder);
            stringBuilder.append(": ");
            XMLText.escapeXML(dataType.getMaxExclusive().toString(this), stringBuilder);
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 256)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DG.minExclusive"), stringBuilder);
            stringBuilder.append(": ");
            XMLText.escapeXML(dataType.getMinExclusive().toString(this), stringBuilder);
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 512)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DG.minInclusive"), stringBuilder);
            stringBuilder.append(": ");
            XMLText.escapeXML(dataType.getMinInclusive().toString(this), stringBuilder);
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 1024)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DG.totalDigits"), stringBuilder);
            stringBuilder.append(": ");
            stringBuilder.append(Integer.toString(dataType.getTotalDigits()));
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 2048)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DG.fractionDigits"), stringBuilder);
            stringBuilder.append(": ");
            stringBuilder.append(Integer.toString(dataType.getFractionDigits()));
        }
    }

    private static final boolean hasFacet(DataType dataType, DataType dataType2, int n) {
        return dataType.hasFacet(n) && !dataType2.hasFacet(n);
    }

    private static final void appendLongLine(String string, StringBuilder stringBuilder) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = Math.min(n2, n + 80);
            if (n > 0) {
                stringBuilder.append("<br>\n");
            }
            XMLText.escapeXML(string.substring(n, n3), stringBuilder);
            n = n3;
        }
    }

    private void appendDefaultValue(Value value, boolean bl, DataType dataType, boolean bl2, StringBuilder stringBuilder) {
        if (value == null) {
            if (bl2) {
                XMLText.escapeXML(Msg.msg("DG.requiredValue"), stringBuilder);
            } else {
                stringBuilder.append("&#160;");
            }
            return;
        }
        if (bl) {
            XMLText.escapeXML(Msg.msg("DG.fixedValue"), stringBuilder);
            stringBuilder.append(": ");
        }
        stringBuilder.append('\"');
        DocumentationGenerator.appendLongLine(value.toString(this), stringBuilder);
        stringBuilder.append('\"');
    }

    @Override
    public SubDocumentType getSubDocumentType() {
        return this.schema;
    }

    @Override
    public ElementType getElementType(String string) {
        ElementDeclaration elementDeclaration = this.getElementDeclaration(string);
        if (elementDeclaration == null) {
            return null;
        }
        return new ElementTypeImpl(this.schema, elementDeclaration, null);
    }

    @Override
    public boolean generateElementPage(ElementType elementType, DocumentationGeneratorBase.PageInfo pageInfo) {
        return this.generateElementPage(((ElementTypeImpl)elementType).decl, pageInfo);
    }

    private static final class Entry
    implements Comparable<Entry> {
        private ElementDeclaration decl;
        private int occurrenceOfName;

        public Entry(ElementDeclaration elementDeclaration) {
            this.decl = elementDeclaration;
        }

        private Entry() {
        }

        public ElementDeclaration getElementDeclaration() {
            return this.decl;
        }

        public Name getName() {
            return this.decl.name;
        }

        public Type getType() {
            return this.decl.type;
        }

        public int getOccurrenceOfName() {
            return this.occurrenceOfName;
        }

        public int hashCode() {
            return System.identityHashCode(this.decl.name) ^ System.identityHashCode(this.decl.type);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.decl.name == entry.decl.name && this.decl.type == entry.decl.type;
        }

        public String toPageName() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.decl.name.localPart);
            stringBuilder.append("__");
            stringBuilder.append(Integer.toString(System.identityHashCode(this.decl), 36));
            stringBuilder.append(".html");
            return stringBuilder.toString();
        }

        @Override
        public int compareTo(Entry entry) {
            Name name;
            Name name2 = this.getName();
            if (name2 == (name = entry.getName())) {
                return this.occurrenceOfName - entry.occurrenceOfName;
            }
            return name2.compareTo(name);
        }
    }
}

