/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.wxs.load.AttributeGroupInfo;
import com.xmlmind.xml.wxs.load.AttributeInfo;
import com.xmlmind.xml.wxs.load.ComplexTypeInfo;
import com.xmlmind.xml.wxs.load.ElementInfo;
import com.xmlmind.xml.wxs.load.GroupInfo;
import com.xmlmind.xml.wxs.load.IdentityConstraintInfo;
import com.xmlmind.xml.wxs.load.Info;
import com.xmlmind.xml.wxs.load.NamedComponent;
import com.xmlmind.xml.wxs.load.SchemaErrors;
import com.xmlmind.xml.wxs.load.SchemaInfo;
import com.xmlmind.xml.wxs.load.SubstitutionGroup;
import com.xmlmind.xml.wxs.load.TypeInfo;
import com.xmlmind.xml.wxs.validate.AttributeDeclaration;
import com.xmlmind.xml.wxs.validate.ElementDeclaration;
import com.xmlmind.xml.wxs.validate.SimpleType;
import com.xmlmind.xml.wxs.validate.Type;
import com.xmlmind.xml.wxs.validate.WXSchema;
import com.xmlmind.xml.wxs.validate.WXSchemaForWXSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;

final class LoadState {
    public static final String MISSING_COMPONENT = "missingComponent";
    public static final String CIRCULAR_COMPONENT = "circularComponent";
    public static final String INVALID_COMPONENT = "invalidComponent";
    public SchemaInfo schemaInfo;
    public WXSchema schema;
    public SchemaErrors errors;
    public SchemaErrors warnings;
    public ArrayList<Object> localComplexTypes;
    public IdentityHashMap<Name, IdentityConstraintInfo> identityConstraints;
    private HashMap<NamedComponent, NamedComponent> circularComponents;
    private HashMap<NamedComponent, NamedComponent> badComponents;
    private NamedComponent namedComponentProbe;
    private HashMap<SubstitutionGroup, SubstitutionGroup> substitutionGroups;
    private SubstitutionGroup subGroupProbe;

    public LoadState(SchemaInfo schemaInfo) {
        this.schemaInfo = schemaInfo;
        this.schema = schemaInfo.targetNamespace == Namespace.XSD ? new WXSchemaForWXSchema() : new WXSchema(schemaInfo.targetNamespace);
        this.errors = new SchemaErrors();
        this.warnings = new SchemaErrors();
        this.localComplexTypes = new ArrayList();
        this.identityConstraints = new IdentityHashMap();
        this.circularComponents = new HashMap();
        this.badComponents = new HashMap();
        this.namedComponentProbe = new NamedComponent();
        this.initSubstitutionGroups();
    }

    private void initSubstitutionGroups() {
        int n;
        ElementInfo[] elementInfoArray;
        ElementInfo elementInfo;
        SubstitutionGroup substitutionGroup;
        this.substitutionGroups = new HashMap();
        this.subGroupProbe = new SubstitutionGroup();
        for (ElementInfo substitutionGroupArray2 : this.schemaInfo.elementInfo.values()) {
            ElementInfo n2;
            if (substitutionGroupArray2.substitutionGroup == null || (n2 = this.getElementInfo(substitutionGroupArray2.substitutionGroup, substitutionGroupArray2, "e-props-correct.1")) == null) continue;
            if ((n2.block & 4) != 0) {
                this.errors.append(substitutionGroupArray2, "cos-equiv-derived-ok-rec.1", "disallowedSubstitution", substitutionGroupArray2.substitutionGroup.format(false, substitutionGroupArray2));
                continue;
            }
            Object object = this.getSubstitutionGroup(n2);
            if (object == null) {
                object = new SubstitutionGroup(n2);
                this.substitutionGroups.put((SubstitutionGroup)object, (SubstitutionGroup)object);
            }
            ((SubstitutionGroup)object).addMember(substitutionGroupArray2);
        }
        SubstitutionGroup[] substitutionGroupArray = new SubstitutionGroup[this.substitutionGroups.size()];
        int n2 = 0;
        for (SubstitutionGroup i : this.substitutionGroups.values()) {
            substitutionGroupArray[n2++] = new SubstitutionGroup(i);
        }
        for (int substitutionGroup3 = 0; substitutionGroup3 < substitutionGroupArray.length; ++substitutionGroup3) {
            substitutionGroup = substitutionGroupArray[substitutionGroup3];
            elementInfo = substitutionGroup.head;
            elementInfoArray = substitutionGroup.members;
            for (n = 0; n < elementInfoArray.length; ++n) {
                this.addToSubstitutionGroups(elementInfoArray[n], elementInfo);
            }
        }
        n2 = 0;
        for (SubstitutionGroup i : this.substitutionGroups.values()) {
            substitutionGroupArray[n2++] = i;
        }
        for (int i = 0; i < substitutionGroupArray.length; ++i) {
            substitutionGroup = substitutionGroupArray[i];
            elementInfo = substitutionGroup.head;
            elementInfoArray = substitutionGroup.members;
            n = 0;
            if (!elementInfo.abstract_) {
                ++n;
            }
            for (int j = 0; j < elementInfoArray.length; ++j) {
                if (elementInfoArray[j].abstract_) continue;
                ++n;
            }
            if (n != 0) continue;
            this.subGroupProbe.head = elementInfo;
            this.substitutionGroups.remove(this.subGroupProbe);
        }
    }

    public SubstitutionGroup getSubstitutionGroup(ElementInfo elementInfo) {
        this.subGroupProbe.head = elementInfo;
        return this.substitutionGroups.get(this.subGroupProbe);
    }

    private void addToSubstitutionGroups(ElementInfo elementInfo, ElementInfo elementInfo2) {
        while (elementInfo2.substitutionGroup != null) {
            ElementInfo elementInfo3 = this.schemaInfo.elementInfo.get(elementInfo2.substitutionGroup);
            if (elementInfo3 == null) {
                return;
            }
            if (elementInfo == elementInfo3) {
                return;
            }
            SubstitutionGroup substitutionGroup = this.getSubstitutionGroup(elementInfo3);
            if (substitutionGroup == null) {
                return;
            }
            substitutionGroup.addMember(elementInfo);
            elementInfo2 = elementInfo3;
        }
        return;
    }

    public boolean isBadComponent(NamedComponent.Type type, Name name) {
        this.namedComponentProbe.type = type;
        this.namedComponentProbe.name = name;
        return this.badComponents.containsKey(this.namedComponentProbe);
    }

    public void addBadComponent(NamedComponent.Type type, Name name, String string, Info info, String string2) {
        if (this.isBadComponent(type, name)) {
            return;
        }
        NamedComponent namedComponent = new NamedComponent(type, name);
        this.badComponents.put(namedComponent, namedComponent);
        if (string == MISSING_COMPONENT) {
            this.warnings.append(info, string2, MISSING_COMPONENT, new Object[]{type, name.format(false, info)});
        } else if (string != INVALID_COMPONENT) {
            this.errors.append(info, string2, string, new Object[]{type, name.format(false, info)});
        }
    }

    public boolean isCircularComponent(NamedComponent.Type type, Name name) {
        this.namedComponentProbe.type = type;
        this.namedComponentProbe.name = name;
        return this.circularComponents.containsKey(this.namedComponentProbe);
    }

    public boolean detectCircularComponent(NamedComponent.Type type, Name name, Info info, String string) {
        if (this.isCircularComponent(type, name)) {
            this.addBadComponent(type, name, CIRCULAR_COMPONENT, info, string);
            return true;
        }
        NamedComponent namedComponent = new NamedComponent(type, name);
        this.circularComponents.put(namedComponent, namedComponent);
        return false;
    }

    public void undetectCircularComponent(NamedComponent.Type type, Name name) {
        this.namedComponentProbe.type = type;
        this.namedComponentProbe.name = name;
        this.circularComponents.remove(this.namedComponentProbe);
    }

    public SimpleType getSimpleType(Name name, Info info, String string) {
        Type type = this.getType(name, info, string);
        if (type != null && !(type instanceof SimpleType)) {
            this.errors.append(info, string, "unexpectedComplexType", name.format(false, info));
            return null;
        }
        return (SimpleType)type;
    }

    public Type getType(Name name, Info info, String string) {
        if (this.isBadComponent(NamedComponent.Type.TYPE, name)) {
            return null;
        }
        Type type = this.schema.findType(name);
        if (type != null) {
            return type;
        }
        TypeInfo typeInfo = this.schemaInfo.typeInfo.get(name);
        if (typeInfo == null) {
            this.addBadComponent(NamedComponent.Type.TYPE, name, MISSING_COMPONENT, info, string);
            return null;
        }
        if (this.detectCircularComponent(NamedComponent.Type.TYPE, name, info, string)) {
            return null;
        }
        Type type2 = typeInfo instanceof ComplexTypeInfo ? ((ComplexTypeInfo)typeInfo).toComplexType(this) : typeInfo.toType(this);
        this.undetectCircularComponent(NamedComponent.Type.TYPE, name);
        if (type2 == null) {
            this.addBadComponent(NamedComponent.Type.TYPE, name, INVALID_COMPONENT, info, string);
            return null;
        }
        this.schema.addType(type2);
        return type2;
    }

    public AttributeDeclaration getAttributeDeclaration(Name name, Info info, String string) {
        if (this.isBadComponent(NamedComponent.Type.ATTRIBUTE, name)) {
            return null;
        }
        AttributeDeclaration attributeDeclaration = this.schema.getAttributeDeclaration(name);
        if (attributeDeclaration != null) {
            return attributeDeclaration;
        }
        AttributeInfo attributeInfo = this.schemaInfo.attributeInfo.get(name);
        if (attributeInfo == null) {
            this.addBadComponent(NamedComponent.Type.ATTRIBUTE, name, MISSING_COMPONENT, info, string);
            return null;
        }
        AttributeDeclaration attributeDeclaration2 = attributeInfo.toAttributeDeclaration(this);
        if (attributeDeclaration2 == null) {
            this.addBadComponent(NamedComponent.Type.ATTRIBUTE, name, INVALID_COMPONENT, info, string);
            return null;
        }
        this.schema.addAttributeDeclaration(attributeDeclaration2);
        return attributeDeclaration2;
    }

    public ElementDeclaration getElementDeclaration(Name name, Info info, String string) {
        if (this.isBadComponent(NamedComponent.Type.ELEMENT, name)) {
            return null;
        }
        ElementDeclaration elementDeclaration = this.schema.getElementDeclaration(name);
        if (elementDeclaration != null) {
            return elementDeclaration;
        }
        ElementInfo elementInfo = this.schemaInfo.elementInfo.get(name);
        if (elementInfo == null) {
            this.addBadComponent(NamedComponent.Type.ELEMENT, name, MISSING_COMPONENT, info, string);
            return null;
        }
        ElementDeclaration elementDeclaration2 = elementInfo.toElementDeclaration(this);
        if (elementDeclaration2 == null) {
            this.addBadComponent(NamedComponent.Type.ELEMENT, name, INVALID_COMPONENT, info, string);
            return null;
        }
        this.schema.addElementDeclaration(elementDeclaration2);
        return elementDeclaration2;
    }

    public ElementInfo getElementInfo(Name name, Info info, String string) {
        if (this.isBadComponent(NamedComponent.Type.ELEMENT, name)) {
            return null;
        }
        ElementInfo elementInfo = this.schemaInfo.elementInfo.get(name);
        if (elementInfo == null) {
            this.addBadComponent(NamedComponent.Type.ELEMENT, name, MISSING_COMPONENT, info, string);
            return null;
        }
        return elementInfo;
    }

    public GroupInfo getGroupInfo(Name name, Info info, String string) {
        if (this.isBadComponent(NamedComponent.Type.GROUP, name)) {
            return null;
        }
        GroupInfo groupInfo = this.schemaInfo.groupInfo.get(name);
        if (groupInfo == null) {
            this.addBadComponent(NamedComponent.Type.GROUP, name, MISSING_COMPONENT, info, string);
            return null;
        }
        return groupInfo;
    }

    public AttributeGroupInfo getAttributeGroupInfo(Name name, Info info, String string) {
        if (this.isBadComponent(NamedComponent.Type.ATTRIBUTE_GROUP, name)) {
            return null;
        }
        AttributeGroupInfo attributeGroupInfo = this.schemaInfo.attributeGroupInfo.get(name);
        if (attributeGroupInfo == null) {
            this.addBadComponent(NamedComponent.Type.ATTRIBUTE_GROUP, name, MISSING_COMPONENT, info, string);
            return null;
        }
        return attributeGroupInfo;
    }

    public TypeInfo getTypeInfo(Name name, Info info, String string) {
        if (this.isBadComponent(NamedComponent.Type.TYPE, name)) {
            return null;
        }
        TypeInfo typeInfo = this.schemaInfo.typeInfo.get(name);
        if (typeInfo == null) {
            this.addBadComponent(NamedComponent.Type.TYPE, name, MISSING_COMPONENT, info, string);
            return null;
        }
        return typeInfo;
    }
}

