/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.load.DocumentLoader;
import com.xmlmind.xml.wxs.load.Info;
import com.xmlmind.xml.wxs.load.LoadContext;
import com.xmlmind.xml.wxs.load.SchemaErrors;
import com.xmlmind.xml.wxs.load.SchemaInfo;
import java.net.URL;
import org.xml.sax.SAXParseException;

final class IncludeInfo
extends Info {
    public URL schemaLocation = null;

    public IncludeInfo(Info info) {
        super(info);
    }

    @Override
    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.schemaLocation = IncludeInfo.getResolvedURLAttribute(element, _SCHEMA_LOCATION, this.getLocation(), null);
        if (this.schemaLocation == null) {
            schemaErrors2.append(this, "x-src-include.1", "invalidSchemaLocation");
            return;
        }
        if (loadContext.isSchemaBeingLoaded(this.schemaLocation)) {
            return;
        }
        SchemaInfo schemaInfo2 = null;
        try {
            schemaInfo2 = IncludeInfo.loadSchema(this.schemaLocation, schemaInfo.targetNamespace, loadContext, schemaErrors, schemaErrors2);
        }
        catch (Exception exception) {
            String string = exception instanceof SAXParseException ? DocumentLoader.format((SAXParseException)exception) : ThrowableUtil.reason(exception);
            schemaErrors2.append(this, "x-src-include.1", "cannotLoadSchema", this.schemaLocation, string);
            return;
        }
        if (schemaInfo2 != null) {
            if (schemaInfo2.targetNamespace != schemaInfo.targetNamespace) {
                schemaErrors2.append(this, "src-include.2", "unexpectedTargetNamespace", schemaInfo.targetNamespace, this.schemaLocation, schemaInfo2.targetNamespace);
            } else {
                IncludeInfo.moveInfo(schemaInfo2, schemaInfo, schemaErrors2);
            }
        }
    }
}

