/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype.regex;

import com.xmlmind.xml.wxs.datatype.regex.Categories;
import com.xmlmind.xml.wxs.datatype.regex.Localizer;
import com.xmlmind.xml.wxs.datatype.regex.RegexSyntaxException;
import com.xmlmind.xml.wxs.datatype.regex.Utf16;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Translator {
    private String regExp;
    private int length;
    private int pos = 0;
    private char curChar;
    private boolean eos = false;
    private final StringBuilder result = new StringBuilder();
    private static final String categories = "LMNPZSC";
    private static final CharClass[] categoryCharClasses = new CharClass["LMNPZSC".length()];
    private static final String subCategories = "LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn";
    private static final CharClass[] subCategoryCharClasses = new CharClass["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];
    private static final int NONBMP_MIN = 65536;
    private static final int NONBMP_MAX = 0x10FFFF;
    private static final char SURROGATE2_MIN = '\udc00';
    private static final char SURROGATE2_MAX = '\udfff';
    static final Localizer localizer = new Localizer(Translator.class);
    private static final String[] blockNames = new String[]{"BasicLatin", "Latin-1Supplement", "LatinExtended-A", "LatinExtended-B", "IPAExtensions", "SpacingModifierLetters", "CombiningDiacriticalMarks", "Greek", "Cyrillic", "Armenian", "Hebrew", "Arabic", "Syriac", "Thaana", "Devanagari", "Bengali", "Gurmukhi", "Gujarati", "Oriya", "Tamil", "Telugu", "Kannada", "Malayalam", "Sinhala", "Thai", "Lao", "Tibetan", "Myanmar", "Georgian", "HangulJamo", "Ethiopic", "Cherokee", "UnifiedCanadianAboriginalSyllabics", "Ogham", "Runic", "Khmer", "Mongolian", "LatinExtendedAdditional", "GreekExtended", "GeneralPunctuation", "SuperscriptsandSubscripts", "CurrencySymbols", "CombiningMarksforSymbols", "LetterlikeSymbols", "NumberForms", "Arrows", "MathematicalOperators", "MiscellaneousTechnical", "ControlPictures", "OpticalCharacterRecognition", "EnclosedAlphanumerics", "BoxDrawing", "BlockElements", "GeometricShapes", "MiscellaneousSymbols", "Dingbats", "BraillePatterns", "CJKRadicalsSupplement", "KangxiRadicals", "IdeographicDescriptionCharacters", "CJKSymbolsandPunctuation", "Hiragana", "Katakana", "Bopomofo", "HangulCompatibilityJamo", "Kanbun", "BopomofoExtended", "EnclosedCJKLettersandMonths", "CJKCompatibility", "CJKUnifiedIdeographsExtensionA", "CJKUnifiedIdeographs", "YiSyllables", "YiRadicals", "HangulSyllables", "CJKCompatibilityIdeographs", "AlphabeticPresentationForms", "ArabicPresentationForms-A", "CombiningHalfMarks", "CJKCompatibilityForms", "SmallFormVariants", "ArabicPresentationForms-B", "Specials", "HalfwidthandFullwidthForms", "Specials"};
    private static final String[] specialBlockNames = new String[]{"OldItalic", "Gothic", "Deseret", "ByzantineMusicalSymbols", "MusicalSymbols", "MathematicalAlphanumericSymbols", "CJKUnifiedIdeographsExtensionB", "CJKCompatibilityIdeographsSupplement", "Tags", "PrivateUse", "HighSurrogates", "HighPrivateUseSurrogates", "LowSurrogates"};
    private static final CharClass[] specialBlockCharClasses = new CharClass[]{new CharRange(66304, 66351), new CharRange(66352, 66383), new CharRange(66560, 66639), new CharRange(118784, 119039), new CharRange(119040, 119295), new CharRange(119808, 120831), new CharRange(131072, 173782), new CharRange(194560, 195103), new CharRange(917504, 917631), new Union(new CharClass[]{new CharRange(57344, 63743), new CharRange(983040, 1048573), new CharRange(0x100000, 1114109)}), Empty.getInstance(), Empty.getInstance(), Empty.getInstance()};
    private static final CharClass DOT = new Complement(new Union(new CharClass[]{new SingleChar('\n'), new SingleChar('\r')}));
    private static final CharClass ESC_d = new Property("Nd");
    private static final CharClass ESC_D = new Complement(ESC_d);
    private static final CharClass ESC_W = new Union(new CharClass[]{new Property("P"), new Property("Z"), new Property("C")});
    private static final CharClass ESC_w = new Complement(ESC_W);
    private static final CharClass ESC_s = new Union(new CharClass[]{new SingleChar(' '), new SingleChar('\n'), new SingleChar('\r'), new SingleChar('\t')});
    private static final CharClass ESC_S = new Complement(ESC_s);
    private static final CharClass ESC_i = Translator.makeCharClass("LlLuLoLtNl", ":_\u02bb\u02bc\u02bd\u02be\u02bf\u02c0\u02c1\u0559\u06e5\u06e6\u212e", "\u00aa\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02ad\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u048c\u048f\u04ec\u04ed\u0587\u0587\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07a5\u0950\u0950\u0ad0\u0ad0\u0d85\u0dc6\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u1055\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a8\u207f\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc");
    private static final CharClass ESC_I = new Complement(ESC_i);
    private static final CharClass ESC_c = Translator.makeCharClass("LlLuLoLtNlMcMeMnLmNd", "-.:_\u00b7\u0387\u212e", "\u00aa\u00b5\u00ba\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02b8\u02e0\u02ee\u0346\u034e\u0362\u037a\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u0488\u048f\u04ec\u04ed\u0587\u0587\u0653\u0655\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07b0\u0950\u0950\u0ad0\u0ad0\u0d82\u0df3\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u0f6a\u0f96\u0f96\u0fae\u0fb0\u0fb8\u0fb8\u0fba\u1059\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a9\u207f\u207f\u20dd\u20e0\u20e2\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u2183\u3006\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc");
    private static final CharClass ESC_C = new Complement(ESC_c);
    private static final char EOS = '\u0000';
    static final int NONE = -1;
    static final int SOME = 0;
    static final int ALL = 1;
    static final String SURROGATES1_CLASS = "[\ud800-\udbff]";
    static final String SURROGATES2_CLASS = "[\udc00-\udfff]";
    static final String NOT_ALLOWED_CLASS = "[\u0000&&[^\u0000]]";
    private static final char UNICODE_3_1_ADD_Lu = '\u03f4';
    private static final char UNICODE_3_1_ADD_Ll = '\u03f5';
    private static final char UNICODE_3_1_CHANGE_No_to_Nl_MIN = '\u16ee';
    private static final char UNICODE_3_1_CHANGE_No_to_Nl_MAX = '\u16f0';
    private static final String CATEGORY_Pi = "\u00ab\u2018\u201b\u201c\u201f\u2039";
    private static final String CATEGORY_Pf = "\u00bb\u2019\u201d\u203a";

    private Translator(String string) {
        this.regExp = string;
        this.length = string.length();
        this.advance();
    }

    public static String translate(String string) throws RegexSyntaxException {
        Translator translator = new Translator(string);
        translator.translateTop();
        return translator.result.toString();
    }

    private void advance() {
        if (this.pos < this.length) {
            this.curChar = this.regExp.charAt(this.pos++);
        } else {
            ++this.pos;
            this.curChar = '\u0000';
            this.eos = true;
        }
    }

    private void translateTop() throws RegexSyntaxException {
        this.translateRegExp();
        if (!this.eos) {
            throw this.makeException("expected_eos");
        }
    }

    private void translateRegExp() throws RegexSyntaxException {
        this.translateBranch();
        while (this.curChar == '|') {
            this.copyCurChar();
            this.translateBranch();
        }
    }

    private void translateBranch() throws RegexSyntaxException {
        while (this.translateAtom()) {
            this.translateQuantifier();
        }
    }

    private void translateQuantifier() throws RegexSyntaxException {
        switch (this.curChar) {
            case '*': 
            case '+': 
            case '?': {
                this.copyCurChar();
                return;
            }
            case '{': {
                this.copyCurChar();
                this.translateQuantity();
                this.expect('}');
                this.copyCurChar();
            }
        }
    }

    private void translateQuantity() throws RegexSyntaxException {
        block7: {
            String string = this.parseQuantExact();
            int n = -1;
            try {
                n = Integer.parseInt(string);
                this.result.append(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.result.append(Integer.MAX_VALUE);
            }
            if (this.curChar == ',') {
                this.copyCurChar();
                if (this.curChar != '}') {
                    String string2 = this.parseQuantExact();
                    try {
                        int n2 = Integer.parseInt(string2);
                        this.result.append(string2);
                        if (n < 0 || n2 < n) {
                            throw this.makeException("invalid_quantity_range");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.result.append(Integer.MAX_VALUE);
                        if (n >= 0 || new BigDecimal(string).compareTo(new BigDecimal(string2)) <= 0) break block7;
                        throw this.makeException("invalid_quantity_range");
                    }
                }
            }
        }
    }

    private String parseQuantExact() throws RegexSyntaxException {
        StringBuilder stringBuilder = new StringBuilder();
        do {
            if ("0123456789".indexOf(this.curChar) < 0) {
                throw this.makeException("expected_digit");
            }
            stringBuilder.append(this.curChar);
            this.advance();
        } while (this.curChar != ',' && this.curChar != '}');
        return stringBuilder.toString();
    }

    private void copyCurChar() {
        this.result.append(this.curChar);
        this.advance();
    }

    private boolean translateAtom() throws RegexSyntaxException {
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
            }
            case ')': 
            case '*': 
            case '+': 
            case '?': 
            case ']': 
            case '{': 
            case '|': 
            case '}': {
                return false;
            }
            case '(': {
                this.copyCurChar();
                this.translateRegExp();
                this.expect(')');
                this.copyCurChar();
                return true;
            }
            case '\\': {
                this.advance();
                this.parseEsc().output(this.result);
                return true;
            }
            case '[': {
                this.advance();
                this.parseCharClassExpr().output(this.result);
                return true;
            }
            case '.': {
                DOT.output(this.result);
                this.advance();
                return true;
            }
            case '$': 
            case '^': {
                this.result.append('\\');
            }
        }
        this.copyCurChar();
        return true;
    }

    private static CharClass makeCharClass(String string, String string2, String string3) {
        int n;
        int n2;
        ArrayList<CharClass> arrayList = new ArrayList<CharClass>();
        int n3 = string.length();
        for (n2 = 0; n2 < n3; n2 += 2) {
            arrayList.add(new Property(string.substring(n2, n2 + 2)));
        }
        n3 = string2.length();
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = n2 + 1; n < n3 && string2.charAt(n) - string2.charAt(n2) == n - n2; ++n) {
            }
            if (n2 == --n - 1) {
                --n;
            }
            if (n2 == n) {
                arrayList.add(new SingleChar(string2.charAt(n2)));
            } else {
                arrayList.add(new CharRange(string2.charAt(n2), string2.charAt(n)));
            }
            n2 = n;
        }
        ArrayList<CharClass> arrayList2 = new ArrayList<CharClass>();
        n = string3.length();
        for (n3 = 0; n3 < n; n3 += 2) {
            char c;
            char c2 = string3.charAt(n3);
            if (c2 == (c = string3.charAt(n3 + 1))) {
                arrayList2.add(new SingleChar(c2));
                continue;
            }
            if (c2 == c - '\u0001') {
                arrayList2.add(new SingleChar(c2));
                arrayList2.add(new SingleChar(c));
                continue;
            }
            arrayList2.add(new CharRange(c2, c));
        }
        return new Subtraction(new Union(arrayList), new Union(arrayList2));
    }

    private CharClass parseEsc() throws RegexSyntaxException {
        switch (this.curChar) {
            case 'n': {
                this.advance();
                return new SingleChar('\n');
            }
            case 'r': {
                this.advance();
                return new SingleChar('\r');
            }
            case 't': {
                this.advance();
                return new SingleChar('\t');
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                break;
            }
            case 's': {
                this.advance();
                return ESC_s;
            }
            case 'S': {
                this.advance();
                return ESC_S;
            }
            case 'i': {
                this.advance();
                return ESC_i;
            }
            case 'I': {
                this.advance();
                return ESC_I;
            }
            case 'c': {
                this.advance();
                return ESC_c;
            }
            case 'C': {
                this.advance();
                return ESC_C;
            }
            case 'd': {
                this.advance();
                return ESC_d;
            }
            case 'D': {
                this.advance();
                return ESC_D;
            }
            case 'w': {
                this.advance();
                return ESC_w;
            }
            case 'W': {
                this.advance();
                return ESC_W;
            }
            case 'p': {
                this.advance();
                return this.parseProp();
            }
            case 'P': {
                this.advance();
                return new Complement(this.parseProp());
            }
            default: {
                throw this.makeException("bad_escape");
            }
        }
        SingleChar singleChar = new SingleChar(this.curChar);
        this.advance();
        return singleChar;
    }

    private CharClass parseProp() throws RegexSyntaxException {
        this.expect('{');
        int n = this.pos;
        while (true) {
            this.advance();
            if (this.curChar == '}') break;
            if (Translator.isAsciiAlnum(this.curChar) || this.curChar == '-') continue;
            this.expect('}');
        }
        String string = this.regExp.substring(n, this.pos - 1);
        this.advance();
        switch (string.length()) {
            case 0: {
                throw this.makeException("empty_property_name");
            }
            case 2: {
                int n2 = subCategories.indexOf(string);
                if (n2 < 0 || n2 % 2 == 1) {
                    throw this.makeException("bad_category");
                }
                return Translator.getSubCategoryCharClass(n2 / 2);
            }
            case 1: {
                int n3 = categories.indexOf(string.charAt(0));
                if (n3 < 0) {
                    throw this.makeException("bad_category", string);
                }
                return Translator.getCategoryCharClass(n3);
            }
        }
        if (string.startsWith("Is")) {
            String string2 = string.substring(2);
            for (int i = 0; i < specialBlockNames.length; ++i) {
                if (!string2.equals(specialBlockNames[i])) continue;
                return specialBlockCharClasses[i];
            }
            if (!Translator.isBlock(string2)) {
                throw this.makeException("bad_block_name", string2);
            }
            return new Property("In" + string2);
        }
        throw this.makeException("bad_property_name", string);
    }

    private static boolean isBlock(String string) {
        for (int i = 0; i < blockNames.length; ++i) {
            if (!string.equals(blockNames[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isAsciiAlnum(char c) {
        if ('a' <= c && c <= 'z') {
            return true;
        }
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        return '0' <= c && c <= '9';
    }

    private void expect(char c) throws RegexSyntaxException {
        if (this.curChar != c) {
            throw this.makeException("expected", new String(new char[]{c}));
        }
    }

    private CharClass parseCharClassExpr() throws RegexSyntaxException {
        CharClass charClass;
        boolean bl;
        if (this.curChar == '^') {
            this.advance();
            bl = true;
        } else {
            bl = false;
        }
        ArrayList<CharClass> arrayList = new ArrayList<CharClass>();
        do {
            charClass = this.parseCharClassEscOrXmlChar(bl);
            arrayList.add(charClass);
            if (this.curChar != '-') continue;
            CharClass charClass2 = this.parseCharClassSepar(bl);
            if (charClass2 != null) {
                arrayList.add(charClass2);
                continue;
            }
            this.advance();
            if (this.curChar == '[') break;
            CharClass charClass3 = this.parseCharClassEscOrXmlChar(bl);
            if (charClass.singleChar() < 0 || charClass3.singleChar() < 0) {
                throw this.makeException("multi_range");
            }
            if (charClass.singleChar() > charClass3.singleChar()) {
                throw this.makeException("invalid_range");
            }
            arrayList.set(arrayList.size() - 1, new CharRange(charClass.singleChar(), charClass3.singleChar()));
            if (this.curChar != '-') continue;
            charClass2 = this.parseCharClassSepar(bl);
            if (charClass2 != null) {
                arrayList.add(charClass2);
                continue;
            }
            this.advance();
            this.expect('[');
            break;
        } while (this.curChar != ']');
        charClass = arrayList.size() == 1 ? (CharClass)arrayList.get(0) : new Union(arrayList);
        if (bl) {
            charClass = new Complement(charClass);
        }
        if (this.curChar == '[') {
            this.advance();
            charClass = new Subtraction(charClass, this.parseCharClassExpr());
            this.expect(']');
        }
        this.advance();
        return charClass;
    }

    private CharClass parseCharClassEscOrXmlChar(boolean bl) throws RegexSyntaxException {
        SimpleCharClass simpleCharClass;
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
                this.expect(']');
                break;
            }
            case '\\': {
                this.advance();
                return this.parseEsc();
            }
            case '-': {
                CharClass charClass = this.parseCharClassSepar(bl);
                if (charClass != null) {
                    return charClass;
                }
            }
            case '[': 
            case ']': {
                throw this.makeException("should_quote", new String(new char[]{this.curChar}));
            }
        }
        if (Utf16.isSurrogate(this.curChar)) {
            if (!Utf16.isSurrogate1(this.curChar)) {
                throw this.makeException("invalid_surrogate");
            }
            char c = this.curChar;
            this.advance();
            if (!Utf16.isSurrogate2(this.curChar)) {
                throw this.makeException("invalid_surrogate");
            }
            simpleCharClass = new WideSingleChar(Utf16.scalarValue(c, this.curChar));
        } else {
            simpleCharClass = new SingleChar(this.curChar);
        }
        this.advance();
        return simpleCharClass;
    }

    private CharClass parseCharClassSepar(boolean bl) {
        assert (this.curChar == '-');
        if (!bl && this.pos - 2 >= 0 && this.regExp.charAt(this.pos - 2) == '[' || this.pos < this.length && this.regExp.charAt(this.pos) == ']') {
            SingleChar singleChar = new SingleChar(this.curChar);
            this.advance();
            return singleChar;
        }
        return null;
    }

    private RegexSyntaxException makeException(String string) {
        return new RegexSyntaxException(localizer.message(string), this.pos - 1);
    }

    private RegexSyntaxException makeException(String string, String string2) {
        return new RegexSyntaxException(localizer.message(string, string2), this.pos - 1);
    }

    private static boolean isJavaMetaChar(char c) {
        switch (c) {
            case '$': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private static synchronized CharClass getCategoryCharClass(int n) {
        if (categoryCharClasses[n] == null) {
            Translator.categoryCharClasses[n] = Translator.computeCategoryCharClass(categories.charAt(n));
        }
        return categoryCharClasses[n];
    }

    private static synchronized CharClass getSubCategoryCharClass(int n) {
        if (subCategoryCharClasses[n] == null) {
            Translator.subCategoryCharClasses[n] = Translator.computeSubCategoryCharClass(subCategories.substring(n * 2, (n + 1) * 2));
        }
        return subCategoryCharClasses[n];
    }

    private static CharClass computeCategoryCharClass(char c) {
        int n;
        ArrayList<CharClass> arrayList = new ArrayList<CharClass>();
        arrayList.add(new Property(new String(new char[]{c})));
        int n2 = "NoLoMnCfLlNlLuMcNdSoSmCo".indexOf(c);
        while (n2 >= 0) {
            int[] nArray = Categories.CATEGORY_RANGES[n2 / 2];
            for (n = 0; n < nArray.length; n += 2) {
                arrayList.add(new CharRange(nArray[n], nArray[n + 1]));
            }
            n2 = "NoLoMnCfLlNlLuMcNdSoSmCo".indexOf(c, n2 + 1);
        }
        if (c == 'P') {
            arrayList.add(Translator.makeCharClass("\u00ab\u2018\u201b\u201c\u201f\u2039\u00bb\u2019\u201d\u203a"));
        }
        if (c == 'L') {
            arrayList.add(new SingleChar('\u03f5'));
            arrayList.add(new SingleChar('\u03f4'));
        }
        if (c == 'C') {
            arrayList.add(new Subtraction(new Property("Cn"), new Union(new CharClass[]{new SingleChar('\u03f4'), new SingleChar('\u03f5')})));
            ArrayList<CharClass> arrayList2 = new ArrayList<CharClass>();
            for (int i = 0; i < Categories.CATEGORY_RANGES.length; ++i) {
                for (n = 0; n < Categories.CATEGORY_RANGES[i].length; n += 2) {
                    arrayList2.add(new CharRange(Categories.CATEGORY_RANGES[i][n], Categories.CATEGORY_RANGES[i][n + 1]));
                }
            }
            arrayList.add(new Subtraction(new CharRange(65536, 0x10FFFF), new Union(arrayList2)));
        }
        if (arrayList.size() == 1) {
            return (CharClass)arrayList.get(0);
        }
        return new Union(arrayList);
    }

    private static CharClass computeSubCategoryCharClass(String string) {
        Property property = new Property(string);
        int n = "NoLoMnCfLlNlLuMcNdSoSmCo".indexOf(string);
        if (n < 0) {
            if (string.equals("Cn")) {
                ArrayList<CharClass> arrayList = new ArrayList<CharClass>();
                arrayList.add(new SingleChar('\u03f4'));
                arrayList.add(new SingleChar('\u03f5'));
                for (int i = 0; i < Categories.CATEGORY_RANGES.length; ++i) {
                    for (int j = 0; j < Categories.CATEGORY_RANGES[i].length; j += 2) {
                        arrayList.add(new CharRange(Categories.CATEGORY_RANGES[i][j], Categories.CATEGORY_RANGES[i][j + 1]));
                    }
                }
                return new Subtraction(new Union(new CharClass[]{property, new CharRange(65536, 0x10FFFF)}), new Union(arrayList));
            }
            if (string.equals("Pi")) {
                return Translator.makeCharClass(CATEGORY_Pi);
            }
            if (string.equals("Pf")) {
                return Translator.makeCharClass(CATEGORY_Pf);
            }
            return property;
        }
        ArrayList<CharClass> arrayList = new ArrayList<CharClass>();
        arrayList.add(property);
        int[] nArray = Categories.CATEGORY_RANGES[n / 2];
        for (int i = 0; i < nArray.length; i += 2) {
            arrayList.add(new CharRange(nArray[i], nArray[i + 1]));
        }
        if (string.equals("Lu")) {
            arrayList.add(new SingleChar('\u03f4'));
        } else if (string.equals("Ll")) {
            arrayList.add(new SingleChar('\u03f5'));
        } else if (string.equals("Nl")) {
            arrayList.add(new CharRange(5870, 5872));
        } else if (string.equals("No")) {
            return new Subtraction(new Union(arrayList), new CharRange(5870, 5872));
        }
        return new Union(arrayList);
    }

    private static CharClass makeCharClass(String string) {
        ArrayList<CharClass> arrayList = new ArrayList<CharClass>();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new SingleChar(string.charAt(i)));
        }
        return new Union(arrayList);
    }

    static class Complement
    extends CharClass {
        private final CharClass cc;

        Complement(CharClass charClass) {
            super(-charClass.getContainsBmp(), -charClass.getContainsNonBmp());
            this.cc = charClass;
        }

        @Override
        void outputBmp(StringBuilder stringBuilder) {
            this.cc.outputComplementBmp(stringBuilder);
        }

        @Override
        void outputComplementBmp(StringBuilder stringBuilder) {
            this.cc.outputBmp(stringBuilder);
        }

        @Override
        void addNonBmpRanges(List<Range> list) {
            ArrayList<Range> arrayList = new ArrayList<Range>();
            this.cc.addNonBmpRanges(arrayList);
            Complement.sortRangeList(arrayList);
            int n = 65536;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                Range range = (Range)arrayList.get(i);
                if (range.getMin() > n) {
                    list.add(new Range(n, range.getMin() - 1));
                }
                n = range.getMax() + 1;
            }
            if (n != 0x110000) {
                list.add(new Range(n, 0x10FFFF));
            }
        }
    }

    static class Union
    extends CharClass {
        private final List<CharClass> members;

        Union(CharClass[] charClassArray) {
            this(Union.toList(charClassArray));
        }

        private static List<CharClass> toList(CharClass[] charClassArray) {
            ArrayList<CharClass> arrayList = new ArrayList<CharClass>();
            for (int i = 0; i < charClassArray.length; ++i) {
                arrayList.add(charClassArray[i]);
            }
            return arrayList;
        }

        Union(List<CharClass> list) {
            super(Union.computeContainsBmp(list), Union.computeContainsNonBmp(list));
            this.members = list;
        }

        @Override
        void outputBmp(StringBuilder stringBuilder) {
            stringBuilder.append('[');
            int n = this.members.size();
            for (int i = 0; i < n; ++i) {
                CharClass charClass = this.members.get(i);
                if (charClass.getContainsBmp() == -1) continue;
                if (charClass instanceof SimpleCharClass) {
                    ((SimpleCharClass)charClass).inClassOutputBmp(stringBuilder);
                    continue;
                }
                charClass.outputBmp(stringBuilder);
            }
            stringBuilder.append(']');
        }

        @Override
        void outputComplementBmp(StringBuilder stringBuilder) {
            CharClass charClass;
            int n;
            boolean bl = true;
            int n2 = this.members.size();
            for (n = 0; n < n2; ++n) {
                charClass = this.members.get(n);
                if (charClass.getContainsBmp() == -1 || !(charClass instanceof SimpleCharClass)) continue;
                if (bl) {
                    stringBuilder.append("[^");
                    bl = false;
                }
                ((SimpleCharClass)charClass).inClassOutputBmp(stringBuilder);
            }
            for (n = 0; n < n2; ++n) {
                charClass = this.members.get(n);
                if (charClass.getContainsBmp() == -1 || charClass instanceof SimpleCharClass) continue;
                if (bl) {
                    stringBuilder.append('[');
                    bl = false;
                } else {
                    stringBuilder.append("&&");
                }
                charClass.outputComplementBmp(stringBuilder);
            }
            if (bl) {
                stringBuilder.append("[\u0000-\uffff]");
            } else {
                stringBuilder.append(']');
            }
        }

        @Override
        void addNonBmpRanges(List<Range> list) {
            int n = this.members.size();
            for (int i = 0; i < n; ++i) {
                this.members.get(i).addNonBmpRanges(list);
            }
        }

        private static int computeContainsBmp(List<CharClass> list) {
            int n = -1;
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                n = Math.max(n, list.get(i).getContainsBmp());
            }
            return n;
        }

        private static int computeContainsNonBmp(List<CharClass> list) {
            int n = -1;
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                n = Math.max(n, list.get(i).getContainsNonBmp());
            }
            return n;
        }
    }

    static class Subtraction
    extends CharClass {
        private final CharClass cc1;
        private final CharClass cc2;

        Subtraction(CharClass charClass, CharClass charClass2) {
            super(Math.min(charClass.getContainsBmp(), -charClass2.getContainsBmp()), Math.min(charClass.getContainsNonBmp(), -charClass2.getContainsNonBmp()));
            this.cc1 = charClass;
            this.cc2 = charClass2;
        }

        @Override
        void outputBmp(StringBuilder stringBuilder) {
            stringBuilder.append('[');
            this.cc1.outputBmp(stringBuilder);
            stringBuilder.append("&&");
            this.cc2.outputComplementBmp(stringBuilder);
            stringBuilder.append(']');
        }

        @Override
        void outputComplementBmp(StringBuilder stringBuilder) {
            stringBuilder.append('[');
            this.cc1.outputComplementBmp(stringBuilder);
            this.cc2.outputBmp(stringBuilder);
            stringBuilder.append(']');
        }

        @Override
        void addNonBmpRanges(List<Range> list) {
            ArrayList<Range> arrayList = new ArrayList<Range>();
            this.cc1.addNonBmpRanges(arrayList);
            ArrayList<Range> arrayList2 = new ArrayList<Range>();
            this.cc2.addNonBmpRanges(arrayList2);
            Subtraction.sortRangeList(arrayList);
            Subtraction.sortRangeList(arrayList2);
            Iterator iterator = arrayList2.iterator();
            Range range = iterator.hasNext() ? (Range)iterator.next() : null;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Range range2 = (Range)arrayList.get(i);
                while (range != null && range.getMax() < range2.getMin()) {
                    if (iterator.hasNext()) {
                        range = (Range)iterator.next();
                        continue;
                    }
                    range = null;
                }
                int n2 = range2.getMin();
                while (range != null && range.getMin() <= range2.getMax()) {
                    if (n2 < range.getMin()) {
                        list.add(new Range(n2, range.getMin() - 1));
                    }
                    if ((n2 = range.getMax() + 1) > range2.getMax()) break;
                    if (iterator.hasNext()) {
                        range = (Range)iterator.next();
                        continue;
                    }
                    range = null;
                }
                if (n2 > range2.getMax()) continue;
                list.add(new Range(n2, range2.getMax()));
            }
        }
    }

    static class Property
    extends SimpleCharClass {
        private final String name;

        Property(String string) {
            super(0, -1);
            this.name = string;
        }

        @Override
        void outputBmp(StringBuilder stringBuilder) {
            this.inClassOutputBmp(stringBuilder);
        }

        @Override
        void inClassOutputBmp(StringBuilder stringBuilder) {
            stringBuilder.append("\\p{");
            stringBuilder.append(this.name);
            stringBuilder.append('}');
        }

        @Override
        void outputComplementBmp(StringBuilder stringBuilder) {
            stringBuilder.append("\\P{");
            stringBuilder.append(this.name);
            stringBuilder.append('}');
        }
    }

    static class CharRange
    extends SimpleCharClass {
        private final int lower;
        private final int upper;

        CharRange(int n, int n2) {
            super(n < 65536 ? 0 : -1, n2 >= 65536 ? 0 : -1);
            this.lower = n;
            this.upper = n2;
        }

        @Override
        void inClassOutputBmp(StringBuilder stringBuilder) {
            if (this.lower >= 65536) {
                throw new RuntimeException("BMP output botch");
            }
            if (Translator.isJavaMetaChar((char)this.lower)) {
                stringBuilder.append('\\');
            }
            stringBuilder.append((char)this.lower);
            stringBuilder.append('-');
            if (this.upper < 65536) {
                if (Translator.isJavaMetaChar((char)this.upper)) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append((char)this.upper);
            } else {
                stringBuilder.append('\uffff');
            }
        }

        @Override
        void addNonBmpRanges(List<Range> list) {
            if (this.upper >= 65536) {
                list.add(new Range(this.lower < 65536 ? 65536 : this.lower, this.upper));
            }
        }
    }

    static class Empty
    extends SimpleCharClass {
        private static final Empty instance = new Empty();

        private Empty() {
            super(-1, -1);
        }

        static Empty getInstance() {
            return instance;
        }

        @Override
        void inClassOutputBmp(StringBuilder stringBuilder) {
            throw new RuntimeException("BMP output botch");
        }
    }

    static class WideSingleChar
    extends SimpleCharClass {
        private final int c;

        WideSingleChar(int n) {
            super(-1, 0);
            this.c = n;
        }

        @Override
        void inClassOutputBmp(StringBuilder stringBuilder) {
            throw new RuntimeException("BMP output botch");
        }

        @Override
        int singleChar() {
            return this.c;
        }

        @Override
        void addNonBmpRanges(List<Range> list) {
            list.add(new Range(this.c, this.c));
        }
    }

    static class SingleChar
    extends SimpleCharClass {
        private final char c;

        SingleChar(char c) {
            super(0, -1);
            this.c = c;
        }

        @Override
        int singleChar() {
            return this.c;
        }

        @Override
        void outputBmp(StringBuilder stringBuilder) {
            this.inClassOutputBmp(stringBuilder);
        }

        @Override
        void inClassOutputBmp(StringBuilder stringBuilder) {
            if (Translator.isJavaMetaChar(this.c)) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(this.c);
        }
    }

    static abstract class SimpleCharClass
    extends CharClass {
        SimpleCharClass(int n, int n2) {
            super(n, n2);
        }

        @Override
        void outputBmp(StringBuilder stringBuilder) {
            stringBuilder.append('[');
            this.inClassOutputBmp(stringBuilder);
            stringBuilder.append(']');
        }

        @Override
        void outputComplementBmp(StringBuilder stringBuilder) {
            if (this.getContainsBmp() == -1) {
                stringBuilder.append("[\u0000-\uffff]");
            } else {
                stringBuilder.append("[^");
                this.inClassOutputBmp(stringBuilder);
                stringBuilder.append(']');
            }
        }

        abstract void inClassOutputBmp(StringBuilder var1);
    }

    static abstract class CharClass {
        private final int containsBmp;
        private final int containsNonBmp;

        protected CharClass(int n, int n2) {
            this.containsBmp = n;
            this.containsNonBmp = n2;
        }

        int getContainsBmp() {
            return this.containsBmp;
        }

        int getContainsNonBmp() {
            return this.containsNonBmp;
        }

        final void output(StringBuilder stringBuilder) {
            switch (this.containsNonBmp) {
                case -1: {
                    if (this.containsBmp == -1) {
                        stringBuilder.append(Translator.NOT_ALLOWED_CLASS);
                        break;
                    }
                    this.outputBmp(stringBuilder);
                    break;
                }
                case 1: {
                    stringBuilder.append('(');
                    if (this.containsBmp == -1) {
                        stringBuilder.append(Translator.SURROGATES1_CLASS);
                        stringBuilder.append(Translator.SURROGATES2_CLASS);
                    } else {
                        this.outputBmp(stringBuilder);
                        stringBuilder.append(Translator.SURROGATES2_CLASS);
                        stringBuilder.append('?');
                    }
                    stringBuilder.append(')');
                    break;
                }
                case 0: {
                    char c;
                    int n;
                    int n2;
                    stringBuilder.append('(');
                    boolean bl = false;
                    if (this.containsBmp != -1) {
                        bl = true;
                        this.outputBmp(stringBuilder);
                    }
                    ArrayList<Range> arrayList = new ArrayList<Range>();
                    this.addNonBmpRanges(arrayList);
                    CharClass.sortRangeList(arrayList);
                    String string = CharClass.highSurrogateRanges(arrayList);
                    if (string.length() > 0) {
                        if (bl) {
                            stringBuilder.append('|');
                        } else {
                            bl = true;
                        }
                        stringBuilder.append('[');
                        n2 = string.length();
                        for (int i = 0; i < n2; i += 2) {
                            n = string.charAt(i);
                            if (n == (c = string.charAt(i + 1))) {
                                stringBuilder.append((char)n);
                                continue;
                            }
                            stringBuilder.append((char)n);
                            stringBuilder.append('-');
                            stringBuilder.append(c);
                        }
                        stringBuilder.append(']');
                        stringBuilder.append(Translator.SURROGATES2_CLASS);
                    }
                    String string2 = CharClass.lowSurrogateRanges(arrayList);
                    n = string2.length();
                    for (n2 = 0; n2 < n; n2 += 3) {
                        if (bl) {
                            stringBuilder.append('|');
                        } else {
                            bl = true;
                        }
                        stringBuilder.append(string2.charAt(n2));
                        c = string2.charAt(n2 + 1);
                        char c2 = string2.charAt(n2 + 2);
                        if (c == c2 && (n2 + 3 >= n || string2.charAt(n2 + 3) != string2.charAt(n2))) {
                            stringBuilder.append(c);
                            continue;
                        }
                        stringBuilder.append('[');
                        while (true) {
                            if (c == c2) {
                                stringBuilder.append(c);
                            } else {
                                stringBuilder.append(c);
                                stringBuilder.append('-');
                                stringBuilder.append(c2);
                            }
                            if (n2 + 3 >= n || string2.charAt(n2 + 3) != string2.charAt(n2)) break;
                            c = string2.charAt((n2 += 3) + 1);
                            c2 = string2.charAt(n2 + 2);
                        }
                        stringBuilder.append(']');
                    }
                    if (!bl) {
                        stringBuilder.append(Translator.NOT_ALLOWED_CLASS);
                    }
                    stringBuilder.append(')');
                }
            }
        }

        static String highSurrogateRanges(List<Range> list) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Range range = list.get(i);
                char c = Utf16.surrogate1(range.getMin());
                char c2 = Utf16.surrogate2(range.getMin());
                char c3 = Utf16.surrogate1(range.getMax());
                char c4 = Utf16.surrogate2(range.getMax());
                if (c2 != '\udc00') {
                    c = (char)(c + '\u0001');
                }
                if (c4 != '\udfff') {
                    c3 = (char)(c3 - '\u0001');
                }
                if (c3 < c) continue;
                stringBuilder.append(c);
                stringBuilder.append(c3);
            }
            return stringBuilder.toString();
        }

        static String lowSurrogateRanges(List<Range> list) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Range range = list.get(i);
                char c = Utf16.surrogate1(range.getMin());
                char c2 = Utf16.surrogate2(range.getMin());
                char c3 = Utf16.surrogate1(range.getMax());
                char c4 = Utf16.surrogate2(range.getMax());
                if (c == c3) {
                    if (c2 == '\udc00' && c4 == '\udfff') continue;
                    stringBuilder.append(c);
                    stringBuilder.append(c2);
                    stringBuilder.append(c4);
                    continue;
                }
                if (c2 != '\udc00') {
                    stringBuilder.append(c);
                    stringBuilder.append(c2);
                    stringBuilder.append('\udfff');
                }
                if (c4 == '\udfff') continue;
                stringBuilder.append(c3);
                stringBuilder.append('\udc00');
                stringBuilder.append(c4);
            }
            return stringBuilder.toString();
        }

        abstract void outputBmp(StringBuilder var1);

        abstract void outputComplementBmp(StringBuilder var1);

        int singleChar() {
            return -1;
        }

        void addNonBmpRanges(List<Range> list) {
        }

        static void sortRangeList(List<Range> list) {
            Collections.sort(list);
            int n = 0;
            int n2 = 0;
            int n3 = list.size();
            while (n2 < n3) {
                Range range;
                Range range2 = list.get(n2);
                int n4 = range2.getMin();
                int n5 = range2.getMax();
                while (++n2 < n3 && (range = list.get(n2)).getMin() <= n5 + 1) {
                    if (range.getMax() <= n5) continue;
                    n5 = range.getMax();
                }
                if (n5 != range2.getMax()) {
                    range2 = new Range(n4, n5);
                }
                list.set(n++, range2);
            }
            while (n3 > n) {
                list.remove(--n3);
            }
        }
    }

    static final class Range
    implements Comparable<Range> {
        private final int min;
        private final int max;

        Range(int n, int n2) {
            this.min = n;
            this.max = n2;
        }

        int getMin() {
            return this.min;
        }

        int getMax() {
            return this.max;
        }

        @Override
        public int compareTo(Range range) {
            if (this.min < range.min) {
                return -1;
            }
            if (this.min > range.min) {
                return 1;
            }
            if (this.max > range.max) {
                return -1;
            }
            if (this.max < range.max) {
                return 1;
            }
            return 0;
        }
    }
}

