/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype;

import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.Msg;
import com.xmlmind.xml.wxs.datatype.NumericValue;
import com.xmlmind.xml.wxs.datatype.Value;
import java.math.BigDecimal;

public class ShortValue
extends NumericValue {
    private final short number;

    public static ShortValue parseShort(String string) throws InvalidDataException {
        short s;
        if (string.length() > 0 && string.charAt(0) == '+') {
            string = string.substring(1);
        }
        try {
            s = Short.parseShort(string);
        }
        catch (Exception exception) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("shortSyntax", string));
        }
        return new ShortValue(s);
    }

    public ShortValue(short s) {
        this.number = s;
    }

    public short getShort() {
        return this.number;
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(Short.toString(this.number));
    }

    @Override
    public String toString() {
        return Short.toString(this.number);
    }

    @Override
    public int hashCode() {
        return this.number;
    }

    @Override
    public int compareTo(Value value) {
        if (value == null || !(value instanceof NumericValue)) {
            return -2;
        }
        if (value instanceof ShortValue) {
            short s = ((ShortValue)value).number;
            return this.number < s ? -1 : (this.number > s ? 1 : 0);
        }
        return this.toBigDecimal().compareTo(((NumericValue)value).toBigDecimal());
    }

    @Override
    public int totalDigits() {
        return Short.toString(this.number).length();
    }

    @Override
    public int fractionDigits() {
        return 0;
    }
}

