/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype;

import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.validate.UnparsedEntities;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.Msg;
import com.xmlmind.xml.wxs.datatype.StringValue;
import com.xmlmind.xml.wxs.datatype.TokenType;
import com.xmlmind.xml.wxs.datatype.Value;
import java.io.ObjectStreamException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class LanguageType
extends TokenType {
    public static final LanguageType BASE = new LanguageType();
    public static final String[] KNOWN_LANGUAGES = new String[]{"aa", "Afar", "ab", "Abkhazian", "ae", "Avestan", "af", "Afrikaans", "ak", "Akan", "am", "Amharic", "an", "Aragonese", "ar", "Arabic", "as", "Assamese", "av", "Avaric", "ay", "Aymara", "az", "Azerbaijani", "ba", "Bashkir", "be", "Belarusian", "bg", "Bulgarian", "bh", "Bihari languages", "bi", "Bislama", "bm", "Bambara", "bn", "Bengali", "bo", "Tibetan", "br", "Breton", "bs", "Bosnian", "ca", "Catalan", "ce", "Chechen", "ch", "Chamorro", "co", "Corsican", "cr", "Cree", "cs", "Czech", "cu", "Church Slavic", "cv", "Chuvash", "cy", "Welsh", "cy", "Welsh", "da", "Danish", "de", "German", "dv", "Divehi", "dz", "Dzongkha", "ee", "Ewe", "el", "Greek", "en", "English", "eo", "Esperanto", "es", "Spanish", "et", "Estonian", "eu", "Basque", "fa", "Persian", "ff", "Fulah", "fi", "Finnish", "fj", "Fijian", "fo", "Faroese", "fr", "French", "fy", "Western Frisian", "ga", "Irish", "gd", "Gaelic", "gl", "Galician", "gn", "Guarani", "gu", "Gujarati", "gv", "Manx", "ha", "Hausa", "he", "Hebrew", "hi", "Hindi", "ho", "Hiri Motu", "hr", "Croatian", "ht", "Haitian", "hu", "Hungarian", "hy", "Armenian", "hz", "Herero", "ia", "Interlingua", "id", "Indonesian", "ie", "Interlingue", "ig", "Igbo", "ii", "Sichuan Yi", "ik", "Inupiaq", "io", "Ido", "is", "Icelandic", "it", "Italian", "iu", "Inuktitut", "ja", "Japanese", "jv", "Javanese", "ka", "Georgian", "kg", "Kongo", "ki", "Kikuyu", "kj", "Kuanyama", "kk", "Kazakh", "kl", "Kalaallisut", "km", "Central Khmer", "kn", "Kannada", "ko", "Korean", "kr", "Kanuri", "ks", "Kashmiri", "ku", "Kurdish", "kv", "Komi", "kw", "Cornish", "ky", "Kirghiz", "la", "Latin", "lb", "Luxembourgish", "lg", "Ganda", "li", "Limburgan", "ln", "Lingala", "lo", "Lao", "lt", "Lithuanian", "lu", "Luba-Katanga", "lv", "Latvian", "mg", "Malagasy", "mh", "Marshallese", "mi", "Maori", "mk", "Macedonian", "ml", "Malayalam", "mn", "Mongolian", "mr", "Marathi", "ms", "Malay", "mt", "Maltese", "my", "Burmese", "na", "Nauru", "nb", "Norwegian Bokm\u00e5l", "nd", "Ndebele, North", "ne", "Nepali", "ng", "Ndonga", "nl", "Dutch", "nn", "Norwegian Nynorsk", "no", "Norwegian", "nr", "Ndebele, South", "nv", "Navajo", "ny", "Chichewa", "oc", "Occitan", "oj", "Ojibwa", "om", "Oromo", "or", "Oriya", "os", "Ossetian", "pa", "Panjabi", "pi", "Pali", "pl", "Polish", "ps", "Pushto", "pt", "Portuguese", "qu", "Quechua", "rm", "Romansh", "rn", "Rundi", "ro", "Romanian", "ru", "Russian", "rw", "Kinyarwanda", "sa", "Sanskrit", "sc", "Sardinian", "sd", "Sindhi", "se", "Northern Sami", "sg", "Sango", "si", "Sinhala", "sk", "Slovak", "sl", "Slovenian", "sm", "Samoan", "sn", "Shona", "so", "Somali", "sq", "Albanian", "sr", "Serbian", "ss", "Swati", "st", "Sotho, Southern", "su", "Sundanese", "sv", "Swedish", "sw", "Swahili", "ta", "Tamil", "te", "Telugu", "tg", "Tajik", "th", "Thai", "ti", "Tigrinya", "tk", "Turkmen", "tl", "Tagalog", "tn", "Tswana", "to", "Tonga", "tr", "Turkish", "ts", "Tsonga", "tt", "Tatar", "tw", "Twi", "ty", "Tahitian", "ug", "Uighur", "uk", "Ukrainian", "ur", "Urdu", "uz", "Uzbek", "ve", "Venda", "vi", "Vietnamese", "vo", "Volap\u00fck", "wa", "Walloon", "wo", "Wolof", "xh", "Xhosa", "yi", "Yiddish", "yo", "Yoruba", "za", "Zhuang", "zh", "Chinese", "zu", "Zulu"};
    private static final HashMap<String, String> knownLanguageMap = new HashMap();
    protected static final Pattern languagePattern;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isKnownLanguage(String string) {
        HashMap<String, String> hashMap = knownLanguageMap;
        synchronized (hashMap) {
            return knownLanguageMap.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] getKnownLanguages() {
        HashMap<String, String> hashMap = knownLanguageMap;
        synchronized (hashMap) {
            Object[] objectArray = new String[knownLanguageMap.size()];
            knownLanguageMap.keySet().toArray(objectArray);
            Arrays.sort(objectArray);
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getKnownLanguageName(String string) {
        HashMap<String, String> hashMap = knownLanguageMap;
        synchronized (hashMap) {
            return knownLanguageMap.get(string);
        }
    }

    protected LanguageType() {
    }

    private Object readResolve() throws ObjectStreamException {
        return this.baseType == null ? BASE : this;
    }

    @Override
    protected Value doParse(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities) throws InvalidDataException {
        if (!languagePattern.matcher(string).matches()) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("languageSyntax", string));
        }
        return new StringValue(string.toLowerCase());
    }

    @Override
    public String getDataTypeLabel(NamespaceToPrefixes namespaceToPrefixes) {
        return "language";
    }

    static {
        int n = KNOWN_LANGUAGES.length;
        for (int i = 0; i < n; i += 2) {
            knownLanguageMap.put(KNOWN_LANGUAGES[i], KNOWN_LANGUAGES[i + 1]);
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        languagePattern = pattern;
    }
}

