/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype;

import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.Msg;
import com.xmlmind.xml.wxs.datatype.NumericValue;
import com.xmlmind.xml.wxs.datatype.Value;
import java.math.BigDecimal;

public class IntValue
extends NumericValue {
    private final int number;

    public static IntValue parseInt(String string) throws InvalidDataException {
        int n;
        if (string.length() > 0 && string.charAt(0) == '+') {
            string = string.substring(1);
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("intSyntax", string));
        }
        return new IntValue(n);
    }

    public IntValue(int n) {
        this.number = n;
    }

    public int getInt() {
        return this.number;
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(Integer.toString(this.number));
    }

    @Override
    public String toString() {
        return Integer.toString(this.number);
    }

    @Override
    public int hashCode() {
        return this.number;
    }

    @Override
    public int compareTo(Value value) {
        if (value == null || !(value instanceof NumericValue)) {
            return -2;
        }
        if (value instanceof IntValue) {
            int n = ((IntValue)value).number;
            return this.number < n ? -1 : (this.number > n ? 1 : 0);
        }
        return this.toBigDecimal().compareTo(((NumericValue)value).toBigDecimal());
    }

    @Override
    public int totalDigits() {
        return Integer.toString(this.number).length();
    }

    @Override
    public int fractionDigits() {
        return 0;
    }
}

